/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.util.concurrent.TimeUnit;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DurationArgument
extends Argument {
    private static final long serialVersionUID = -8824262632728709264L;
    private final Long defaultValueNanos;
    private final long maxValueNanos;
    private final long minValueNanos;
    private Long valueNanos;
    private final String lowerBoundStr;
    private final String upperBoundStr;

    public DurationArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, valuePlaceholder, description, null, null, null, null, null, null);
    }

    public DurationArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, String description, Long defaultValue, TimeUnit defaultValueUnit, Long lowerBound, TimeUnit lowerBoundUnit, Long upperBound, TimeUnit upperBoundUnit) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, 1, valuePlaceholder, description);
        if (valuePlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MUST_TAKE_VALUE.get(this.getIdentifierString()));
        }
        if (defaultValue == null) {
            this.defaultValueNanos = null;
        } else {
            if (defaultValueUnit == null) {
                throw new ArgumentException(ArgsMessages.ERR_DURATION_DEFAULT_REQUIRES_UNIT.get(this.getIdentifierString()));
            }
            this.defaultValueNanos = defaultValueUnit.toNanos(defaultValue);
        }
        if (lowerBound == null) {
            this.minValueNanos = 0L;
            this.lowerBoundStr = "0ns";
        } else {
            if (lowerBoundUnit == null) {
                throw new ArgumentException(ArgsMessages.ERR_DURATION_LOWER_REQUIRES_UNIT.get(this.getIdentifierString()));
            }
            this.minValueNanos = lowerBoundUnit.toNanos(lowerBound);
            switch (lowerBoundUnit) {
                case MICROSECONDS: {
                    this.lowerBoundStr = lowerBound + "us";
                    break;
                }
                case MILLISECONDS: {
                    this.lowerBoundStr = lowerBound + "ms";
                    break;
                }
                case SECONDS: {
                    this.lowerBoundStr = lowerBound + "s";
                    break;
                }
                case MINUTES: {
                    this.lowerBoundStr = lowerBound + "m";
                    break;
                }
                case HOURS: {
                    this.lowerBoundStr = lowerBound + "h";
                    break;
                }
                case DAYS: {
                    this.lowerBoundStr = lowerBound + "d";
                    break;
                }
                default: {
                    this.lowerBoundStr = this.minValueNanos + "ns";
                }
            }
        }
        if (upperBound == null) {
            this.maxValueNanos = Long.MAX_VALUE;
            this.upperBoundStr = "9223372036854775807ns";
        } else {
            if (upperBoundUnit == null) {
                throw new ArgumentException(ArgsMessages.ERR_DURATION_UPPER_REQUIRES_UNIT.get(this.getIdentifierString()));
            }
            this.maxValueNanos = upperBoundUnit.toNanos(upperBound);
            switch (upperBoundUnit) {
                case MICROSECONDS: {
                    this.upperBoundStr = upperBound + "us";
                    break;
                }
                case MILLISECONDS: {
                    this.upperBoundStr = upperBound + "ms";
                    break;
                }
                case SECONDS: {
                    this.upperBoundStr = upperBound + "s";
                    break;
                }
                case MINUTES: {
                    this.upperBoundStr = upperBound + "m";
                    break;
                }
                case HOURS: {
                    this.upperBoundStr = upperBound + "h";
                    break;
                }
                case DAYS: {
                    this.upperBoundStr = upperBound + "d";
                    break;
                }
                default: {
                    this.upperBoundStr = this.maxValueNanos + "ns";
                }
            }
        }
        if (this.minValueNanos > this.maxValueNanos) {
            throw new ArgumentException(ArgsMessages.ERR_DURATION_LOWER_GT_UPPER.get(this.getIdentifierString(), this.lowerBoundStr, this.upperBoundStr));
        }
        this.valueNanos = null;
    }

    private DurationArgument(DurationArgument source) {
        super(source);
        this.defaultValueNanos = source.defaultValueNanos;
        this.maxValueNanos = source.maxValueNanos;
        this.minValueNanos = source.minValueNanos;
        this.lowerBoundStr = source.lowerBoundStr;
        this.upperBoundStr = source.upperBoundStr;
        this.valueNanos = null;
    }

    public long getLowerBound(TimeUnit unit) {
        return unit.convert(this.minValueNanos, TimeUnit.NANOSECONDS);
    }

    public long getUpperBound(TimeUnit unit) {
        return unit.convert(this.maxValueNanos, TimeUnit.NANOSECONDS);
    }

    protected boolean hasDefaultValue() {
        return this.defaultValueNanos != null;
    }

    public Long getDefaultValue(TimeUnit unit) {
        if (this.defaultValueNanos == null) {
            return null;
        }
        return unit.convert(this.defaultValueNanos, TimeUnit.NANOSECONDS);
    }

    public Long getValue(TimeUnit unit) {
        if (this.valueNanos == null) {
            if (this.defaultValueNanos == null) {
                return null;
            }
            return unit.convert(this.defaultValueNanos, TimeUnit.NANOSECONDS);
        }
        return unit.convert(this.valueNanos, TimeUnit.NANOSECONDS);
    }

    protected void addValue(String valueString) throws ArgumentException {
        TimeUnit unit;
        if (this.valueNanos != null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        String lowerStr = StaticUtils.toLowerCase(valueString);
        if (lowerStr.length() == 0) {
            throw new ArgumentException(ArgsMessages.ERR_DURATION_MALFORMED_VALUE.get(valueString, this.getIdentifierString()));
        }
        boolean digitFound = false;
        boolean nonDigitFound = false;
        int nonDigitPos = -1;
        for (int i = 0; i < lowerStr.length(); ++i) {
            char c = lowerStr.charAt(i);
            if (!Character.isDigit(c)) {
                nonDigitFound = true;
                nonDigitPos = i;
                if (digitFound) break;
                throw new ArgumentException(ArgsMessages.ERR_DURATION_MALFORMED_VALUE.get(valueString, this.getIdentifierString()));
            }
            digitFound = true;
        }
        if (!nonDigitFound) {
            throw new ArgumentException(ArgsMessages.ERR_DURATION_MALFORMED_VALUE.get(valueString, this.getIdentifierString()));
        }
        long integerPortion = Long.parseLong(lowerStr.substring(0, nonDigitPos));
        String unitStr = lowerStr.substring(nonDigitPos).trim();
        if (unitStr.equals("ns") || unitStr.equals("nano") || unitStr.equals("nanos") || unitStr.equals("nanosecond") || unitStr.equals("nanoseconds")) {
            unit = TimeUnit.NANOSECONDS;
        } else if (unitStr.equals("us") || unitStr.equals("micro") || unitStr.equals("micros") || unitStr.equals("microsecond") || unitStr.equals("microseconds")) {
            unit = TimeUnit.MICROSECONDS;
        } else if (unitStr.equals("ms") || unitStr.equals("milli") || unitStr.equals("millis") || unitStr.equals("millisecond") || unitStr.equals("milliseconds")) {
            unit = TimeUnit.MILLISECONDS;
        } else if (unitStr.equals("s") || unitStr.equals("sec") || unitStr.equals("secs") || unitStr.equals("second") || unitStr.equals("seconds")) {
            unit = TimeUnit.SECONDS;
        } else if (unitStr.equals("m") || unitStr.equals("min") || unitStr.equals("mins") || unitStr.equals("minute") || unitStr.equals("minutes")) {
            unit = TimeUnit.MINUTES;
        } else if (unitStr.equals("h") || unitStr.equals("hr") || unitStr.equals("hrs") || unitStr.equals("hour") || unitStr.equals("hours")) {
            unit = TimeUnit.HOURS;
        } else if (unitStr.equals("d") || unitStr.equals("day") || unitStr.equals("days")) {
            unit = TimeUnit.DAYS;
        } else {
            throw new ArgumentException(ArgsMessages.ERR_DURATION_UNRECOGNIZED_UNIT.get(valueString, this.getIdentifierString(), unitStr));
        }
        long proposedValueNanos = TimeUnit.NANOSECONDS.convert(integerPortion, unit);
        if (proposedValueNanos < this.minValueNanos) {
            throw new ArgumentException(ArgsMessages.ERR_DURATION_BELOW_LOWER_BOUND.get(this.getIdentifierString(), this.lowerBoundStr));
        }
        if (proposedValueNanos > this.maxValueNanos) {
            throw new ArgumentException(ArgsMessages.ERR_DURATION_ABOVE_UPPER_BOUND.get(this.getIdentifierString(), this.upperBoundStr));
        }
        this.valueNanos = proposedValueNanos;
    }

    public String getDataTypeName() {
        return ArgsMessages.INFO_DURATION_TYPE_NAME.get();
    }

    public String getValueConstraints() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(ArgsMessages.INFO_DURATION_CONSTRAINTS_FORMAT.get());
        if (this.lowerBoundStr != null) {
            if (this.upperBoundStr == null) {
                buffer.append("  ");
                buffer.append(ArgsMessages.INFO_DURATION_CONSTRAINTS_LOWER_BOUND.get(this.lowerBoundStr));
            } else {
                buffer.append("  ");
                buffer.append(ArgsMessages.INFO_DURATION_CONSTRAINTS_LOWER_AND_UPPER_BOUND.get(this.lowerBoundStr, this.upperBoundStr));
            }
        } else if (this.upperBoundStr != null) {
            buffer.append("  ");
            buffer.append(ArgsMessages.INFO_DURATION_CONSTRAINTS_UPPER_BOUND.get(this.upperBoundStr));
        }
        return buffer.toString();
    }

    public DurationArgument getCleanCopy() {
        return new DurationArgument(this);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("DurationArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.lowerBoundStr != null) {
            buffer.append(", lowerBound='");
            buffer.append(this.lowerBoundStr);
            buffer.append('\'');
        }
        if (this.upperBoundStr != null) {
            buffer.append(", upperBound='");
            buffer.append(this.upperBoundStr);
            buffer.append('\'');
        }
        if (this.defaultValueNanos != null) {
            buffer.append(", defaultValueNanos=");
            buffer.append(this.defaultValueNanos);
        }
        buffer.append(')');
    }
}

