/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordExpiredControl
extends Control
implements DecodeableControl {
    public static final String PASSWORD_EXPIRED_OID = "2.16.840.1.113730.3.4.4";
    private static final long serialVersionUID = -2731704592689892224L;

    public PasswordExpiredControl() {
        super(PASSWORD_EXPIRED_OID, false, new ASN1OctetString("0"));
    }

    public PasswordExpiredControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_EXPIRED_NO_VALUE.get());
        }
        try {
            Integer.parseInt(value.stringValue());
        }
        catch (NumberFormatException nfe) {
            Debug.debugException(nfe);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_EXPIRED_VALUE_NOT_INTEGER.get(), nfe);
        }
    }

    public PasswordExpiredControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new PasswordExpiredControl(oid, isCritical, value);
    }

    public static PasswordExpiredControl get(LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(PASSWORD_EXPIRED_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof PasswordExpiredControl) {
            return (PasswordExpiredControl)c;
        }
        return new PasswordExpiredControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PW_EXPIRED.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PasswordExpiredControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

