/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SSLUtil {
    private static final AtomicReference<String> DEFAULT_SSL_PROTOCOL = new AtomicReference<String>("TLSv1");
    private final KeyManager[] keyManagers;
    private final TrustManager[] trustManagers;

    public SSLUtil() {
        this.keyManagers = null;
        this.trustManagers = null;
    }

    public SSLUtil(TrustManager trustManager) {
        this.keyManagers = null;
        this.trustManagers = trustManager == null ? null : new TrustManager[]{trustManager};
    }

    public SSLUtil(TrustManager[] trustManagers) {
        this.keyManagers = null;
        this.trustManagers = trustManagers == null || trustManagers.length == 0 ? null : trustManagers;
    }

    public SSLUtil(KeyManager keyManager, TrustManager trustManager) {
        this.keyManagers = keyManager == null ? null : new KeyManager[]{keyManager};
        this.trustManagers = trustManager == null ? null : new TrustManager[]{trustManager};
    }

    public SSLUtil(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.keyManagers = keyManagers == null || keyManagers.length == 0 ? null : keyManagers;
        this.trustManagers = trustManagers == null || trustManagers.length == 0 ? null : trustManagers;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public SSLContext createSSLContext() throws GeneralSecurityException {
        return this.createSSLContext(DEFAULT_SSL_PROTOCOL.get());
    }

    public SSLContext createSSLContext(String protocol) throws GeneralSecurityException {
        Validator.ensureNotNull(protocol);
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(this.keyManagers, this.trustManagers, null);
        return sslContext;
    }

    public SSLContext createSSLContext(String protocol, String provider) throws GeneralSecurityException {
        Validator.ensureNotNull(protocol, provider);
        SSLContext sslContext = SSLContext.getInstance(protocol, provider);
        sslContext.init(this.keyManagers, this.trustManagers, null);
        return sslContext;
    }

    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException {
        return this.createSSLContext().getSocketFactory();
    }

    public SSLSocketFactory createSSLSocketFactory(String protocol) throws GeneralSecurityException {
        return this.createSSLContext(protocol).getSocketFactory();
    }

    public SSLSocketFactory createSSLSocketFactory(String protocol, String provider) throws GeneralSecurityException {
        return this.createSSLContext(protocol, provider).getSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory() throws GeneralSecurityException {
        return this.createSSLContext().getServerSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory(String protocol) throws GeneralSecurityException {
        return this.createSSLContext(protocol).getServerSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory(String protocol, String provider) throws GeneralSecurityException {
        return this.createSSLContext(protocol, provider).getServerSocketFactory();
    }

    public static String getDefaultSSLProtocol() {
        return DEFAULT_SSL_PROTOCOL.get();
    }

    public static void setDefaultSSLProtocol(String defaultSSLProtocol) {
        Validator.ensureNotNull(defaultSSLProtocol);
        DEFAULT_SSL_PROTOCOL.set(defaultSSLProtocol);
    }

    static {
        try {
            Method getDefaultMethod = SSLContext.class.getMethod("getDefault", new Class[0]);
            SSLContext defaultContext = (SSLContext)getDefaultMethod.invoke(null, new Object[0]);
            Method getSupportedParamsMethod = SSLContext.class.getMethod("getSupportedSSLParameters", new Class[0]);
            Object paramsObj = getSupportedParamsMethod.invoke((Object)defaultContext, new Object[0]);
            Class<?> sslParamsClass = Class.forName("javax.net.ssl.SSLParameters");
            Method getProtocolsMethod = sslParamsClass.getMethod("getProtocols", new Class[0]);
            String[] supportedProtocols = (String[])getProtocolsMethod.invoke(paramsObj, new Object[0]);
            HashSet<String> protocolMap = new HashSet<String>(Arrays.asList(supportedProtocols));
            if (protocolMap.contains("TLSv1.2")) {
                DEFAULT_SSL_PROTOCOL.set("TLSv1.2");
            } else if (protocolMap.contains("TLSv1.1")) {
                DEFAULT_SSL_PROTOCOL.set("TLSv1.1");
            } else if (protocolMap.contains("TLSv1")) {
                DEFAULT_SSL_PROTOCOL.set("TLSv1");
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }
}

