/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.examples.SearchRateThread;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ValuePattern;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SearchRate
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 3345838530404592182L;
    private BooleanArgument asynchronousMode;
    private BooleanArgument csvFormat;
    private BooleanArgument suppressErrors;
    private IntegerArgument collectionInterval;
    private IntegerArgument iterationsBeforeReconnect;
    private IntegerArgument maxOutstandingRequests;
    private IntegerArgument numIntervals;
    private IntegerArgument numThreads;
    private IntegerArgument randomSeed;
    private IntegerArgument ratePerSecond;
    private IntegerArgument warmUpIntervals;
    private ScopeArgument scopeArg;
    private StringArgument attributes;
    private StringArgument baseDN;
    private StringArgument filter;
    private StringArgument proxyAs;
    private StringArgument timestampFormat;

    public static void main(String[] args) {
        ResultCode resultCode = SearchRate.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        SearchRate searchRate = new SearchRate(outStream, errStream);
        return searchRate.runTool(args);
    }

    public SearchRate(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "searchrate";
    }

    @Override
    public String getToolDescription() {
        return "Perform repeated searches against an LDAP directory server.";
    }

    @Override
    public String getToolVersion() {
        return "2.3.3";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        String description = "The base DN to use for the searches.  It may be a simple DN or a value pattern to specify a range of DNs (e.g., \"uid=user.[1-1000],ou=People,dc=example,dc=com\").  This must be provided.";
        this.baseDN = new StringArgument(Character.valueOf('b'), "baseDN", true, 1, "{dn}", description);
        parser.addArgument(this.baseDN);
        description = "The scope to use for the searches.  It should be 'base', 'one', 'sub', or 'subord'.  If this is not provided, then a default scope of 'sub' will be used.";
        this.scopeArg = new ScopeArgument(Character.valueOf('s'), "scope", false, "{scope}", description, SearchScope.SUB);
        parser.addArgument(this.scopeArg);
        description = "The filter to use for the searches.  It may be a simple filter or a value pattern to specify a range of filters (e.g., \"(uid=user.[1-1000])\").  This must be provided.";
        this.filter = new StringArgument(Character.valueOf('f'), "filter", true, 1, "{filter}", description);
        parser.addArgument(this.filter);
        description = "The name of an attribute to include in entries returned from the searches.  Multiple attributes may be requested by providing this argument multiple times.  If no request attributes are provided, then the entries returned will include all user attributes.";
        this.attributes = new StringArgument(Character.valueOf('A'), "attribute", false, 0, "{name}", description);
        parser.addArgument(this.attributes);
        description = "The number of threads to use to perform the searches.  If this is not provided, then a default of one thread will be used.";
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 1);
        parser.addArgument(this.numThreads);
        description = "The length of time in seconds between output lines.  If this is not provided, then a default interval of five seconds will be used.";
        this.collectionInterval = new IntegerArgument(Character.valueOf('i'), "intervalDuration", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 5);
        parser.addArgument(this.collectionInterval);
        description = "The maximum number of intervals for which to run.  If this is not provided, then the tool will run until it is interrupted.";
        this.numIntervals = new IntegerArgument(Character.valueOf('I'), "numIntervals", true, 1, "{num}", description, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        parser.addArgument(this.numIntervals);
        description = "The number of search iterations that should be processed on a connection before that connection is closed and replaced with a newly-established (and authenticated, if appropriate) connection.  If this is not provided, then connections will not be periodically closed and re-established.";
        this.iterationsBeforeReconnect = new IntegerArgument(null, "iterationsBeforeReconnect", false, 1, "{num}", description, 0);
        parser.addArgument(this.iterationsBeforeReconnect);
        description = "The target number of searches to perform per second.  It is still necessary to specify a sufficient number of threads for achieving this rate.  If this option is not provided, then the tool will run at the maximum rate for the specified number of threads.";
        this.ratePerSecond = new IntegerArgument(Character.valueOf('r'), "ratePerSecond", false, 1, "{searches-per-second}", description, 1, Integer.MAX_VALUE);
        parser.addArgument(this.ratePerSecond);
        description = "The number of intervals to complete before beginning overall statistics collection.  Specifying a nonzero number of warm-up intervals gives the client and server a chance to warm up without skewing performance results.";
        this.warmUpIntervals = new IntegerArgument(null, "warmUpIntervals", true, 1, "{num}", description, 0, Integer.MAX_VALUE, 0);
        parser.addArgument(this.warmUpIntervals);
        description = "Indicates the format to use for timestamps included in the output.  A value of 'none' indicates that no timestamps should be included.  A value of 'with-date' indicates that both the date and the time should be included.  A value of 'without-date' indicates that only the time should be included.";
        LinkedHashSet<String> allowedFormats = new LinkedHashSet<String>(3);
        allowedFormats.add("none");
        allowedFormats.add("with-date");
        allowedFormats.add("without-date");
        this.timestampFormat = new StringArgument(null, "timestampFormat", true, 1, "{format}", description, allowedFormats, "none");
        parser.addArgument(this.timestampFormat);
        description = "Indicates that the proxied authorization control (as defined in RFC 4370) should be used to request that operations be processed using an alternate authorization identity.";
        this.proxyAs = new StringArgument(Character.valueOf('Y'), "proxyAs", false, 1, "{authzID}", description);
        parser.addArgument(this.proxyAs);
        description = "Indicates that the client should operate in asynchronous mode, in which it will not be necessary to wait for a response to a previous request before sending the next request.  Either the '--ratePerSecond' or the '--maxOutstandingRequests' argument must be provided to limit the number of outstanding requests.";
        this.asynchronousMode = new BooleanArgument(Character.valueOf('a'), "asynchronous", description);
        parser.addArgument(this.asynchronousMode);
        description = "Specifies the maximum number of outstanding requests that should be allowed when operating in asynchronous mode.";
        this.maxOutstandingRequests = new IntegerArgument(Character.valueOf('O'), "maxOutstandingRequests", false, 1, "{num}", description, 1, Integer.MAX_VALUE, (Integer)null);
        parser.addArgument(this.maxOutstandingRequests);
        description = "Indicates that information about the result codes for failed operations should not be displayed.";
        this.suppressErrors = new BooleanArgument(null, "suppressErrorResultCodes", 1, description);
        parser.addArgument(this.suppressErrors);
        description = "Generate output in CSV format rather than a display-friendly format";
        this.csvFormat = new BooleanArgument(Character.valueOf('c'), "csv", 1, description);
        parser.addArgument(this.csvFormat);
        description = "Specifies the seed to use for the random number generator.";
        this.randomSeed = new IntegerArgument(Character.valueOf('R'), "randomSeed", false, 1, "{value}", description);
        parser.addArgument(this.randomSeed);
        parser.addDependentArgumentSet(this.asynchronousMode, this.ratePerSecond, this.maxOutstandingRequests);
        parser.addDependentArgumentSet(this.maxOutstandingRequests, this.asynchronousMode, new Argument[0]);
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setAutoReconnect(true);
        options.setUseSynchronousMode(!this.asynchronousMode.isPresent());
        return options;
    }

    @Override
    public ResultCode doToolProcessing() {
        long totalIntervals;
        boolean warmUp;
        String timeFormat;
        boolean includeTimestamp;
        String[] attrs;
        ValuePattern authzIDPattern;
        ValuePattern filterPattern;
        ValuePattern dnPattern;
        Long seed = this.randomSeed.isPresent() ? Long.valueOf(this.randomSeed.getValue().intValue()) : null;
        try {
            dnPattern = new ValuePattern(this.baseDN.getValue(), seed);
        }
        catch (ParseException pe) {
            this.err("Unable to parse the base DN value pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        try {
            filterPattern = new ValuePattern(this.filter.getValue(), seed);
        }
        catch (ParseException pe) {
            this.err("Unable to parse the filter pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        if (this.proxyAs.isPresent()) {
            try {
                authzIDPattern = new ValuePattern(this.proxyAs.getValue(), seed);
            }
            catch (ParseException pe) {
                this.err("Unable to parse the proxied authorization pattern:  ", pe.getMessage());
                return ResultCode.PARAM_ERROR;
            }
        } else {
            authzIDPattern = null;
        }
        if (this.attributes.isPresent()) {
            List<String> attrList = this.attributes.getValues();
            attrs = new String[attrList.size()];
            attrList.toArray(attrs);
        } else {
            attrs = StaticUtils.NO_STRINGS;
        }
        FixedRateBarrier fixedRateBarrier = null;
        if (this.ratePerSecond.isPresent()) {
            int intervalSeconds = this.collectionInterval.getValue();
            int ratePerInterval = this.ratePerSecond.getValue() * intervalSeconds;
            fixedRateBarrier = new FixedRateBarrier(1000L * (long)intervalSeconds, ratePerInterval);
        }
        Semaphore asyncSemaphore = this.maxOutstandingRequests.isPresent() ? new Semaphore(this.maxOutstandingRequests.getValue()) : null;
        if (this.timestampFormat.getValue().equalsIgnoreCase("with-date")) {
            includeTimestamp = true;
            timeFormat = "dd/MM/yyyy HH:mm:ss";
        } else if (this.timestampFormat.getValue().equalsIgnoreCase("without-date")) {
            includeTimestamp = true;
            timeFormat = "HH:mm:ss";
        } else {
            includeTimestamp = false;
            timeFormat = null;
        }
        int remainingWarmUpIntervals = this.warmUpIntervals.getValue();
        if (remainingWarmUpIntervals > 0) {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue() + (long)remainingWarmUpIntervals;
        } else {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue();
        }
        OutputFormat outputFormat = this.csvFormat.isPresent() ? OutputFormat.CSV : OutputFormat.COLUMNS;
        ColumnFormatter formatter = new ColumnFormatter(includeTimestamp, timeFormat, outputFormat, " ", new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Searches/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Avg Dur ms"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Entries/Srch"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Errors/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Searches/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Avg Dur ms"));
        AtomicLong searchCounter = new AtomicLong(0L);
        AtomicLong entryCounter = new AtomicLong(0L);
        AtomicLong errorCounter = new AtomicLong(0L);
        AtomicLong searchDurations = new AtomicLong(0L);
        ResultCodeCounter rcCounter = new ResultCodeCounter();
        long intervalMillis = 1000L * (long)this.collectionInterval.getValue().intValue();
        CyclicBarrier barrier = new CyclicBarrier(this.numThreads.getValue() + 1);
        SearchRateThread[] threads = new SearchRateThread[this.numThreads.getValue().intValue()];
        for (int i = 0; i < threads.length; ++i) {
            LDAPConnection connection;
            try {
                connection = this.getConnection();
            }
            catch (LDAPException le) {
                this.err("Unable to connect to the directory server:  ", StaticUtils.getExceptionMessage(le));
                return le.getResultCode();
            }
            threads[i] = new SearchRateThread(this, i, connection, this.asynchronousMode.isPresent(), dnPattern, this.scopeArg.getValue(), filterPattern, attrs, authzIDPattern, this.iterationsBeforeReconnect.getValue().intValue(), barrier, searchCounter, entryCounter, searchDurations, errorCounter, rcCounter, fixedRateBarrier, asyncSemaphore);
            threads[i].start();
        }
        for (String headerLine : formatter.getHeaderLines(true)) {
            this.out(headerLine);
        }
        try {
            barrier.await();
        }
        catch (Exception e) {
            // empty catch block
        }
        long overallStartTime = System.nanoTime();
        long nextIntervalStartTime = System.currentTimeMillis() + intervalMillis;
        boolean setOverallStartTime = false;
        long lastDuration = 0L;
        long lastNumEntries = 0L;
        long lastNumErrors = 0L;
        long lastNumSearches = 0L;
        long lastEndTime = System.nanoTime();
        for (long i = 0L; i < totalIntervals; ++i) {
            double recentAvgDuration;
            double recentEntriesPerSearch;
            long totalDuration;
            long numErrors;
            long numEntries;
            long numSearches;
            long startTimeMillis = System.currentTimeMillis();
            long sleepTimeMillis = nextIntervalStartTime - startTimeMillis;
            nextIntervalStartTime += intervalMillis;
            try {
                if (sleepTimeMillis > 0L) {
                    Thread.sleep(sleepTimeMillis);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            long endTime = System.nanoTime();
            long intervalDuration = endTime - lastEndTime;
            if (warmUp && remainingWarmUpIntervals > 0) {
                numSearches = searchCounter.getAndSet(0L);
                numEntries = entryCounter.getAndSet(0L);
                numErrors = errorCounter.getAndSet(0L);
                totalDuration = searchDurations.getAndSet(0L);
            } else {
                numSearches = searchCounter.get();
                numEntries = entryCounter.get();
                numErrors = errorCounter.get();
                totalDuration = searchDurations.get();
            }
            long recentNumSearches = numSearches - lastNumSearches;
            long recentNumEntries = numEntries - lastNumEntries;
            long recentNumErrors = numErrors - lastNumErrors;
            long recentDuration = totalDuration - lastDuration;
            double numSeconds = (double)intervalDuration / 1.0E9;
            double recentSearchRate = (double)recentNumSearches / numSeconds;
            double recentErrorRate = (double)recentNumErrors / numSeconds;
            if (recentNumSearches > 0L) {
                recentEntriesPerSearch = 1.0 * (double)recentNumEntries / (double)recentNumSearches;
                recentAvgDuration = 1.0 * (double)recentDuration / (double)recentNumSearches / 1000000.0;
            } else {
                recentEntriesPerSearch = 0.0;
                recentAvgDuration = 0.0;
            }
            if (warmUp && remainingWarmUpIntervals > 0) {
                this.out(formatter.formatRow(recentSearchRate, recentAvgDuration, recentEntriesPerSearch, recentErrorRate, "warming up", "warming up"));
                if (--remainingWarmUpIntervals == 0) {
                    this.out("Warm-up completed.  Beginning overall statistics collection.");
                    setOverallStartTime = true;
                }
            } else {
                if (setOverallStartTime) {
                    overallStartTime = lastEndTime;
                    setOverallStartTime = false;
                }
                double numOverallSeconds = (double)(endTime - overallStartTime) / 1.0E9;
                double overallSearchRate = (double)numSearches / numOverallSeconds;
                double overallAvgDuration = numSearches > 0L ? 1.0 * (double)totalDuration / (double)numSearches / 1000000.0 : 0.0;
                this.out(formatter.formatRow(recentSearchRate, recentAvgDuration, recentEntriesPerSearch, recentErrorRate, overallSearchRate, overallAvgDuration));
                lastNumSearches = numSearches;
                lastNumEntries = numEntries;
                lastNumErrors = numErrors;
                lastDuration = totalDuration;
            }
            List<ObjectPair<ResultCode, Long>> rcCounts = rcCounter.getCounts(true);
            if (!this.suppressErrors.isPresent() && !rcCounts.isEmpty()) {
                this.err("\tError Results:");
                for (ObjectPair<ResultCode, Long> p : rcCounts) {
                    this.err("\t", p.getFirst().getName(), ":  ", p.getSecond());
                }
            }
            lastEndTime = endTime;
        }
        ResultCode resultCode = ResultCode.SUCCESS;
        for (SearchRateThread t : threads) {
            t.signalShutdown();
        }
        for (SearchRateThread t : threads) {
            ResultCode r = t.waitForShutdown();
            if (resultCode != ResultCode.SUCCESS) continue;
            resultCode = r;
        }
        return resultCode;
    }

    int getMaxOutstandingRequests() {
        if (this.maxOutstandingRequests.isPresent()) {
            return this.maxOutstandingRequests.getValue();
        }
        return -1;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--scope", "sub", "--filter", "(uid=user.[1-1000000])", "--attribute", "givenName", "--attribute", "sn", "--attribute", "mail", "--numThreads", "10"};
        String description = "Test search performance by searching randomly across a set of one million users located below 'dc=example,dc=com' with ten concurrent threads.  The entries returned to the client will include the givenName, sn, and mail attributes.";
        examples.put(args, "Test search performance by searching randomly across a set of one million users located below 'dc=example,dc=com' with ten concurrent threads.  The entries returned to the client will include the givenName, sn, and mail attributes.");
        return examples;
    }
}

