/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedSearchOperation
extends InterceptedOperation
implements InMemoryInterceptedSearchRequest,
InMemoryInterceptedSearchResult {
    private SearchRequest searchRequest;
    private LDAPResult searchResult;

    InterceptedSearchOperation(LDAPListenerClientConnection clientConnection, int messageID, SearchRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.searchRequest = requestOp.toSearchRequest(requestControls);
        this.searchResult = null;
    }

    public ReadOnlySearchRequest getRequest() {
        return this.searchRequest;
    }

    public void setRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
    }

    public LDAPResult getResult() {
        return this.searchResult;
    }

    public void setResult(LDAPResult searchResult) {
        this.searchResult = searchResult;
    }

    public void sendSearchEntry(Entry entry) throws LDAPException {
        Control[] controls = entry instanceof SearchResultEntry ? ((SearchResultEntry)entry).getControls() : null;
        this.getClientConnection().sendSearchResultEntry(this.getMessageID(), new SearchResultEntryProtocolOp(entry), controls);
    }

    public void sendSearchReference(SearchResultReference reference) throws LDAPException {
        this.getClientConnection().sendSearchResultReference(this.getMessageID(), new SearchResultReferenceProtocolOp(reference), reference.getControls());
    }

    public void toString(StringBuilder buffer) {
        buffer.append("InterceptedSearchOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.searchRequest);
        buffer.append(", result=");
        buffer.append(this.searchResult);
        buffer.append(')');
    }
}

