/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import com.unboundid.util.WakeableSleeper;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.DurationArgument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
public final class RateAdjustor
extends Thread {
    public static final char COMMENT_START = '#';
    public static final String END_HEADER_TEXT = "END HEADER";
    public static final String DEFAULT_DURATION_KEY = "default-duration";
    public static final String FORMAT_KEY = "format";
    public static final String FORMAT_VALUE_RATE_DURATION = "rate-and-duration";
    public static final List<String> FORMATS = Arrays.asList("rate-and-duration");
    public static final String REPEAT_KEY = "repeat";
    public static final List<String> KEYS = Arrays.asList("default-duration", "format", "repeat");
    private final FixedRateBarrier barrier;
    private final List<ObjectPair<Double, Long>> ratesAndDurations;
    private final boolean repeat;
    private volatile boolean shutDown = false;
    private final CountDownLatch initialRateSetLatch = new CountDownLatch(1);
    private final WakeableSleeper sleeper = new WakeableSleeper();

    public static RateAdjustor newInstance(FixedRateBarrier barrier, Integer baseRatePerSecond, File rates) throws IOException, IllegalArgumentException {
        FileReader reader = new FileReader(rates);
        return new RateAdjustor(barrier, baseRatePerSecond == null ? 0L : (long)baseRatePerSecond.intValue(), reader);
    }

    public static String getVariableRateDataArgumentDescription(String genArgName) {
        return UtilityMessages.INFO_RATE_ADJUSTOR_VARIABLE_RATE_DATA_ARG_DESCRIPTION.get(genArgName);
    }

    public static String getGenerateSampleVariableRateFileDescription(String dataFileArgName) {
        return UtilityMessages.INFO_RATE_ADJUSTOR_GENERATE_SAMPLE_RATE_FILE_ARG_DESCRIPTION.get(dataFileArgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSampleVariableRateFile(File f) throws IOException {
        PrintWriter w = new PrintWriter(f);
        try {
            w.println("# This is an example variable rate data file.  All blank lines will be ignored.");
            w.println("# All lines starting with the '#' character are considered comments and will");
            w.println("# also be ignored.");
            w.println();
            w.println("# The beginning of the file must be a header containing properties pertaining");
            w.println("# to the variable rate data.  All headers must be in the format 'name=value',");
            w.println("# in which any spaces surrounding the equal sign will be ignored.");
            w.println();
            w.println("# The first header should be the 'format' header, which specifies the format");
            w.println("# for the variable rate data file.  This header is required.  At present, the");
            w.println("# only supported format is 'rate-and-duration', although additional formats may");
            w.println("# be added in the future.");
            w.println("format = rate-and-duration");
            w.println();
            w.println("# The optional 'default-duration' header may be used to specify a duration that");
            w.println("# will be used for any interval that does not explicitly specify a duration.");
            w.println("# The duration must consist of a positive integer value followed by a time");
            w.println("# unit (with zero or more spaces separating the integer value from the unit).");
            w.println("# The supported time units are:");
            w.println("#");
            w.println("# - nanoseconds, nanosecond, nanos, nano, ns");
            w.println("# - microseconds, microseconds, micros, micro, us");
            w.println("# - milliseconds, millisecond, millis, milli, ms");
            w.println("# - seconds, second, secs, sec, s");
            w.println("# - minutes, minute, mins, min, m");
            w.println("# - hours, hour, hrs, hr, h");
            w.println("# - days, day, d");
            w.println("#");
            w.println("# If no 'default-duration' header is present, then every data interval must");
            w.println("# include an explicitly-specified duration.");
            w.println("default-duration = 10 seconds");
            w.println();
            w.println("# The optional 'repeat' header may be used to indicate how the tool should");
            w.println("# behave once the end of the variable rate data definitions has been reached.");
            w.println("# If the 'repeat' header is present with a value of 'true', then the tool will");
            w.println("# operate in an endless loop, returning to the beginning of the variable rate");
            w.println("# definitions once the end has been reached.  If the 'repeat' header is present");
            w.println("# with a value of 'false', or if the 'repeat' header is absent, then the tool");
            w.println("# will exit after it has processed all of the variable rate definitions.");
            w.println("repeat = true");
            w.println();
            w.println("# After all header properties have been specified, the end of the header must");
            w.println("# be signified with a line containing only the text 'END HEADER'.");
            w.println(END_HEADER_TEXT);
            w.println();
            w.println();
            w.println("# After the header is complete, the variable rate definitions should be");
            w.println("# provided.  Each definition should be given on a line by itself, and should");
            w.println("# contain a target rate per second and an optional length of time to maintain");
            w.println("# that rate.");
            w.println("#");
            w.println("# The target rate must always be present in a variable rate definition.  It may");
            w.println("# be either a positive integer value that specifies the absolute target rate");
            w.println("# per second (e.g., a value of '1000' indicates a target rate of 1000");
            w.println("# operations per second), or it may be a floating-point value followed by the");
            w.println("# letter 'x' to indicate that it is a multiplier of the value specified by the");
            w.println("# '--ratePerSecond' argument (e.g., if the '--ratePerSecond' argument is");
            w.println("# present with a value of 1000, then a target rate value of '0.75x' indicates a");
            w.println("# target rate that is 75% of the '--ratePerSecond' value, or 750 operations per");
            w.println("# second).  If the latter format is used, then the '--ratePerSecond' argument");
            w.println("# must be provided.");
            w.println("#");
            w.println("# The duration may optionally be present in a variable rate definition.  If");
            w.println("# present, it must be separated from the target rate by a comma (and there may");
            w.println("# be zero or more spaces on either side of the comma).  The duration must be in");
            w.println("# the same format as specified in the description of the 'default-duration'");
            w.println("# header above (i.e., a positive integer followed by a time unit).  If a");
            w.println("# variable rate definition does not include a duration, then the");
            w.println("# 'default-duration' header must have been specified, and that default duration");
            w.println("# will be used for that variable rate definition.");
            w.println("#");
            w.println("# The following variable rate definitions may be used to stairstep the target");
            w.println("# rate from 1000 operations per second to 10000 operations per second, in");
            w.println("# increments of 1000 operations per second, spending one minute at each level.");
            w.println("# If the 'repeat' header is present with a value of 'true', then the process");
            w.println("# will start back over at 1000 operations per second after completing one");
            w.println("# minute at 10000 operations per second.  Otherwise, the tool will exit after");
            w.println("# completing the 10000 operation-per-second interval.");
            w.println("1000, 1 minute");
            w.println("2000, 1 minute");
            w.println("3000, 1 minute");
            w.println("4000, 1 minute");
            w.println("5000, 1 minute");
            w.println("6000, 1 minute");
            w.println("7000, 1 minute");
            w.println("8000, 1 minute");
            w.println("9000, 1 minute");
            w.println("10000, 1 minute");
            w.println();
            Object var3_2 = null;
            w.close();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            w.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateAdjustor(FixedRateBarrier barrier, long baseRatePerSecond, Reader rates) throws IOException, IllegalArgumentException {
        List<String> lines;
        try {
            Validator.ensureNotNull(barrier, rates);
            this.setDaemon(true);
            this.barrier = barrier;
            lines = RateAdjustor.readLines(rates);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            rates.close();
            throw throwable;
        }
        rates.close();
        Map<String, String> header = RateAdjustor.consumeHeader(lines);
        LinkedHashSet<String> invalidKeys = new LinkedHashSet<String>(header.keySet());
        invalidKeys.removeAll(KEYS);
        if (!invalidKeys.isEmpty()) {
            throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_INVALID_KEYS.get(invalidKeys, KEYS));
        }
        String format = header.get(FORMAT_KEY);
        if (format == null) {
            throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_MISSING_FORMAT.get(FORMAT_KEY, FORMATS, Character.valueOf('#')));
        }
        if (!format.equals(FORMAT_VALUE_RATE_DURATION)) {
            throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_INVALID_FORMAT.get(format, FORMAT_KEY, FORMATS));
        }
        this.repeat = Boolean.parseBoolean(header.get(REPEAT_KEY));
        long defaultDurationMillis = 0L;
        String defaultDurationStr = header.get(DEFAULT_DURATION_KEY);
        if (defaultDurationStr != null) {
            try {
                defaultDurationMillis = DurationArgument.parseDuration(defaultDurationStr, TimeUnit.MILLISECONDS);
            }
            catch (ArgumentException e) {
                Debug.debugException(e);
                throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_INVALID_DEFAULT_DURATION.get(defaultDurationStr, e.getExceptionMessage()), e);
            }
        }
        ArrayList<ObjectPair<Double, Long>> ratesAndDurationList = new ArrayList<ObjectPair<Double, Long>>(10);
        Pattern splitPattern = Pattern.compile("\\s*,\\s*");
        Iterator<String> i$ = lines.iterator();
        while (i$.hasNext()) {
            long durationMillis;
            double rate;
            String fullLine;
            String line = fullLine = i$.next();
            int commentStart = fullLine.indexOf(35);
            if (commentStart >= 0) {
                line = line.substring(0, commentStart);
            }
            if ((line = line.trim()).length() == 0) continue;
            String[] fields = splitPattern.split(line);
            if (fields.length != 2 && (fields.length != 1 || defaultDurationMillis == 0L)) {
                throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_INVALID_LINE.get(fullLine, DEFAULT_DURATION_KEY));
            }
            String rateStr = fields[0];
            boolean isRateMultiplier = false;
            if (rateStr.endsWith("X") || rateStr.endsWith("x")) {
                rateStr = rateStr.substring(0, rateStr.length() - 1).trim();
                isRateMultiplier = true;
            }
            try {
                rate = Double.parseDouble(rateStr);
            }
            catch (NumberFormatException e) {
                Debug.debugException(e);
                throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_INVALID_RATE.get(rateStr, fullLine), e);
            }
            if (isRateMultiplier) {
                if (baseRatePerSecond <= 0L) {
                    throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_RELATIVE_RATE_WITHOUT_BASELINE.get(rateStr, fullLine));
                }
                rate *= (double)baseRatePerSecond;
            }
            if (fields.length < 2) {
                durationMillis = defaultDurationMillis;
            } else {
                String duration = fields[1];
                try {
                    durationMillis = DurationArgument.parseDuration(duration, TimeUnit.MILLISECONDS);
                }
                catch (ArgumentException e) {
                    Debug.debugException(e);
                    throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_INVALID_DURATION.get(duration, fullLine, e.getExceptionMessage()), e);
                }
            }
            ratesAndDurationList.add(new ObjectPair<Double, Long>(rate, durationMillis));
        }
        this.ratesAndDurations = Collections.unmodifiableList(ratesAndDurationList);
    }

    @Override
    public void start() {
        super.start();
        try {
            this.initialRateSetLatch.await();
        }
        catch (InterruptedException e) {
            Debug.debugException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block9: {
            block8: {
                try {
                    if (this.ratesAndDurations.isEmpty()) {
                        Object var14_1 = null;
                        if (this.initialRateSetLatch.getCount() <= 0L) return;
                        this.initialRateSetLatch.countDown();
                        return;
                    }
                    do {
                        ArrayList<ObjectPair<Double, Long>> ratesAndEndTimes = new ArrayList<ObjectPair<Double, Long>>(this.ratesAndDurations.size());
                        long endTime = System.currentTimeMillis();
                        for (ObjectPair<Double, Long> rateAndDuration : this.ratesAndDurations) {
                            ratesAndEndTimes.add(new ObjectPair<Double, Long>(rateAndDuration.getFirst(), endTime += rateAndDuration.getSecond().longValue()));
                        }
                        for (ObjectPair<Double, Long> rateAndEndTime : ratesAndEndTimes) {
                            long durationMillis;
                            if (this.shutDown) {
                                break block8;
                            }
                            double rate = rateAndEndTime.getFirst();
                            long intervalMillis = this.barrier.getTargetRate().getFirst();
                            int perInterval = RateAdjustor.calculatePerInterval(intervalMillis, rate);
                            this.barrier.setRate(intervalMillis, perInterval);
                            if (this.initialRateSetLatch.getCount() > 0L) {
                                this.initialRateSetLatch.countDown();
                            }
                            if ((durationMillis = rateAndEndTime.getSecond() - System.currentTimeMillis()) <= 0L) continue;
                            this.sleeper.sleep(durationMillis);
                        }
                    } while (this.repeat);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var14_4 = null;
                    if (this.initialRateSetLatch.getCount() <= 0L) throw throwable;
                    this.initialRateSetLatch.countDown();
                    throw throwable;
                }
            }
            Object var14_2 = null;
            if (this.initialRateSetLatch.getCount() <= 0L) return;
            this.initialRateSetLatch.countDown();
            return;
        }
        Object var14_3 = null;
        if (this.initialRateSetLatch.getCount() <= 0L) return;
        this.initialRateSetLatch.countDown();
    }

    public void shutDown() {
        this.shutDown = true;
        this.sleeper.wakeup();
    }

    List<ObjectPair<Double, Long>> getRatesAndDurations() {
        return this.ratesAndDurations;
    }

    static int calculatePerInterval(long intervalDurationMillis, double ratePerSecond) {
        double intervalDurationSeconds = (double)intervalDurationMillis / 1000.0;
        double ratePerInterval = ratePerSecond * intervalDurationSeconds;
        return (int)Math.max(1L, Math.round(ratePerInterval));
    }

    static Map<String, String> consumeHeader(List<String> lines) throws IllegalArgumentException {
        boolean endHeaderFound = false;
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(3);
        Iterator<String> lineIter = lines.iterator();
        while (lineIter.hasNext()) {
            String line = lineIter.next().trim();
            lineIter.remove();
            if (line.length() == 0 || line.startsWith(String.valueOf('#'))) continue;
            if (line.equalsIgnoreCase(END_HEADER_TEXT)) {
                endHeaderFound = true;
                break;
            }
            int equalPos = line.indexOf(61);
            if (equalPos < 0) {
                throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_HEADER_NO_EQUAL.get(line));
            }
            String key = line.substring(0, equalPos).trim();
            if (key.length() == 0) {
                throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_HEADER_EMPTY_KEY.get(line));
            }
            String newValue = line.substring(equalPos + 1).trim();
            String existingValue = (String)headerMap.get(key);
            if (existingValue != null) {
                throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_DUPLICATE_HEADER_KEY.get(key, existingValue, newValue));
            }
            headerMap.put(key, newValue);
        }
        if (!endHeaderFound) {
            throw new IllegalArgumentException(UtilityMessages.ERR_RATE_ADJUSTOR_NO_END_HEADER_FOUND.get(END_HEADER_TEXT));
        }
        return headerMap;
    }

    private static List<String> readLines(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        LinkedList<String> lines = new LinkedList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }
}

