/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.CommandLineToolInteractiveModeProcessor;
import com.unboundid.util.CommandLineToolShutdownHook;
import com.unboundid.util.Debug;
import com.unboundid.util.ExampleCommandLineArgument;
import com.unboundid.util.Extensible;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.NullOutputStream;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class CommandLineTool {
    private final PrintStream out;
    private final PrintStream err;
    private BooleanArgument helpArgument = null;
    private BooleanArgument interactiveArgument = null;
    private BooleanArgument versionArgument = null;

    public CommandLineTool(OutputStream outStream, OutputStream errStream) {
        this.out = outStream == null ? NullOutputStream.getPrintStream() : new PrintStream(outStream);
        this.err = errStream == null ? NullOutputStream.getPrintStream() : new PrintStream(errStream);
    }

    public final ResultCode runTool(String ... args) {
        try {
            ArgumentParser parser = this.createArgumentParser();
            if (!this.supportsInteractiveMode() || !this.defaultsToInteractiveMode() || args != null && args.length != 0) {
                parser.parse(args);
            }
            if (this.helpArgument.isPresent()) {
                this.out(parser.getUsageString(StaticUtils.TERMINAL_WIDTH_COLUMNS - 1));
                this.displayExampleUsages();
                return ResultCode.SUCCESS;
            }
            if (this.versionArgument != null && this.versionArgument.isPresent()) {
                this.out(this.getToolVersion());
                return ResultCode.SUCCESS;
            }
            boolean extendedValidationDone = false;
            if (this.interactiveArgument != null && (this.interactiveArgument.isPresent() || this.defaultsToInteractiveMode() && (args == null || args.length == 0))) {
                CommandLineToolInteractiveModeProcessor interactiveProcessor = new CommandLineToolInteractiveModeProcessor(this, parser);
                try {
                    interactiveProcessor.doInteractiveModeProcessing();
                    extendedValidationDone = true;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    String message = le.getMessage();
                    if (message != null && message.length() > 0) {
                        this.err(message);
                    }
                    return le.getResultCode();
                }
            }
            if (!extendedValidationDone) {
                this.doExtendedArgumentValidation();
            }
        }
        catch (ArgumentException ae) {
            Debug.debugException(ae);
            this.err(ae.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        AtomicReference<ResultCode> exitCode = new AtomicReference<ResultCode>();
        if (this.registerShutdownHook()) {
            CommandLineToolShutdownHook shutdownHook = new CommandLineToolShutdownHook(this, exitCode);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        try {
            exitCode.set(this.doToolProcessing());
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(StaticUtils.getExceptionMessage(e));
            exitCode.set(ResultCode.LOCAL_ERROR);
        }
        return exitCode.get();
    }

    private void displayExampleUsages() {
        LinkedHashMap<String[], String> examples = this.getExampleUsages();
        if (examples == null || examples.isEmpty()) {
            return;
        }
        this.out(new Object[]{UtilityMessages.INFO_CL_TOOL_LABEL_EXAMPLES});
        int wrapWidth = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
        for (Map.Entry<String[], String> e : examples.entrySet()) {
            this.out(new Object[0]);
            this.wrapOut(2, wrapWidth, e.getValue());
            this.out(new Object[0]);
            StringBuilder buffer = new StringBuilder();
            buffer.append("    ");
            buffer.append(this.getToolName());
            String[] args = e.getKey();
            for (int i = 0; i < args.length; ++i) {
                ExampleCommandLineArgument cleanArg;
                buffer.append(' ');
                String arg = args[i];
                if (arg.startsWith("-")) {
                    if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                        cleanArg = ExampleCommandLineArgument.getCleanArgument(args[i + 1]);
                        arg = arg + ' ' + cleanArg.getLocalForm();
                        ++i;
                    }
                } else {
                    cleanArg = ExampleCommandLineArgument.getCleanArgument(arg);
                    arg = cleanArg.getLocalForm();
                }
                if (buffer.length() + arg.length() + 2 < wrapWidth) {
                    buffer.append(arg);
                    continue;
                }
                buffer.append('\\');
                this.out(buffer.toString());
                buffer.setLength(0);
                buffer.append("         ");
                buffer.append(arg);
            }
            this.out(buffer.toString());
        }
    }

    public abstract String getToolName();

    public abstract String getToolDescription();

    public String getToolVersion() {
        return null;
    }

    public int getMinTrailingArguments() {
        return 0;
    }

    public int getMaxTrailingArguments() {
        return 0;
    }

    public String getTrailingArgumentsPlaceholder() {
        return null;
    }

    public boolean supportsInteractiveMode() {
        return false;
    }

    public boolean defaultsToInteractiveMode() {
        return false;
    }

    public final ArgumentParser createArgumentParser() throws ArgumentException {
        ArgumentParser parser = new ArgumentParser(this.getToolName(), this.getToolDescription(), this.getMinTrailingArguments(), this.getMaxTrailingArguments(), this.getTrailingArgumentsPlaceholder());
        this.addToolArguments(parser);
        if (this.supportsInteractiveMode()) {
            this.interactiveArgument = new BooleanArgument(null, "interactive", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_INTERACTIVE.get());
            this.interactiveArgument.setUsageArgument(true);
            parser.addArgument(this.interactiveArgument);
        }
        this.helpArgument = new BooleanArgument(Character.valueOf('H'), "help", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_HELP.get());
        this.helpArgument.addShortIdentifier(Character.valueOf('?'));
        this.helpArgument.setUsageArgument(true);
        parser.addArgument(this.helpArgument);
        String version = this.getToolVersion();
        if (version != null && version.length() > 0 && parser.getNamedArgument("version") == null) {
            Character shortIdentifier = parser.getNamedArgument(Character.valueOf('V')) == null ? Character.valueOf('V') : null;
            this.versionArgument = new BooleanArgument(shortIdentifier, "version", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_VERSION.get());
            this.versionArgument.setUsageArgument(true);
            parser.addArgument(this.versionArgument);
        }
        return parser;
    }

    static Set<String> getUsageArgumentIdentifiers() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>(21);
        ids.add("interactive");
        ids.add("help");
        ids.add("version");
        return Collections.unmodifiableSet(ids);
    }

    public abstract void addToolArguments(ArgumentParser var1) throws ArgumentException;

    public void doExtendedArgumentValidation() throws ArgumentException {
    }

    public abstract ResultCode doToolProcessing();

    protected boolean registerShutdownHook() {
        return false;
    }

    protected void doShutdownHookProcessing(ResultCode resultCode) {
        throw new LDAPSDKUsageException(UtilityMessages.ERR_COMMAND_LINE_TOOL_SHUTDOWN_HOOK_NOT_IMPLEMENTED.get(this.getToolName()));
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public LinkedHashMap<String[], String> getExampleUsages() {
        return null;
    }

    public final PrintStream getOut() {
        return this.out;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void out(Object ... msg) {
        CommandLineTool.write(this.out, 0, 0, msg);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void wrapOut(int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(this.out, indent, wrapColumn, msg);
    }

    final synchronized void wrapStandardOut(int firstLineIndent, int subsequentLineIndent, int wrapColumn, boolean endWithNewline, Object ... msg) {
        CommandLineTool.write(this.out, firstLineIndent, subsequentLineIndent, wrapColumn, endWithNewline, msg);
    }

    public final PrintStream getErr() {
        return this.err;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void err(Object ... msg) {
        CommandLineTool.write(this.err, 0, 0, msg);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void wrapErr(int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(this.err, indent, wrapColumn, msg);
    }

    private static void write(PrintStream stream, int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(stream, indent, indent, wrapColumn, true, msg);
    }

    private static void write(PrintStream stream, int firstLineIndent, int subsequentLineIndent, int wrapColumn, boolean endWithNewline, Object ... msg) {
        StringBuilder buffer = new StringBuilder();
        for (Object o : msg) {
            buffer.append(o);
        }
        if (wrapColumn > 2) {
            boolean firstLine = true;
            for (String line : StaticUtils.wrapLine(buffer.toString(), wrapColumn - firstLineIndent, wrapColumn - subsequentLineIndent)) {
                int indent;
                if (firstLine) {
                    indent = firstLineIndent;
                    firstLine = false;
                } else {
                    stream.println();
                    indent = subsequentLineIndent;
                }
                if (indent > 0) {
                    for (int i = 0; i < indent; ++i) {
                        stream.print(' ');
                    }
                }
                stream.print(line);
            }
        } else {
            if (firstLineIndent > 0) {
                for (int i = 0; i < firstLineIndent; ++i) {
                    stream.print(' ');
                }
            }
            stream.print(buffer.toString());
        }
        if (endWithNewline) {
            stream.println();
        }
        stream.flush();
    }
}

