/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.WakeableSleeper;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPSearch
extends LDAPCommandLineTool
implements SearchResultListener {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss.SSS");
    private static final long serialVersionUID = 7465188734621412477L;
    private ArgumentParser parser;
    private boolean repeat;
    private BooleanArgument followReferrals;
    private BooleanArgument terseMode;
    private ControlArgument bindControls;
    private ControlArgument searchControls;
    private IntegerArgument numSearches;
    private IntegerArgument repeatIntervalMillis;
    private DNArgument baseDN;
    private ScopeArgument scopeArg;

    public static void main(String[] args) {
        ResultCode resultCode = LDAPSearch.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        LDAPSearch ldapSearch = new LDAPSearch(outStream, errStream);
        return ldapSearch.runTool(args);
    }

    public LDAPSearch(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "ldapsearch";
    }

    @Override
    public String getToolDescription() {
        return "Search an LDAP directory server.";
    }

    @Override
    public String getToolVersion() {
        return "3.1.1";
    }

    @Override
    public int getMinTrailingArguments() {
        return 1;
    }

    @Override
    public int getMaxTrailingArguments() {
        return -1;
    }

    @Override
    public String getTrailingArgumentsPlaceholder() {
        return "{filter} [attr1 [attr2 [...]]]";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        String description = "The base DN to use for the search.  This must be provided.";
        this.baseDN = new DNArgument(Character.valueOf('b'), "baseDN", true, 1, "{dn}", description);
        this.baseDN.addLongIdentifier("base-dn");
        parser.addArgument(this.baseDN);
        description = "The scope to use for the search.  It should be 'base', 'one', 'sub', or 'subord'.  If this is not provided, then a default scope of 'sub' will be used.";
        this.scopeArg = new ScopeArgument(Character.valueOf('s'), "scope", false, "{scope}", description, SearchScope.SUB);
        parser.addArgument(this.scopeArg);
        description = "Follow any referrals encountered during processing.";
        this.followReferrals = new BooleanArgument(Character.valueOf('R'), "followReferrals", description);
        this.followReferrals.addLongIdentifier("follow-referrals");
        parser.addArgument(this.followReferrals);
        description = "Information about a control to include in the bind request.";
        this.bindControls = new ControlArgument(null, "bindControl", false, 0, null, description);
        this.bindControls.addLongIdentifier("bind-control");
        parser.addArgument(this.bindControls);
        description = "Information about a control to include in search requests.";
        this.searchControls = new ControlArgument(Character.valueOf('J'), "control", false, 0, null, description);
        parser.addArgument(this.searchControls);
        description = "Generate terse output with minimal additional information.";
        this.terseMode = new BooleanArgument(Character.valueOf('t'), "terse", description);
        parser.addArgument(this.terseMode);
        description = "Specifies the length of time in milliseconds to sleep before repeating the same search.  If this is not provided, then the search will only be performed once.";
        this.repeatIntervalMillis = new IntegerArgument(Character.valueOf('i'), "repeatIntervalMillis", false, 1, "{millis}", description, 0, Integer.MAX_VALUE);
        this.repeatIntervalMillis.addLongIdentifier("repeat-interval-millis");
        parser.addArgument(this.repeatIntervalMillis);
        description = "Specifies the number of times that the search should be performed.  If this argument is present, then the --repeatIntervalMillis argument must also be provided to specify the length of time between searches.  If --repeatIntervalMillis is used without --numSearches, then the search will be repeated until the tool is interrupted.";
        this.numSearches = new IntegerArgument(Character.valueOf('n'), "numSearches", false, 1, "{count}", description, 1, Integer.MAX_VALUE);
        this.numSearches.addLongIdentifier("num-searches");
        parser.addArgument(this.numSearches);
        parser.addDependentArgumentSet(this.numSearches, this.repeatIntervalMillis, new Argument[0]);
    }

    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        if (this.parser.getTrailingArguments().isEmpty()) {
            throw new ArgumentException("At least one trailing argument must be provided to specify the search filter.  Additional trailing arguments are allowed to specify the attributes to return in search result entries.");
        }
        try {
            Filter.create(this.parser.getTrailingArguments().get(0));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException("The first trailing argument value could not be parsed as a valid LDAP search filter.", e);
        }
    }

    @Override
    protected List<Control> getBindControls() {
        return this.bindControls.getValues();
    }

    @Override
    public ResultCode doToolProcessing() {
        int numIterations;
        boolean infinite;
        LDAPConnection connection;
        String[] attributesToReturn;
        Filter filter;
        List<String> trailingArguments = this.parser.getTrailingArguments();
        if (trailingArguments.isEmpty()) {
            this.err("No search filter was provided.");
            this.err(new Object[0]);
            this.err(this.parser.getUsageString(StaticUtils.TERMINAL_WIDTH_COLUMNS - 1));
            return ResultCode.PARAM_ERROR;
        }
        try {
            filter = Filter.create(trailingArguments.get(0));
        }
        catch (LDAPException le) {
            this.err("Invalid search filter:  ", le.getMessage());
            return le.getResultCode();
        }
        if (trailingArguments.size() > 1) {
            attributesToReturn = new String[trailingArguments.size() - 1];
            for (int i = 1; i < trailingArguments.size(); ++i) {
                attributesToReturn[i - 1] = trailingArguments.get(i);
            }
        } else {
            attributesToReturn = StaticUtils.NO_STRINGS;
        }
        try {
            connection = this.getConnection();
            if (!this.terseMode.isPresent()) {
                this.out("# Connected to ", connection.getConnectedAddress(), Character.valueOf(':'), connection.getConnectedPort());
            }
        }
        catch (LDAPException le) {
            this.err("Error connecting to the directory server:  ", le.getMessage());
            return le.getResultCode();
        }
        SearchRequest searchRequest = new SearchRequest((SearchResultListener)this, this.baseDN.getStringValue(), this.scopeArg.getValue(), DereferencePolicy.NEVER, 0, 0, false, filter, attributesToReturn);
        searchRequest.setFollowReferrals(this.followReferrals.isPresent());
        List<Control> controlList = this.searchControls.getValues();
        if (controlList != null) {
            searchRequest.setControls(controlList);
        }
        if (this.repeatIntervalMillis.isPresent()) {
            this.repeat = true;
            if (this.numSearches.isPresent()) {
                infinite = false;
                numIterations = this.numSearches.getValue();
            } else {
                infinite = true;
                numIterations = Integer.MAX_VALUE;
            }
        } else {
            infinite = false;
            this.repeat = false;
            numIterations = 1;
        }
        ResultCode resultCode = ResultCode.SUCCESS;
        long lastSearchTime = System.currentTimeMillis();
        WakeableSleeper sleeper = new WakeableSleeper();
        for (int i = 0; infinite || i < numIterations; ++i) {
            if (this.repeat && i > 0) {
                long sleepTime = lastSearchTime + (long)this.repeatIntervalMillis.getValue().intValue() - System.currentTimeMillis();
                if (sleepTime > 0L) {
                    sleeper.sleep(sleepTime);
                }
                lastSearchTime = System.currentTimeMillis();
            }
            try {
                SearchResult searchResult = connection.search(searchRequest);
                if (this.repeat || this.terseMode.isPresent()) continue;
                this.out("# The search operation was processed successfully.");
                this.out("# Entries returned:  ", searchResult.getEntryCount());
                this.out("# References returned:  ", searchResult.getReferenceCount());
                continue;
            }
            catch (LDAPException le) {
                this.err("An error occurred while processing the search:  ", le.getMessage());
                this.err("Result Code:  ", le.getResultCode().intValue(), " (", le.getResultCode().getName(), Character.valueOf(')'));
                if (le.getMatchedDN() != null) {
                    this.err("Matched DN:  ", le.getMatchedDN());
                }
                if (le.getReferralURLs() != null) {
                    for (String url : le.getReferralURLs()) {
                        this.err("Referral URL:  ", url);
                    }
                }
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = le.getResultCode();
                }
                if (!le.getResultCode().isConnectionUsable()) break;
            }
        }
        connection.close();
        if (!this.terseMode.isPresent()) {
            this.out(new Object[0]);
            this.out("# Disconnected from the server");
        }
        return resultCode;
    }

    @Override
    public void searchEntryReturned(SearchResultEntry entry) {
        if (this.repeat) {
            this.out("# ", DATE_FORMAT.format(new Date()));
        }
        this.out(entry.toLDIFString());
    }

    @Override
    public void searchReferenceReturned(SearchResultReference reference) {
        if (this.repeat) {
            this.out("# ", DATE_FORMAT.format(new Date()));
        }
        this.out(reference.toString());
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--scope", "sub", "(uid=jdoe)", "givenName", "sn", "mail"};
        String description = "Perform a search in the directory server to find all entries matching the filter '(uid=jdoe)' anywhere below 'dc=example,dc=com'.  Include only the givenName, sn, and mail attributes in the entries that are returned.";
        examples.put(args, "Perform a search in the directory server to find all entries matching the filter '(uid=jdoe)' anywhere below 'dc=example,dc=com'.  Include only the givenName, sn, and mail attributes in the entries that are returned.");
        return examples;
    }
}

