/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NoticeOfDisconnectionExtendedResult
extends ExtendedResult {
    public static final String NOTICE_OF_DISCONNECTION_RESULT_OID = "1.3.6.1.4.1.1466.20036";
    private static final long serialVersionUID = -4706102471360689558L;

    public NoticeOfDisconnectionExtendedResult(ResultCode resultCode, String diagnosticMessage, Control ... responseControls) {
        this(0, resultCode, diagnosticMessage, null, null, responseControls);
    }

    public NoticeOfDisconnectionExtendedResult(ExtendedResult extendedResult) {
        super(extendedResult);
    }

    public NoticeOfDisconnectionExtendedResult(LDAPException ldapException) {
        this(0, ldapException.getResultCode(), ldapException.getDiagnosticMessage(), ldapException.getMatchedDN(), ldapException.getReferralURLs(), ldapException.getResponseControls());
    }

    public NoticeOfDisconnectionExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, NOTICE_OF_DISCONNECTION_RESULT_OID, null, responseControls);
    }

    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_NOTICE_OF_DISCONNECT.get();
    }

    public void toString(StringBuilder buffer) {
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("NoticeOfDisconnectionExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        buffer.append(", oid=");
        buffer.append(NOTICE_OF_DISCONNECTION_RESULT_OID);
        Control[] responseControls = this.getResponseControls();
        if (responseControls.length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

