/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.AddAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ExcludeAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ExcludeEntryTransformation;
import com.unboundid.ldap.sdk.transformations.FlattenSubtreeTransformation;
import com.unboundid.ldap.sdk.transformations.MoveSubtreeTransformation;
import com.unboundid.ldap.sdk.transformations.PreEncodedLDIFEntry;
import com.unboundid.ldap.sdk.transformations.RedactAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.RenameAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ReplaceAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ReplaceWithCounterTransformation;
import com.unboundid.ldap.sdk.transformations.ScrambleAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.TransformationMessages;
import com.unboundid.ldif.AggregateLDIFReaderChangeRecordTranslator;
import com.unboundid.ldif.AggregateLDIFReaderEntryTranslator;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFReaderChangeRecordTranslator;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.util.AggregateInputStream;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class TransformLDIF
extends CommandLineTool
implements LDIFReaderEntryTranslator {
    private static final int MAX_OUTPUT_LINE_LENGTH = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private BooleanArgument addToExistingValues = null;
    private BooleanArgument appendToTargetLDIF = null;
    private BooleanArgument compressTarget = null;
    private BooleanArgument excludeNonMatchingEntries = null;
    private BooleanArgument flattenAddOmittedRDNAttributesToEntry = null;
    private BooleanArgument flattenAddOmittedRDNAttributesToRDN = null;
    private BooleanArgument hideRedactedValueCount = null;
    private BooleanArgument processDNs = null;
    private BooleanArgument sourceCompressed = null;
    private BooleanArgument sourceContainsChangeRecords = null;
    private BooleanArgument sourceFromStandardInput = null;
    private BooleanArgument targetToStandardOutput = null;
    private DNArgument addAttributeBaseDN = null;
    private DNArgument excludeEntryBaseDN = null;
    private DNArgument flattenBaseDN = null;
    private DNArgument moveSubtreeFrom = null;
    private DNArgument moveSubtreeTo = null;
    private FileArgument schemaPath = null;
    private FileArgument sourceLDIF = null;
    private FileArgument targetLDIF = null;
    private FilterArgument addAttributeFilter = null;
    private FilterArgument excludeEntryFilter = null;
    private FilterArgument flattenExcludeFilter = null;
    private IntegerArgument initialSequentialValue = null;
    private IntegerArgument numThreads = null;
    private IntegerArgument randomSeed = null;
    private IntegerArgument sequentialValueIncrement = null;
    private IntegerArgument wrapColumn = null;
    private ScopeArgument addAttributeScope = null;
    private ScopeArgument excludeEntryScope = null;
    private StringArgument addAttributeName = null;
    private StringArgument addAttributeValue = null;
    private StringArgument excludeAttribute = null;
    private StringArgument redactAttribute = null;
    private StringArgument renameAttributeFrom = null;
    private StringArgument renameAttributeTo = null;
    private StringArgument replaceValuesAttribute = null;
    private StringArgument replacementValue = null;
    private StringArgument scrambleAttribute = null;
    private StringArgument scrambleJSONField = null;
    private StringArgument sequentialAttribute = null;
    private StringArgument textAfterSequentialValue = null;
    private StringArgument textBeforeSequentialValue = null;
    private final ThreadLocal<ByteStringBuffer> byteStringBuffers = new ThreadLocal();

    public static void main(String ... args) {
        ResultCode resultCode = TransformLDIF.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(OutputStream out, OutputStream err, String ... args) {
        TransformLDIF tool = new TransformLDIF(out, err);
        return tool.runTool(args);
    }

    public TransformLDIF(OutputStream out, OutputStream err) {
        super(out, err);
    }

    @Override
    public String getToolName() {
        return "transform-ldif";
    }

    @Override
    public String getToolDescription() {
        return TransformationMessages.INFO_TRANSFORM_LDIF_TOOL_DESCRIPTION.get();
    }

    @Override
    public String getToolVersion() {
        return "3.2.1";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.sourceLDIF = new FileArgument(Character.valueOf('l'), "sourceLDIF", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_LDIF.get(), true, true, true, false);
        this.sourceLDIF.addLongIdentifier("inputLDIF");
        this.sourceLDIF.addLongIdentifier("source-ldif");
        this.sourceLDIF.addLongIdentifier("input-ldif");
        this.sourceLDIF.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.sourceLDIF);
        this.sourceFromStandardInput = new BooleanArgument(null, "sourceFromStandardInput", 1, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_STD_IN.get());
        this.sourceFromStandardInput.addLongIdentifier("source-from-standard-input");
        this.sourceFromStandardInput.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.sourceFromStandardInput);
        parser.addRequiredArgumentSet(this.sourceLDIF, this.sourceFromStandardInput, new Argument[0]);
        parser.addExclusiveArgumentSet(this.sourceLDIF, this.sourceFromStandardInput, new Argument[0]);
        this.targetLDIF = new FileArgument(Character.valueOf('o'), "targetLDIF", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_TARGET_LDIF.get(), false, true, true, false);
        this.targetLDIF.addLongIdentifier("outputLDIF");
        this.targetLDIF.addLongIdentifier("target-ldif");
        this.targetLDIF.addLongIdentifier("output-ldif");
        this.targetLDIF.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.targetLDIF);
        this.targetToStandardOutput = new BooleanArgument(null, "targetToStandardOutput", 1, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_TARGET_STD_OUT.get());
        this.targetToStandardOutput.addLongIdentifier("target-to-standard-output");
        this.targetToStandardOutput.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.targetToStandardOutput);
        parser.addExclusiveArgumentSet(this.targetLDIF, this.targetToStandardOutput, new Argument[0]);
        this.sourceContainsChangeRecords = new BooleanArgument(null, "sourceContainsChangeRecords", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_CONTAINS_CHANGE_RECORDS.get());
        this.sourceContainsChangeRecords.addLongIdentifier("source-contains-change-records");
        this.sourceContainsChangeRecords.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.sourceContainsChangeRecords);
        this.appendToTargetLDIF = new BooleanArgument(null, "appendToTargetLDIF", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_APPEND_TO_TARGET.get());
        this.appendToTargetLDIF.addLongIdentifier("append-to-target-ldif");
        this.appendToTargetLDIF.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.appendToTargetLDIF);
        parser.addExclusiveArgumentSet(this.targetToStandardOutput, this.appendToTargetLDIF, new Argument[0]);
        this.wrapColumn = new IntegerArgument(null, "wrapColumn", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_WRAP_COLUMN.get(), 5, Integer.MAX_VALUE);
        this.wrapColumn.addLongIdentifier("wrap-column");
        this.wrapColumn.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.wrapColumn);
        this.sourceCompressed = new BooleanArgument(Character.valueOf('C'), "sourceCompressed", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_COMPRESSED.get());
        this.sourceCompressed.addLongIdentifier("inputCompressed");
        this.sourceCompressed.addLongIdentifier("source-compressed");
        this.sourceCompressed.addLongIdentifier("input-compressed");
        this.sourceCompressed.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.sourceCompressed);
        this.compressTarget = new BooleanArgument(Character.valueOf('c'), "compressTarget", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_COMPRESS_TARGET.get());
        this.compressTarget.addLongIdentifier("compressOutput");
        this.compressTarget.addLongIdentifier("compress");
        this.compressTarget.addLongIdentifier("compress-target");
        this.compressTarget.addLongIdentifier("compress-output");
        this.compressTarget.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.compressTarget);
        this.scrambleAttribute = new StringArgument(Character.valueOf('a'), "scrambleAttribute", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SCRAMBLE_ATTR.get());
        this.scrambleAttribute.addLongIdentifier("attributeName");
        this.scrambleAttribute.addLongIdentifier("scramble-attribute");
        this.scrambleAttribute.addLongIdentifier("attribute-name");
        this.scrambleAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SCRAMBLE.get());
        parser.addArgument(this.scrambleAttribute);
        this.scrambleJSONField = new StringArgument(null, "scrambleJSONField", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_FIELD_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SCRAMBLE_JSON_FIELD.get(this.scrambleAttribute.getIdentifierString()));
        this.scrambleJSONField.addLongIdentifier("scramble-json-field");
        this.scrambleJSONField.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SCRAMBLE.get());
        parser.addArgument(this.scrambleJSONField);
        parser.addDependentArgumentSet(this.scrambleJSONField, this.scrambleAttribute, new Argument[0]);
        this.randomSeed = new IntegerArgument(Character.valueOf('s'), "randomSeed", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_RANDOM_SEED.get());
        this.randomSeed.addLongIdentifier("random-seed");
        this.randomSeed.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SCRAMBLE.get());
        parser.addArgument(this.randomSeed);
        this.sequentialAttribute = new StringArgument(Character.valueOf('S'), "sequentialAttribute", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_ATTR.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.sequentialAttribute.addLongIdentifier("sequentialAttributeName");
        this.sequentialAttribute.addLongIdentifier("sequential-attribute");
        this.sequentialAttribute.addLongIdentifier("sequential-attribute-name");
        this.sequentialAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.sequentialAttribute);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.sequentialAttribute, new Argument[0]);
        this.initialSequentialValue = new IntegerArgument(Character.valueOf('i'), "initialSequentialValue", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_INITIAL_SEQUENTIAL_VALUE.get(this.sequentialAttribute.getIdentifierString()));
        this.initialSequentialValue.addLongIdentifier("initial-sequential-value");
        this.initialSequentialValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.initialSequentialValue);
        parser.addDependentArgumentSet(this.initialSequentialValue, this.sequentialAttribute, new Argument[0]);
        this.sequentialValueIncrement = new IntegerArgument(null, "sequentialValueIncrement", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_INCREMENT.get(this.sequentialAttribute.getIdentifierString()));
        this.sequentialValueIncrement.addLongIdentifier("sequential-value-increment");
        this.sequentialValueIncrement.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.sequentialValueIncrement);
        parser.addDependentArgumentSet(this.sequentialValueIncrement, this.sequentialAttribute, new Argument[0]);
        this.textBeforeSequentialValue = new StringArgument(null, "textBeforeSequentialValue", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_TEXT_BEFORE.get(this.sequentialAttribute.getIdentifierString()));
        this.textBeforeSequentialValue.addLongIdentifier("text-before-sequential-value");
        this.textBeforeSequentialValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.textBeforeSequentialValue);
        parser.addDependentArgumentSet(this.textBeforeSequentialValue, this.sequentialAttribute, new Argument[0]);
        this.textAfterSequentialValue = new StringArgument(null, "textAfterSequentialValue", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_TEXT_AFTER.get(this.sequentialAttribute.getIdentifierString()));
        this.textAfterSequentialValue.addLongIdentifier("text-after-sequential-value");
        this.textAfterSequentialValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.textAfterSequentialValue);
        parser.addDependentArgumentSet(this.textAfterSequentialValue, this.sequentialAttribute, new Argument[0]);
        this.replaceValuesAttribute = new StringArgument(null, "replaceValuesAttribute", false, 1, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_REPLACE_VALUES_ATTR.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.replaceValuesAttribute.addLongIdentifier("replace-values-attribute");
        this.replaceValuesAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_REPLACE_VALUES.get());
        parser.addArgument(this.replaceValuesAttribute);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.replaceValuesAttribute, new Argument[0]);
        this.replacementValue = new StringArgument(null, "replacementValue", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_REPLACEMENT_VALUE.get(this.replaceValuesAttribute.getIdentifierString()));
        this.replacementValue.addLongIdentifier("replacement-value");
        this.replacementValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_REPLACE_VALUES.get());
        parser.addArgument(this.replacementValue);
        parser.addDependentArgumentSet(this.replaceValuesAttribute, this.replacementValue, new Argument[0]);
        parser.addDependentArgumentSet(this.replacementValue, this.replaceValuesAttribute, new Argument[0]);
        this.addAttributeName = new StringArgument(null, "addAttributeName", false, 1, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_ATTR.get("--addAttributeValue", this.sourceContainsChangeRecords.getIdentifierString()));
        this.addAttributeName.addLongIdentifier("add-attribute-name");
        this.addAttributeName.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeName);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.addAttributeName, new Argument[0]);
        this.addAttributeValue = new StringArgument(null, "addAttributeValue", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_VALUE.get(this.addAttributeName.getIdentifierString()));
        this.addAttributeValue.addLongIdentifier("add-attribute-value");
        this.addAttributeValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeValue);
        parser.addDependentArgumentSet(this.addAttributeName, this.addAttributeValue, new Argument[0]);
        parser.addDependentArgumentSet(this.addAttributeValue, this.addAttributeName, new Argument[0]);
        this.addToExistingValues = new BooleanArgument(null, "addToExistingValues", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_MERGE_VALUES.get(this.addAttributeName.getIdentifierString(), this.addAttributeValue.getIdentifierString()));
        this.addToExistingValues.addLongIdentifier("add-to-existing-values");
        this.addToExistingValues.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addToExistingValues);
        parser.addDependentArgumentSet(this.addToExistingValues, this.addAttributeName, new Argument[0]);
        this.addAttributeBaseDN = new DNArgument(null, "addAttributeBaseDN", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_BASE_DN.get(this.addAttributeName.getIdentifierString()));
        this.addAttributeBaseDN.addLongIdentifier("add-attribute-base-dn");
        this.addAttributeBaseDN.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeBaseDN);
        parser.addDependentArgumentSet(this.addAttributeBaseDN, this.addAttributeName, new Argument[0]);
        this.addAttributeScope = new ScopeArgument(null, "addAttributeScope", false, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_SCOPE.get(this.addAttributeBaseDN.getIdentifierString(), this.addAttributeName.getIdentifierString()));
        this.addAttributeScope.addLongIdentifier("add-attribute-scope");
        this.addAttributeScope.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeScope);
        parser.addDependentArgumentSet(this.addAttributeScope, this.addAttributeName, new Argument[0]);
        this.addAttributeFilter = new FilterArgument(null, "addAttributeFilter", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_FILTER.get(this.addAttributeName.getIdentifierString()));
        this.addAttributeFilter.addLongIdentifier("add-attribute-filter");
        this.addAttributeFilter.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeFilter);
        parser.addDependentArgumentSet(this.addAttributeFilter, this.addAttributeName, new Argument[0]);
        this.renameAttributeFrom = new StringArgument(null, "renameAttributeFrom", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_RENAME_FROM.get());
        this.renameAttributeFrom.addLongIdentifier("rename-attribute-from");
        this.renameAttributeFrom.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_RENAME.get());
        parser.addArgument(this.renameAttributeFrom);
        this.renameAttributeTo = new StringArgument(null, "renameAttributeTo", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_RENAME_TO.get(this.renameAttributeFrom.getIdentifierString()));
        this.renameAttributeTo.addLongIdentifier("rename-attribute-to");
        this.renameAttributeTo.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_RENAME.get());
        parser.addArgument(this.renameAttributeTo);
        parser.addDependentArgumentSet(this.renameAttributeFrom, this.renameAttributeTo, new Argument[0]);
        parser.addDependentArgumentSet(this.renameAttributeTo, this.renameAttributeFrom, new Argument[0]);
        this.flattenBaseDN = new DNArgument(null, "flattenBaseDN", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_BASE_DN.get());
        this.flattenBaseDN.addLongIdentifier("flatten-base-dn");
        this.flattenBaseDN.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN.get());
        parser.addArgument(this.flattenBaseDN);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.flattenBaseDN, new Argument[0]);
        this.flattenAddOmittedRDNAttributesToEntry = new BooleanArgument(null, "flattenAddOmittedRDNAttributesToEntry", 1, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_ADD_OMITTED_TO_ENTRY.get());
        this.flattenAddOmittedRDNAttributesToEntry.addLongIdentifier("flatten-add-omitted-rdn-attributes-to-entry");
        this.flattenAddOmittedRDNAttributesToEntry.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN.get());
        parser.addArgument(this.flattenAddOmittedRDNAttributesToEntry);
        parser.addDependentArgumentSet(this.flattenAddOmittedRDNAttributesToEntry, this.flattenBaseDN, new Argument[0]);
        this.flattenAddOmittedRDNAttributesToRDN = new BooleanArgument(null, "flattenAddOmittedRDNAttributesToRDN", 1, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_ADD_OMITTED_TO_RDN.get());
        this.flattenAddOmittedRDNAttributesToRDN.addLongIdentifier("flatten-add-omitted-rdn-attributes-to-rdn");
        this.flattenAddOmittedRDNAttributesToRDN.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN.get());
        parser.addArgument(this.flattenAddOmittedRDNAttributesToRDN);
        parser.addDependentArgumentSet(this.flattenAddOmittedRDNAttributesToRDN, this.flattenBaseDN, new Argument[0]);
        this.flattenExcludeFilter = new FilterArgument(null, "flattenExcludeFilter", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_EXCLUDE_FILTER.get());
        this.flattenExcludeFilter.addLongIdentifier("flatten-exclude-filter");
        this.flattenExcludeFilter.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN.get());
        parser.addArgument(this.flattenExcludeFilter);
        parser.addDependentArgumentSet(this.flattenExcludeFilter, this.flattenBaseDN, new Argument[0]);
        this.moveSubtreeFrom = new DNArgument(null, "moveSubtreeFrom", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_MOVE_SUBTREE_FROM.get());
        this.moveSubtreeFrom.addLongIdentifier("move-subtree-from");
        this.moveSubtreeFrom.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_MOVE.get());
        parser.addArgument(this.moveSubtreeFrom);
        this.moveSubtreeTo = new DNArgument(null, "moveSubtreeTo", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_MOVE_SUBTREE_TO.get(this.moveSubtreeFrom.getIdentifierString()));
        this.moveSubtreeTo.addLongIdentifier("move-subtree-to");
        this.moveSubtreeTo.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_MOVE.get());
        parser.addArgument(this.moveSubtreeTo);
        parser.addDependentArgumentSet(this.moveSubtreeFrom, this.moveSubtreeTo, new Argument[0]);
        parser.addDependentArgumentSet(this.moveSubtreeTo, this.moveSubtreeFrom, new Argument[0]);
        this.redactAttribute = new StringArgument(null, "redactAttribute", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_REDACT_ATTR.get());
        this.redactAttribute.addLongIdentifier("redact-attribute");
        this.redactAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_REDACT.get());
        parser.addArgument(this.redactAttribute);
        this.hideRedactedValueCount = new BooleanArgument(null, "hideRedactedValueCount", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_HIDE_REDACTED_COUNT.get());
        this.hideRedactedValueCount.addLongIdentifier("hide-redacted-value-count");
        this.hideRedactedValueCount.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_REDACT.get());
        parser.addArgument(this.hideRedactedValueCount);
        parser.addDependentArgumentSet(this.hideRedactedValueCount, this.redactAttribute, new Argument[0]);
        this.excludeAttribute = new StringArgument(null, "excludeAttribute", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ATTR.get());
        this.excludeAttribute.addLongIdentifier("suppressAttribute");
        this.excludeAttribute.addLongIdentifier("exclude-attribute");
        this.excludeAttribute.addLongIdentifier("suppress-attribute");
        this.excludeAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeAttribute);
        this.excludeEntryBaseDN = new DNArgument(null, "excludeEntryBaseDN", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_BASE_DN.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.excludeEntryBaseDN.addLongIdentifier("suppressEntryBaseDN");
        this.excludeEntryBaseDN.addLongIdentifier("exclude-entry-base-dn");
        this.excludeEntryBaseDN.addLongIdentifier("suppress-entry-base-dn");
        this.excludeEntryBaseDN.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeEntryBaseDN);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.excludeEntryBaseDN, new Argument[0]);
        this.excludeEntryScope = new ScopeArgument(null, "excludeEntryScope", false, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_SCOPE.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.excludeEntryScope.addLongIdentifier("suppressEntryScope");
        this.excludeEntryScope.addLongIdentifier("exclude-entry-scope");
        this.excludeEntryScope.addLongIdentifier("suppress-entry-scope");
        this.excludeEntryScope.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeEntryScope);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.excludeEntryScope, new Argument[0]);
        this.excludeEntryFilter = new FilterArgument(null, "excludeEntryFilter", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_FILTER.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.excludeEntryFilter.addLongIdentifier("suppressEntryFilter");
        this.excludeEntryFilter.addLongIdentifier("exclude-entry-filter");
        this.excludeEntryFilter.addLongIdentifier("suppress-entry-filter");
        this.excludeEntryFilter.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeEntryFilter);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.excludeEntryFilter, new Argument[0]);
        this.excludeNonMatchingEntries = new BooleanArgument(null, "excludeNonMatchingEntries", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_NON_MATCHING.get());
        this.excludeNonMatchingEntries.addLongIdentifier("exclude-non-matching-entries");
        this.excludeNonMatchingEntries.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeNonMatchingEntries);
        parser.addDependentArgumentSet(this.excludeNonMatchingEntries, this.excludeEntryBaseDN, this.excludeEntryScope, this.excludeEntryFilter);
        this.schemaPath = new FileArgument(null, "schemaPath", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SCHEMA_PATH.get(), true, true, false, false);
        this.schemaPath.addLongIdentifier("schemaFile");
        this.schemaPath.addLongIdentifier("schemaDirectory");
        this.schemaPath.addLongIdentifier("schema-path");
        this.schemaPath.addLongIdentifier("schema-file");
        this.schemaPath.addLongIdentifier("schema-directory");
        parser.addArgument(this.schemaPath);
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_NUM_THREADS.get(), 1, Integer.MAX_VALUE, 1);
        this.numThreads.addLongIdentifier("num-threads");
        parser.addArgument(this.numThreads);
        this.processDNs = new BooleanArgument(Character.valueOf('d'), "processDNs", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_PROCESS_DNS.get());
        this.processDNs.addLongIdentifier("process-dns");
        parser.addArgument(this.processDNs);
        parser.addRequiredArgumentSet(this.scrambleAttribute, this.sequentialAttribute, this.replaceValuesAttribute, this.addAttributeName, this.renameAttributeFrom, this.flattenBaseDN, this.moveSubtreeFrom, this.redactAttribute, this.excludeAttribute, this.excludeEntryBaseDN, this.excludeEntryScope, this.excludeEntryFilter);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        int moveToOccurrences;
        int renameToOccurrences;
        if (!(this.targetLDIF.isPresent() || this.targetToStandardOutput.isPresent() || this.scrambleAttribute.isPresent() || this.sequentialAttribute.isPresent())) {
            throw new ArgumentException(TransformationMessages.ERR_TRANSFORM_LDIF_MISSING_TARGET_ARG.get(this.targetLDIF.getIdentifierString(), this.targetToStandardOutput.getIdentifierString()));
        }
        int renameFromOccurrences = this.renameAttributeFrom.getNumOccurrences();
        if (renameFromOccurrences != (renameToOccurrences = this.renameAttributeTo.getNumOccurrences())) {
            throw new ArgumentException(TransformationMessages.ERR_TRANSFORM_LDIF_ARG_COUNT_MISMATCH.get(this.renameAttributeFrom.getIdentifierString(), this.renameAttributeTo.getIdentifierString()));
        }
        int moveFromOccurrences = this.moveSubtreeFrom.getNumOccurrences();
        if (moveFromOccurrences != (moveToOccurrences = this.moveSubtreeTo.getNumOccurrences())) {
            throw new ArgumentException(TransformationMessages.ERR_TRANSFORM_LDIF_ARG_COUNT_MISMATCH.get(this.moveSubtreeFrom.getIdentifierString(), this.moveSubtreeTo.getIdentifierString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        ResultCode resultCode;
        block51: {
            Exception e422222;
            LDIFReader ldifReader;
            block55: {
                Schema schema;
                try {
                    schema = this.getSchema();
                }
                catch (LDAPException le) {
                    this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, le.getMessage());
                    return le.getResultCode();
                }
                ArrayList<LDIFReaderEntryTranslator> entryTranslators = new ArrayList<LDIFReaderEntryTranslator>(10);
                ArrayList<LDIFReaderChangeRecordTranslator> changeRecordTranslators = new ArrayList<LDIFReaderChangeRecordTranslator>(10);
                AtomicLong excludedEntryCount = new AtomicLong(0L);
                this.createTranslators(entryTranslators, changeRecordTranslators, schema, excludedEntryCount);
                AggregateLDIFReaderEntryTranslator entryTranslator = new AggregateLDIFReaderEntryTranslator(entryTranslators);
                AggregateLDIFReaderChangeRecordTranslator changeRecordTranslator = new AggregateLDIFReaderChangeRecordTranslator(changeRecordTranslators);
                Object targetFile = this.targetLDIF.isPresent() ? this.targetLDIF.getValue() : (this.targetToStandardOutput.isPresent() ? null : new File(this.sourceLDIF.getValue().getAbsolutePath() + ".scrambled"));
                try {
                    InputStream inputStream;
                    if (this.sourceLDIF.isPresent()) {
                        List<File> sourceFiles = this.sourceLDIF.getValues();
                        ArrayList<InputStream> fileInputStreams = new ArrayList<InputStream>(2 * sourceFiles.size());
                        for (File f : sourceFiles) {
                            if (!fileInputStreams.isEmpty()) {
                                byte[] doubleEOL = new byte[StaticUtils.EOL_BYTES.length * 2];
                                System.arraycopy(StaticUtils.EOL_BYTES, 0, doubleEOL, 0, StaticUtils.EOL_BYTES.length);
                                System.arraycopy(StaticUtils.EOL_BYTES, 0, doubleEOL, StaticUtils.EOL_BYTES.length, StaticUtils.EOL_BYTES.length);
                                fileInputStreams.add(new ByteArrayInputStream(doubleEOL));
                            }
                            fileInputStreams.add(new FileInputStream(f));
                        }
                        inputStream = fileInputStreams.size() == 1 ? (InputStream)fileInputStreams.get(0) : new AggregateInputStream(fileInputStreams);
                    } else {
                        inputStream = System.in;
                    }
                    if (this.sourceCompressed.isPresent()) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    ldifReader = new LDIFReader(inputStream, (int)this.numThreads.getValue(), (LDIFReaderEntryTranslator)entryTranslator, (LDIFReaderChangeRecordTranslator)changeRecordTranslator);
                    if (schema != null) {
                        ldifReader.setSchema(schema);
                    }
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                    this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_CREATING_LDIF_READER.get(StaticUtils.getExceptionMessage(e2)));
                    return ResultCode.LOCAL_ERROR;
                }
                resultCode = ResultCode.SUCCESS;
                OutputStream outputStream = null;
                try {
                    block49: {
                        try {
                            outputStream = targetFile == null ? this.getOut() : new FileOutputStream((File)targetFile, this.appendToTargetLDIF.isPresent());
                            if (!this.compressTarget.isPresent()) break block49;
                            outputStream = new GZIPOutputStream(outputStream);
                        }
                        catch (Exception e3) {
                            Exception e422222;
                            block50: {
                                Debug.debugException(e3);
                                this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_CREATING_OUTPUT_STREAM.get(((File)targetFile).getAbsolutePath(), StaticUtils.getExceptionMessage(e3)));
                                resultCode = ResultCode.LOCAL_ERROR;
                                Object var17_25 = null;
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Exception e422222) {
                                        Debug.debugException(e422222);
                                        this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_CLOSING_OUTPUT_STREAM.get(((File)targetFile).getAbsolutePath(), StaticUtils.getExceptionMessage(e422222)));
                                        if (resultCode != ResultCode.SUCCESS) break block50;
                                        resultCode = ResultCode.LOCAL_ERROR;
                                    }
                                }
                            }
                            try {
                                ldifReader.close();
                            }
                            catch (Exception e422222) {
                                Debug.debugException(e422222);
                            }
                            break block51;
                        }
                    }
                    long entriesWritten = 0L;
                    while (true) {
                        LDIFRecord ldifRecord;
                        try {
                            ldifRecord = ldifReader.readLDIFRecord();
                        }
                        catch (LDIFException le) {
                            Exception e422222;
                            block52: {
                                Debug.debugException(le);
                                if (le.mayContinueReading()) {
                                    this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_RECOVERABLE_MALFORMED_RECORD.get(StaticUtils.getExceptionMessage(le)));
                                    if (resultCode != ResultCode.SUCCESS) continue;
                                    resultCode = ResultCode.PARAM_ERROR;
                                    continue;
                                }
                                this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_UNRECOVERABLE_MALFORMED_RECORD.get(StaticUtils.getExceptionMessage(le)));
                                if (resultCode == ResultCode.SUCCESS) {
                                    resultCode = ResultCode.PARAM_ERROR;
                                }
                                Object var17_26 = null;
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Exception e422222) {
                                        Debug.debugException(e422222);
                                        this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_CLOSING_OUTPUT_STREAM.get(((File)targetFile).getAbsolutePath(), StaticUtils.getExceptionMessage(e422222)));
                                        if (resultCode != ResultCode.SUCCESS) break block52;
                                        resultCode = ResultCode.LOCAL_ERROR;
                                    }
                                }
                            }
                            try {
                                ldifReader.close();
                            }
                            catch (Exception e422222) {
                                Debug.debugException(e422222);
                            }
                            break block51;
                        }
                        catch (Exception e5) {
                            Exception e422222;
                            block53: {
                                Debug.debugException(e5);
                                this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_UNEXPECTED_READ_ERROR.get(StaticUtils.getExceptionMessage(e5)));
                                resultCode = ResultCode.LOCAL_ERROR;
                                Object var17_27 = null;
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Exception e422222) {
                                        Debug.debugException(e422222);
                                        this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_CLOSING_OUTPUT_STREAM.get(((File)targetFile).getAbsolutePath(), StaticUtils.getExceptionMessage(e422222)));
                                        if (resultCode != ResultCode.SUCCESS) break block53;
                                        resultCode = ResultCode.LOCAL_ERROR;
                                    }
                                }
                            }
                            try {
                                ldifReader.close();
                            }
                            catch (Exception e422222) {
                                Debug.debugException(e422222);
                            }
                            break block51;
                        }
                        if (ldifRecord == null) break;
                        try {
                            if (ldifRecord instanceof PreEncodedLDIFEntry) {
                                outputStream.write(((PreEncodedLDIFEntry)ldifRecord).getLDIFBytes());
                            } else {
                                ByteStringBuffer buffer = this.getBuffer();
                                if (this.wrapColumn.isPresent()) {
                                    ldifRecord.toLDIF(buffer, this.wrapColumn.getValue());
                                } else {
                                    ldifRecord.toLDIF(buffer, 0);
                                }
                                buffer.append(StaticUtils.EOL_BYTES);
                                buffer.write(outputStream);
                            }
                        }
                        catch (Exception e6) {
                            Exception e422222;
                            block54: {
                                Debug.debugException(e6);
                                this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_WRITE_ERROR.get(((File)targetFile).getAbsolutePath(), StaticUtils.getExceptionMessage(e6)));
                                resultCode = ResultCode.LOCAL_ERROR;
                                Object var17_28 = null;
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Exception e422222) {
                                        Debug.debugException(e422222);
                                        this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_CLOSING_OUTPUT_STREAM.get(((File)targetFile).getAbsolutePath(), StaticUtils.getExceptionMessage(e422222)));
                                        if (resultCode != ResultCode.SUCCESS) break block54;
                                        resultCode = ResultCode.LOCAL_ERROR;
                                    }
                                }
                            }
                            try {
                                ldifReader.close();
                            }
                            catch (Exception e422222) {
                                Debug.debugException(e422222);
                            }
                            break block51;
                        }
                        if (this.targetToStandardOutput.isPresent() || ++entriesWritten % 1000L != 0L) continue;
                        long numExcluded = excludedEntryCount.get();
                        if (numExcluded > 0L) {
                            this.wrapOut(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.INFO_TRANSFORM_LDIF_WROTE_ENTRIES_WITH_EXCLUDED.get(entriesWritten, numExcluded));
                            continue;
                        }
                        this.wrapOut(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.INFO_TRANSFORM_LDIF_WROTE_ENTRIES_NONE_EXCLUDED.get(entriesWritten));
                    }
                    if (!this.targetToStandardOutput.isPresent()) {
                        long numExcluded = excludedEntryCount.get();
                        if (numExcluded > 0L) {
                            this.wrapOut(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.INFO_TRANSFORM_LDIF_COMPLETE_WITH_EXCLUDED.get(entriesWritten, numExcluded));
                        } else {
                            this.wrapOut(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.INFO_TRANSFORM_LDIF_COMPLETE_NONE_EXCLUDED.get(entriesWritten));
                        }
                    }
                    Object var17_29 = null;
                    if (outputStream == null) break block55;
                }
                catch (Throwable throwable) {
                    Exception e422222;
                    block56: {
                        Object var17_30 = null;
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Exception e422222) {
                                Debug.debugException(e422222);
                                this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_CLOSING_OUTPUT_STREAM.get(((File)targetFile).getAbsolutePath(), StaticUtils.getExceptionMessage(e422222)));
                                if (resultCode != ResultCode.SUCCESS) break block56;
                                resultCode = ResultCode.LOCAL_ERROR;
                            }
                        }
                    }
                    try {
                        ldifReader.close();
                    }
                    catch (Exception e422222) {
                        Debug.debugException(e422222);
                    }
                    throw throwable;
                }
                try {
                    outputStream.close();
                }
                catch (Exception e422222) {
                    Debug.debugException(e422222);
                    this.wrapErr(0, MAX_OUTPUT_LINE_LENGTH, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_CLOSING_OUTPUT_STREAM.get(((File)targetFile).getAbsolutePath(), StaticUtils.getExceptionMessage(e422222)));
                    if (resultCode != ResultCode.SUCCESS) break block55;
                    resultCode = ResultCode.LOCAL_ERROR;
                }
            }
            try {
                ldifReader.close();
            }
            catch (Exception e422222) {
                Debug.debugException(e422222);
            }
        }
        return resultCode;
    }

    private Schema getSchema() throws LDAPException {
        if (this.schemaPath.isPresent()) {
            ArrayList<File> schemaFiles = new ArrayList<File>(10);
            for (File path : this.schemaPath.getValues()) {
                if (path.isFile()) {
                    schemaFiles.add(path);
                    continue;
                }
                TreeMap<String, File> fileMap = new TreeMap<String, File>();
                for (File schemaDirFile : path.listFiles()) {
                    String name = schemaDirFile.getName();
                    if (!schemaDirFile.isFile() || !name.toLowerCase().endsWith(".ldif")) continue;
                    fileMap.put(name, schemaDirFile);
                }
                schemaFiles.addAll(fileMap.values());
            }
            if (schemaFiles.isEmpty()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, TransformationMessages.ERR_TRANSFORM_LDIF_NO_SCHEMA_FILES.get(this.schemaPath.getIdentifierString()));
            }
            try {
                return Schema.getSchema(schemaFiles);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_LOADING_SCHEMA.get(StaticUtils.getExceptionMessage(e)));
            }
        }
        try {
            File instanceRoot;
            File configDir;
            File schemaDir;
            String instanceRootStr = System.getenv("INSTANCE_ROOT");
            if (instanceRootStr != null && (schemaDir = new File(configDir = new File(instanceRoot = new File(instanceRootStr), "config"), "schema")).exists()) {
                TreeMap<String, File> fileMap = new TreeMap<String, File>();
                for (File schemaDirFile : schemaDir.listFiles()) {
                    String name = schemaDirFile.getName();
                    if (!schemaDirFile.isFile() || !name.toLowerCase().endsWith(".ldif")) continue;
                    fileMap.put(name, schemaDirFile);
                }
                if (!fileMap.isEmpty()) {
                    return Schema.getSchema(new ArrayList<File>(fileMap.values()));
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    private void createTranslators(List<LDIFReaderEntryTranslator> entryTranslators, List<LDIFReaderChangeRecordTranslator> changeRecordTranslators, Schema schema, AtomicLong excludedEntryCount) {
        if (this.scrambleAttribute.isPresent()) {
            Long seed = this.randomSeed.isPresent() ? Long.valueOf(this.randomSeed.getValue().longValue()) : null;
            ScrambleAttributeTransformation t = new ScrambleAttributeTransformation(schema, seed, this.processDNs.isPresent(), this.scrambleAttribute.getValues(), this.scrambleJSONField.getValues());
            entryTranslators.add(t);
            changeRecordTranslators.add(t);
        }
        if (this.sequentialAttribute.isPresent()) {
            long initialValue = this.initialSequentialValue.isPresent() ? this.initialSequentialValue.getValue().longValue() : 0L;
            long incrementAmount = this.sequentialValueIncrement.isPresent() ? this.sequentialValueIncrement.getValue().longValue() : 1L;
            for (String attrName : this.sequentialAttribute.getValues()) {
                ReplaceWithCounterTransformation t = new ReplaceWithCounterTransformation(schema, attrName, initialValue, incrementAmount, this.textBeforeSequentialValue.getValue(), this.textAfterSequentialValue.getValue(), this.processDNs.isPresent());
                entryTranslators.add(t);
            }
        }
        if (this.replaceValuesAttribute.isPresent()) {
            ReplaceAttributeTransformation t = new ReplaceAttributeTransformation(schema, this.replaceValuesAttribute.getValue(), this.replacementValue.getValues());
            entryTranslators.add(t);
        }
        if (this.addAttributeName.isPresent()) {
            AddAttributeTransformation t = new AddAttributeTransformation(schema, this.addAttributeBaseDN.getValue(), this.addAttributeScope.getValue(), this.addAttributeFilter.getValue(), new Attribute(this.addAttributeName.getValue(), schema, this.addAttributeValue.getValues()), !this.addToExistingValues.isPresent());
            entryTranslators.add(t);
        }
        if (this.renameAttributeFrom.isPresent()) {
            Iterator<String> renameFromIterator = this.renameAttributeFrom.getValues().iterator();
            Iterator<String> renameToIterator = this.renameAttributeTo.getValues().iterator();
            while (renameFromIterator.hasNext()) {
                RenameAttributeTransformation t = new RenameAttributeTransformation(schema, renameFromIterator.next(), renameToIterator.next(), this.processDNs.isPresent());
                entryTranslators.add(t);
                changeRecordTranslators.add(t);
            }
        }
        if (this.flattenBaseDN.isPresent()) {
            FlattenSubtreeTransformation t = new FlattenSubtreeTransformation(schema, this.flattenBaseDN.getValue(), this.flattenAddOmittedRDNAttributesToEntry.isPresent(), this.flattenAddOmittedRDNAttributesToRDN.isPresent(), this.flattenExcludeFilter.getValue());
            entryTranslators.add(t);
        }
        if (this.moveSubtreeFrom.isPresent()) {
            Iterator<DN> moveFromIterator = this.moveSubtreeFrom.getValues().iterator();
            Iterator<DN> moveToIterator = this.moveSubtreeTo.getValues().iterator();
            while (moveFromIterator.hasNext()) {
                MoveSubtreeTransformation t = new MoveSubtreeTransformation(moveFromIterator.next(), moveToIterator.next());
                entryTranslators.add(t);
                changeRecordTranslators.add(t);
            }
        }
        if (this.redactAttribute.isPresent()) {
            RedactAttributeTransformation t = new RedactAttributeTransformation(schema, this.processDNs.isPresent(), !this.hideRedactedValueCount.isPresent(), this.redactAttribute.getValues());
            entryTranslators.add(t);
            changeRecordTranslators.add(t);
        }
        if (this.excludeAttribute.isPresent()) {
            ExcludeAttributeTransformation t = new ExcludeAttributeTransformation(schema, this.excludeAttribute.getValues());
            entryTranslators.add(t);
            changeRecordTranslators.add(t);
        }
        if (this.excludeEntryBaseDN.isPresent() || this.excludeEntryScope.isPresent() || this.excludeEntryFilter.isPresent()) {
            ExcludeEntryTransformation t = new ExcludeEntryTransformation(schema, this.excludeEntryBaseDN.getValue(), this.excludeEntryScope.getValue(), this.excludeEntryFilter.getValue(), !this.excludeNonMatchingEntries.isPresent(), excludedEntryCount);
            entryTranslators.add(t);
        }
        entryTranslators.add(this);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(4);
        examples.put(new String[]{"--sourceLDIF", "input.ldif", "--targetLDIF", "scrambled.ldif", "--scrambleAttribute", "givenName", "--scrambleAttribute", "sn", "--scrambleAttribute", "cn", "--numThreads", "10", "--schemaPath", "/ds/config/schema", "--processDNs"}, TransformationMessages.INFO_TRANSFORM_LDIF_EXAMPLE_SCRAMBLE.get());
        examples.put(new String[]{"--sourceLDIF", "input.ldif", "--targetLDIF", "sequential.ldif", "--sequentialAttribute", "uid", "--initialSequentialValue", "1", "--sequentialValueIncrement", "1", "--textBeforeSequentialValue", "user.", "--numThreads", "10", "--schemaPath", "/ds/config/schema", "--processDNs"}, TransformationMessages.INFO_TRANSFORM_LDIF_EXAMPLE_SEQUENTIAL.get());
        examples.put(new String[]{"--sourceLDIF", "input.ldif", "--targetLDIF", "added-organization.ldif", "--addAttributeName", "o", "--addAttributeValue", "Example Corp.", "--addAttributeFilter", "(objectClass=person)", "--numThreads", "10", "--schemaPath", "/ds/config/schema"}, TransformationMessages.INFO_TRANSFORM_LDIF_EXAMPLE_ADD.get());
        examples.put(new String[]{"--sourceLDIF", "input.ldif", "--targetLDIF", "rebased.ldif", "--moveSubtreeFrom", "o=example.com", "--moveSubtreeTo", "dc=example,dc=com", "--numThreads", "10", "--schemaPath", "/ds/config/schema"}, TransformationMessages.INFO_TRANSFORM_LDIF_EXAMPLE_REBASE.get());
        return examples;
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) throws LDIFException {
        ByteStringBuffer buffer = this.getBuffer();
        if (this.wrapColumn.isPresent()) {
            original.toLDIF(buffer, this.wrapColumn.getValue());
        } else {
            original.toLDIF(buffer, 0);
        }
        buffer.append(StaticUtils.EOL_BYTES);
        return new PreEncodedLDIFEntry(original, buffer.toByteArray());
    }

    private ByteStringBuffer getBuffer() {
        ByteStringBuffer buffer = this.byteStringBuffers.get();
        if (buffer == null) {
            buffer = new ByteStringBuffer();
            this.byteStringBuffers.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }
}

