/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFAttributeHashTranslator;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFEntry;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFFewestEntriesTranslator;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFFilterTranslator;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFRDNHashTranslator;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.util.AggregateInputStream;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.SubCommand;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SplitLDIF
extends CommandLineTool {
    private static final int MAX_OUTPUT_LINE_LENGTH = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private BooleanArgument addEntriesOutsideSplitBaseDNToAllSets = null;
    private BooleanArgument addEntriesOutsideSplitBaseDNToDedicatedSet = null;
    private BooleanArgument compressTarget = null;
    private BooleanArgument sourceCompressed = null;
    private DNArgument splitBaseDN = null;
    private FileArgument schemaPath = null;
    private FileArgument sourceLDIF = null;
    private FileArgument targetLDIFBasePath = null;
    private IntegerArgument numThreads = null;
    private IntegerArgument splitUsingHashOnRDNNumSets = null;
    private SubCommand splitUsingHashOnRDN = null;
    private BooleanArgument splitUsingHashOnAttributeAssumeFlatDIT = null;
    private BooleanArgument splitUsingHashOnAttributeUseAllValues = null;
    private IntegerArgument splitUsingHashOnAttributeNumSets = null;
    private StringArgument splitUsingHashOnAttributeAttributeName = null;
    private SubCommand splitUsingHashOnAttribute = null;
    private BooleanArgument splitUsingFewestEntriesAssumeFlatDIT = null;
    private IntegerArgument splitUsingFewestEntriesNumSets = null;
    private SubCommand splitUsingFewestEntries = null;
    private BooleanArgument splitUsingFilterAssumeFlatDIT = null;
    private FilterArgument splitUsingFilterFilter = null;
    private SubCommand splitUsingFilter = null;

    public static void main(String ... args) {
        ResultCode resultCode = SplitLDIF.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(OutputStream out, OutputStream err, String ... args) {
        SplitLDIF tool = new SplitLDIF(out, err);
        return tool.runTool(args);
    }

    public SplitLDIF(OutputStream out, OutputStream err) {
        super(out, err);
    }

    @Override
    public String getToolName() {
        return "split-ldif";
    }

    @Override
    public String getToolDescription() {
        return ToolMessages.INFO_SPLIT_LDIF_TOOL_DESCRIPTION.get();
    }

    @Override
    public String getToolVersion() {
        return "4.0.1";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.sourceLDIF = new FileArgument(Character.valueOf('l'), "sourceLDIF", true, 0, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_SOURCE_LDIF.get(), true, false, true, false);
        this.sourceLDIF.addLongIdentifier("inputLDIF");
        this.sourceLDIF.addLongIdentifier("source-ldif");
        this.sourceLDIF.addLongIdentifier("input-ldif");
        parser.addArgument(this.sourceLDIF);
        this.sourceCompressed = new BooleanArgument(Character.valueOf('C'), "sourceCompressed", ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_SOURCE_COMPRESSED.get());
        this.sourceCompressed.addLongIdentifier("inputCompressed");
        this.sourceCompressed.addLongIdentifier("source-compressed");
        this.sourceCompressed.addLongIdentifier("input-compressed");
        parser.addArgument(this.sourceCompressed);
        this.targetLDIFBasePath = new FileArgument(Character.valueOf('o'), "targetLDIFBasePath", false, 1, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_TARGET_LDIF_BASE.get(), false, true, true, false);
        this.targetLDIFBasePath.addLongIdentifier("outputLDIFBasePath");
        this.targetLDIFBasePath.addLongIdentifier("target-ldif-base-path");
        this.targetLDIFBasePath.addLongIdentifier("output-ldif-base-path");
        parser.addArgument(this.targetLDIFBasePath);
        this.compressTarget = new BooleanArgument(Character.valueOf('c'), "compressTarget", ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_COMPRESS_TARGET.get());
        this.compressTarget.addLongIdentifier("compressOutput");
        this.compressTarget.addLongIdentifier("compress");
        this.compressTarget.addLongIdentifier("compress-target");
        this.compressTarget.addLongIdentifier("compress-output");
        parser.addArgument(this.compressTarget);
        this.splitBaseDN = new DNArgument(Character.valueOf('b'), "splitBaseDN", true, 1, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_SPLIT_BASE_DN.get());
        this.splitBaseDN.addLongIdentifier("baseDN");
        this.splitBaseDN.addLongIdentifier("split-base-dn");
        this.splitBaseDN.addLongIdentifier("base-dn");
        parser.addArgument(this.splitBaseDN);
        this.addEntriesOutsideSplitBaseDNToAllSets = new BooleanArgument(null, "addEntriesOutsideSplitBaseDNToAllSets", 1, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_OUTSIDE_TO_ALL_SETS.get());
        this.addEntriesOutsideSplitBaseDNToAllSets.addLongIdentifier("add-entries-outside-split-base-dn-to-all-sets");
        parser.addArgument(this.addEntriesOutsideSplitBaseDNToAllSets);
        this.addEntriesOutsideSplitBaseDNToDedicatedSet = new BooleanArgument(null, "addEntriesOutsideSplitBaseDNToDedicatedSet", 1, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_OUTSIDE_TO_DEDICATED_SET.get());
        this.addEntriesOutsideSplitBaseDNToDedicatedSet.addLongIdentifier("add-entries-outside-split-base-dn-to-dedicated-set");
        parser.addArgument(this.addEntriesOutsideSplitBaseDNToDedicatedSet);
        this.schemaPath = new FileArgument(null, "schemaPath", false, 0, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_SCHEMA_PATH.get(), true, false, false, false);
        this.schemaPath.addLongIdentifier("schemaFile");
        this.schemaPath.addLongIdentifier("schemaDirectory");
        this.schemaPath.addLongIdentifier("schema-path");
        this.schemaPath.addLongIdentifier("schema-file");
        this.schemaPath.addLongIdentifier("schema-directory");
        parser.addArgument(this.schemaPath);
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", false, 1, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_NUM_THREADS.get(), 1, Integer.MAX_VALUE, 1);
        this.numThreads.addLongIdentifier("num-threads");
        parser.addArgument(this.numThreads);
        ArgumentParser splitUsingHashOnRDNParser = new ArgumentParser("split-using-hash-on-rdn", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_RDN_DESC.get());
        this.splitUsingHashOnRDNNumSets = new IntegerArgument(null, "numSets", true, 1, null, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_RDN_ARG_DESC_NUM_SETS.get(), 2, Integer.MAX_VALUE);
        this.splitUsingHashOnRDNNumSets.addLongIdentifier("num-sets");
        splitUsingHashOnRDNParser.addArgument(this.splitUsingHashOnRDNNumSets);
        LinkedHashMap<String[], String> splitUsingHashOnRDNExamples = new LinkedHashMap<String[], String>(1);
        splitUsingHashOnRDNExamples.put(new String[]{"split-using-hash-on-rdn", "--sourceLDIF", "whole.ldif", "--targetLDIFBasePath", "split.ldif", "--splitBaseDN", "ou=People,dc=example,dc=com", "--numSets", "4", "--schemaPath", "config/schema", "--addEntriesOutsideSplitBaseDNToAllSets"}, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_RDN_EXAMPLE.get());
        this.splitUsingHashOnRDN = new SubCommand("split-using-hash-on-rdn", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_RDN_DESC.get(), splitUsingHashOnRDNParser, splitUsingHashOnRDNExamples);
        this.splitUsingHashOnRDN.addName("hash-on-rdn");
        parser.addSubCommand(this.splitUsingHashOnRDN);
        ArgumentParser splitUsingHashOnAttributeParser = new ArgumentParser("split-using-hash-on-attribute", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_DESC.get());
        this.splitUsingHashOnAttributeAttributeName = new StringArgument(null, "attributeName", true, 1, "{attr}", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_ARG_DESC_ATTR_NAME.get());
        this.splitUsingHashOnAttributeAttributeName.addLongIdentifier("attribute-name");
        splitUsingHashOnAttributeParser.addArgument(this.splitUsingHashOnAttributeAttributeName);
        this.splitUsingHashOnAttributeNumSets = new IntegerArgument(null, "numSets", true, 1, null, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_ARG_DESC_NUM_SETS.get(), 2, Integer.MAX_VALUE);
        this.splitUsingHashOnAttributeNumSets.addLongIdentifier("num-sets");
        splitUsingHashOnAttributeParser.addArgument(this.splitUsingHashOnAttributeNumSets);
        this.splitUsingHashOnAttributeUseAllValues = new BooleanArgument(null, "useAllValues", 1, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_ARG_DESC_ALL_VALUES.get());
        this.splitUsingHashOnAttributeUseAllValues.addLongIdentifier("use-all-values");
        splitUsingHashOnAttributeParser.addArgument(this.splitUsingHashOnAttributeUseAllValues);
        this.splitUsingHashOnAttributeAssumeFlatDIT = new BooleanArgument(null, "assumeFlatDIT", 1, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_ARG_DESC_ASSUME_FLAT_DIT.get());
        this.splitUsingHashOnAttributeAssumeFlatDIT.addLongIdentifier("assume-flat-dit");
        splitUsingHashOnAttributeParser.addArgument(this.splitUsingHashOnAttributeAssumeFlatDIT);
        LinkedHashMap<String[], String> splitUsingHashOnAttributeExamples = new LinkedHashMap<String[], String>(1);
        splitUsingHashOnAttributeExamples.put(new String[]{"split-using-hash-on-attribute", "--sourceLDIF", "whole.ldif", "--targetLDIFBasePath", "split.ldif", "--splitBaseDN", "ou=People,dc=example,dc=com", "--attributeName", "uid", "--numSets", "4", "--schemaPath", "config/schema", "--addEntriesOutsideSplitBaseDNToAllSets"}, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_EXAMPLE.get());
        this.splitUsingHashOnAttribute = new SubCommand("split-using-hash-on-attribute", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_DESC.get(), splitUsingHashOnAttributeParser, splitUsingHashOnAttributeExamples);
        this.splitUsingHashOnAttribute.addName("hash-on-attribute");
        parser.addSubCommand(this.splitUsingHashOnAttribute);
        ArgumentParser splitUsingFewestEntriesParser = new ArgumentParser("split-using-fewest-entries", ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_DESC.get());
        this.splitUsingFewestEntriesNumSets = new IntegerArgument(null, "numSets", true, 1, null, ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_ARG_DESC_NUM_SETS.get(), 2, Integer.MAX_VALUE);
        this.splitUsingFewestEntriesNumSets.addLongIdentifier("num-sets");
        splitUsingFewestEntriesParser.addArgument(this.splitUsingFewestEntriesNumSets);
        this.splitUsingFewestEntriesAssumeFlatDIT = new BooleanArgument(null, "assumeFlatDIT", 1, ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_ARG_DESC_ASSUME_FLAT_DIT.get());
        this.splitUsingFewestEntriesAssumeFlatDIT.addLongIdentifier("assume-flat-dit");
        splitUsingFewestEntriesParser.addArgument(this.splitUsingFewestEntriesAssumeFlatDIT);
        LinkedHashMap<String[], String> splitUsingFewestEntriesExamples = new LinkedHashMap<String[], String>(1);
        splitUsingFewestEntriesExamples.put(new String[]{"split-using-fewest-entries", "--sourceLDIF", "whole.ldif", "--targetLDIFBasePath", "split.ldif", "--splitBaseDN", "ou=People,dc=example,dc=com", "--numSets", "4", "--schemaPath", "config/schema", "--addEntriesOutsideSplitBaseDNToAllSets"}, ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_EXAMPLE.get());
        this.splitUsingFewestEntries = new SubCommand("split-using-fewest-entries", ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_DESC.get(), splitUsingFewestEntriesParser, splitUsingFewestEntriesExamples);
        this.splitUsingFewestEntries.addName("fewest-entries");
        parser.addSubCommand(this.splitUsingFewestEntries);
        ArgumentParser splitUsingFilterParser = new ArgumentParser("split-using-filter", ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_DESC.get());
        this.splitUsingFilterFilter = new FilterArgument(null, "filter", true, 0, null, ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_ARG_DESC_FILTER.get());
        splitUsingFilterParser.addArgument(this.splitUsingFilterFilter);
        this.splitUsingFilterAssumeFlatDIT = new BooleanArgument(null, "assumeFlatDIT", 1, ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_ARG_DESC_ASSUME_FLAT_DIT.get());
        this.splitUsingFilterAssumeFlatDIT.addLongIdentifier("assume-flat-dit");
        splitUsingFilterParser.addArgument(this.splitUsingFilterAssumeFlatDIT);
        LinkedHashMap<String[], String> splitUsingFilterExamples = new LinkedHashMap<String[], String>(1);
        splitUsingFilterExamples.put(new String[]{"split-using-filter", "--sourceLDIF", "whole.ldif", "--targetLDIFBasePath", "split.ldif", "--splitBaseDN", "ou=People,dc=example,dc=com", "--filter", "(timeZone=Eastern)", "--filter", "(timeZone=Central)", "--filter", "(timeZone=Mountain)", "--filter", "(timeZone=Pacific)", "--schemaPath", "config/schema", "--addEntriesOutsideSplitBaseDNToAllSets"}, ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_EXAMPLE.get());
        this.splitUsingFilter = new SubCommand("split-using-filter", ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_DESC.get(), splitUsingFilterParser, splitUsingFilterExamples);
        this.splitUsingFilter.addName("filter");
        parser.addSubCommand(this.splitUsingFilter);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        List<File> sourceLDIFValues = this.sourceLDIF.getValues();
        if (sourceLDIFValues.size() > 1 && !this.targetLDIFBasePath.isPresent()) {
            throw new ArgumentException(ToolMessages.ERR_SPLIT_LDIF_NO_TARGET_BASE_PATH.get(this.sourceLDIF.getIdentifierString(), this.targetLDIFBasePath.getIdentifierString()));
        }
        if (this.splitUsingFilter.isPresent()) {
            List<Filter> filterList = this.splitUsingFilterFilter.getValues();
            LinkedHashSet<Filter> filterSet = new LinkedHashSet<Filter>(filterList.size());
            for (Filter f : filterList) {
                if (filterSet.contains(f)) {
                    throw new ArgumentException(ToolMessages.ERR_SPLIT_LDIF_NON_UNIQUE_FILTER.get(this.splitUsingFilterFilter.getIdentifierString(), f.toString()));
                }
                filterSet.add(f);
            }
            if (filterSet.size() < 2) {
                throw new ArgumentException(ToolMessages.ERR_SPLIT_LDIF_NOT_ENOUGH_FILTERS.get(this.splitUsingFilter.getPrimaryName(), this.splitUsingFilterFilter.getIdentifierString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ResultCode doToolProcessing() {
        block62: {
            try {
                schema = this.getSchema();
            }
            catch (LDAPException le) {
                this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{le.getMessage()});
                return le.getResultCode();
            }
            if (this.splitUsingHashOnRDN.isPresent()) {
                translator = new SplitLDIFRDNHashTranslator(this.splitBaseDN.getValue(), this.splitUsingHashOnRDNNumSets.getValue(), this.addEntriesOutsideSplitBaseDNToAllSets.isPresent(), this.addEntriesOutsideSplitBaseDNToDedicatedSet.isPresent());
            } else if (this.splitUsingHashOnAttribute.isPresent()) {
                translator = new SplitLDIFAttributeHashTranslator(this.splitBaseDN.getValue(), this.splitUsingHashOnAttributeNumSets.getValue(), this.splitUsingHashOnAttributeAttributeName.getValue(), this.splitUsingHashOnAttributeUseAllValues.isPresent(), this.splitUsingHashOnAttributeAssumeFlatDIT.isPresent(), this.addEntriesOutsideSplitBaseDNToAllSets.isPresent(), this.addEntriesOutsideSplitBaseDNToDedicatedSet.isPresent());
            } else if (this.splitUsingFewestEntries.isPresent()) {
                translator = new SplitLDIFFewestEntriesTranslator(this.splitBaseDN.getValue(), this.splitUsingFewestEntriesNumSets.getValue(), this.splitUsingFewestEntriesAssumeFlatDIT.isPresent(), this.addEntriesOutsideSplitBaseDNToAllSets.isPresent(), this.addEntriesOutsideSplitBaseDNToDedicatedSet.isPresent());
            } else if (this.splitUsingFilter.isPresent()) {
                filterList = this.splitUsingFilterFilter.getValues();
                filterSet = new LinkedHashSet<Filter>(filterList.size());
                for (Filter f : filterList) {
                    filterSet.add(f);
                }
                translator = new SplitLDIFFilterTranslator(this.splitBaseDN.getValue(), schema, filterSet, this.splitUsingFilterAssumeFlatDIT.isPresent(), this.addEntriesOutsideSplitBaseDNToAllSets.isPresent(), this.addEntriesOutsideSplitBaseDNToDedicatedSet.isPresent());
            } else {
                this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_CANNOT_DETERMINE_SPLIT_ALGORITHM.get(new Object[]{this.splitUsingHashOnRDN.getPrimaryName() + ", " + this.splitUsingHashOnAttribute.getPrimaryName() + ", " + this.splitUsingFewestEntries.getPrimaryName() + ", " + this.splitUsingFilter.getPrimaryName()})});
                return ResultCode.PARAM_ERROR;
            }
            try {
                if (this.sourceLDIF.isPresent()) {
                    sourceFiles = this.sourceLDIF.getValues();
                    fileInputStreams = new ArrayList<InputStream>(2 * sourceFiles.size());
                    for (File f : sourceFiles) {
                        if (!fileInputStreams.isEmpty()) {
                            doubleEOL = new byte[StaticUtils.EOL_BYTES.length * 2];
                            System.arraycopy(StaticUtils.EOL_BYTES, 0, doubleEOL, 0, StaticUtils.EOL_BYTES.length);
                            System.arraycopy(StaticUtils.EOL_BYTES, 0, doubleEOL, StaticUtils.EOL_BYTES.length, StaticUtils.EOL_BYTES.length);
                            fileInputStreams.add(new ByteArrayInputStream(doubleEOL));
                        }
                        fileInputStreams.add(new FileInputStream(f));
                    }
                    inputStream = fileInputStreams.size() == 1 ? (InputStream)fileInputStreams.get(0) : new AggregateInputStream(fileInputStreams);
                } else {
                    inputStream = System.in;
                }
                if (this.sourceCompressed.isPresent()) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                ldifReader = new LDIFReader(inputStream, (int)this.numThreads.getValue(), (LDIFReaderEntryTranslator)translator);
                if (schema != null) {
                    ldifReader.setSchema(schema);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_ERROR_CREATING_LDIF_READER.get(new Object[]{StaticUtils.getExceptionMessage(e)})});
                return ResultCode.LOCAL_ERROR;
            }
            resultCode = ResultCode.SUCCESS;
            outputStreams = new LinkedHashMap<String, OutputStream>(10);
            entriesRead = new AtomicLong(0L);
            entriesExcluded = new AtomicLong(0L);
            fileCounts = new TreeMap<String, AtomicLong>();
            block30: while (true) {
                try {
                    entry = (SplitLDIFEntry)ldifReader.readEntry();
                }
                catch (LDIFException le) {
                    Debug.debugException(le);
                    resultCode = ResultCode.LOCAL_ERROR;
                    f = this.getOutputFile(".errors");
                    s = (OutputStream)outputStreams.get(".errors");
                    if (s == null) {
                        try {
                            s = new FileOutputStream(f);
                            if (this.compressTarget.isPresent()) {
                                s = new GZIPOutputStream(s);
                            }
                            outputStreams.put(".errors", s);
                            fileCounts.put(".errors", new AtomicLong(0L));
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            resultCode = ResultCode.LOCAL_ERROR;
                            this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_CANNOT_OPEN_OUTPUT_FILE.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)})});
                            break;
                        }
                    }
                    buffer = new ByteStringBuffer();
                    buffer.append("# ");
                    buffer.append(le.getMessage());
                    buffer.append(StaticUtils.EOL_BYTES);
                    dataLines = le.getDataLines();
                    if (dataLines != null) {
                        for (String dataLine : dataLines) {
                            buffer.append(dataLine);
                            buffer.append(StaticUtils.EOL_BYTES);
                        }
                    }
                    buffer.append(StaticUtils.EOL_BYTES);
                    try {
                        s.write(buffer.toByteArray());
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        resultCode = ResultCode.LOCAL_ERROR;
                        this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_ERROR_WRITING_ERROR_TO_FILE.get(new Object[]{le.getMessage(), f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)})});
                        break;
                    }
                    if (le.mayContinueReading()) {
                        this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_INVALID_LDIF_RECORD_RECOVERABLE.get(new Object[]{StaticUtils.getExceptionMessage(le)})});
                        continue;
                    }
                    this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_INVALID_LDIF_RECORD_UNRECOVERABLE.get(new Object[]{StaticUtils.getExceptionMessage(le)})});
                    break;
                }
                catch (IOException ioe) {
                    Debug.debugException(ioe);
                    resultCode = ResultCode.LOCAL_ERROR;
                    this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_IO_READ_ERROR.get(new Object[]{StaticUtils.getExceptionMessage(ioe)})});
                    break;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    resultCode = ResultCode.LOCAL_ERROR;
                    this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_UNEXPECTED_READ_ERROR.get(new Object[]{StaticUtils.getExceptionMessage(e)})});
                    break;
                }
                if (entry == null) break;
                readCount = entriesRead.incrementAndGet();
                if (readCount % 1000L == 0L) {
                    this.wrapOut(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.INFO_SPLIT_LDIF_PROGRESS.get(new Object[]{readCount})});
                }
                sets = entry.getSets();
                ldifBytes = entry.getLDIFBytes();
                if (sets == null) {
                    try {
                        sets = translator.translate(entry, 0L).getSets();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    if (sets == null) {
                        errorEntry = translator.createEntry(entry, ToolMessages.ERR_SPLIT_LDIF_ENTRY_WITHOUT_PARENT.get(new Object[]{entry.getDN(), this.splitBaseDN.getStringValue()}), Collections.singleton(".errors"));
                        ldifBytes = errorEntry.getLDIFBytes();
                        sets = errorEntry.getSets();
                    }
                }
                if (sets.isEmpty()) {
                    entriesExcluded.incrementAndGet();
                    continue;
                }
                i$ = sets.iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block30;
                    set = i$.next();
                    if (set.equals(".errors")) {
                        resultCode = ResultCode.LOCAL_ERROR;
                    }
                    f = this.getOutputFile(set);
                    s = (OutputStream)outputStreams.get(set);
                    if (s == null) {
                        try {
                            s = new FileOutputStream(f);
                            if (this.compressTarget.isPresent()) {
                                s = new GZIPOutputStream(s);
                            }
                            outputStreams.put(set, s);
                            fileCounts.put(set, new AtomicLong(0L));
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            resultCode = ResultCode.LOCAL_ERROR;
                            this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_CANNOT_OPEN_OUTPUT_FILE.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)})});
                            break block30;
                        }
                    }
                    try {
                        s.write(ldifBytes);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        resultCode = ResultCode.LOCAL_ERROR;
                        this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_ERROR_WRITING_TO_FILE.get(new Object[]{entry.getDN(), f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)})});
                        break block30;
                    }
                    ((AtomicLong)fileCounts.get(set)).incrementAndGet();
                }
                break;
            }
            finalReadCount = entriesRead.get();
            if (finalReadCount > 1000L) {
                this.out(new Object[0]);
            }
            this.wrapOut(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.INFO_SPLIT_LDIF_PROCESSING_COMPLETE.get(new Object[]{finalReadCount})});
            excludedCount = entriesExcluded.get();
            if (excludedCount > 0L) {
                this.wrapOut(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.INFO_SPLIT_LDIF_EXCLUDED_COUNT.get(new Object[]{excludedCount})});
            }
            for (Map.Entry<K, V> e : fileCounts.entrySet()) {
                f = this.getOutputFile((String)e.getKey());
                this.wrapOut(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.INFO_SPLIT_LDIF_COUNT_TO_FILE.get(new Object[]{((AtomicLong)e.getValue()).get(), f.getName()})});
            }
            try {
                ldifReader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            for (Map.Entry<K, V> e : outputStreams.entrySet()) {
                try {
                    ((OutputStream)e.getValue()).close();
                }
                catch (Exception ex) {
                    Debug.debugException(ex);
                    resultCode = ResultCode.LOCAL_ERROR;
                    this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_ERROR_CLOSING_FILE.get(new Object[]{this.getOutputFile((String)e.getKey()), StaticUtils.getExceptionMessage(ex)})});
                }
            }
            break block62;
            catch (Throwable var19_33) {
                try {
                    ldifReader.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                for (Map.Entry<K, V> e : outputStreams.entrySet()) {
                    try {
                        ((OutputStream)e.getValue()).close();
                    }
                    catch (Exception ex) {
                        Debug.debugException(ex);
                        resultCode = ResultCode.LOCAL_ERROR;
                        this.wrapErr(0, SplitLDIF.MAX_OUTPUT_LINE_LENGTH, new Object[]{ToolMessages.ERR_SPLIT_LDIF_ERROR_CLOSING_FILE.get(new Object[]{this.getOutputFile((String)e.getKey()), StaticUtils.getExceptionMessage(ex)})});
                    }
                }
                throw var19_33;
            }
        }
        return resultCode;
    }

    private Schema getSchema() throws LDAPException {
        if (this.schemaPath.isPresent()) {
            ArrayList<File> schemaFiles = new ArrayList<File>(10);
            for (File path : this.schemaPath.getValues()) {
                if (path.isFile()) {
                    schemaFiles.add(path);
                    continue;
                }
                TreeMap<String, File> fileMap = new TreeMap<String, File>();
                for (File schemaDirFile : path.listFiles()) {
                    String name = schemaDirFile.getName();
                    if (!schemaDirFile.isFile() || !name.toLowerCase().endsWith(".ldif")) continue;
                    fileMap.put(name, schemaDirFile);
                }
                schemaFiles.addAll(fileMap.values());
            }
            if (schemaFiles.isEmpty()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_SPLIT_LDIF_NO_SCHEMA_FILES.get(this.schemaPath.getIdentifierString()));
            }
            try {
                return Schema.getSchema(schemaFiles);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_SPLIT_LDIF_ERROR_LOADING_SCHEMA.get(StaticUtils.getExceptionMessage(e)));
            }
        }
        try {
            File instanceRoot;
            File configDir;
            File schemaDir;
            String instanceRootStr = System.getenv("INSTANCE_ROOT");
            if (instanceRootStr != null && (schemaDir = new File(configDir = new File(instanceRoot = new File(instanceRootStr), "config"), "schema")).exists()) {
                TreeMap<String, File> fileMap = new TreeMap<String, File>();
                for (File schemaDirFile : schemaDir.listFiles()) {
                    String name = schemaDirFile.getName();
                    if (!schemaDirFile.isFile() || !name.toLowerCase().endsWith(".ldif")) continue;
                    fileMap.put(name, schemaDirFile);
                }
                if (!fileMap.isEmpty()) {
                    return Schema.getSchema(new ArrayList<File>(fileMap.values()));
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    private File getOutputFile(String extension) {
        File baseFile = this.targetLDIFBasePath.isPresent() ? this.targetLDIFBasePath.getValue() : this.sourceLDIF.getValue();
        return new File(baseFile.getAbsolutePath() + extension);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(4);
        for (Map.Entry<String[], String> e : this.splitUsingHashOnRDN.getExampleUsages().entrySet()) {
            exampleMap.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String[], String> e : this.splitUsingHashOnAttribute.getExampleUsages().entrySet()) {
            exampleMap.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String[], String> e : this.splitUsingFewestEntries.getExampleUsages().entrySet()) {
            exampleMap.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String[], String> e : this.splitUsingFilter.getExampleUsages().entrySet()) {
            exampleMap.put(e.getKey(), e.getValue());
        }
        return exampleMap;
    }
}

