/*
 * Copyright 2019 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright (C) 2019 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk.transformations;



import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;



/**
 * This enum defines a set of message keys for messages in the
 * com.unboundid.ldap.sdk.transformations package, which correspond to messages in the
 * unboundid-ldapsdk-transformations.properties properties file.
 * <BR><BR>
 * This source file was generated from the properties file.
 * Do not edit it directly.
 */
enum TransformationMessages
{
  /**
   * The {0} and {1} arguments must be provided an equal number of times.
   */
  ERR_TRANSFORM_LDIF_ARG_COUNT_MISMATCH("The {0} and {1} arguments must be provided an equal number of times."),



  /**
   * An error occurred while attempting to close the output stream used to write the transformed data to file {0}:  {1}.  The transformed output may not be complete.
   */
  ERR_TRANSFORM_LDIF_ERROR_CLOSING_OUTPUT_STREAM("An error occurred while attempting to close the output stream used to write the transformed data to file {0}:  {1}.  The transformed output may not be complete."),



  /**
   * An error occurred while attempting to create the LDIF reader to iterate across the source records:  {0}
   */
  ERR_TRANSFORM_LDIF_ERROR_CREATING_LDIF_READER("An error occurred while attempting to create the LDIF reader to iterate across the source records:  {0}"),



  /**
   * An error occurred while attempting to create the output stream to use to write the transformed data to file {0}:  {1}
   */
  ERR_TRANSFORM_LDIF_ERROR_CREATING_OUTPUT_STREAM("An error occurred while attempting to create the output stream to use to write the transformed data to file {0}:  {1}"),



  /**
   * An error occurred while attempting to read schema information from the specified schema path(s):  {0}
   */
  ERR_TRANSFORM_LDIF_ERROR_LOADING_SCHEMA("An error occurred while attempting to read schema information from the specified schema path(s):  {0}"),



  /**
   * Either the {0} or {1} argument must be provided to specify where to write the transformed LDIF records.
   */
  ERR_TRANSFORM_LDIF_MISSING_TARGET_ARG("Either the {0} or {1} argument must be provided to specify where to write the transformed LDIF records."),



  /**
   * The {0} argument was provided, but no schema files were found in the specified path(s)
   */
  ERR_TRANSFORM_LDIF_NO_SCHEMA_FILES("The {0} argument was provided, but no schema files were found in the specified path(s)"),



  /**
   * A malformed LDIF record was encountered while reading data from a source file:  {0}.  This record will be excluded from the output, but processing will continue.
   */
  ERR_TRANSFORM_LDIF_RECOVERABLE_MALFORMED_RECORD("A malformed LDIF record was encountered while reading data from a source file:  {0}.  This record will be excluded from the output, but processing will continue."),



  /**
   * An unexpected error occurred while attempting to obtain the next record from a source file:  {0}.  Transformation processing cannot continue.
   */
  ERR_TRANSFORM_LDIF_UNEXPECTED_READ_ERROR("An unexpected error occurred while attempting to obtain the next record from a source file:  {0}.  Transformation processing cannot continue."),



  /**
   * A malformed LDIF record was encountered while reading data from a source file:  {0}.  This is not a recoverable error, so transformation processing cannot continue.
   */
  ERR_TRANSFORM_LDIF_UNRECOVERABLE_MALFORMED_RECORD("A malformed LDIF record was encountered while reading data from a source file:  {0}.  This is not a recoverable error, so transformation processing cannot continue."),



  /**
   * An unexpected error occurred while attempting to write an LDIF record to output file {0}:  {1}.  Transformation processing cannot continue.
   */
  ERR_TRANSFORM_LDIF_WRITE_ERROR("An unexpected error occurred while attempting to write an LDIF record to output file {0}:  {1}.  Transformation processing cannot continue."),



  /**
   * The name or OID of an attribute for which to add a set of attribute values specified using the {0} argument.  The values will only be added to entries that match the associated base DN, scope, and filter criteria, and may optionally only be added to entries that do not already contain one or more values for this attribute.  This argument may be provided at most once, and it cannot be used in conjunction with the {1} argument.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_ADD_ATTR("The name or OID of an attribute for which to add a set of attribute values specified using the {0} argument.  The values will only be added to entries that match the associated base DN, scope, and filter criteria, and may optionally only be added to entries that do not already contain one or more values for this attribute.  This argument may be provided at most once, and it cannot be used in conjunction with the {1} argument."),



  /**
   * The base DN for the subtree in which the attribute targeted by the {0} argument should be added to entries that do not already contain it.  This argument may be provided at most once, but if it is not provided then a default base DN of the null DN (which will be considered an ancestor of all entries) will be used.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_ADD_BASE_DN("The base DN for the subtree in which the attribute targeted by the {0} argument should be added to entries that do not already contain it.  This argument may be provided at most once, but if it is not provided then a default base DN of the null DN (which will be considered an ancestor of all entries) will be used."),



  /**
   * The filter to use to identify entries in which the attribute specified by the {0} argument should be added.  This argument may be provided at most once, but if it is not provided then a default filter of '(&)' (which is the LDAP true filter and will match any entry) will be used.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_ADD_FILTER("The filter to use to identify entries in which the attribute specified by the {0} argument should be added.  This argument may be provided at most once, but if it is not provided then a default filter of '(&)' (which is the LDAP true filter and will match any entry) will be used."),



  /**
   * Indicates that the attribute values specified with the {0} and {1} arguments should be added to entries that already contain the specified attribute (as long as those entries also match the base DN, scope, and filter criteria).  If this argument is not provided, then the attribute values will only be added to entries that do not already contain one or more values for the target attribute (and that match the base DN, scope, and filter criteria).
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_ADD_MERGE_VALUES("Indicates that the attribute values specified with the {0} and {1} arguments should be added to entries that already contain the specified attribute (as long as those entries also match the base DN, scope, and filter criteria).  If this argument is not provided, then the attribute values will only be added to entries that do not already contain one or more values for the target attribute (and that match the base DN, scope, and filter criteria)."),



  /**
   * The scope to use in conjunction with the value of the {0} argument to identify the portion of the hierarchy in which to add values for the attribute targeted by the {1} argument.  This argument may be provided at most once, but if it is not provided then a default scope of 'sub' (which will include all entries at and below the specified base DN) will be used.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_ADD_SCOPE("The scope to use in conjunction with the value of the {0} argument to identify the portion of the hierarchy in which to add values for the attribute targeted by the {1} argument.  This argument may be provided at most once, but if it is not provided then a default scope of 'sub' (which will include all entries at and below the specified base DN) will be used."),



  /**
   * A value that should be added to the attribute targeted by the {0} argument.  This argument may be provided multiple times to specify multiple values to add for that attribute.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_ADD_VALUE("A value that should be added to the attribute targeted by the {0} argument.  This argument may be provided multiple times to specify multiple values to add for that attribute."),



  /**
   * Indicates that, if the target LDIF file already exists, the tool should append to that file rather than overwriting it.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_APPEND_TO_TARGET("Indicates that, if the target LDIF file already exists, the tool should append to that file rather than overwriting it."),



  /**
   * Indicates that the target LDIF file should be gzip-compressed.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_COMPRESS_TARGET("Indicates that the target LDIF file should be gzip-compressed."),



  /**
   * The path to a file that contains the passphrase that should be used to generate the encryption key, and also to decrypt the input if it happens to be encrypted.  If the --encryptTarget argument is provided and no passphrase file is given, then the passphrase will be interactively requested.  If an encryption passphrase file is specified, then it must contain exactly one line, and that line must be comprised entirely of the passphrase.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_ENCRYPTION_PW_FILE("The path to a file that contains the passphrase that should be used to generate the encryption key, and also to decrypt the input if it happens to be encrypted.  If the --encryptTarget argument is provided and no passphrase file is given, then the passphrase will be interactively requested.  If an encryption passphrase file is specified, then it must contain exactly one line, and that line must be comprised entirely of the passphrase."),



  /**
   * Indicates that the target LDIF file should be encrypted with a key generated from a provided passphrase.  If the --encryptionPassphraseFile argument is provided, then the passphrase will be read from that file; otherwise, it will be interactively requested.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_ENCRYPT_TARGET("Indicates that the target LDIF file should be encrypted with a key generated from a provided passphrase.  If the --encryptionPassphraseFile argument is provided, then the passphrase will be read from that file; otherwise, it will be interactively requested."),



  /**
   * The name or OID of an attribute to exclude from the output.  This argument may be provided multiple times to specify multiple attributes to be excluded.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ATTR("The name or OID of an attribute to exclude from the output.  This argument may be provided multiple times to specify multiple attributes to be excluded."),



  /**
   * The base DN to use to identify entries to exclude from the output if at least one of the --excludeEntryBaseDN, --excludeEntryScope, or --excludeEntryFilter arguments is provided.  If this argument is not provided, a default base DN of the null DN (which will be considered an ancestor of every other entry) will be used.  This argument cannot be used in conjunction with the {0} argument.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_BASE_DN("The base DN to use to identify entries to exclude from the output if at least one of the --excludeEntryBaseDN, --excludeEntryScope, or --excludeEntryFilter arguments is provided.  If this argument is not provided, a default base DN of the null DN (which will be considered an ancestor of every other entry) will be used.  This argument cannot be used in conjunction with the {0} argument."),



  /**
   * The filter to use to identify entries to exclude from the output if at least one of the --excludeEntryBaseDN, --excludeEntryScope, or --excludeEntryFilter arguments is provided.  If this argument is not provided, a default filter of '(&)' (which is the LDAP true filter and will match any entry) will be used.  This argument cannot be used in conjunction with the {0} argument.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_FILTER("The filter to use to identify entries to exclude from the output if at least one of the --excludeEntryBaseDN, --excludeEntryScope, or --excludeEntryFilter arguments is provided.  If this argument is not provided, a default filter of '(&)' (which is the LDAP true filter and will match any entry) will be used.  This argument cannot be used in conjunction with the {0} argument."),



  /**
   * The scope to use to identify entries to exclude from the output if at least one of the --excludeEntryBaseDN, --excludeEntryScope, or --excludeEntryFilter arguments is provided.  If this argument is not provided, a default scope of 'sub' (which will include all entries at or below the base DN) will be used.  This argument cannot be used in conjunction with the {0} argument.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_SCOPE("The scope to use to identify entries to exclude from the output if at least one of the --excludeEntryBaseDN, --excludeEntryScope, or --excludeEntryFilter arguments is provided.  If this argument is not provided, a default scope of 'sub' (which will include all entries at or below the base DN) will be used.  This argument cannot be used in conjunction with the {0} argument."),



  /**
   * Indicates that entries that do not match the criteria specified using the --excludeEntryBaseDN, --excludeEntryScope, and --excludeEntryFilter arguments should be excluded from the output, and entries that do match the criteria will be preserved.  If this argument is not provided, then entries that do  match the criteria will be excluded and entries that do not match the criteria will be preserved.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_NON_MATCHING("Indicates that entries that do not match the criteria specified using the --excludeEntryBaseDN, --excludeEntryScope, and --excludeEntryFilter arguments should be excluded from the output, and entries that do match the criteria will be preserved.  If this argument is not provided, then entries that do  match the criteria will be excluded and entries that do not match the criteria will be preserved."),



  /**
   * Indicates that all name-value pairs contained in DN components omitted from a flattened DN should be added as attribute values to the entry.  For example, if the flatten base DN is 'ou=People,dc=example,dc=com', the DN 'uid=john.doe,ou=New York,ou=East,ou=People,dc=example,dc=com' will be flattened to simply 'uid=john.doe,ou=People,dc=example,dc=com' and the 'ou=New York' and 'ou=East' components will be omitted.  If this argument is provided, then ou values of 'New York' and 'East' will be added to the entry during the flattening process.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_ADD_OMITTED_TO_ENTRY("Indicates that all name-value pairs contained in DN components omitted from a flattened DN should be added as attribute values to the entry.  For example, if the flatten base DN is 'ou=People,dc=example,dc=com', the DN 'uid=john.doe,ou=New York,ou=East,ou=People,dc=example,dc=com' will be flattened to simply 'uid=john.doe,ou=People,dc=example,dc=com' and the 'ou=New York' and 'ou=East' components will be omitted.  If this argument is provided, then ou values of 'New York' and 'East' will be added to the entry during the flattening process."),



  /**
   * Indicates that all name-value pairs contained in DN components omitted from a flattened DN should be added to the original RDN (making it a multivalued RDN if it wasn't already).  For example, if this argument is provided and the flatten base DN is 'ou=People,dc=Example,dc=com', the DN 'uid=john.doe,ou=New York,ou=East,ou=People,dc=example,dc=com' will be flattened to 'uid=john.doe+ou=New York+ou=East,ou=People,dc=example,dc=com'.  This will help ensure that all flattened DNs are unique in the event that the same RDN might exist in different branches below the flatten base DN.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_ADD_OMITTED_TO_RDN("Indicates that all name-value pairs contained in DN components omitted from a flattened DN should be added to the original RDN (making it a multivalued RDN if it wasn't already).  For example, if this argument is provided and the flatten base DN is 'ou=People,dc=Example,dc=com', the DN 'uid=john.doe,ou=New York,ou=East,ou=People,dc=example,dc=com' will be flattened to 'uid=john.doe+ou=New York+ou=East,ou=People,dc=example,dc=com'.  This will help ensure that all flattened DNs are unique in the event that the same RDN might exist in different branches below the flatten base DN."),



  /**
   * The base DN below which the DIT should be flattened.  Any entries more than one level below this base DN will be renamed so that they are exactly one level below this base DN.  By default, the flattening process will create a new DN that is simply the original RDN followed by a comma and the flatten base DN (so that all DN components between the RDN and the flatten base DN will simply be stripped from the DN).  This flattening will also be applied to all attribute values that represent DNs that are more than one level below this flatten base DN.  All DNs that are not more than one level below the flatten base DN will be left unchanged.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_BASE_DN("The base DN below which the DIT should be flattened.  Any entries more than one level below this base DN will be renamed so that they are exactly one level below this base DN.  By default, the flattening process will create a new DN that is simply the original RDN followed by a comma and the flatten base DN (so that all DN components between the RDN and the flatten base DN will simply be stripped from the DN).  This flattening will also be applied to all attribute values that represent DNs that are more than one level below this flatten base DN.  All DNs that are not more than one level below the flatten base DN will be left unchanged."),



  /**
   * Provides a filter that can be used to identify entries below the flatten base DN that should be excluded from the resulting LDIF file.  This can be used to exclude non-leaf 'container' entries that were only present to provide hierarchy in the previous non-flattened DIT and are no longer needed in the flattened representation of the DIT.  This argument will not exclude any entries that are at or outside the flatten base DN.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_EXCLUDE_FILTER("Provides a filter that can be used to identify entries below the flatten base DN that should be excluded from the resulting LDIF file.  This can be used to exclude non-leaf 'container' entries that were only present to provide hierarchy in the previous non-flattened DIT and are no longer needed in the flattened representation of the DIT.  This argument will not exclude any entries that are at or outside the flatten base DN."),



  /**
   * Indicates that the number of values contained in a redacted attribute should be hidden so that it is no longer possible to determine the original number of values.  If this argument is provided, then any redacted attribute that originally had one or more values will be updated so that it only has a single value of '***REDACTED***'.  If this argument is not provided, then any redacted attribute that had a single value will have that value replaced with '***REDACTED***', but any redacted attribute that had multiple values will still have that same number of values, with each replacement containing a counter (e.g., '***REDACTED1***', '***REDACTED2***', etc.).
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_HIDE_REDACTED_COUNT("Indicates that the number of values contained in a redacted attribute should be hidden so that it is no longer possible to determine the original number of values.  If this argument is provided, then any redacted attribute that originally had one or more values will be updated so that it only has a single value of '***REDACTED***'.  If this argument is not provided, then any redacted attribute that had a single value will have that value replaced with '***REDACTED***', but any redacted attribute that had multiple values will still have that same number of values, with each replacement containing a counter (e.g., '***REDACTED1***', '***REDACTED2***', etc.)."),



  /**
   * The initial value for the counter used to generate values for attributes targeted by the {0} argument.  This argument may be provided at most once, with all configured sequential attributes using the same initial counter value.  If this argument is not provided, a default initial counter value of zero will be used.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_INITIAL_SEQUENTIAL_VALUE("The initial value for the counter used to generate values for attributes targeted by the {0} argument.  This argument may be provided at most once, with all configured sequential attributes using the same initial counter value.  If this argument is not provided, a default initial counter value of zero will be used."),



  /**
   * The base DN for a subtree to be moved to another location in the DIT, with this source base DN being replaced with the base DN specified using the --moveSubtreeTo argument.  This argument may be specified multiple times to rename multiple subtrees as long as the source subtrees are not hierarchically related, and as long as the --moveSubtreeTo argument is specified the same number of times (and the order in which these arguments are provided will be used to correlate the source and target subtree base DNs).
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_MOVE_SUBTREE_FROM("The base DN for a subtree to be moved to another location in the DIT, with this source base DN being replaced with the base DN specified using the --moveSubtreeTo argument.  This argument may be specified multiple times to rename multiple subtrees as long as the source subtrees are not hierarchically related, and as long as the --moveSubtreeTo argument is specified the same number of times (and the order in which these arguments are provided will be used to correlate the source and target subtree base DNs)."),



  /**
   * The new base DN for a subtree to be moved.  This argument must be specified the same number of times as the {0} argument.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_MOVE_SUBTREE_TO("The new base DN for a subtree to be moved.  This argument must be specified the same number of times as the {0} argument."),



  /**
   * The number of concurrent threads to use when processing.  If this is not specified, only a single thread will be used.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_NUM_THREADS("The number of concurrent threads to use when processing.  If this is not specified, only a single thread will be used."),



  /**
   * Indicates that transformations performed may be allowed to alter the DNs of entries read from the source LDIF files to make any appropriate changes (e.g., to scramble or redact RDN attribute values or to rename RDN attributes).  If this argument is not provided, then the original entry DNs will be preserved.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_PROCESS_DNS("Indicates that transformations performed may be allowed to alter the DNs of entries read from the source LDIF files to make any appropriate changes (e.g., to scramble or redact RDN attribute values or to rename RDN attributes).  If this argument is not provided, then the original entry DNs will be preserved."),



  /**
   * The seed to provided to the random number generators that will be used when scrambling values.  If a random seed is provided, then running this tool multiple times with the same seed on the same source LDIF files should yield the same scrambled representations for most types of attributes.  If no random seed is given, an appropriate seed will be automatically selected.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_RANDOM_SEED("The seed to provided to the random number generators that will be used when scrambling values.  If a random seed is provided, then running this tool multiple times with the same seed on the same source LDIF files should yield the same scrambled representations for most types of attributes.  If no random seed is given, an appropriate seed will be automatically selected."),



  /**
   * The name or OID of an attribute whose values should be redacted so that it is possible to determine that the specified attribute is present in an entry without exposing the values for that attribute.  This argument may be provided multiple times to specify multiple attributes whose values should be redacted.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_REDACT_ATTR("The name or OID of an attribute whose values should be redacted so that it is possible to determine that the specified attribute is present in an entry without exposing the values for that attribute.  This argument may be provided multiple times to specify multiple attributes whose values should be redacted."),



  /**
   * The name or OID of an attribute to rename to the value specified by the --renameAttributeTo argument.  This argument may be specified multiple times to specify multiple attributes to rename, as long as the --renameAttributeTo argument is specified the same number of times (and the order in which these arguments are provided will be used to correlate the source and target attribute names).
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_RENAME_FROM("The name or OID of an attribute to rename to the value specified by the --renameAttributeTo argument.  This argument may be specified multiple times to specify multiple attributes to rename, as long as the --renameAttributeTo argument is specified the same number of times (and the order in which these arguments are provided will be used to correlate the source and target attribute names)."),



  /**
   * The new name or OID for an attribute to be renamed.  This argument must be specified the same number of times as the {0} argument.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_RENAME_TO("The new name or OID for an attribute to be renamed.  This argument must be specified the same number of times as the {0} argument."),



  /**
   * A value that should be used to replace the existing values of the attribute targeted by the {0} argument.  This argument may be provided multiple times to specify multiple replacement values.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_REPLACEMENT_VALUE("A value that should be used to replace the existing values of the attribute targeted by the {0} argument.  This argument may be provided multiple times to specify multiple replacement values."),



  /**
   * The name or OID of an attribute whose values should be replaced with the value(s) specified using the --replacementValue argument.  The values will only be set in entries that already contain the specified attribute; the attribute will not be added to any entries that do not already contain it (although the --addMissingAttributeName and --addMissingAttributeValue arguments may be used to accomplish that).  This argument may be provided at most once, and it cannot be used in conjunction with the {0} argument.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_REPLACE_VALUES_ATTR("The name or OID of an attribute whose values should be replaced with the value(s) specified using the --replacementValue argument.  The values will only be set in entries that already contain the specified attribute; the attribute will not be added to any entries that do not already contain it (although the --addMissingAttributeName and --addMissingAttributeValue arguments may be used to accomplish that).  This argument may be provided at most once, and it cannot be used in conjunction with the {0} argument."),



  /**
   * The path to a file or directory from which to read schema definitions to use to improve the accuracy and flexibility of the processing performed by this tool (including identifying alternate names that may be used to reference attributes, and identifying the expected syntax for attribute values).  If the specified path is a file, then that file must be an LDIF file containing the schema definitions to read.  If the specified path is a directory, then all files in that directory that have a '.ldif' extension will be read (in alphabetical order by filename) to obtain schema definitions.  This argument may be provided multiple times to specify multiple schema file or directory paths.  If this argument is not provided, then a default schema will be used containing a number of standard attribute type and object class definitions.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SCHEMA_PATH("The path to a file or directory from which to read schema definitions to use to improve the accuracy and flexibility of the processing performed by this tool (including identifying alternate names that may be used to reference attributes, and identifying the expected syntax for attribute values).  If the specified path is a file, then that file must be an LDIF file containing the schema definitions to read.  If the specified path is a directory, then all files in that directory that have a '.ldif' extension will be read (in alphabetical order by filename) to obtain schema definitions.  This argument may be provided multiple times to specify multiple schema file or directory paths.  If this argument is not provided, then a default schema will be used containing a number of standard attribute type and object class definitions."),



  /**
   * The name or OID of an attribute whose values should be scrambled.  Scrambling will be performed in a manner that attempts to preserve the associated attribute syntax and that will generally try to ensure that a given input value will consistently yield the same scrambled output.  This argument may be provided multiple times to indicate that multiple attributes should have their values scrambled.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SCRAMBLE_ATTR("The name or OID of an attribute whose values should be scrambled.  Scrambling will be performed in a manner that attempts to preserve the associated attribute syntax and that will generally try to ensure that a given input value will consistently yield the same scrambled output.  This argument may be provided multiple times to indicate that multiple attributes should have their values scrambled."),



  /**
   * The name of a JSON field whose values should be scrambled.  If the {0} argument is used to scramble any attributes whose values may be JSON objects, then all JSON field names will be preserved and only the values will be scrambled.  If this argument is given (and it may be provided multiple times to target multiple JSON fields), then only the specified JSON fields will have their values scrambled.  If this argument is not given, then any JSON objects contained in any of the attributes to scramble will have all values of all fields scrambled.  JSON field names will be treated in a case-insensitive manner.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SCRAMBLE_JSON_FIELD("The name of a JSON field whose values should be scrambled.  If the {0} argument is used to scramble any attributes whose values may be JSON objects, then all JSON field names will be preserved and only the values will be scrambled.  If this argument is given (and it may be provided multiple times to target multiple JSON fields), then only the specified JSON fields will have their values scrambled.  If this argument is not given, then any JSON objects contained in any of the attributes to scramble will have all values of all fields scrambled.  JSON field names will be treated in a case-insensitive manner."),



  /**
   * The name or OID of an attribute whose values should be replaced with a generated value that contains a numeric counter that will be incremented for each entry containing this attribute.  The counter will only be incremented for entries that contain the specified attribute.  This argument may be provided multiple times to indicate that multiple attributes should include generated values that contain counters, with a separate counter maintained for each attribute.  This argument cannot be used in conjunction with the {0} argument.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_ATTR("The name or OID of an attribute whose values should be replaced with a generated value that contains a numeric counter that will be incremented for each entry containing this attribute.  The counter will only be incremented for entries that contain the specified attribute.  This argument may be provided multiple times to indicate that multiple attributes should include generated values that contain counters, with a separate counter maintained for each attribute.  This argument cannot be used in conjunction with the {0} argument."),



  /**
   * The amount by which to increment the counter for each entry containing an attribute targeted by the {0} argument.  This argument may be provided at most once, with all configured sequential attributes using the same increment.  If this argument is not provided, a default increment of one will be used.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_INCREMENT("The amount by which to increment the counter for each entry containing an attribute targeted by the {0} argument.  This argument may be provided at most once, with all configured sequential attributes using the same increment.  If this argument is not provided, a default increment of one will be used."),



  /**
   * An optional string that will appear immediately after the numeric counter in values generated for attributes targeted by the {0} argument.  This argument may be provided at most once, with all configured sequential attributes ending with the same final text.  If this argument is not provided, the generated values will not include any text after the counter.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_TEXT_AFTER("An optional string that will appear immediately after the numeric counter in values generated for attributes targeted by the {0} argument.  This argument may be provided at most once, with all configured sequential attributes ending with the same final text.  If this argument is not provided, the generated values will not include any text after the counter."),



  /**
   * An optional string that will appear immediately before the numeric counter in values generated for attributes targeted by the {0} argument.  This argument may be provided at most once, with all configured sequential attributes starting with the same initial text.  If this argument is not provided, the generated values will not include any text before the counter.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_TEXT_BEFORE("An optional string that will appear immediately before the numeric counter in values generated for attributes targeted by the {0} argument.  This argument may be provided at most once, with all configured sequential attributes starting with the same initial text.  If this argument is not provided, the generated values will not include any text before the counter."),



  /**
   * Indicates that the source LDIF files are gzip-compressed.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_COMPRESSED("Indicates that the source LDIF files are gzip-compressed."),



  /**
   * Indicates that the source LDIF files may contain LDIF change records.  Note that some types of transformations are not supported for use with LDIF change records.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_CONTAINS_CHANGE_RECORDS("Indicates that the source LDIF files may contain LDIF change records.  Note that some types of transformations are not supported for use with LDIF change records."),



  /**
   * The path to an LDIF file containing the entries or change records to transform.  This argument may be provided multiple times to transform data contained in multiple files, and if multiple source LDIF files are specified, they will be processed in the order listed on the command line.  Either the --sourceLDIF or the --sourceFromStandardInput argument (but not both) must be provided.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_LDIF("The path to an LDIF file containing the entries or change records to transform.  This argument may be provided multiple times to transform data contained in multiple files, and if multiple source LDIF files are specified, they will be processed in the order listed on the command line.  Either the --sourceLDIF or the --sourceFromStandardInput argument (but not both) must be provided."),



  /**
   * Indicates that the source data data will be read from standard input rather than from one or more LDIF files.  This option is primarily intended for use when piping the output of another tool (perhaps even another invocation of the transform-ldif tool) into this tool.  Either the --sourceLDIF or the --sourceFromStandardInput argument (but not both) must be provided.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_STD_IN("Indicates that the source data data will be read from standard input rather than from one or more LDIF files.  This option is primarily intended for use when piping the output of another tool (perhaps even another invocation of the transform-ldif tool) into this tool.  Either the --sourceLDIF or the --sourceFromStandardInput argument (but not both) must be provided."),



  /**
   * The path to the LDIF file to which the transformed entries and change records will be written.  This argument must be provided at most once.  Even if multiple source LDIF files were provided, all of the transformed entries and change records will be written to the same destination.  Either the --targetLDIF or the --targetToStandardOutput argument (but not both) must be provided.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_TARGET_LDIF("The path to the LDIF file to which the transformed entries and change records will be written.  This argument must be provided at most once.  Even if multiple source LDIF files were provided, all of the transformed entries and change records will be written to the same destination.  Either the --targetLDIF or the --targetToStandardOutput argument (but not both) must be provided."),



  /**
   * Indicates that the transformed entries and change records should be written to standard output rather than to an LDIF file.  This option is primarily intended to allow the transformed output to be piped into another tool (perhaps even another invocation of the transform-ldif tool) for further processing, but it can also be used to write the output to the terminal for visual inspection.  If this argument is provided, then progress messages will not be written to standard output.  Either the --targetLDIF or the --targetToStandardOutput argument (but not both) must be provided.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_TARGET_STD_OUT("Indicates that the transformed entries and change records should be written to standard output rather than to an LDIF file.  This option is primarily intended to allow the transformed output to be piped into another tool (perhaps even another invocation of the transform-ldif tool) for further processing, but it can also be used to write the output to the terminal for visual inspection.  If this argument is provided, then progress messages will not be written to standard output.  Either the --targetLDIF or the --targetToStandardOutput argument (but not both) must be provided."),



  /**
   * The column at which lines should be wrapped when writing to the target LDIF file.  If this is not provided, then no line wrapping will be performed.
   */
  INFO_TRANSFORM_LDIF_ARG_DESC_WRAP_COLUMN("The column at which lines should be wrapped when writing to the target LDIF file.  If this is not provided, then no line wrapping will be performed."),



  /**
   * Arguments for Adding Attribute Values
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR("Arguments for Adding Attribute Values"),



  /**
   * Arguments for Excluding Attributes and Entries
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE("Arguments for Excluding Attributes and Entries"),



  /**
   * Arguments for Flattening DITs
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN("Arguments for Flattening DITs"),



  /**
   * Arguments for Configuring Input and Output LDIF Files
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF("Arguments for Configuring Input and Output LDIF Files"),



  /**
   * Arguments for Moving Subtrees
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_MOVE("Arguments for Moving Subtrees"),



  /**
   * Arguments for Redacting Attribute Values
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_REDACT("Arguments for Redacting Attribute Values"),



  /**
   * Arguments for Renaming Attributes
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_RENAME("Arguments for Renaming Attributes"),



  /**
   * Arguments for Replacing Values of Existing Attributes
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_REPLACE_VALUES("Arguments for Replacing Values of Existing Attributes"),



  /**
   * Arguments for Scrambling Attribute Values
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_SCRAMBLE("Arguments for Scrambling Attribute Values"),



  /**
   * Arguments for Replacing Attribute Values with a Sequential Counter
   */
  INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL("Arguments for Replacing Attribute Values with a Sequential Counter"),



  /**
   * Processing completed.  Transformed {0,number,0} entries.
   */
  INFO_TRANSFORM_LDIF_COMPLETE_NONE_EXCLUDED("Processing completed.  Transformed {0,number,0} entries."),



  /**
   * Processing completed.  Transformed {0,number,0} entries.  Excluded {1,number,0} entries.
   */
  INFO_TRANSFORM_LDIF_COMPLETE_WITH_EXCLUDED("Processing completed.  Transformed {0,number,0} entries.  Excluded {1,number,0} entries."),



  /**
   * Transform the data contained in file 'input.ldif' to add an 'o' attribute with a value of 'Example Corp.' to any entry that matches filter '(objectClass=person)' and does not already have an 'o' attribute.  The output will be written to the 'added-organization.ldif' file.
   */
  INFO_TRANSFORM_LDIF_EXAMPLE_ADD("Transform the data contained in file 'input.ldif' to add an 'o' attribute with a value of 'Example Corp.' to any entry that matches filter '(objectClass=person)' and does not already have an 'o' attribute.  The output will be written to the 'added-organization.ldif' file."),



  /**
   * Transform the data contained in file 'input.ldif' to move all entries at or below 'o=example.com' so that they will instead be below 'dc=example,dc=com'.  The output will be written to the 'rebased.ldif' file.
   */
  INFO_TRANSFORM_LDIF_EXAMPLE_REBASE("Transform the data contained in file 'input.ldif' to move all entries at or below 'o=example.com' so that they will instead be below 'dc=example,dc=com'.  The output will be written to the 'rebased.ldif' file."),



  /**
   * Transform the data contained in file 'input.ldif' to scramble the values of the givenName, sn, and cn attributes and write the result to the 'scrambled.ldif' file.  Ten concurrent threads will be used to perform the processing, it will use the schema defined in the files in the '/ds/config/schema directory', and the values of attributes that appear in entry DNs may be scrambled.
   */
  INFO_TRANSFORM_LDIF_EXAMPLE_SCRAMBLE("Transform the data contained in file 'input.ldif' to scramble the values of the givenName, sn, and cn attributes and write the result to the 'scrambled.ldif' file.  Ten concurrent threads will be used to perform the processing, it will use the schema defined in the files in the '/ds/config/schema directory', and the values of attributes that appear in entry DNs may be scrambled."),



  /**
   * Transform the data contained in file 'input.ldif' to replace the value of the uid attribute with a dynamically-generated value consisting of the string 'user.' followed by a sequentially-incrementing counter that starts at 1 and increases by 1 for each entry that has a uid attribute.  Entry DNs containing the uid attribute will be updated, and the output will be written to the 'sequential.ldif' file.
   */
  INFO_TRANSFORM_LDIF_EXAMPLE_SEQUENTIAL("Transform the data contained in file 'input.ldif' to replace the value of the uid attribute with a dynamically-generated value consisting of the string 'user.' followed by a sequentially-incrementing counter that starts at 1 and increases by 1 for each entry that has a uid attribute.  Entry DNs containing the uid attribute will be updated, and the output will be written to the 'sequential.ldif' file."),



  /**
   * {attributeName}
   */
  INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME("{attributeName}"),



  /**
   * {fieldName}
   */
  INFO_TRANSFORM_LDIF_PLACEHOLDER_FIELD_NAME("{fieldName}"),



  /**
   * Apply one or more changes to entries or change records read from an LDIF file, writing the updating records to a new file.  This tool can apply a variety of transformations, including scrambling attribute values, redacting attribute values, excluding attributes or entries, replacing existing attributes, adding new attributes, renaming attributes, and moving entries from one subtree to another.
   */
  INFO_TRANSFORM_LDIF_TOOL_DESCRIPTION("Apply one or more changes to entries or change records read from an LDIF file, writing the updating records to a new file.  This tool can apply a variety of transformations, including scrambling attribute values, redacting attribute values, excluding attributes or entries, replacing existing attributes, adding new attributes, renaming attributes, and moving entries from one subtree to another."),



  /**
   * Transformed {0,number,0} entries.
   */
  INFO_TRANSFORM_LDIF_WROTE_ENTRIES_NONE_EXCLUDED("Transformed {0,number,0} entries."),



  /**
   * Transformed {0,number,0} entries.  Excluded {1,number,0} entries.
   */
  INFO_TRANSFORM_LDIF_WROTE_ENTRIES_WITH_EXCLUDED("Transformed {0,number,0} entries.  Excluded {1,number,0} entries.");



  /**
   * Indicates whether the unit tests are currently running.
   */
  private static final boolean IS_WITHIN_UNIT_TESTS =
       Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") ||
       Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");



  /**
   * The resource bundle that will be used to load the properties file.
   */
  private static final ResourceBundle RESOURCE_BUNDLE;
  static
  {
    ResourceBundle rb = null;
    try
    {
      rb = ResourceBundle.getBundle("unboundid-ldapsdk-transformations");
    } catch (final Exception e) {}
    RESOURCE_BUNDLE = rb;
  }



  /**
   * The map that will be used to hold the unformatted message strings, indexed by property name.
   */
  private static final ConcurrentHashMap<TransformationMessages,String> MESSAGE_STRINGS = new ConcurrentHashMap<>(100);



  /**
   * The map that will be used to hold the message format objects, indexed by property name.
   */
  private static final ConcurrentHashMap<TransformationMessages,MessageFormat> MESSAGES = new ConcurrentHashMap<>(100);



  // The default text for this message
  private final String defaultText;



  /**
   * Creates a new message key.
   */
  private TransformationMessages(final String defaultText)
  {
    this.defaultText = defaultText;
  }



  /**
   * Retrieves a localized version of the message.
   * This method should only be used for messages which do not take any arguments.
   *
   * @return  A localized version of the message.
   */
  public String get()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        s = defaultText;
      }
      else
      {
        try
        {
          s = RESOURCE_BUNDLE.getString(name());
        }
        catch (final Exception e)
        {
          s = defaultText;
        }
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }

    if (IS_WITHIN_UNIT_TESTS &&
        (s.contains("{0}") || s.contains("{0,number,0}") ||
         s.contains("{1}") || s.contains("{1,number,0}") ||
         s.contains("{2}") || s.contains("{2,number,0}") ||
         s.contains("{3}") || s.contains("{3,number,0}") ||
         s.contains("{4}") || s.contains("{4,number,0}") ||
         s.contains("{5}") || s.contains("{5,number,0}") ||
         s.contains("{6}") || s.contains("{6,number,0}") ||
         s.contains("{7}") || s.contains("{7,number,0}") ||
         s.contains("{8}") || s.contains("{8,number,0}") ||
         s.contains("{9}") || s.contains("{9,number,0}") ||
         s.contains("{10}") ||  s.contains("{10,number,0}")))
    {
         throw new IllegalArgumentException(
              "Message " + getClass().getName() + '.' + name() +
                   " contains an un-replaced token:  " + s);
    }

    return s;
  }



  /**
   * Retrieves a localized version of the message.
   *
   * @param  args  The arguments to use to format the message.
   *
   * @return  A localized version of the message.
   */
  public String get(final Object... args)
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(args);
    }

    if (IS_WITHIN_UNIT_TESTS &&
        (formattedMessage.contains("{0}") ||
         formattedMessage.contains("{0,number,0}") ||
         formattedMessage.contains("{1}") ||
         formattedMessage.contains("{1,number,0}") ||
         formattedMessage.contains("{2}") ||
         formattedMessage.contains("{2,number,0}") ||
         formattedMessage.contains("{3}") ||
         formattedMessage.contains("{3,number,0}") ||
         formattedMessage.contains("{4}") ||
         formattedMessage.contains("{4,number,0}") ||
         formattedMessage.contains("{5}") ||
         formattedMessage.contains("{5,number,0}") ||
         formattedMessage.contains("{6}") ||
         formattedMessage.contains("{6,number,0}") ||
         formattedMessage.contains("{7}") ||
         formattedMessage.contains("{7,number,0}") ||
         formattedMessage.contains("{8}") ||
         formattedMessage.contains("{8,number,0}") ||
         formattedMessage.contains("{9}") ||
         formattedMessage.contains("{9,number,0}") ||
         formattedMessage.contains("{10}") ||
         formattedMessage.contains("{10,number,0}")))
    {
         throw new IllegalArgumentException(
              "Message " + getClass().getName() + '.' + name() +
                   " contains an un-replaced token:  " + formattedMessage);
    }

    return f.format(args);
  }



  /**
   * Retrieves a string representation of this message key.
   *
   * @return  A string representation of this message key.
   */
  @Override()
  public String toString()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        s = defaultText;
      }
      else
      {
        try
        {
          s = RESOURCE_BUNDLE.getString(name());
        }
        catch (final Exception e)
        {
          s = defaultText;
        }
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }

    return s;
  }
}

