/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class WriteTimeoutHandler
extends TimerTask {
    private static final long TIMER_INTERVAL_MILLIS = 100L;
    private static final Timer TIMER = new Timer("Write Timeout Handler Timer", true);
    private final AtomicLong counter;
    private final ConcurrentHashMap<Long, Long> writeTimeouts;
    private final LDAPConnection connection;

    WriteTimeoutHandler(LDAPConnection connection) {
        this.connection = connection;
        this.counter = new AtomicLong(0L);
        this.writeTimeouts = new ConcurrentHashMap(10);
        TIMER.schedule((TimerTask)this, 100L, 100L);
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<Long, Long>> iterator = this.writeTimeouts.entrySet().iterator();
        while (iterator.hasNext()) {
            long closeTime = iterator.next().getValue();
            if (currentTime <= closeTime) continue;
            try {
                this.connection.getConnectionInternals(true).getSocket().close();
            }
            catch (Exception e) {
                Debug.debugException(e);
                return;
            }
        }
    }

    @Override
    public boolean cancel() {
        boolean result = super.cancel();
        TIMER.purge();
        return result;
    }

    long beginWrite(long timeoutMillis) {
        long id = this.counter.getAndIncrement();
        long writeExpirationTime = System.currentTimeMillis() + timeoutMillis;
        this.writeTimeouts.put(id, writeExpirationTime);
        return id;
    }

    void writeCompleted(long writeID) {
        this.writeTimeouts.remove(writeID);
    }
}

