/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.examples.SearchAndModRate;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.ValuePattern;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class SearchAndModRateThread
extends Thread {
    private final AtomicBoolean stopRequested;
    private final AtomicInteger runningThreads;
    private final AtomicLong errorCounter;
    private final AtomicLong modCounter;
    private final AtomicLong modDurations;
    private final AtomicLong remainingIterationsBeforeReconnect;
    private final AtomicLong searchCounter;
    private final AtomicLong searchDurations;
    private final AtomicReference<Thread> searchAndModThread;
    private final AtomicReference<ResultCode> resultCode;
    private final byte[] charSet;
    private final CyclicBarrier startBarrier;
    private final int valueLength;
    private final Integer simplePageSize;
    private LDAPConnection connection;
    private final List<Control> modifyControls;
    private final List<Control> searchControls;
    private final long iterationsBeforeReconnect;
    private final Random random;
    private final ResultCodeCounter rcCounter;
    private final SearchAndModRate searchAndModRate;
    private final SearchRequest searchRequest;
    private final String[] modAttributes;
    private final ValuePattern authzID;
    private final ValuePattern baseDN;
    private final ValuePattern filter;
    private final FixedRateBarrier fixedRateBarrier;

    SearchAndModRateThread(SearchAndModRate searchAndModRate, int threadNumber, LDAPConnection connection, ValuePattern baseDN, SearchScope scope, ValuePattern filter, String[] returnAttributes, String[] modAttributes, int valueLength, byte[] charSet, ValuePattern authzID, Integer simplePageSize, List<Control> searchControls, List<Control> modifyControls, long iterationsBeforeReconnect, long randomSeed, AtomicInteger runningThreads, CyclicBarrier startBarrier, AtomicLong searchCounter, AtomicLong modCounter, AtomicLong searchDurations, AtomicLong modDurations, AtomicLong errorCounter, ResultCodeCounter rcCounter, FixedRateBarrier rateBarrier) {
        this.setName("SearchAndModRate Thread " + threadNumber);
        this.setDaemon(true);
        this.searchAndModRate = searchAndModRate;
        this.connection = connection;
        this.baseDN = baseDN;
        this.filter = filter;
        this.modAttributes = modAttributes;
        this.valueLength = valueLength;
        this.charSet = charSet;
        this.authzID = authzID;
        this.simplePageSize = simplePageSize;
        this.searchControls = searchControls;
        this.modifyControls = modifyControls;
        this.iterationsBeforeReconnect = iterationsBeforeReconnect;
        this.searchCounter = searchCounter;
        this.modCounter = modCounter;
        this.searchDurations = searchDurations;
        this.modDurations = modDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.runningThreads = runningThreads;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        this.remainingIterationsBeforeReconnect = iterationsBeforeReconnect > 0L ? new AtomicLong(iterationsBeforeReconnect) : null;
        connection.setConnectionName("search-and-mod-" + threadNumber);
        this.random = new Random(randomSeed);
        this.resultCode = new AtomicReference<Object>(null);
        this.searchAndModThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.searchRequest = new SearchRequest("", scope, Filter.createPresenceFilter("objectClass"), returnAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            long searchStartTime;
            this.searchAndModThread.set(SearchAndModRateThread.currentThread());
            this.runningThreads.incrementAndGet();
            Modification[] mods = new Modification[this.modAttributes.length];
            byte[] valueBytes = new byte[this.valueLength];
            ASN1OctetString[] values = new ASN1OctetString[1];
            ModifyRequest modifyRequest = new ModifyRequest("", mods);
            try {
                this.startBarrier.await();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            block21: while (!this.stopRequested.get()) {
                ProxiedAuthorizationV2RequestControl proxyControl;
                block36: {
                    if (this.iterationsBeforeReconnect > 0L && this.remainingIterationsBeforeReconnect.decrementAndGet() <= 0L) {
                        this.remainingIterationsBeforeReconnect.set(this.iterationsBeforeReconnect);
                        if (this.connection != null) {
                            this.connection.close();
                            this.connection = null;
                        }
                    }
                    if (this.connection == null) {
                        try {
                            this.connection = this.searchAndModRate.getConnection();
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.errorCounter.incrementAndGet();
                            ResultCode rc = le.getResultCode();
                            this.rcCounter.increment(rc);
                            this.resultCode.compareAndSet(null, rc);
                            if (this.fixedRateBarrier == null) continue;
                            this.fixedRateBarrier.await();
                            continue;
                        }
                    }
                    if (this.fixedRateBarrier != null) {
                        this.fixedRateBarrier.await();
                    }
                    proxyControl = null;
                    try {
                        this.searchRequest.setBaseDN(this.baseDN.nextValue());
                        this.searchRequest.setFilter(this.filter.nextValue());
                        this.searchRequest.setControls(this.searchControls);
                        if (this.authzID != null) {
                            proxyControl = new ProxiedAuthorizationV2RequestControl(this.authzID.nextValue());
                            this.searchRequest.addControl(proxyControl);
                        }
                        if (this.simplePageSize == null) break block36;
                        this.searchRequest.addControl(new SimplePagedResultsControl(this.simplePageSize));
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.errorCounter.incrementAndGet();
                        ResultCode rc = le.getResultCode();
                        this.rcCounter.increment(rc);
                        this.resultCode.compareAndSet(null, rc);
                        continue;
                    }
                }
                Object pagedResultCookie = null;
                searchStartTime = System.nanoTime();
                while (true) {
                    int i;
                    SearchResult r;
                    try {
                        r = this.connection.search(this.searchRequest);
                    }
                    catch (LDAPSearchException lse) {
                        Debug.debugException(lse);
                        this.errorCounter.incrementAndGet();
                        ResultCode rc = lse.getResultCode();
                        this.rcCounter.increment(rc);
                        this.resultCode.compareAndSet(null, rc);
                        if (!lse.getResultCode().isConnectionUsable()) {
                            this.connection.close();
                            this.connection = null;
                        }
                        this.searchCounter.incrementAndGet();
                        this.searchDurations.addAndGet(System.nanoTime() - searchStartTime);
                        continue block21;
                    }
                    for (i = 0; i < this.valueLength; ++i) {
                        valueBytes[i] = this.charSet[this.random.nextInt(this.charSet.length)];
                    }
                    values[0] = new ASN1OctetString(valueBytes);
                    for (i = 0; i < this.modAttributes.length; ++i) {
                        mods[i] = new Modification(ModificationType.REPLACE, this.modAttributes[i], values);
                    }
                    modifyRequest.setModifications(mods);
                    modifyRequest.setControls(this.modifyControls);
                    if (proxyControl != null) {
                        modifyRequest.addControl(proxyControl);
                    }
                    for (SearchResultEntry e : r.getSearchEntries()) {
                        if (this.fixedRateBarrier != null) {
                            this.fixedRateBarrier.await();
                        }
                        modifyRequest.setDN(e.getDN());
                        long modStartTime = System.nanoTime();
                        try {
                            if (this.connection == null) continue;
                            this.connection.modify(modifyRequest);
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.errorCounter.incrementAndGet();
                            ResultCode rc = le.getResultCode();
                            this.rcCounter.increment(rc);
                            this.resultCode.compareAndSet(null, rc);
                            if (le.getResultCode().isConnectionUsable()) continue;
                            this.connection.close();
                            this.connection = null;
                        }
                        finally {
                            this.modCounter.incrementAndGet();
                            this.modDurations.addAndGet(System.nanoTime() - modStartTime);
                        }
                    }
                    if (this.simplePageSize == null) break;
                    try {
                        SimplePagedResultsControl sprResponse = SimplePagedResultsControl.get(r);
                        if (sprResponse == null || !sprResponse.moreResultsToReturn()) break;
                        this.searchRequest.setControls(this.searchControls);
                        if (proxyControl != null) {
                            this.searchRequest.addControl(proxyControl);
                        }
                        if (this.simplePageSize == null) continue;
                        this.searchRequest.addControl(new SimplePagedResultsControl((int)this.simplePageSize, sprResponse.getCookie()));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        break;
                    }
                }
                this.searchCounter.incrementAndGet();
                this.searchDurations.addAndGet(System.nanoTime() - searchStartTime);
            }
            return;
            catch (Throwable throwable) {
                this.searchCounter.incrementAndGet();
                this.searchDurations.addAndGet(System.nanoTime() - searchStartTime);
                throw throwable;
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
            this.searchAndModThread.set(null);
            this.runningThreads.decrementAndGet();
        }
    }

    public ResultCode stopRunning() {
        block4: {
            Thread t;
            this.stopRequested.set(true);
            if (this.fixedRateBarrier != null) {
                this.fixedRateBarrier.shutdownRequested();
            }
            if ((t = this.searchAndModThread.get()) != null) {
                try {
                    t.join();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (!(e instanceof InterruptedException)) break block4;
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

