/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SCRAMClientFinalMessage;
import com.unboundid.ldap.sdk.SCRAMClientFirstMessage;
import com.unboundid.ldap.sdk.SCRAMServerFinalMessage;
import com.unboundid.ldap.sdk.SCRAMServerFirstMessage;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.security.MessageDigest;
import java.util.List;
import java.util.logging.Level;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class SCRAMBindRequest
extends SASLBindRequest {
    private static final long serialVersionUID = -1141722265190138366L;
    private final ASN1OctetString password;
    private final String username;

    public SCRAMBindRequest(String username, ASN1OctetString password, Control ... controls) {
        super(controls);
        Validator.ensureNotNullOrEmpty(username, "SCRAMBindRequest.username must not be null or empty");
        Validator.ensureTrue(password != null && password.getValueLength() > 0, "SCRAMBindRequest.password must not be null or empty");
        this.username = username;
        this.password = password;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPasswordString() {
        return this.password.stringValue();
    }

    public final byte[] getPasswordBytes() {
        return this.password.getValue();
    }

    protected abstract String getDigestAlgorithmName();

    protected abstract String getMACAlgorithmName();

    @Override
    protected final BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        BindResult serverFirstResult;
        SCRAMClientFirstMessage clientFirstMessage = new SCRAMClientFirstMessage(this);
        if (Debug.debugEnabled()) {
            Debug.debug(Level.INFO, DebugType.LDAP, "Sending " + this.getSASLMechanismName() + " client first message " + clientFirstMessage);
        }
        if ((serverFirstResult = this.sendBindRequest(connection, null, new ASN1OctetString(clientFirstMessage.getClientFirstMessage()), this.getControls(), this.getResponseTimeoutMillis(connection))).getResultCode() != ResultCode.SASL_BIND_IN_PROGRESS) {
            return serverFirstResult;
        }
        SCRAMServerFirstMessage serverFirstMessage = new SCRAMServerFirstMessage(this, clientFirstMessage, serverFirstResult);
        if (Debug.debugEnabled()) {
            Debug.debug(Level.INFO, DebugType.LDAP, "Received " + this.getSASLMechanismName() + " server first message " + serverFirstMessage);
        }
        SCRAMClientFinalMessage clientFinalMessage = new SCRAMClientFinalMessage(this, clientFirstMessage, serverFirstMessage);
        if (Debug.debugEnabled()) {
            Debug.debug(Level.INFO, DebugType.LDAP, "Sending " + this.getSASLMechanismName() + " client final message " + clientFinalMessage);
        }
        BindResult serverFinalResult = this.sendBindRequest(connection, null, new ASN1OctetString(clientFinalMessage.getClientFinalMessage()), this.getControls(), this.getResponseTimeoutMillis(connection));
        SCRAMServerFinalMessage serverFinalMessage = new SCRAMServerFinalMessage(this, clientFirstMessage, clientFinalMessage, serverFinalResult);
        if (Debug.debugEnabled()) {
            Debug.debug(Level.INFO, DebugType.LDAP, "Received " + this.getSASLMechanismName() + " server final message " + serverFinalMessage);
        }
        return serverFinalResult;
    }

    final byte[] mac(byte[] key, byte[] data) throws LDAPBindException {
        return this.getMac(key).doFinal(data);
    }

    final Mac getMac(byte[] key) throws LDAPBindException {
        try {
            Mac mac = Mac.getInstance(this.getMACAlgorithmName());
            SecretKeySpec macKey = new SecretKeySpec(key, this.getMACAlgorithmName());
            mac.init(macKey);
            return mac;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPBindException(new BindResult(-1, ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SCRAM_BIND_REQUEST_CANNOT_GET_MAC.get(this.getSASLMechanismName(), this.getMACAlgorithmName()), null, null, null, null));
        }
    }

    final byte[] digest(byte[] data) throws LDAPBindException {
        try {
            MessageDigest digest = MessageDigest.getInstance(this.getDigestAlgorithmName());
            return digest.digest(data);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPBindException(new BindResult(-1, ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SCRAM_BIND_REQUEST_CANNOT_GET_DIGEST.get(this.getSASLMechanismName(), this.getDigestAlgorithmName()), null, null, null, null));
        }
    }

    @Override
    public abstract SCRAMBindRequest getRebindRequest(String var1, int var2);

    @Override
    public abstract SCRAMBindRequest duplicate();

    @Override
    public abstract SCRAMBindRequest duplicate(Control[] var1);

    @Override
    public abstract void toString(StringBuilder var1);

    @Override
    public abstract void toCode(List<String> var1, String var2, int var3, boolean var4);
}

