/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.DITContentRuleDefinition;
import com.unboundid.ldap.sdk.schema.NameFormDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
public final class EntryValidator
implements Serializable {
    private static final long serialVersionUID = -8945609557086398241L;
    private final AtomicLong entriesExamined;
    private final AtomicLong entriesMissingRDNValues;
    private final AtomicLong invalidEntries;
    private final AtomicLong malformedDNs;
    private final AtomicLong missingSuperiorClasses;
    private final AtomicLong multipleStructuralClasses;
    private final AtomicLong nameFormViolations;
    private final AtomicLong noObjectClasses;
    private final AtomicLong noStructuralClass;
    private boolean checkAttributeSyntax;
    private boolean checkEntryMissingRDNValues;
    private boolean checkMalformedDNs;
    private boolean checkMissingAttributes;
    private boolean checkMissingSuperiorObjectClasses;
    private boolean checkNameForms;
    private boolean checkProhibitedAttributes;
    private boolean checkProhibitedObjectClasses;
    private boolean checkSingleValuedAttributes;
    private boolean checkStructuralObjectClasses;
    private boolean checkUndefinedAttributes;
    private boolean checkUndefinedObjectClasses;
    private final ConcurrentHashMap<String, AtomicLong> attributesViolatingSyntax;
    private final ConcurrentHashMap<String, AtomicLong> missingAttributes;
    private final ConcurrentHashMap<String, AtomicLong> prohibitedAttributes;
    private final ConcurrentHashMap<String, AtomicLong> prohibitedObjectClasses;
    private final ConcurrentHashMap<String, AtomicLong> singleValueViolations;
    private final ConcurrentHashMap<String, AtomicLong> undefinedAttributes;
    private final ConcurrentHashMap<String, AtomicLong> undefinedObjectClasses;
    private final Schema schema;
    private Set<AttributeTypeDefinition> ignoreSyntaxViolationTypes;

    public EntryValidator(Schema schema) {
        this.schema = schema;
        this.checkAttributeSyntax = true;
        this.checkEntryMissingRDNValues = true;
        this.checkMalformedDNs = true;
        this.checkMissingAttributes = true;
        this.checkMissingSuperiorObjectClasses = true;
        this.checkNameForms = true;
        this.checkProhibitedAttributes = true;
        this.checkProhibitedObjectClasses = true;
        this.checkSingleValuedAttributes = true;
        this.checkStructuralObjectClasses = true;
        this.checkUndefinedAttributes = true;
        this.checkUndefinedObjectClasses = true;
        this.ignoreSyntaxViolationTypes = Collections.emptySet();
        this.entriesExamined = new AtomicLong(0L);
        this.entriesMissingRDNValues = new AtomicLong(0L);
        this.invalidEntries = new AtomicLong(0L);
        this.malformedDNs = new AtomicLong(0L);
        this.missingSuperiorClasses = new AtomicLong(0L);
        this.multipleStructuralClasses = new AtomicLong(0L);
        this.nameFormViolations = new AtomicLong(0L);
        this.noObjectClasses = new AtomicLong(0L);
        this.noStructuralClass = new AtomicLong(0L);
        this.attributesViolatingSyntax = new ConcurrentHashMap(StaticUtils.computeMapCapacity(20));
        this.missingAttributes = new ConcurrentHashMap(StaticUtils.computeMapCapacity(20));
        this.prohibitedAttributes = new ConcurrentHashMap(StaticUtils.computeMapCapacity(20));
        this.prohibitedObjectClasses = new ConcurrentHashMap(StaticUtils.computeMapCapacity(20));
        this.singleValueViolations = new ConcurrentHashMap(StaticUtils.computeMapCapacity(20));
        this.undefinedAttributes = new ConcurrentHashMap(StaticUtils.computeMapCapacity(20));
        this.undefinedObjectClasses = new ConcurrentHashMap(StaticUtils.computeMapCapacity(20));
    }

    public boolean checkMissingAttributes() {
        return this.checkMissingAttributes;
    }

    public void setCheckMissingAttributes(boolean checkMissingAttributes) {
        this.checkMissingAttributes = checkMissingAttributes;
    }

    public boolean checkMissingSuperiorObjectClasses() {
        return this.checkMissingSuperiorObjectClasses;
    }

    public void setCheckMissingSuperiorObjectClasses(boolean checkMissingSuperiorObjectClasses) {
        this.checkMissingSuperiorObjectClasses = checkMissingSuperiorObjectClasses;
    }

    public boolean checkMalformedDNs() {
        return this.checkMalformedDNs;
    }

    public void setCheckMalformedDNs(boolean checkMalformedDNs) {
        this.checkMalformedDNs = checkMalformedDNs;
    }

    public boolean checkEntryMissingRDNValues() {
        return this.checkEntryMissingRDNValues;
    }

    public void setCheckEntryMissingRDNValues(boolean checkEntryMissingRDNValues) {
        this.checkEntryMissingRDNValues = checkEntryMissingRDNValues;
    }

    public boolean checkNameForms() {
        return this.checkNameForms;
    }

    public void setCheckNameForms(boolean checkNameForms) {
        this.checkNameForms = checkNameForms;
    }

    public boolean checkProhibitedAttributes() {
        return this.checkProhibitedAttributes;
    }

    public void setCheckProhibitedAttributes(boolean checkProhibitedAttributes) {
        this.checkProhibitedAttributes = checkProhibitedAttributes;
    }

    public boolean checkProhibitedObjectClasses() {
        return this.checkProhibitedObjectClasses;
    }

    public void setCheckProhibitedObjectClasses(boolean checkProhibitedObjectClasses) {
        this.checkProhibitedObjectClasses = checkProhibitedObjectClasses;
    }

    public boolean checkSingleValuedAttributes() {
        return this.checkSingleValuedAttributes;
    }

    public void setCheckSingleValuedAttributes(boolean checkSingleValuedAttributes) {
        this.checkSingleValuedAttributes = checkSingleValuedAttributes;
    }

    public boolean checkStructuralObjectClasses() {
        return this.checkStructuralObjectClasses;
    }

    public void setCheckStructuralObjectClasses(boolean checkStructuralObjectClasses) {
        this.checkStructuralObjectClasses = checkStructuralObjectClasses;
    }

    public boolean checkAttributeSyntax() {
        return this.checkAttributeSyntax;
    }

    public void setCheckAttributeSyntax(boolean checkAttributeSyntax) {
        this.checkAttributeSyntax = checkAttributeSyntax;
    }

    public Set<AttributeTypeDefinition> getIgnoreSyntaxViolationsAttributeTypes() {
        return this.ignoreSyntaxViolationTypes;
    }

    public void setIgnoreSyntaxViolationAttributeTypes(AttributeTypeDefinition ... attributeTypes) {
        this.ignoreSyntaxViolationTypes = attributeTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<AttributeTypeDefinition>(StaticUtils.toList(attributeTypes)));
    }

    public void setIgnoreSyntaxViolationAttributeTypes(String ... attributeTypes) {
        this.setIgnoreSyntaxViolationAttributeTypes(StaticUtils.toList(attributeTypes));
    }

    public void setIgnoreSyntaxViolationAttributeTypes(Collection<String> attributeTypes) {
        if (attributeTypes == null) {
            this.ignoreSyntaxViolationTypes = Collections.emptySet();
            return;
        }
        HashSet<AttributeTypeDefinition> atSet = new HashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(attributeTypes.size()));
        for (String s : attributeTypes) {
            AttributeTypeDefinition d = this.schema.getAttributeType(s);
            if (d == null) continue;
            atSet.add(d);
        }
        this.ignoreSyntaxViolationTypes = Collections.unmodifiableSet(atSet);
    }

    public boolean checkUndefinedAttributes() {
        return this.checkUndefinedAttributes;
    }

    public void setCheckUndefinedAttributes(boolean checkUndefinedAttributes) {
        this.checkUndefinedAttributes = checkUndefinedAttributes;
    }

    public boolean checkUndefinedObjectClasses() {
        return this.checkUndefinedObjectClasses;
    }

    public void setCheckUndefinedObjectClasses(boolean checkUndefinedObjectClasses) {
        this.checkUndefinedObjectClasses = checkUndefinedObjectClasses;
    }

    public boolean entryIsValid(Entry entry, List<String> invalidReasons) {
        boolean missingOC;
        RDN rdn;
        boolean entryValid;
        block12: {
            Validator.ensureNotNull(entry);
            entryValid = true;
            this.entriesExamined.incrementAndGet();
            rdn = null;
            try {
                rdn = entry.getParsedDN().getRDN();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (!this.checkMalformedDNs) break block12;
                entryValid = false;
                this.malformedDNs.incrementAndGet();
                if (invalidReasons == null) break block12;
                invalidReasons.add(SchemaMessages.ERR_ENTRY_MALFORMED_DN.get(StaticUtils.getExceptionMessage(le)));
            }
        }
        HashSet<ObjectClassDefinition> ocSet = new HashSet<ObjectClassDefinition>(StaticUtils.computeMapCapacity(10));
        boolean bl = missingOC = !this.getObjectClasses(entry, ocSet, invalidReasons);
        if (missingOC) {
            entryValid = false;
        }
        DITContentRuleDefinition ditContentRule = null;
        NameFormDefinition nameForm = null;
        if (!missingOC) {
            AtomicReference<Object> ref = new AtomicReference<Object>(null);
            entryValid &= this.getStructuralClass(ocSet, ref, invalidReasons);
            ObjectClassDefinition structuralClass = ref.get();
            if (structuralClass != null) {
                ditContentRule = this.schema.getDITContentRule(structuralClass.getOID());
                nameForm = this.schema.getNameFormByObjectClass(structuralClass.getNameOrOID());
            }
        }
        HashSet<AttributeTypeDefinition> requiredAttrs = null;
        if (this.checkMissingAttributes || this.checkProhibitedAttributes) {
            requiredAttrs = this.getRequiredAttributes(ocSet, ditContentRule);
            if (this.checkMissingAttributes) {
                entryValid &= this.checkForMissingAttributes(entry, rdn, requiredAttrs, invalidReasons);
            }
        }
        HashSet<AttributeTypeDefinition> optionalAttrs = null;
        if (this.checkProhibitedAttributes) {
            optionalAttrs = this.getOptionalAttributes(ocSet, ditContentRule, requiredAttrs);
        }
        for (Attribute a : entry.getAttributes()) {
            entryValid &= this.checkAttribute(a, requiredAttrs, optionalAttrs, invalidReasons);
        }
        if (this.checkProhibitedObjectClasses && ditContentRule != null) {
            entryValid &= this.checkAuxiliaryClasses(ocSet, ditContentRule, invalidReasons);
        }
        if (rdn != null) {
            entryValid &= this.checkRDN(rdn, entry, requiredAttrs, optionalAttrs, nameForm, invalidReasons);
        }
        if (!entryValid) {
            this.invalidEntries.incrementAndGet();
        }
        return entryValid;
    }

    private boolean getObjectClasses(Entry entry, HashSet<ObjectClassDefinition> ocSet, List<String> invalidReasons) {
        String[] ocValues = entry.getObjectClassValues();
        if (ocValues == null || ocValues.length == 0) {
            this.noObjectClasses.incrementAndGet();
            if (invalidReasons != null) {
                invalidReasons.add(SchemaMessages.ERR_ENTRY_NO_OCS.get());
            }
            return false;
        }
        boolean entryValid = true;
        HashSet<String> missingOCs = new HashSet<String>(StaticUtils.computeMapCapacity(ocValues.length));
        for (String ocName : entry.getObjectClassValues()) {
            ObjectClassDefinition d = this.schema.getObjectClass(ocName);
            if (d == null) {
                if (!this.checkUndefinedObjectClasses) continue;
                entryValid = false;
                missingOCs.add(StaticUtils.toLowerCase(ocName));
                EntryValidator.updateCount(ocName, this.undefinedObjectClasses);
                if (invalidReasons == null) continue;
                invalidReasons.add(SchemaMessages.ERR_ENTRY_UNDEFINED_OC.get(ocName));
                continue;
            }
            ocSet.add(d);
        }
        for (ObjectClassDefinition d : new HashSet<ObjectClassDefinition>(ocSet)) {
            entryValid &= this.addSuperiorClasses(d, ocSet, missingOCs, invalidReasons);
        }
        return entryValid;
    }

    private boolean addSuperiorClasses(ObjectClassDefinition d, HashSet<ObjectClassDefinition> ocSet, HashSet<String> missingOCNames, List<String> invalidReasons) {
        boolean entryValid = true;
        for (String ocName : d.getSuperiorClasses()) {
            ObjectClassDefinition supOC = this.schema.getObjectClass(ocName);
            if (supOC == null) {
                if (!this.checkUndefinedObjectClasses) continue;
                entryValid = false;
                String lowerName = StaticUtils.toLowerCase(ocName);
                if (missingOCNames.contains(lowerName)) continue;
                missingOCNames.add(lowerName);
                EntryValidator.updateCount(ocName, this.undefinedObjectClasses);
                if (invalidReasons == null) continue;
                invalidReasons.add(SchemaMessages.ERR_ENTRY_UNDEFINED_SUP_OC.get(d.getNameOrOID(), ocName));
                continue;
            }
            if (!ocSet.contains(supOC)) {
                ocSet.add(supOC);
                if (this.checkMissingSuperiorObjectClasses) {
                    entryValid = false;
                    this.missingSuperiorClasses.incrementAndGet();
                    if (invalidReasons != null) {
                        invalidReasons.add(SchemaMessages.ERR_ENTRY_MISSING_SUP_OC.get(supOC.getNameOrOID(), d.getNameOrOID()));
                    }
                }
            }
            entryValid &= this.addSuperiorClasses(supOC, ocSet, missingOCNames, invalidReasons);
        }
        return entryValid;
    }

    private boolean getStructuralClass(HashSet<ObjectClassDefinition> ocSet, AtomicReference<ObjectClassDefinition> structuralClass, List<String> invalidReasons) {
        HashSet<ObjectClassDefinition> ocCopy = new HashSet<ObjectClassDefinition>(ocSet);
        for (ObjectClassDefinition d : ocSet) {
            ObjectClassType t = d.getObjectClassType(this.schema);
            if (t == ObjectClassType.STRUCTURAL) {
                ocCopy.removeAll(d.getSuperiorClasses(this.schema, true));
                continue;
            }
            if (t != ObjectClassType.AUXILIARY) continue;
            ocCopy.remove(d);
            ocCopy.removeAll(d.getSuperiorClasses(this.schema, true));
        }
        boolean entryValid = true;
        Iterator<ObjectClassDefinition> iterator = ocCopy.iterator();
        while (iterator.hasNext()) {
            ObjectClassDefinition d = iterator.next();
            if (d.getObjectClassType(this.schema) != ObjectClassType.ABSTRACT) continue;
            if (this.checkProhibitedObjectClasses) {
                entryValid = false;
                EntryValidator.updateCount(d.getNameOrOID(), this.prohibitedObjectClasses);
                if (invalidReasons != null) {
                    invalidReasons.add(SchemaMessages.ERR_ENTRY_INVALID_ABSTRACT_CLASS.get(d.getNameOrOID()));
                }
            }
            iterator.remove();
        }
        switch (ocCopy.size()) {
            case 0: {
                if (!this.checkStructuralObjectClasses) break;
                entryValid = false;
                this.noStructuralClass.incrementAndGet();
                if (invalidReasons == null) break;
                invalidReasons.add(SchemaMessages.ERR_ENTRY_NO_STRUCTURAL_CLASS.get());
                break;
            }
            case 1: {
                structuralClass.set(ocCopy.iterator().next());
                break;
            }
            default: {
                if (!this.checkStructuralObjectClasses) break;
                entryValid = false;
                this.multipleStructuralClasses.incrementAndGet();
                if (invalidReasons == null) break;
                StringBuilder ocList = new StringBuilder();
                iterator = ocCopy.iterator();
                while (iterator.hasNext()) {
                    ocList.append(iterator.next().getNameOrOID());
                    if (!iterator.hasNext()) continue;
                    ocList.append(", ");
                }
                invalidReasons.add(SchemaMessages.ERR_ENTRY_MULTIPLE_STRUCTURAL_CLASSES.get(ocList));
            }
        }
        return entryValid;
    }

    private HashSet<AttributeTypeDefinition> getRequiredAttributes(HashSet<ObjectClassDefinition> ocSet, DITContentRuleDefinition ditContentRule) {
        HashSet<AttributeTypeDefinition> attrSet = new HashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(20));
        for (ObjectClassDefinition oc : ocSet) {
            attrSet.addAll(oc.getRequiredAttributes(this.schema, false));
        }
        if (ditContentRule != null) {
            for (String s : ditContentRule.getRequiredAttributes()) {
                AttributeTypeDefinition d = this.schema.getAttributeType(s);
                if (d == null) continue;
                attrSet.add(d);
            }
        }
        return attrSet;
    }

    private HashSet<AttributeTypeDefinition> getOptionalAttributes(HashSet<ObjectClassDefinition> ocSet, DITContentRuleDefinition ditContentRule, HashSet<AttributeTypeDefinition> requiredAttrSet) {
        HashSet<AttributeTypeDefinition> attrSet = new HashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(20));
        for (ObjectClassDefinition oc : ocSet) {
            if (oc.hasNameOrOID("extensibleObject") || oc.hasNameOrOID("1.3.6.1.4.1.1466.101.120.111")) {
                attrSet.addAll(this.schema.getUserAttributeTypes());
                break;
            }
            for (AttributeTypeDefinition d : oc.getOptionalAttributes(this.schema, false)) {
                if (requiredAttrSet.contains(d)) continue;
                attrSet.add(d);
            }
        }
        if (ditContentRule != null) {
            AttributeTypeDefinition d;
            for (String s : ditContentRule.getOptionalAttributes()) {
                d = this.schema.getAttributeType(s);
                if (d == null || requiredAttrSet.contains(d)) continue;
                attrSet.add(d);
            }
            for (String s : ditContentRule.getProhibitedAttributes()) {
                d = this.schema.getAttributeType(s);
                if (d == null) continue;
                attrSet.remove(d);
            }
        }
        return attrSet;
    }

    private boolean checkForMissingAttributes(Entry entry, RDN rdn, HashSet<AttributeTypeDefinition> requiredAttrs, List<String> invalidReasons) {
        boolean entryValid = true;
        for (AttributeTypeDefinition d : requiredAttrs) {
            boolean found = false;
            for (String s : d.getNames()) {
                if (!entry.hasAttribute(s) && (rdn == null || !rdn.hasAttribute(s))) continue;
                found = true;
                break;
            }
            if (found || entry.hasAttribute(d.getOID()) || rdn != null && rdn.hasAttribute(d.getOID())) continue;
            entryValid = false;
            EntryValidator.updateCount(d.getNameOrOID(), this.missingAttributes);
            if (invalidReasons == null) continue;
            invalidReasons.add(SchemaMessages.ERR_ENTRY_MISSING_REQUIRED_ATTR.get(d.getNameOrOID()));
        }
        return entryValid;
    }

    private boolean checkAttribute(Attribute attr, HashSet<AttributeTypeDefinition> requiredAttrs, HashSet<AttributeTypeDefinition> optionalAttrs, List<String> invalidReasons) {
        boolean entryValid = true;
        AttributeTypeDefinition d = this.schema.getAttributeType(attr.getBaseName());
        if (d == null) {
            if (this.checkUndefinedAttributes) {
                entryValid = false;
                EntryValidator.updateCount(attr.getBaseName(), this.undefinedAttributes);
                if (invalidReasons != null) {
                    invalidReasons.add(SchemaMessages.ERR_ENTRY_UNDEFINED_ATTR.get(attr.getBaseName()));
                }
            }
            return entryValid;
        }
        if (this.checkProhibitedAttributes && !d.isOperational() && !requiredAttrs.contains(d) && !optionalAttrs.contains(d)) {
            entryValid = false;
            EntryValidator.updateCount(d.getNameOrOID(), this.prohibitedAttributes);
            if (invalidReasons != null) {
                invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_NOT_ALLOWED.get(d.getNameOrOID()));
            }
        }
        ASN1OctetString[] rawValues = attr.getRawValues();
        if (this.checkSingleValuedAttributes && d.isSingleValued() && rawValues.length > 1) {
            entryValid = false;
            EntryValidator.updateCount(d.getNameOrOID(), this.singleValueViolations);
            if (invalidReasons != null) {
                invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_HAS_MULTIPLE_VALUES.get(d.getNameOrOID()));
            }
        }
        if (this.checkAttributeSyntax && !this.ignoreSyntaxViolationTypes.contains(d)) {
            String[] maxValueCounts;
            MatchingRule r = MatchingRule.selectEqualityMatchingRule(d.getNameOrOID(), this.schema);
            Map<String, String[]> extensions = d.getExtensions();
            for (ASN1OctetString v : rawValues) {
                String[] maxIntValues;
                block61: {
                    String[] minIntValues;
                    String[] maxValueLengths;
                    String[] minValueLengths;
                    String[] valueRegexes;
                    block60: {
                        try {
                            r.normalize(v);
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            entryValid = false;
                            EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                            if (invalidReasons == null) break block60;
                            invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_INVALID_SYNTAX.get(v.stringValue(), d.getNameOrOID(), StaticUtils.getExceptionMessage(le)));
                        }
                    }
                    String[] allowedValues = extensions.get("X-ALLOWED-VALUE");
                    if (allowedValues != null) {
                        boolean isAllowed = false;
                        for (String allowedValue : allowedValues) {
                            try {
                                if (!r.valuesMatch(v, new ASN1OctetString(allowedValue))) continue;
                                isAllowed = true;
                                break;
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                        }
                        if (!isAllowed) {
                            entryValid = false;
                            EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                            if (invalidReasons != null) {
                                invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_VALUE_NOT_ALLOWED.get(v.stringValue(), d.getNameOrOID()));
                            }
                        }
                    }
                    if ((valueRegexes = extensions.get("X-VALUE-REGEX")) != null) {
                        boolean matchesRegex = false;
                        for (String regex : valueRegexes) {
                            try {
                                Pattern pattern = Pattern.compile(regex);
                                if (!pattern.matcher(v.stringValue()).matches()) continue;
                                matchesRegex = true;
                                break;
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                        }
                        if (!matchesRegex) {
                            entryValid = false;
                            EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                            if (invalidReasons != null) {
                                invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_VALUE_NOT_ALLOWED_BY_REGEX.get(v.stringValue(), d.getNameOrOID()));
                            }
                        }
                    }
                    if ((minValueLengths = extensions.get("X-MIN-VALUE-LENGTH")) != null) {
                        int minLength = 0;
                        for (String s : minValueLengths) {
                            try {
                                minLength = Math.max(minLength, Integer.parseInt(s));
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                        }
                        if (v.stringValue().length() < minLength) {
                            entryValid = false;
                            EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                            if (invalidReasons != null) {
                                invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_VALUE_SHORTER_THAN_MIN_LENGTH.get(v.stringValue(), d.getNameOrOID(), minLength));
                            }
                        }
                    }
                    if ((maxValueLengths = extensions.get("X-MAX-VALUE-LENGTH")) != null) {
                        int maxLength = Integer.MAX_VALUE;
                        for (String s : maxValueLengths) {
                            try {
                                maxLength = Math.min(maxLength, Integer.parseInt(s));
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                        }
                        if (v.stringValue().length() > maxLength) {
                            entryValid = false;
                            EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                            if (invalidReasons != null) {
                                invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_VALUE_LONGER_THAN_MAX_LENGTH.get(v.stringValue(), d.getNameOrOID(), maxLength));
                            }
                        }
                    }
                    if ((minIntValues = extensions.get("X-MIN-INT-VALUE")) != null) {
                        try {
                            long longValue = Long.parseLong(v.stringValue());
                            long minAllowedValue = 0L;
                            for (String s : minIntValues) {
                                try {
                                    minAllowedValue = Math.max(minAllowedValue, Long.parseLong(s));
                                }
                                catch (Exception e) {
                                    Debug.debugException(e);
                                }
                            }
                            if (longValue < minAllowedValue) {
                                entryValid = false;
                                EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                                if (invalidReasons != null) {
                                    invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_VALUE_INT_TOO_SMALL.get(longValue, d.getNameOrOID(), minAllowedValue));
                                }
                            }
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            entryValid = false;
                            EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                            if (invalidReasons == null) break block61;
                            invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_VALUE_NOT_INT.get(v.stringValue(), d.getNameOrOID(), "X-MIN-INT-VALUE"));
                        }
                    }
                }
                if ((maxIntValues = extensions.get("X-MAX-INT-VALUE")) == null) continue;
                try {
                    long longValue = Long.parseLong(v.stringValue());
                    long maxAllowedValue = Long.MAX_VALUE;
                    for (String s : maxIntValues) {
                        try {
                            maxAllowedValue = Math.min(maxAllowedValue, Long.parseLong(s));
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    if (longValue <= maxAllowedValue) continue;
                    entryValid = false;
                    EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                    if (invalidReasons == null) continue;
                    invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_VALUE_INT_TOO_LARGE.get(longValue, d.getNameOrOID(), maxAllowedValue));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    entryValid = false;
                    EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                    if (invalidReasons == null) continue;
                    invalidReasons.add(SchemaMessages.ERR_ENTRY_ATTR_VALUE_NOT_INT.get(v.stringValue(), d.getNameOrOID(), "X-MAX-INT-VALUE"));
                }
            }
            String[] minValueCounts = extensions.get("X-MIN-VALUE-COUNT");
            if (minValueCounts != null) {
                int minValueCount = 0;
                for (String s : minValueCounts) {
                    try {
                        minValueCount = Math.max(minValueCount, Integer.parseInt(s));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                if (rawValues.length < minValueCount) {
                    entryValid = false;
                    EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                    if (invalidReasons != null) {
                        invalidReasons.add(SchemaMessages.ERR_ENTRY_TOO_FEW_VALUES.get(rawValues.length, d.getNameOrOID(), minValueCount));
                    }
                }
            }
            if ((maxValueCounts = extensions.get("X-MAX-VALUE-COUNT")) != null) {
                int maxValueCount = Integer.MAX_VALUE;
                for (String s : maxValueCounts) {
                    try {
                        maxValueCount = Math.min(maxValueCount, Integer.parseInt(s));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                if (rawValues.length > maxValueCount) {
                    entryValid = false;
                    EntryValidator.updateCount(d.getNameOrOID(), this.attributesViolatingSyntax);
                    if (invalidReasons != null) {
                        invalidReasons.add(SchemaMessages.ERR_ENTRY_TOO_MANY_VALUES.get(rawValues.length, d.getNameOrOID(), maxValueCount));
                    }
                }
            }
        }
        return entryValid;
    }

    private boolean checkAuxiliaryClasses(HashSet<ObjectClassDefinition> ocSet, DITContentRuleDefinition ditContentRule, List<String> invalidReasons) {
        HashSet<ObjectClassDefinition> auxSet = new HashSet<ObjectClassDefinition>(StaticUtils.computeMapCapacity(20));
        for (String s : ditContentRule.getAuxiliaryClasses()) {
            ObjectClassDefinition d = this.schema.getObjectClass(s);
            if (d == null) continue;
            auxSet.add(d);
        }
        boolean entryValid = true;
        for (ObjectClassDefinition d : ocSet) {
            ObjectClassType t = d.getObjectClassType(this.schema);
            if (t != ObjectClassType.AUXILIARY || auxSet.contains(d)) continue;
            entryValid = false;
            EntryValidator.updateCount(d.getNameOrOID(), this.prohibitedObjectClasses);
            if (invalidReasons == null) continue;
            invalidReasons.add(SchemaMessages.ERR_ENTRY_AUX_CLASS_NOT_ALLOWED.get(d.getNameOrOID()));
        }
        return entryValid;
    }

    private boolean checkRDN(RDN rdn, Entry entry, HashSet<AttributeTypeDefinition> requiredAttrs, HashSet<AttributeTypeDefinition> optionalAttrs, NameFormDefinition nameForm, List<String> invalidReasons) {
        HashSet<AttributeTypeDefinition> nfReqAttrs = new HashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(5));
        HashSet<AttributeTypeDefinition> nfAllowedAttrs = new HashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(5));
        if (nameForm != null) {
            AttributeTypeDefinition d;
            for (String s : nameForm.getRequiredAttributes()) {
                d = this.schema.getAttributeType(s);
                if (d == null) continue;
                nfReqAttrs.add(d);
            }
            nfAllowedAttrs.addAll(nfReqAttrs);
            for (String s : nameForm.getOptionalAttributes()) {
                d = this.schema.getAttributeType(s);
                if (d == null) continue;
                nfAllowedAttrs.add(d);
            }
        }
        boolean entryValid = true;
        String[] attributeNames = rdn.getAttributeNames();
        byte[][] attributeValues = rdn.getByteArrayAttributeValues();
        for (int i = 0; i < attributeNames.length; ++i) {
            AttributeTypeDefinition d;
            MatchingRule matchingRule;
            byte[] value;
            String name = attributeNames[i];
            if (this.checkEntryMissingRDNValues && !entry.hasAttributeValue(name, value = attributeValues[i], matchingRule = MatchingRule.selectEqualityMatchingRule(name, this.schema))) {
                entryValid = false;
                this.entriesMissingRDNValues.incrementAndGet();
                if (invalidReasons != null) {
                    invalidReasons.add(SchemaMessages.ERR_ENTRY_MISSING_RDN_VALUE.get(rdn.getAttributeValues()[i], name));
                }
            }
            if ((d = this.schema.getAttributeType(name)) == null) {
                if (!this.checkUndefinedAttributes) continue;
                entryValid = false;
                EntryValidator.updateCount(name, this.undefinedAttributes);
                if (invalidReasons == null) continue;
                invalidReasons.add(SchemaMessages.ERR_ENTRY_RDN_ATTR_NOT_DEFINED.get(name));
                continue;
            }
            if (this.checkProhibitedAttributes && !requiredAttrs.contains(d) && !optionalAttrs.contains(d) && !d.isOperational()) {
                entryValid = false;
                EntryValidator.updateCount(d.getNameOrOID(), this.prohibitedAttributes);
                if (invalidReasons != null) {
                    invalidReasons.add(SchemaMessages.ERR_ENTRY_RDN_ATTR_NOT_ALLOWED_IN_ENTRY.get(d.getNameOrOID()));
                }
            }
            if (!this.checkNameForms || nameForm == null || nfReqAttrs.remove(d) || nfAllowedAttrs.contains(d)) continue;
            if (entryValid) {
                entryValid = false;
                this.nameFormViolations.incrementAndGet();
            }
            if (invalidReasons == null) continue;
            invalidReasons.add(SchemaMessages.ERR_ENTRY_RDN_ATTR_NOT_ALLOWED_BY_NF.get(name));
        }
        if (this.checkNameForms && !nfReqAttrs.isEmpty()) {
            if (entryValid) {
                entryValid = false;
                this.nameFormViolations.incrementAndGet();
            }
            if (invalidReasons != null) {
                for (AttributeTypeDefinition d : nfReqAttrs) {
                    invalidReasons.add(SchemaMessages.ERR_ENTRY_RDN_MISSING_REQUIRED_ATTR.get(d.getNameOrOID()));
                }
            }
        }
        return entryValid;
    }

    private static void updateCount(String key, ConcurrentHashMap<String, AtomicLong> map) {
        String lowerKey = StaticUtils.toLowerCase(key);
        AtomicLong l = map.get(lowerKey);
        if (l == null && (l = map.putIfAbsent(lowerKey, new AtomicLong(1L))) == null) {
            return;
        }
        l.incrementAndGet();
    }

    public void resetCounts() {
        this.entriesExamined.set(0L);
        this.entriesMissingRDNValues.set(0L);
        this.invalidEntries.set(0L);
        this.malformedDNs.set(0L);
        this.missingSuperiorClasses.set(0L);
        this.multipleStructuralClasses.set(0L);
        this.nameFormViolations.set(0L);
        this.noObjectClasses.set(0L);
        this.noStructuralClass.set(0L);
        this.attributesViolatingSyntax.clear();
        this.missingAttributes.clear();
        this.prohibitedAttributes.clear();
        this.prohibitedObjectClasses.clear();
        this.singleValueViolations.clear();
        this.undefinedAttributes.clear();
        this.undefinedObjectClasses.clear();
    }

    public long getEntriesExamined() {
        return this.entriesExamined.get();
    }

    public long getInvalidEntries() {
        return this.invalidEntries.get();
    }

    public long getMalformedDNs() {
        return this.malformedDNs.get();
    }

    public long getEntriesMissingRDNValues() {
        return this.entriesMissingRDNValues.get();
    }

    public long getEntriesWithoutAnyObjectClasses() {
        return this.noObjectClasses.get();
    }

    public long getEntriesMissingStructuralObjectClass() {
        return this.noStructuralClass.get();
    }

    public long getEntriesWithMultipleStructuralObjectClasses() {
        return this.multipleStructuralClasses.get();
    }

    public long getEntriesWithMissingSuperiorObjectClasses() {
        return this.missingSuperiorClasses.get();
    }

    public long getNameFormViolations() {
        return this.nameFormViolations.get();
    }

    public long getTotalUndefinedObjectClasses() {
        return EntryValidator.getMapTotal(this.undefinedObjectClasses);
    }

    public Map<String, Long> getUndefinedObjectClasses() {
        return EntryValidator.convertMap(this.undefinedObjectClasses);
    }

    public long getTotalUndefinedAttributes() {
        return EntryValidator.getMapTotal(this.undefinedAttributes);
    }

    public Map<String, Long> getUndefinedAttributes() {
        return EntryValidator.convertMap(this.undefinedAttributes);
    }

    public long getTotalProhibitedObjectClasses() {
        return EntryValidator.getMapTotal(this.prohibitedObjectClasses);
    }

    public Map<String, Long> getProhibitedObjectClasses() {
        return EntryValidator.convertMap(this.prohibitedObjectClasses);
    }

    public long getTotalProhibitedAttributes() {
        return EntryValidator.getMapTotal(this.prohibitedAttributes);
    }

    public Map<String, Long> getProhibitedAttributes() {
        return EntryValidator.convertMap(this.prohibitedAttributes);
    }

    public long getTotalMissingAttributes() {
        return EntryValidator.getMapTotal(this.missingAttributes);
    }

    public Map<String, Long> getMissingAttributes() {
        return EntryValidator.convertMap(this.missingAttributes);
    }

    public long getTotalAttributesViolatingSyntax() {
        return EntryValidator.getMapTotal(this.attributesViolatingSyntax);
    }

    public Map<String, Long> getAttributesViolatingSyntax() {
        return EntryValidator.convertMap(this.attributesViolatingSyntax);
    }

    public long getTotalSingleValueViolations() {
        return EntryValidator.getMapTotal(this.singleValueViolations);
    }

    public Map<String, Long> getSingleValueViolations() {
        return EntryValidator.convertMap(this.singleValueViolations);
    }

    private static long getMapTotal(Map<String, AtomicLong> map) {
        long total = 0L;
        for (AtomicLong l : map.values()) {
            total += l.longValue();
        }
        return total;
    }

    private static Map<String, Long> convertMap(Map<String, AtomicLong> map) {
        TreeMap<String, Long> m = new TreeMap<String, Long>();
        for (Map.Entry<String, AtomicLong> e : map.entrySet()) {
            m.put(e.getKey(), e.getValue().longValue());
        }
        return Collections.unmodifiableMap(m);
    }

    public List<String> getInvalidEntrySummary(boolean detailedResults) {
        long numSyntaxViolations;
        long numSingleValuedViolations;
        long numProhibitedAttrs;
        long numMissingAttrs;
        long numUndefinedAttrs;
        long numMissingSuperior;
        long numProhibitedOCs;
        long numUndefinedOCs;
        long numNFViolations;
        long numMultipleStructural;
        long numMissingStructural;
        long numNoOCs;
        long numEntriesMissingRDNValues;
        long numInvalid = this.invalidEntries.get();
        if (numInvalid == 0L) {
            return Collections.emptyList();
        }
        ArrayList<String> messages = new ArrayList<String>(5);
        long numEntries = this.entriesExamined.get();
        long pct = 100L * numInvalid / numEntries;
        messages.add(SchemaMessages.INFO_ENTRY_INVALID_ENTRY_COUNT.get(numInvalid, numEntries, pct));
        long numBadDNs = this.malformedDNs.get();
        if (numBadDNs > 0L) {
            pct = 100L * numBadDNs / numEntries;
            messages.add(SchemaMessages.INFO_ENTRY_MALFORMED_DN_COUNT.get(numBadDNs, numEntries, pct));
        }
        if ((numEntriesMissingRDNValues = this.entriesMissingRDNValues.get()) > 0L) {
            pct = 100L * numEntriesMissingRDNValues / numEntries;
            messages.add(SchemaMessages.INFO_ENTRY_MISSING_RDN_VALUE_COUNT.get(numEntriesMissingRDNValues, numEntries, pct));
        }
        if ((numNoOCs = this.noObjectClasses.get()) > 0L) {
            pct = 100L * numNoOCs / numEntries;
            messages.add(SchemaMessages.INFO_ENTRY_NO_OC_COUNT.get(numNoOCs, numEntries, pct));
        }
        if ((numMissingStructural = this.noStructuralClass.get()) > 0L) {
            pct = 100L * numMissingStructural / numEntries;
            messages.add(SchemaMessages.INFO_ENTRY_NO_STRUCTURAL_OC_COUNT.get(numMissingStructural, numEntries, pct));
        }
        if ((numMultipleStructural = this.multipleStructuralClasses.get()) > 0L) {
            pct = 100L * numMultipleStructural / numEntries;
            messages.add(SchemaMessages.INFO_ENTRY_MULTIPLE_STRUCTURAL_OCS_COUNT.get(numMultipleStructural, numEntries, pct));
        }
        if ((numNFViolations = this.nameFormViolations.get()) > 0L) {
            pct = 100L * numNFViolations / numEntries;
            messages.add(SchemaMessages.INFO_ENTRY_NF_VIOLATION_COUNT.get(numNFViolations, numEntries, pct));
        }
        if ((numUndefinedOCs = this.getTotalUndefinedObjectClasses()) > 0L) {
            messages.add(SchemaMessages.INFO_ENTRY_UNDEFINED_OC_COUNT.get(numUndefinedOCs));
            if (detailedResults) {
                for (Map.Entry<String, AtomicLong> e : this.undefinedObjectClasses.entrySet()) {
                    messages.add(SchemaMessages.INFO_ENTRY_UNDEFINED_OC_NAME_COUNT.get(e.getKey(), e.getValue().longValue()));
                }
            }
        }
        if ((numProhibitedOCs = this.getTotalProhibitedObjectClasses()) > 0L) {
            messages.add(SchemaMessages.INFO_ENTRY_PROHIBITED_OC_COUNT.get(numProhibitedOCs));
            if (detailedResults) {
                for (Map.Entry<String, AtomicLong> e : this.prohibitedObjectClasses.entrySet()) {
                    messages.add(SchemaMessages.INFO_ENTRY_PROHIBITED_OC_NAME_COUNT.get(e.getKey(), e.getValue().longValue()));
                }
            }
        }
        if ((numMissingSuperior = this.getEntriesWithMissingSuperiorObjectClasses()) > 0L) {
            messages.add(SchemaMessages.INFO_ENTRY_MISSING_SUPERIOR_OC_COUNT.get(numMissingSuperior));
        }
        if ((numUndefinedAttrs = this.getTotalUndefinedAttributes()) > 0L) {
            messages.add(SchemaMessages.INFO_ENTRY_UNDEFINED_ATTR_COUNT.get(numUndefinedAttrs));
            if (detailedResults) {
                for (Map.Entry<String, AtomicLong> e : this.undefinedAttributes.entrySet()) {
                    messages.add(SchemaMessages.INFO_ENTRY_UNDEFINED_ATTR_NAME_COUNT.get(e.getKey(), e.getValue().longValue()));
                }
            }
        }
        if ((numMissingAttrs = this.getTotalMissingAttributes()) > 0L) {
            messages.add(SchemaMessages.INFO_ENTRY_MISSING_ATTR_COUNT.get(numMissingAttrs));
            if (detailedResults) {
                for (Map.Entry<String, AtomicLong> e : this.missingAttributes.entrySet()) {
                    messages.add(SchemaMessages.INFO_ENTRY_MISSING_ATTR_NAME_COUNT.get(e.getKey(), e.getValue().longValue()));
                }
            }
        }
        if ((numProhibitedAttrs = this.getTotalProhibitedAttributes()) > 0L) {
            messages.add(SchemaMessages.INFO_ENTRY_PROHIBITED_ATTR_COUNT.get(numProhibitedAttrs));
            if (detailedResults) {
                for (Map.Entry<String, AtomicLong> e : this.prohibitedAttributes.entrySet()) {
                    messages.add(SchemaMessages.INFO_ENTRY_PROHIBITED_ATTR_NAME_COUNT.get(e.getKey(), e.getValue().longValue()));
                }
            }
        }
        if ((numSingleValuedViolations = this.getTotalSingleValueViolations()) > 0L) {
            messages.add(SchemaMessages.INFO_ENTRY_SINGLE_VALUE_VIOLATION_COUNT.get(numSingleValuedViolations));
            if (detailedResults) {
                for (Map.Entry<String, AtomicLong> e : this.singleValueViolations.entrySet()) {
                    messages.add(SchemaMessages.INFO_ENTRY_SINGLE_VALUE_VIOLATION_NAME_COUNT.get(e.getKey(), e.getValue().longValue()));
                }
            }
        }
        if ((numSyntaxViolations = this.getTotalAttributesViolatingSyntax()) > 0L) {
            messages.add(SchemaMessages.INFO_ENTRY_SYNTAX_VIOLATION_COUNT.get(numSyntaxViolations));
            if (detailedResults) {
                for (Map.Entry<String, AtomicLong> e : this.attributesViolatingSyntax.entrySet()) {
                    messages.add(SchemaMessages.INFO_ENTRY_SYNTAX_VIOLATION_NAME_COUNT.get(e.getKey(), e.getValue().longValue()));
                }
            }
        }
        return Collections.unmodifiableList(messages);
    }
}

