/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.Base64PasswordEncoderOutputFormatter;
import com.unboundid.ldap.listener.ClearInMemoryPasswordEncoder;
import com.unboundid.ldap.listener.HexPasswordEncoderOutputFormatter;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerExceptionHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.listener.SaltedMessageDigestInMemoryPasswordEncoder;
import com.unboundid.ldap.listener.SelfSignedCertificateGenerator;
import com.unboundid.ldap.listener.UnsaltedMessageDigestInMemoryPasswordEncoder;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.MinimalLogFormatter;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import com.unboundid.util.ssl.cert.CertException;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.StreamHandler;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class InMemoryDirectoryServerTool
extends CommandLineTool
implements Serializable,
LDAPListenerExceptionHandler {
    private static final long serialVersionUID = 6484637038039050412L;
    private BooleanArgument accessLogToStandardOutArgument = null;
    private BooleanArgument dontStartArgument = null;
    private BooleanArgument generateSelfSignedCertificateArgument = null;
    private BooleanArgument ldapDebugLogToStandardOutArgument = null;
    private BooleanArgument useDefaultSchemaArgument = null;
    private BooleanArgument useSSLArgument = null;
    private BooleanArgument useStartTLSArgument = null;
    private DNArgument additionalBindDNArgument = null;
    private DNArgument baseDNArgument = null;
    private FileArgument accessLogFileArgument = null;
    private FileArgument codeLogFile;
    private FileArgument keyStorePathArgument = null;
    private FileArgument ldapDebugLogFileArgument = null;
    private FileArgument ldifFileArgument = null;
    private FileArgument trustStorePathArgument = null;
    private FileArgument useSchemaFileArgument = null;
    private InMemoryDirectoryServer directoryServer = null;
    private IntegerArgument maxChangeLogEntriesArgument = null;
    private IntegerArgument maxConcurrentConnectionsArgument = null;
    private IntegerArgument portArgument = null;
    private IntegerArgument sizeLimitArgument = null;
    private StringArgument additionalBindPasswordArgument = null;
    private StringArgument allowedOperationTypeArgument = null;
    private StringArgument authenticationRequiredOperationTypeArgument = null;
    private StringArgument defaultPasswordEncodingArgument = null;
    private StringArgument equalityIndexArgument = null;
    private StringArgument keyStorePasswordArgument = null;
    private StringArgument keyStoreTypeArgument = null;
    private StringArgument passwordAttributeArgument = null;
    private StringArgument trustStorePasswordArgument = null;
    private StringArgument trustStoreTypeArgument = null;
    private StringArgument vendorNameArgument = null;
    private StringArgument vendorVersionArgument = null;

    public static void main(String ... args) {
        ResultCode resultCode = InMemoryDirectoryServerTool.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        InMemoryDirectoryServerTool tool = new InMemoryDirectoryServerTool(outStream, errStream);
        return tool.runTool(args);
    }

    public InMemoryDirectoryServerTool(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "in-memory-directory-server";
    }

    @Override
    public String getToolDescription() {
        return ListenerMessages.INFO_MEM_DS_TOOL_DESC.get(InMemoryDirectoryServer.class.getName());
    }

    @Override
    public String getToolVersion() {
        return "4.0.13";
    }

    @Override
    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.portArgument = new IntegerArgument(Character.valueOf('p'), "port", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PORT.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_PORT.get(), 0, 65535);
        this.portArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        parser.addArgument(this.portArgument);
        this.useSSLArgument = new BooleanArgument(Character.valueOf('Z'), "useSSL", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_USE_SSL.get());
        this.useSSLArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.useSSLArgument.addLongIdentifier("use-ssl", true);
        parser.addArgument(this.useSSLArgument);
        this.useStartTLSArgument = new BooleanArgument(Character.valueOf('q'), "useStartTLS", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_USE_START_TLS.get());
        this.useStartTLSArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.useStartTLSArgument.addLongIdentifier("use-starttls", true);
        this.useStartTLSArgument.addLongIdentifier("use-start-tls", true);
        parser.addArgument(this.useStartTLSArgument);
        this.keyStorePathArgument = new FileArgument(Character.valueOf('K'), "keyStorePath", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_KEY_STORE_PATH.get(), true, true, true, false);
        this.keyStorePathArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.keyStorePathArgument.addLongIdentifier("key-store-path", true);
        parser.addArgument(this.keyStorePathArgument);
        this.keyStorePasswordArgument = new StringArgument(Character.valueOf('W'), "keyStorePassword", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PASSWORD.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_KEY_STORE_PW.get());
        this.keyStorePasswordArgument.setSensitive(true);
        this.keyStorePasswordArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.keyStorePasswordArgument.addLongIdentifier("keyStorePIN", true);
        this.keyStorePasswordArgument.addLongIdentifier("key-store-password", true);
        this.keyStorePasswordArgument.addLongIdentifier("key-store-pin", true);
        parser.addArgument(this.keyStorePasswordArgument);
        this.keyStoreTypeArgument = new StringArgument(null, "keyStoreType", false, 1, "{type}", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_KEY_STORE_TYPE.get(), "JKS");
        this.keyStoreTypeArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.keyStoreTypeArgument.addLongIdentifier("keyStoreFormat", true);
        this.keyStoreTypeArgument.addLongIdentifier("key-store-type", true);
        this.keyStoreTypeArgument.addLongIdentifier("key-store-format", true);
        parser.addArgument(this.keyStoreTypeArgument);
        this.generateSelfSignedCertificateArgument = new BooleanArgument(null, "generateSelfSignedCertificate", 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_SELF_SIGNED_CERT.get());
        this.generateSelfSignedCertificateArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.generateSelfSignedCertificateArgument.addLongIdentifier("useSelfSignedCertificate", true);
        this.generateSelfSignedCertificateArgument.addLongIdentifier("selfSignedCertificate", true);
        this.generateSelfSignedCertificateArgument.addLongIdentifier("generate-self-signed-certificate", true);
        this.generateSelfSignedCertificateArgument.addLongIdentifier("use-self-signed-certificate", true);
        this.generateSelfSignedCertificateArgument.addLongIdentifier("self-signed-certificate", true);
        parser.addArgument(this.generateSelfSignedCertificateArgument);
        this.trustStorePathArgument = new FileArgument(Character.valueOf('P'), "trustStorePath", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_TRUST_STORE_PATH.get(), true, true, true, false);
        this.trustStorePathArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.trustStorePathArgument.addLongIdentifier("trust-store-path", true);
        parser.addArgument(this.trustStorePathArgument);
        this.trustStorePasswordArgument = new StringArgument(Character.valueOf('T'), "trustStorePassword", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PASSWORD.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_TRUST_STORE_PW.get());
        this.trustStorePasswordArgument.setSensitive(true);
        this.trustStorePasswordArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.trustStorePasswordArgument.addLongIdentifier("trustStorePIN", true);
        this.trustStorePasswordArgument.addLongIdentifier("trust-store-password", true);
        this.trustStorePasswordArgument.addLongIdentifier("trust-store-pin", true);
        parser.addArgument(this.trustStorePasswordArgument);
        this.trustStoreTypeArgument = new StringArgument(null, "trustStoreType", false, 1, "{type}", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_TRUST_STORE_TYPE.get(), "JKS");
        this.trustStoreTypeArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.trustStoreTypeArgument.addLongIdentifier("trustStoreFormat", true);
        this.trustStoreTypeArgument.addLongIdentifier("trust-store-type", true);
        this.trustStoreTypeArgument.addLongIdentifier("trust-store-format", true);
        parser.addArgument(this.trustStoreTypeArgument);
        this.maxConcurrentConnectionsArgument = new IntegerArgument(null, "maxConcurrentConnections", false, 1, null, ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_MAX_CONNECTIONS.get(), 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.maxConcurrentConnectionsArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.maxConcurrentConnectionsArgument.addLongIdentifier("maximumConcurrentConnections", true);
        this.maxConcurrentConnectionsArgument.addLongIdentifier("maxConnections", true);
        this.maxConcurrentConnectionsArgument.addLongIdentifier("maximumConnections", true);
        this.maxConcurrentConnectionsArgument.addLongIdentifier("max-concurrent-connections", true);
        this.maxConcurrentConnectionsArgument.addLongIdentifier("maximum-concurrent-connections", true);
        this.maxConcurrentConnectionsArgument.addLongIdentifier("max-connections", true);
        this.maxConcurrentConnectionsArgument.addLongIdentifier("maximum-connections", true);
        parser.addArgument(this.maxConcurrentConnectionsArgument);
        this.dontStartArgument = new BooleanArgument(null, "dontStart", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_DONT_START.get());
        this.dontStartArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_CONNECTIVITY.get());
        this.dontStartArgument.setHidden(true);
        this.dontStartArgument.addLongIdentifier("doNotStart", true);
        this.dontStartArgument.addLongIdentifier("dont-start", true);
        this.dontStartArgument.addLongIdentifier("do-not-start", true);
        parser.addArgument(this.dontStartArgument);
        this.baseDNArgument = new DNArgument(Character.valueOf('b'), "baseDN", true, 0, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_BASE_DN.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_BASE_DN.get());
        this.baseDNArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.baseDNArgument.addLongIdentifier("base-dn", true);
        parser.addArgument(this.baseDNArgument);
        this.ldifFileArgument = new FileArgument(Character.valueOf('l'), "ldifFile", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_LDIF_FILE.get(), true, true, true, false);
        this.ldifFileArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.ldifFileArgument.addLongIdentifier("ldif-file", true);
        parser.addArgument(this.ldifFileArgument);
        this.additionalBindDNArgument = new DNArgument(Character.valueOf('D'), "additionalBindDN", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_BIND_DN.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ADDITIONAL_BIND_DN.get());
        this.additionalBindDNArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.additionalBindDNArgument.addLongIdentifier("additional-bind-dn", true);
        parser.addArgument(this.additionalBindDNArgument);
        this.additionalBindPasswordArgument = new StringArgument(Character.valueOf('w'), "additionalBindPassword", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PASSWORD.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ADDITIONAL_BIND_PW.get());
        this.additionalBindPasswordArgument.setSensitive(true);
        this.additionalBindPasswordArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.additionalBindPasswordArgument.addLongIdentifier("additional-bind-password", true);
        parser.addArgument(this.additionalBindPasswordArgument);
        this.useDefaultSchemaArgument = new BooleanArgument(Character.valueOf('s'), "useDefaultSchema", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_USE_DEFAULT_SCHEMA.get());
        this.useDefaultSchemaArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.useDefaultSchemaArgument.addLongIdentifier("use-default-schema", true);
        parser.addArgument(this.useDefaultSchemaArgument);
        this.useSchemaFileArgument = new FileArgument(Character.valueOf('S'), "useSchemaFile", false, 0, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_USE_SCHEMA_FILE.get(), true, true, false, false);
        this.useSchemaFileArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.useSchemaFileArgument.addLongIdentifier("use-schema-file", true);
        parser.addArgument(this.useSchemaFileArgument);
        this.equalityIndexArgument = new StringArgument(Character.valueOf('I'), "equalityIndex", false, 0, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_ATTR.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_EQ_INDEX.get());
        this.equalityIndexArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.equalityIndexArgument.addLongIdentifier("equality-index", true);
        parser.addArgument(this.equalityIndexArgument);
        this.maxChangeLogEntriesArgument = new IntegerArgument(Character.valueOf('c'), "maxChangeLogEntries", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_COUNT.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_MAX_CHANGELOG_ENTRIES.get(), 0, Integer.MAX_VALUE, 0);
        this.maxChangeLogEntriesArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.maxChangeLogEntriesArgument.addLongIdentifier("max-changelog-entries", true);
        this.maxChangeLogEntriesArgument.addLongIdentifier("max-change-log-entries", true);
        parser.addArgument(this.maxChangeLogEntriesArgument);
        this.sizeLimitArgument = new IntegerArgument(null, "sizeLimit", false, 1, null, ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_SIZE_LIMIT.get(), 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.sizeLimitArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.sizeLimitArgument.addLongIdentifier("searchSizeLimit", true);
        this.sizeLimitArgument.addLongIdentifier("size-limit", true);
        this.sizeLimitArgument.addLongIdentifier("search-size-limit", true);
        parser.addArgument(this.sizeLimitArgument);
        this.passwordAttributeArgument = new StringArgument(null, "passwordAttribute", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_ATTR.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_PASSWORD_ATTRIBUTE.get(), "userPassword");
        this.passwordAttributeArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.passwordAttributeArgument.addLongIdentifier("passwordAttributeType", true);
        this.passwordAttributeArgument.addLongIdentifier("password-attribute", true);
        this.passwordAttributeArgument.addLongIdentifier("password-attribute-type", true);
        parser.addArgument(this.passwordAttributeArgument);
        Set<String> allowedSchemes = StaticUtils.setOf("md5", "smd5", "sha", "ssha", "sha256", "ssha256", "sha384", "ssha384", "sha512", "ssha512", "clear", "base64", "hex");
        this.defaultPasswordEncodingArgument = new StringArgument(null, "defaultPasswordEncoding", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_SCHEME.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_DEFAULT_PASSWORD_ENCODING.get(), allowedSchemes);
        this.defaultPasswordEncodingArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.defaultPasswordEncodingArgument.addLongIdentifier("defaultPasswordEncodingScheme", true);
        this.defaultPasswordEncodingArgument.addLongIdentifier("defaultPasswordStorageScheme", true);
        this.defaultPasswordEncodingArgument.addLongIdentifier("defaultPasswordScheme", true);
        this.defaultPasswordEncodingArgument.addLongIdentifier("default-password-encoding", true);
        this.defaultPasswordEncodingArgument.addLongIdentifier("default-password-encoding-scheme", true);
        this.defaultPasswordEncodingArgument.addLongIdentifier("default-password-storage-scheme", true);
        this.defaultPasswordEncodingArgument.addLongIdentifier("default-password-scheme", true);
        parser.addArgument(this.defaultPasswordEncodingArgument);
        Set<String> allowedOperationTypeAllowedValues = StaticUtils.setOf("add", "bind", "compare", "delete", "extended", "modify", "modify-dn", "search");
        this.allowedOperationTypeArgument = new StringArgument(null, "allowedOperationType", false, 0, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_TYPE.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ALLOWED_OP_TYPE.get(), allowedOperationTypeAllowedValues);
        this.allowedOperationTypeArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.allowedOperationTypeArgument.addLongIdentifier("allowed-operation-type", true);
        parser.addArgument(this.allowedOperationTypeArgument);
        Set<String> authRequiredTypeAllowedValues = StaticUtils.setOf("add", "compare", "delete", "extended", "modify", "modify-dn", "search");
        this.authenticationRequiredOperationTypeArgument = new StringArgument(null, "authenticationRequiredOperationType", false, 0, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_TYPE.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_AUTH_REQUIRED_OP_TYPE.get(), authRequiredTypeAllowedValues);
        this.authenticationRequiredOperationTypeArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.authenticationRequiredOperationTypeArgument.addLongIdentifier("requiredAuthenticationOperationType", true);
        this.authenticationRequiredOperationTypeArgument.addLongIdentifier("requireAuthenticationOperationType", true);
        this.authenticationRequiredOperationTypeArgument.addLongIdentifier("authentication-required-operation-type", true);
        this.authenticationRequiredOperationTypeArgument.addLongIdentifier("required-authentication-operation-type", true);
        this.authenticationRequiredOperationTypeArgument.addLongIdentifier("require-authentication-operation-type", true);
        parser.addArgument(this.authenticationRequiredOperationTypeArgument);
        this.vendorNameArgument = new StringArgument(null, "vendorName", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_VALUE.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_VENDOR_NAME.get());
        this.vendorNameArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.vendorNameArgument.addLongIdentifier("vendor-name", true);
        parser.addArgument(this.vendorNameArgument);
        this.vendorVersionArgument = new StringArgument(null, "vendorVersion", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_VALUE.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_VENDOR_VERSION.get());
        this.vendorVersionArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_DATA.get());
        this.vendorVersionArgument.addLongIdentifier("vendor-version", true);
        parser.addArgument(this.vendorVersionArgument);
        this.accessLogToStandardOutArgument = new BooleanArgument(Character.valueOf('A'), "accessLogToStandardOut", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ACCESS_LOG_TO_STDOUT.get());
        this.accessLogToStandardOutArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_LOGGING.get());
        this.accessLogToStandardOutArgument.addLongIdentifier("access-log-to-standard-out", true);
        parser.addArgument(this.accessLogToStandardOutArgument);
        this.accessLogFileArgument = new FileArgument(Character.valueOf('a'), "accessLogFile", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ACCESS_LOG_FILE.get(), false, true, true, false);
        this.accessLogFileArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_LOGGING.get());
        this.accessLogFileArgument.addLongIdentifier("access-log-format", true);
        parser.addArgument(this.accessLogFileArgument);
        this.ldapDebugLogToStandardOutArgument = new BooleanArgument(null, "ldapDebugLogToStandardOut", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_LDAP_DEBUG_LOG_TO_STDOUT.get());
        this.ldapDebugLogToStandardOutArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_LOGGING.get());
        this.ldapDebugLogToStandardOutArgument.addLongIdentifier("ldap-debug-log-to-standard-out", true);
        parser.addArgument(this.ldapDebugLogToStandardOutArgument);
        this.ldapDebugLogFileArgument = new FileArgument(Character.valueOf('d'), "ldapDebugLogFile", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_LDAP_DEBUG_LOG_FILE.get(), false, true, true, false);
        this.ldapDebugLogFileArgument.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_LOGGING.get());
        this.ldapDebugLogFileArgument.addLongIdentifier("ldap-debug-log-file", true);
        parser.addArgument(this.ldapDebugLogFileArgument);
        this.codeLogFile = new FileArgument(Character.valueOf('C'), "codeLogFile", false, 1, "{path}", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_CODE_LOG_FILE.get(), false, true, true, false);
        this.codeLogFile.setArgumentGroupName(ListenerMessages.INFO_MEM_DS_TOOL_GROUP_LOGGING.get());
        this.codeLogFile.addLongIdentifier("code-log-file", true);
        parser.addArgument(this.codeLogFile);
        parser.addExclusiveArgumentSet(this.useDefaultSchemaArgument, this.useSchemaFileArgument, new Argument[0]);
        parser.addExclusiveArgumentSet(this.useSSLArgument, this.useStartTLSArgument, new Argument[0]);
        parser.addExclusiveArgumentSet(this.keyStorePathArgument, this.generateSelfSignedCertificateArgument, new Argument[0]);
        parser.addExclusiveArgumentSet(this.accessLogToStandardOutArgument, this.accessLogFileArgument, new Argument[0]);
        parser.addExclusiveArgumentSet(this.ldapDebugLogToStandardOutArgument, this.ldapDebugLogFileArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.additionalBindDNArgument, this.additionalBindPasswordArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.additionalBindPasswordArgument, this.additionalBindDNArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.useSSLArgument, this.keyStorePathArgument, this.generateSelfSignedCertificateArgument);
        parser.addDependentArgumentSet(this.keyStorePathArgument, this.keyStorePasswordArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.keyStorePasswordArgument, this.keyStorePathArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.keyStoreTypeArgument, this.keyStorePathArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.useStartTLSArgument, this.keyStorePathArgument, this.generateSelfSignedCertificateArgument);
        parser.addDependentArgumentSet(this.keyStorePathArgument, this.useSSLArgument, this.useStartTLSArgument);
        parser.addDependentArgumentSet(this.generateSelfSignedCertificateArgument, this.useSSLArgument, this.useStartTLSArgument);
        parser.addDependentArgumentSet(this.trustStorePathArgument, this.useSSLArgument, this.useStartTLSArgument);
        parser.addDependentArgumentSet(this.trustStorePasswordArgument, this.trustStorePathArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.trustStoreTypeArgument, this.trustStorePathArgument, new Argument[0]);
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    public ResultCode doToolProcessing() {
        InMemoryDirectoryServerConfig serverConfig;
        try {
            serverConfig = this.getConfig();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_INITIALIZING_CONFIG.get(le.getMessage()));
            return le.getResultCode();
        }
        try {
            this.directoryServer = new InMemoryDirectoryServer(serverConfig);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_CREATING_SERVER_INSTANCE.get(le.getMessage()));
            return le.getResultCode();
        }
        if (this.ldifFileArgument.isPresent()) {
            File ldifFile = this.ldifFileArgument.getValue();
            try {
                int numEntries = this.directoryServer.importFromLDIF(true, ldifFile.getAbsolutePath());
                this.out(ListenerMessages.INFO_MEM_DS_TOOL_ADDED_ENTRIES_FROM_LDIF.get(numEntries, ldifFile.getAbsolutePath()));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_POPULATING_SERVER_INSTANCE.get(ldifFile.getAbsolutePath(), le.getMessage()));
                return le.getResultCode();
            }
        }
        try {
            if (!this.dontStartArgument.isPresent()) {
                this.directoryServer.startListening();
                this.out(ListenerMessages.INFO_MEM_DS_TOOL_LISTENING.get(this.directoryServer.getListenPort()));
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_STARTING_SERVER.get(StaticUtils.getExceptionMessage(e)));
            return ResultCode.LOCAL_ERROR;
        }
        return ResultCode.SUCCESS;
    }

    private InMemoryDirectoryServerConfig getConfig() throws LDAPException {
        FileHandler handler;
        File logFile;
        StreamHandler handler2;
        EnumSet<OperationType> operationTypes;
        InMemoryPasswordEncoder primaryEncoder;
        List<DN> dnList = this.baseDNArgument.getValues();
        DN[] baseDNs = new DN[dnList.size()];
        dnList.toArray(baseDNs);
        InMemoryDirectoryServerConfig serverConfig = new InMemoryDirectoryServerConfig(baseDNs);
        int listenPort = 0;
        if (this.portArgument.isPresent()) {
            listenPort = this.portArgument.getValue();
        }
        if (this.useDefaultSchemaArgument.isPresent()) {
            serverConfig.setSchema(Schema.getDefaultStandardSchema());
        } else {
            if (this.useSchemaFileArgument.isPresent()) {
                ArrayList<File> schemaFiles = new ArrayList<File>(10);
                for (File f : this.useSchemaFileArgument.getValues()) {
                    if (f.exists()) {
                        if (f.isFile()) {
                            schemaFiles.add(f);
                            continue;
                        }
                        for (File subFile : f.listFiles()) {
                            if (!subFile.isFile()) continue;
                            schemaFiles.add(subFile);
                        }
                        continue;
                    }
                    throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_NO_SUCH_SCHEMA_FILE.get(f.getAbsolutePath()));
                }
                try {
                    serverConfig.setSchema(Schema.getSchema(schemaFiles));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    StringBuilder fileList = new StringBuilder();
                    Iterator<File> fileIterator = schemaFiles.iterator();
                    while (fileIterator.hasNext()) {
                        fileList.append(fileIterator.next().getAbsolutePath());
                        if (!fileIterator.hasNext()) continue;
                        fileList.append(", ");
                    }
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_ERROR_READING_SCHEMA.get(fileList, StaticUtils.getExceptionMessage(e)), e);
                }
            }
            serverConfig.setSchema(null);
        }
        if (this.additionalBindDNArgument.isPresent()) {
            serverConfig.addAdditionalBindCredentials(this.additionalBindDNArgument.getValue().toString(), this.additionalBindPasswordArgument.getValue());
        }
        if (this.maxChangeLogEntriesArgument.isPresent()) {
            serverConfig.setMaxChangeLogEntries(this.maxChangeLogEntriesArgument.getValue());
        }
        if (this.maxConcurrentConnectionsArgument.isPresent()) {
            serverConfig.setMaxConnections(this.maxConcurrentConnectionsArgument.getValue());
        }
        if (this.sizeLimitArgument.isPresent()) {
            serverConfig.setMaxSizeLimit(this.sizeLimitArgument.getValue());
        }
        if (this.passwordAttributeArgument.isPresent()) {
            serverConfig.setPasswordAttributes(this.passwordAttributeArgument.getValues());
        }
        LinkedHashMap<String, InMemoryPasswordEncoder> passwordEncoders = new LinkedHashMap<String, InMemoryPasswordEncoder>(10);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("MD5", "MD5", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA", "SHA-1", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA1", "SHA-1", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA-1", "SHA-1", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA256", "SHA-256", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA-256", "SHA-256", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA384", "SHA-384", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA-384", "SHA-384", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA512", "SHA-512", passwordEncoders);
        InMemoryDirectoryServerTool.addUnsaltedEncoder("SHA-512", "SHA-512", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SMD5", "MD5", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA", "SHA-1", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA1", "SHA-1", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA-1", "SHA-1", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA256", "SHA-256", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA-256", "SHA-256", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA384", "SHA-384", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA-384", "SHA-384", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA512", "SHA-512", passwordEncoders);
        InMemoryDirectoryServerTool.addSaltedEncoder("SSHA-512", "SHA-512", passwordEncoders);
        InMemoryDirectoryServerTool.addClearEncoder("CLEAR", null, passwordEncoders);
        InMemoryDirectoryServerTool.addClearEncoder("BASE64", Base64PasswordEncoderOutputFormatter.getInstance(), passwordEncoders);
        InMemoryDirectoryServerTool.addClearEncoder("HEX", HexPasswordEncoderOutputFormatter.getLowercaseInstance(), passwordEncoders);
        if (this.defaultPasswordEncodingArgument.isPresent()) {
            primaryEncoder = (InMemoryPasswordEncoder)passwordEncoders.remove(StaticUtils.toLowerCase(this.defaultPasswordEncodingArgument.getValue()));
            if (primaryEncoder == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_UNAVAILABLE_PW_ENCODING.get(this.defaultPasswordEncodingArgument.getValue(), String.valueOf(passwordEncoders.keySet())));
            }
        } else {
            primaryEncoder = null;
        }
        serverConfig.setPasswordEncoders(primaryEncoder, passwordEncoders.values());
        if (this.allowedOperationTypeArgument.isPresent()) {
            operationTypes = EnumSet.noneOf(OperationType.class);
            block19: for (String operationTypeName : this.allowedOperationTypeArgument.getValues()) {
                OperationType name = OperationType.forName(operationTypeName);
                if (name == null) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_UNSUPPORTED_ALLOWED_OP_TYPE.get(new Object[]{name}));
                }
                switch (name) {
                    case ADD: 
                    case BIND: 
                    case COMPARE: 
                    case DELETE: 
                    case EXTENDED: 
                    case MODIFY: 
                    case MODIFY_DN: 
                    case SEARCH: {
                        operationTypes.add(name);
                        continue block19;
                    }
                }
                throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_UNSUPPORTED_ALLOWED_OP_TYPE.get(new Object[]{name}));
            }
            serverConfig.setAllowedOperationTypes(operationTypes);
        }
        if (this.authenticationRequiredOperationTypeArgument.isPresent()) {
            operationTypes = EnumSet.noneOf(OperationType.class);
            block20: for (String operationTypeName : this.authenticationRequiredOperationTypeArgument.getValues()) {
                OperationType name = OperationType.forName(operationTypeName);
                if (name == null) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_UNSUPPORTED_AUTH_REQUIRED_OP_TYPE.get(new Object[]{name}));
                }
                switch (name) {
                    case ADD: 
                    case COMPARE: 
                    case DELETE: 
                    case EXTENDED: 
                    case MODIFY: 
                    case MODIFY_DN: 
                    case SEARCH: {
                        operationTypes.add(name);
                        continue block20;
                    }
                }
                throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_UNSUPPORTED_AUTH_REQUIRED_OP_TYPE.get(new Object[]{name}));
            }
            serverConfig.setAuthenticationRequiredOperationTypes(operationTypes);
        }
        if (this.accessLogToStandardOutArgument.isPresent()) {
            handler2 = new StreamHandler(System.out, new MinimalLogFormatter(null, false, false, true));
            StaticUtils.setLogHandlerLevel(handler2, Level.INFO);
            serverConfig.setAccessLogHandler(handler2);
        } else if (this.accessLogFileArgument.isPresent()) {
            logFile = this.accessLogFileArgument.getValue();
            try {
                handler = new FileHandler(logFile.getAbsolutePath(), true);
                StaticUtils.setLogHandlerLevel(handler, Level.INFO);
                handler.setFormatter(new MinimalLogFormatter(null, false, false, true));
                serverConfig.setAccessLogHandler(handler);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_ERROR_CREATING_LOG_HANDLER.get(logFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.ldapDebugLogToStandardOutArgument.isPresent()) {
            handler2 = new StreamHandler(System.out, new MinimalLogFormatter(null, false, false, true));
            StaticUtils.setLogHandlerLevel(handler2, Level.INFO);
            serverConfig.setLDAPDebugLogHandler(handler2);
        } else if (this.ldapDebugLogFileArgument.isPresent()) {
            logFile = this.ldapDebugLogFileArgument.getValue();
            try {
                handler = new FileHandler(logFile.getAbsolutePath(), true);
                StaticUtils.setLogHandlerLevel(handler, Level.INFO);
                handler.setFormatter(new MinimalLogFormatter(null, false, false, true));
                serverConfig.setLDAPDebugLogHandler(handler);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_ERROR_CREATING_LOG_HANDLER.get(logFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.codeLogFile.isPresent()) {
            serverConfig.setCodeLogDetails(this.codeLogFile.getValue().getAbsolutePath(), true);
        }
        if (this.useSSLArgument.isPresent() || this.useStartTLSArgument.isPresent()) {
            String keyStoreType;
            char[] keyStorePIN;
            File keyStorePath;
            if (this.keyStorePathArgument.isPresent()) {
                keyStorePath = this.keyStorePathArgument.getValue();
                keyStorePIN = this.keyStorePasswordArgument.getValue().toCharArray();
                keyStoreType = this.keyStoreTypeArgument.getValue();
            } else {
                try {
                    keyStoreType = "JKS";
                    ObjectPair<File, char[]> keyStoreInfo = SelfSignedCertificateGenerator.generateTemporarySelfSignedCertificate(this.getToolName(), keyStoreType);
                    keyStorePath = keyStoreInfo.getFirst();
                    keyStorePIN = keyStoreInfo.getSecond();
                }
                catch (CertException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, e.getMessage(), e);
                }
            }
            try {
                X509TrustManager trustManager;
                KeyStoreKeyManager keyManager = new KeyStoreKeyManager(keyStorePath, keyStorePIN, keyStoreType, null);
                if (this.trustStorePathArgument.isPresent()) {
                    char[] password = this.trustStorePasswordArgument.isPresent() ? this.trustStorePasswordArgument.getValue().toCharArray() : null;
                    trustManager = new TrustStoreTrustManager(this.trustStorePathArgument.getValue(), password, this.trustStoreTypeArgument.getValue(), true);
                } else {
                    trustManager = new TrustAllTrustManager();
                }
                SSLUtil serverSSLUtil = new SSLUtil(keyManager, trustManager);
                if (this.useSSLArgument.isPresent()) {
                    SSLUtil clientSSLUtil = new SSLUtil(new TrustAllTrustManager());
                    serverConfig.setListenerConfigs(InMemoryListenerConfig.createLDAPSConfig("LDAPS", null, listenPort, serverSSLUtil.createSSLServerSocketFactory(), clientSSLUtil.createSSLSocketFactory()));
                }
                serverConfig.setListenerConfigs(InMemoryListenerConfig.createLDAPConfig("LDAP+StartTLS", null, listenPort, serverSSLUtil.createSSLSocketFactory()));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_ERROR_INITIALIZING_SSL.get(StaticUtils.getExceptionMessage(e)), e);
            }
        } else {
            serverConfig.setListenerConfigs(InMemoryListenerConfig.createLDAPConfig("LDAP", listenPort));
        }
        if (this.vendorNameArgument.isPresent()) {
            serverConfig.setVendorName(this.vendorNameArgument.getValue());
        }
        if (this.vendorVersionArgument.isPresent()) {
            serverConfig.setVendorVersion(this.vendorVersionArgument.getValue());
        }
        if (this.equalityIndexArgument.isPresent()) {
            serverConfig.setEqualityIndexAttributes(this.equalityIndexArgument.getValues());
        }
        return serverConfig;
    }

    private static void addUnsaltedEncoder(String schemeName, String digestAlgorithm, Map<String, InMemoryPasswordEncoder> encoderMap) {
        try {
            UnsaltedMessageDigestInMemoryPasswordEncoder encoder = new UnsaltedMessageDigestInMemoryPasswordEncoder('{' + schemeName + '}', Base64PasswordEncoderOutputFormatter.getInstance(), MessageDigest.getInstance(digestAlgorithm));
            encoderMap.put(StaticUtils.toLowerCase(schemeName), encoder);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    private static void addSaltedEncoder(String schemeName, String digestAlgorithm, Map<String, InMemoryPasswordEncoder> encoderMap) {
        try {
            SaltedMessageDigestInMemoryPasswordEncoder encoder = new SaltedMessageDigestInMemoryPasswordEncoder('{' + schemeName + '}', Base64PasswordEncoderOutputFormatter.getInstance(), MessageDigest.getInstance(digestAlgorithm), 8, true, true);
            encoderMap.put(StaticUtils.toLowerCase(schemeName), encoder);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    private static void addClearEncoder(String schemeName, PasswordEncoderOutputFormatter outputFormatter, Map<String, InMemoryPasswordEncoder> encoderMap) {
        ClearInMemoryPasswordEncoder encoder = new ClearInMemoryPasswordEncoder('{' + schemeName + '}', outputFormatter);
        encoderMap.put(StaticUtils.toLowerCase(schemeName), encoder);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleUsages = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        String[] example1Args = new String[]{"--baseDN", "dc=example,dc=com"};
        exampleUsages.put(example1Args, ListenerMessages.INFO_MEM_DS_TOOL_EXAMPLE_1.get());
        String[] example2Args = new String[]{"--baseDN", "dc=example,dc=com", "--port", "1389", "--ldifFile", "test.ldif", "--accessLogFile", "access.log", "--useDefaultSchema"};
        exampleUsages.put(example2Args, ListenerMessages.INFO_MEM_DS_TOOL_EXAMPLE_2.get());
        return exampleUsages;
    }

    public InMemoryDirectoryServer getDirectoryServer() {
        return this.directoryServer;
    }

    @Override
    public void connectionCreationFailure(Socket socket, Throwable cause) {
        this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_ACCEPTING_CONNECTION.get(StaticUtils.getExceptionMessage(cause)));
    }

    @Override
    public void connectionTerminated(LDAPListenerClientConnection connection, LDAPException cause) {
        this.err(ListenerMessages.ERR_MEM_DS_TOOL_CONNECTION_TERMINATED_BY_EXCEPTION.get(StaticUtils.getExceptionMessage(cause)));
    }
}

