/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JFMessages;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class RegularExpressionJSONObjectFilter
extends JSONObjectFilter {
    public static final String FILTER_TYPE = "regularExpression";
    public static final String FIELD_FIELD_PATH = "field";
    public static final String FIELD_REGULAR_EXPRESSION = "regularExpression";
    public static final String FIELD_MATCH_ALL_ELEMENTS = "matchAllElements";
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("field", "regularExpression")));
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("matchAllElements")));
    private static final long serialVersionUID = 7678844742777504519L;
    private volatile boolean matchAllElements;
    private volatile List<String> field;
    private volatile Pattern regularExpression;

    RegularExpressionJSONObjectFilter() {
        this.field = null;
        this.regularExpression = null;
        this.matchAllElements = false;
    }

    private RegularExpressionJSONObjectFilter(List<String> field, Pattern regularExpression, boolean matchAllElements) {
        this.field = field;
        this.regularExpression = regularExpression;
        this.matchAllElements = matchAllElements;
    }

    public RegularExpressionJSONObjectFilter(String field, String regularExpression) throws JSONException {
        this(Collections.singletonList(field), regularExpression);
    }

    public RegularExpressionJSONObjectFilter(String field, Pattern regularExpression) {
        this(Collections.singletonList(field), regularExpression);
    }

    public RegularExpressionJSONObjectFilter(List<String> field, String regularExpression) throws JSONException {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        Validator.ensureNotNull(regularExpression);
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
        try {
            this.regularExpression = Pattern.compile(regularExpression);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new JSONException(JFMessages.ERR_REGEX_FILTER_INVALID_REGEX.get(regularExpression, StaticUtils.getExceptionMessage(e)), e);
        }
        this.matchAllElements = false;
    }

    public RegularExpressionJSONObjectFilter(List<String> field, Pattern regularExpression) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        Validator.ensureNotNull(regularExpression);
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
        this.regularExpression = regularExpression;
        this.matchAllElements = false;
    }

    public List<String> getField() {
        return this.field;
    }

    public void setField(String ... field) {
        this.setField(StaticUtils.toList(field));
    }

    public void setField(List<String> field) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
    }

    public Pattern getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String regularExpression) throws JSONException {
        Validator.ensureNotNull(regularExpression);
        try {
            this.regularExpression = Pattern.compile(regularExpression);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new JSONException(JFMessages.ERR_REGEX_FILTER_INVALID_REGEX.get(regularExpression, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public void setRegularExpression(Pattern regularExpression) {
        Validator.ensureNotNull(regularExpression);
        this.regularExpression = regularExpression;
    }

    public boolean matchAllElements() {
        return this.matchAllElements;
    }

    public void setMatchAllElements(boolean matchAllElements) {
        this.matchAllElements = matchAllElements;
    }

    @Override
    public String getFilterType() {
        return "regularExpression";
    }

    @Override
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(JSONObject o) {
        List<JSONValue> candidates = RegularExpressionJSONObjectFilter.getValues(o, this.field);
        if (candidates.isEmpty()) {
            return false;
        }
        for (JSONValue v : candidates) {
            if (v instanceof JSONString) {
                Matcher matcher = this.regularExpression.matcher(((JSONString)v).stringValue());
                if (!matcher.matches()) continue;
                return true;
            }
            if (!(v instanceof JSONArray)) continue;
            boolean matchOne = false;
            boolean matchAll = true;
            for (JSONValue arrayValue : ((JSONArray)v).getValues()) {
                Matcher matcher;
                if (!(arrayValue instanceof JSONString)) {
                    matchAll = false;
                    if (this.matchAllElements) break;
                }
                if ((matcher = this.regularExpression.matcher(((JSONString)arrayValue).stringValue())).matches()) {
                    if (!this.matchAllElements) {
                        return true;
                    }
                    matchOne = true;
                    continue;
                }
                matchAll = false;
                if (!this.matchAllElements) continue;
                break;
            }
            if (!matchOne || !matchAll) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(4));
        fields.put("filterType", new JSONString("regularExpression"));
        if (this.field.size() == 1) {
            fields.put(FIELD_FIELD_PATH, new JSONString(this.field.get(0)));
        } else {
            ArrayList<JSONString> fieldNameValues = new ArrayList<JSONString>(this.field.size());
            for (String s : this.field) {
                fieldNameValues.add(new JSONString(s));
            }
            fields.put(FIELD_FIELD_PATH, new JSONArray(fieldNameValues));
        }
        fields.put("regularExpression", new JSONString(this.regularExpression.toString()));
        if (this.matchAllElements) {
            fields.put(FIELD_MATCH_ALL_ELEMENTS, JSONBoolean.TRUE);
        }
        return new JSONObject(fields);
    }

    @Override
    protected RegularExpressionJSONObjectFilter decodeFilter(JSONObject filterObject) throws JSONException {
        Pattern pattern;
        List<String> fieldPath = this.getStrings(filterObject, FIELD_FIELD_PATH, false, null);
        String regex = this.getString(filterObject, "regularExpression", null, true);
        try {
            pattern = Pattern.compile(regex);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new JSONException(JFMessages.ERR_REGEX_FILTER_DECODE_INVALID_REGEX.get(String.valueOf(filterObject), "regularExpression", RegularExpressionJSONObjectFilter.fieldPathToName(fieldPath), StaticUtils.getExceptionMessage(e)), e);
        }
        boolean matchAll = this.getBoolean(filterObject, FIELD_MATCH_ALL_ELEMENTS, false);
        return new RegularExpressionJSONObjectFilter(fieldPath, pattern, matchAll);
    }
}

