/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncHelper;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class AddRequest
extends UpdatableLDAPRequest
implements ReadOnlyAddRequest,
ResponseAcceptor,
ProtocolOp {
    private static final long serialVersionUID = 1320730292848237219L;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private ArrayList<Attribute> attributes;
    private int messageID = -1;
    private String dn;

    public AddRequest(String dn, Attribute ... attributes) {
        super(null);
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn;
        this.attributes = new ArrayList(attributes.length);
        this.attributes.addAll(Arrays.asList(attributes));
    }

    public AddRequest(String dn, Attribute[] attributes, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn;
        this.attributes = new ArrayList(attributes.length);
        this.attributes.addAll(Arrays.asList(attributes));
    }

    public AddRequest(String dn, Collection<Attribute> attributes) {
        super(null);
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn;
        this.attributes = new ArrayList<Attribute>(attributes);
    }

    public AddRequest(String dn, Collection<Attribute> attributes, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn;
        this.attributes = new ArrayList<Attribute>(attributes);
    }

    public AddRequest(DN dn, Attribute ... attributes) {
        super(null);
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn.toString();
        this.attributes = new ArrayList(attributes.length);
        this.attributes.addAll(Arrays.asList(attributes));
    }

    public AddRequest(DN dn, Attribute[] attributes, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn.toString();
        this.attributes = new ArrayList(attributes.length);
        this.attributes.addAll(Arrays.asList(attributes));
    }

    public AddRequest(DN dn, Collection<Attribute> attributes) {
        super(null);
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn.toString();
        this.attributes = new ArrayList<Attribute>(attributes);
    }

    public AddRequest(DN dn, Collection<Attribute> attributes, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn.toString();
        this.attributes = new ArrayList<Attribute>(attributes);
    }

    public AddRequest(Entry entry) {
        super(null);
        Validator.ensureNotNull(entry);
        this.dn = entry.getDN();
        this.attributes = new ArrayList<Attribute>(entry.getAttributes());
    }

    public AddRequest(Entry entry, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(entry);
        this.dn = entry.getDN();
        this.attributes = new ArrayList<Attribute>(entry.getAttributes());
    }

    public AddRequest(String ... ldifLines) throws LDIFException {
        super(null);
        LDIFChangeRecord changeRecord = LDIFReader.decodeChangeRecord(true, ldifLines);
        if (!(changeRecord instanceof LDIFAddChangeRecord)) {
            throw new LDIFException(LDAPMessages.ERR_ADD_INAPPROPRIATE_CHANGE_TYPE.get(changeRecord.getChangeType().name()), 0L, true, Arrays.asList(ldifLines), null);
        }
        this.dn = changeRecord.getDN();
        this.attributes = new ArrayList<Attribute>(Arrays.asList(((LDIFAddChangeRecord)changeRecord).getAttributes()));
        this.setControls(changeRecord.getControls());
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    public void setDN(String dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
    }

    public void setDN(DN dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn.toString();
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public Attribute getAttribute(String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (Attribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return a;
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        return this.getAttribute(attributeName) != null;
    }

    @Override
    public boolean hasAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        Attribute a = this.getAttribute(attribute.getName());
        return a != null && attribute.equals(a);
    }

    @Override
    public boolean hasAttributeValue(String attributeName, String attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute a = this.getAttribute(attributeName);
        return a != null && a.hasValue(attributeValue);
    }

    @Override
    public boolean hasAttributeValue(String attributeName, String attributeValue, MatchingRule matchingRule) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute a = this.getAttribute(attributeName);
        return a != null && a.hasValue(attributeValue, matchingRule);
    }

    @Override
    public boolean hasAttributeValue(String attributeName, byte[] attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute a = this.getAttribute(attributeName);
        return a != null && a.hasValue(attributeValue);
    }

    @Override
    public boolean hasAttributeValue(String attributeName, byte[] attributeValue, MatchingRule matchingRule) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute a = this.getAttribute(attributeName);
        return a != null && a.hasValue(attributeValue, matchingRule);
    }

    @Override
    public boolean hasObjectClass(String objectClassName) {
        return this.hasAttributeValue("objectClass", objectClassName);
    }

    @Override
    public Entry toEntry() {
        return new Entry(this.dn, this.attributes);
    }

    public void setAttributes(Attribute[] attributes) {
        Validator.ensureNotNull(attributes);
        this.attributes.clear();
        this.attributes.addAll(Arrays.asList(attributes));
    }

    public void setAttributes(Collection<Attribute> attributes) {
        Validator.ensureNotNull(attributes);
        this.attributes.clear();
        this.attributes.addAll(attributes);
    }

    public void addAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.get(i);
            if (!a.getName().equalsIgnoreCase(attribute.getName())) continue;
            this.attributes.set(i, Attribute.mergeAttributes(a, attribute));
            return;
        }
        this.attributes.add(attribute);
    }

    public void addAttribute(String name, String value) {
        Validator.ensureNotNull(name, value);
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, byte[] value) {
        Validator.ensureNotNull(name, value);
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, String ... values) {
        Validator.ensureNotNull(name, values);
        this.addAttribute(new Attribute(name, values));
    }

    public void addAttribute(String name, byte[] ... values) {
        Validator.ensureNotNull(name, values);
        this.addAttribute(new Attribute(name, values));
    }

    public boolean removeAttribute(String attributeName) {
        Validator.ensureNotNull(attributeName);
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = iterator.next();
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeAttributeValue(String name, String value) {
        Validator.ensureNotNull(name, value);
        int pos = -1;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.get(i);
            if (!a.getName().equalsIgnoreCase(name)) continue;
            pos = i;
            break;
        }
        if (pos < 0) {
            return false;
        }
        Attribute a = this.attributes.get(pos);
        Attribute newAttr = Attribute.removeValues(a, new Attribute(name, value));
        if (a.getRawValues().length == newAttr.getRawValues().length) {
            return false;
        }
        if (newAttr.getRawValues().length == 0) {
            this.attributes.remove(pos);
        } else {
            this.attributes.set(pos, newAttr);
        }
        return true;
    }

    public boolean removeAttribute(String name, byte[] value) {
        Validator.ensureNotNull(name, value);
        int pos = -1;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.get(i);
            if (!a.getName().equalsIgnoreCase(name)) continue;
            pos = i;
            break;
        }
        if (pos < 0) {
            return false;
        }
        Attribute a = this.attributes.get(pos);
        Attribute newAttr = Attribute.removeValues(a, new Attribute(name, value));
        if (a.getRawValues().length == newAttr.getRawValues().length) {
            return false;
        }
        if (newAttr.getRawValues().length == 0) {
            this.attributes.remove(pos);
        } else {
            this.attributes.set(pos, newAttr);
        }
        return true;
    }

    public void replaceAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(attribute.getName())) continue;
            this.attributes.set(i, attribute);
            return;
        }
        this.attributes.add(attribute);
    }

    public void replaceAttribute(String name, String value) {
        Validator.ensureNotNull(name, value);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(name)) continue;
            this.attributes.set(i, new Attribute(name, value));
            return;
        }
        this.attributes.add(new Attribute(name, value));
    }

    public void replaceAttribute(String name, byte[] value) {
        Validator.ensureNotNull(name, value);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(name)) continue;
            this.attributes.set(i, new Attribute(name, value));
            return;
        }
        this.attributes.add(new Attribute(name, value));
    }

    public void replaceAttribute(String name, String ... values) {
        Validator.ensureNotNull(name, values);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(name)) continue;
            this.attributes.set(i, new Attribute(name, values));
            return;
        }
        this.attributes.add(new Attribute(name, values));
    }

    public void replaceAttribute(String name, byte[] ... values) {
        Validator.ensureNotNull(name, values);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(name)) continue;
            this.attributes.set(i, new Attribute(name, values));
            return;
        }
        this.attributes.add(new Attribute(name, values));
    }

    @Override
    public byte getProtocolOpType() {
        return 104;
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence requestSequence = buffer.beginSequence((byte)104);
        buffer.addOctetString(this.dn);
        ASN1BufferSequence attrSequence = buffer.beginSequence();
        for (Attribute a : this.attributes) {
            a.writeTo(buffer);
        }
        attrSequence.end();
        requestSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] attrElements = new ASN1Element[this.attributes.size()];
        for (int i = 0; i < attrElements.length; ++i) {
            attrElements[i] = this.attributes.get(i).encode();
        }
        ASN1Element[] addRequestElements = new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1Sequence(attrElements)};
        return new ASN1Sequence(104, addRequestElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LDAPResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            boolean autoReconnect = connection.getConnectionOptions().autoReconnect();
            return this.processSync(connection, depth, autoReconnect);
        }
        long requestTime = System.nanoTime();
        this.processAsync(connection, null);
        try {
            LDAPResponse response;
            try {
                long responseTimeout = this.getResponseTimeoutMillis(connection);
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_ADD_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            LDAPResult lDAPResult = this.handleResponse(connection, response, requestTime, depth, false);
            return lDAPResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection connection, AsyncResultListener resultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (resultListener == null) {
            asyncRequestID = null;
            connection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncHelper helper = new AsyncHelper(connection, OperationType.ADD, this.messageID, resultListener, this.getIntermediateResponseListener());
            connection.registerResponseAcceptor(this.messageID, helper);
            asyncRequestID = helper.getAsyncRequestID();
            long timeout = this.getResponseTimeoutMillis(connection);
            if (timeout > 0L) {
                Timer timer = connection.getTimer();
                AsyncTimeoutTimerTask timerTask = new AsyncTimeoutTimerTask(helper);
                timer.schedule((TimerTask)timerTask, timeout);
                asyncRequestID.setTimerTask(timerTask);
            }
        }
        try {
            Debug.debugLDAPRequest(Level.INFO, this, this.messageID, connection);
            connection.getConnectionStatistics().incrementNumAddRequests();
            connection.sendMessage(message);
            return asyncRequestID;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.deregisterResponseAcceptor(this.messageID);
            throw le;
        }
    }

    private LDAPResult processSync(LDAPConnection connection, int depth, boolean allowRetry) throws LDAPException {
        LDAPResponse response;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            InternalSDKHelper.setSoTimeout(connection, (int)this.getResponseTimeoutMillis(connection));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(Level.INFO, this, this.messageID, connection);
        connection.getConnectionStatistics().incrementNumAddRequests();
        try {
            connection.sendMessage(message);
        }
        catch (LDAPException le) {
            LDAPResult retryResult;
            Debug.debugException(le);
            if (allowRetry && (retryResult = this.reconnectAndRetry(connection, depth, le.getResultCode())) != null) {
                return retryResult;
            }
            throw le;
        }
        while (true) {
            try {
                response = connection.readResponse(this.messageID);
            }
            catch (LDAPException le) {
                LDAPResult retryResult;
                Debug.debugException(le);
                if (le.getResultCode() == ResultCode.TIMEOUT && connection.getConnectionOptions().abandonOnTimeout()) {
                    connection.abandon(this.messageID, new Control[0]);
                }
                if (allowRetry && (retryResult = this.reconnectAndRetry(connection, depth, le.getResultCode())) != null) {
                    return retryResult;
                }
                throw le;
            }
            if (!(response instanceof IntermediateResponse)) break;
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime, depth, allowRetry);
    }

    private LDAPResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime, int depth, boolean allowRetry) throws LDAPException {
        LDAPResult retryResult;
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            if (connection.getConnectionOptions().abandonOnTimeout()) {
                connection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_ADD_CLIENT_TIMEOUT.get(waitTime, this.messageID, this.dn, connection.getHostPort()));
        }
        connection.getConnectionStatistics().incrementNumAddResponses(System.nanoTime() - requestTime);
        if (response instanceof ConnectionClosedResponse) {
            LDAPResult retryResult2;
            if (allowRetry && (retryResult2 = this.reconnectAndRetry(connection, depth, ResultCode.SERVER_DOWN)) != null) {
                return retryResult2;
            }
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ADD_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ADD_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        LDAPResult result = (LDAPResult)response;
        if (result.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(connection)) {
            if (depth >= connection.getConnectionOptions().getReferralHopLimit()) {
                return new LDAPResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), result.getMatchedDN(), result.getReferralURLs(), result.getResponseControls());
            }
            return this.followReferral(result, connection, depth);
        }
        if (allowRetry && (retryResult = this.reconnectAndRetry(connection, depth, result.getResultCode())) != null) {
            return retryResult;
        }
        return result;
    }

    private LDAPResult reconnectAndRetry(LDAPConnection connection, int depth, ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    connection.reconnect();
                    return this.processSync(connection, depth, false);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followReferral(LDAPResult referralResult, LDAPConnection connection, int depth) throws LDAPException {
        for (String urlString : referralResult.getReferralURLs()) {
            LDAPURL referralURL = new LDAPURL(urlString);
            String host = referralURL.getHost();
            if (host == null) continue;
            AddRequest addRequest = referralURL.baseDNProvided() ? new AddRequest(referralURL.getBaseDN(), this.attributes, this.getControls()) : this;
            LDAPConnection referralConn = connection.getReferralConnector().getReferralConnection(referralURL, connection);
            try {
                LDAPResult lDAPResult = addRequest.process(referralConn, depth + 1);
                referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                referralConn.close();
                return lDAPResult;
            }
            catch (Throwable throwable) {
                try {
                    referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConn.close();
                    throw throwable;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
        }
        return referralResult;
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.ADD;
    }

    @Override
    public AddRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public AddRequest duplicate(Control[] controls) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(this.attributes);
        AddRequest r = new AddRequest(this.dn, attrs, controls);
        if (this.followReferralsInternal() != null) {
            r.setFollowReferrals(this.followReferralsInternal());
        }
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public LDIFAddChangeRecord toLDIFChangeRecord() {
        return new LDIFAddChangeRecord(this);
    }

    @Override
    public String[] toLDIF() {
        return this.toLDIFChangeRecord().toLDIF();
    }

    @Override
    public String toLDIFString() {
        return this.toLDIFChangeRecord().toLDIFString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AddRequest(dn='");
        buffer.append(this.dn);
        buffer.append("', attrs={");
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.attributes.get(i));
        }
        buffer.append('}');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(List<String> lineList, String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(this.attributes.size() + 1);
        constructorArgs.add(ToCodeArgHelper.createString(this.dn, "Entry DN"));
        boolean firstAttribute = true;
        for (Attribute a : this.attributes) {
            String comment;
            if (firstAttribute) {
                firstAttribute = false;
                comment = "Entry Attributes";
            } else {
                comment = null;
            }
            constructorArgs.add(ToCodeArgHelper.createAttribute(a, comment));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "AddRequest", requestID + "Request", "new AddRequest", constructorArgs);
        for (Control c : this.getControls()) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "Request.addControl", ToCodeArgHelper.createControl(c, null));
        }
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  LDAPResult " + requestID + "Result = connection.add(" + requestID + "Request);");
            lineList.add(indent + "  // The add was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The add failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

