/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeregisterYubiKeyOTPDeviceExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.RegisterYubiKeyOTPDeviceExtendedRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class RegisterYubiKeyOTPDevice
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 5705120716566064832L;
    private BooleanArgument deregister = null;
    private BooleanArgument promptForUserPassword = null;
    private FileArgument userPasswordFile = null;
    private StringArgument authenticationID = null;
    private StringArgument userPassword = null;
    private StringArgument otp = null;

    public static void main(String ... args) {
        ResultCode resultCode = RegisterYubiKeyOTPDevice.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        RegisterYubiKeyOTPDevice tool = new RegisterYubiKeyOTPDevice(outStream, errStream);
        return tool.runTool(args);
    }

    public RegisterYubiKeyOTPDevice(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "register-yubikey-otp-device";
    }

    @Override
    public String getToolDescription() {
        return UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_TOOL_DESCRIPTION.get("UNBOUNDID-YUBIKEY-OTP");
    }

    @Override
    public String getToolVersion() {
        return "4.0.3";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.deregister = new BooleanArgument(null, "deregister", 1, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_DESCRIPTION_DEREGISTER.get("--otp"));
        this.deregister.addLongIdentifier("de-register", true);
        parser.addArgument(this.deregister);
        this.otp = new StringArgument(null, "otp", false, 1, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_PLACEHOLDER_OTP.get(), UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_DESCRIPTION_OTP.get());
        parser.addArgument(this.otp);
        this.authenticationID = new StringArgument(null, "authID", false, 1, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_PLACEHOLDER_AUTHID.get(), UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_DESCRIPTION_AUTHID.get());
        this.authenticationID.addLongIdentifier("authenticationID", true);
        this.authenticationID.addLongIdentifier("auth-id", true);
        this.authenticationID.addLongIdentifier("authentication-id", true);
        parser.addArgument(this.authenticationID);
        this.userPassword = new StringArgument(null, "userPassword", false, 1, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_PLACEHOLDER_USER_PW.get(), UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_DESCRIPTION_USER_PW.get(this.authenticationID.getIdentifierString()));
        this.userPassword.setSensitive(true);
        this.userPassword.addLongIdentifier("user-password", true);
        parser.addArgument(this.userPassword);
        this.userPasswordFile = new FileArgument(null, "userPasswordFile", false, 1, null, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_DESCRIPTION_USER_PW_FILE.get(this.authenticationID.getIdentifierString()), true, true, true, false);
        this.userPasswordFile.addLongIdentifier("user-password-file", true);
        parser.addArgument(this.userPasswordFile);
        this.promptForUserPassword = new BooleanArgument(null, "promptForUserPassword", UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_DESCRIPTION_PROMPT_FOR_USER_PW.get(this.authenticationID.getIdentifierString()));
        this.promptForUserPassword.addLongIdentifier("prompt-for-user-password", true);
        parser.addArgument(this.promptForUserPassword);
        parser.addExclusiveArgumentSet(this.userPassword, this.userPasswordFile, this.promptForUserPassword);
        parser.addDependentArgumentSet(this.userPassword, this.authenticationID, new Argument[0]);
        parser.addDependentArgumentSet(this.userPasswordFile, this.authenticationID, new Argument[0]);
        parser.addDependentArgumentSet(this.promptForUserPassword, this.authenticationID, new Argument[0]);
    }

    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        if (!this.deregister.isPresent() && !this.otp.isPresent()) {
            throw new ArgumentException(UnboundIDDSMessages.ERR_REGISTER_YUBIKEY_OTP_DEVICE_NO_OTP_TO_REGISTER.get(this.otp.getIdentifierString()));
        }
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultCode doToolProcessing() {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, UnboundIDDSMessages.ERR_REGISTER_YUBIKEY_OTP_DEVICE_CANNOT_CONNECT.get(StaticUtils.getExceptionMessage(le)));
            return le.getResultCode();
        }
        try {
            ExtendedResult registerResult;
            byte[] staticPassword;
            String authID;
            block36: {
                block38: {
                    BufferedReader bufferedReader;
                    block37: {
                        authID = this.authenticationID.getValue();
                        if (!this.userPassword.isPresent()) break block37;
                        staticPassword = StaticUtils.getBytes(this.userPassword.getValue());
                        break block36;
                    }
                    if (!this.userPasswordFile.isPresent()) break block38;
                    BufferedReader bufferedReader2 = null;
                    try {
                        bufferedReader = new BufferedReader(new FileReader(this.userPasswordFile.getValue()));
                        staticPassword = StaticUtils.getBytes(bufferedReader.readLine());
                        if (bufferedReader != null) {
                        }
                        break block36;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, UnboundIDDSMessages.ERR_REGISTER_YUBIKEY_OTP_DEVICE_CANNOT_READ_PW.get(StaticUtils.getExceptionMessage(e)));
                        ResultCode resultCode = ResultCode.LOCAL_ERROR;
                        conn.close();
                        return resultCode;
                    }
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    break block36;
                    finally {
                        if (bufferedReader2 != null) {
                            try {
                                bufferedReader2.close();
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                        }
                    }
                }
                if (this.promptForUserPassword.isPresent()) {
                    try {
                        this.getOut().print(UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_ENTER_PW.get(authID));
                        staticPassword = PasswordReader.readPassword();
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, UnboundIDDSMessages.ERR_REGISTER_YUBIKEY_OTP_DEVICE_CANNOT_READ_PW.get(StaticUtils.getExceptionMessage(exception)));
                        ResultCode e = ResultCode.LOCAL_ERROR;
                        conn.close();
                        return e;
                    }
                } else {
                    staticPassword = null;
                }
            }
            if (this.deregister.isPresent()) {
                ExtendedResult deregisterResult;
                DeregisterYubiKeyOTPDeviceExtendedRequest deregisterYubiKeyOTPDeviceExtendedRequest = new DeregisterYubiKeyOTPDeviceExtendedRequest(authID, staticPassword, this.otp.getValue(), new Control[0]);
                try {
                    deregisterResult = conn.processExtendedOperation(deregisterYubiKeyOTPDeviceExtendedRequest);
                }
                catch (LDAPException le) {
                    deregisterResult = new ExtendedResult(le);
                }
                if (deregisterResult.getResultCode() != ResultCode.SUCCESS) {
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, UnboundIDDSMessages.ERR_REGISTER_YUBIKEY_OTP_DEVICE_DEREGISTER_FAILED.get(authID, String.valueOf(deregisterResult)));
                    ResultCode le = deregisterResult.getResultCode();
                    return le;
                }
                if (this.otp.isPresent()) {
                    this.wrapOut(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_DEREGISTER_SUCCESS_ONE.get(authID));
                } else {
                    this.wrapOut(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_DEREGISTER_SUCCESS_ALL.get(authID));
                }
                ResultCode le = ResultCode.SUCCESS;
                return le;
            }
            RegisterYubiKeyOTPDeviceExtendedRequest registerYubiKeyOTPDeviceExtendedRequest = new RegisterYubiKeyOTPDeviceExtendedRequest(authID, staticPassword, this.otp.getValue(), new Control[0]);
            try {
                registerResult = conn.processExtendedOperation(registerYubiKeyOTPDeviceExtendedRequest);
            }
            catch (LDAPException le) {
                registerResult = new ExtendedResult(le);
            }
            if (registerResult.getResultCode() == ResultCode.SUCCESS) {
                this.wrapOut(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_REGISTER_SUCCESS.get(authID));
                ResultCode resultCode = ResultCode.SUCCESS;
                return resultCode;
            }
            this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, UnboundIDDSMessages.ERR_REGISTER_YUBIKEY_OTP_DEVICE_REGISTER_FAILED.get(authID, String.valueOf(registerResult)));
            ResultCode resultCode = registerResult.getResultCode();
            return resultCode;
        }
        finally {
            conn.close();
        }
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(2);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "adminPassword", "--authenticationID", "u:test.user", "--userPassword", "testUserPassword", "--otp", "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqr"};
        exampleMap.put(args, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_EXAMPLE_REGISTER.get());
        args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "adminPassword", "--deregister", "--authenticationID", "dn:uid=test.user,ou=People,dc=example,dc=com"};
        exampleMap.put(args, UnboundIDDSMessages.INFO_REGISTER_YUBIKEY_OTP_DEVICE_EXAMPLE_DEREGISTER.get());
        return exampleMap;
    }
}

