/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.examples;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.examples.GenericFilter;
import com.unboundid.ldap.sdk.unboundidds.logs.AbandonRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogReader;
import com.unboundid.ldap.sdk.unboundidds.logs.AddResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ConnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DisconnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.UnbindRequestAccessLogMessage;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ReverseComparator;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SummarizeAccessLog
extends CommandLineTool
implements Serializable {
    private static final long serialVersionUID = -1211445611798245343L;
    private ArgumentParser argumentParser;
    private BooleanArgument isCompressed;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.000");
    private long logDurationMillis = 0L;
    private double addProcessingDuration = 0.0;
    private double bindProcessingDuration = 0.0;
    private double compareProcessingDuration = 0.0;
    private double deleteProcessingDuration = 0.0;
    private double extendedProcessingDuration = 0.0;
    private double modifyProcessingDuration = 0.0;
    private double modifyDNProcessingDuration = 0.0;
    private double searchProcessingDuration = 0.0;
    private long numAbandons = 0L;
    private long numAdds = 0L;
    private long numBinds = 0L;
    private long numCompares = 0L;
    private long numConnects = 0L;
    private long numDeletes = 0L;
    private long numDisconnects = 0L;
    private long numExtended = 0L;
    private long numModifies = 0L;
    private long numModifyDNs = 0L;
    private long numNonBaseSearches = 0L;
    private long numSearches = 0L;
    private long numUnbinds = 0L;
    private long numUncachedAdds = 0L;
    private long numUncachedBinds = 0L;
    private long numUncachedCompares = 0L;
    private long numUncachedDeletes = 0L;
    private long numUncachedExtended = 0L;
    private long numUncachedModifies = 0L;
    private long numUncachedModifyDNs = 0L;
    private long numUncachedSearches = 0L;
    private long numUnindexedAttempts;
    private long numUnindexedFailed;
    private long numUnindexedSuccessful;
    private final HashMap<Long, AtomicLong> searchEntryCounts = new HashMap(10);
    private final HashMap<ResultCode, AtomicLong> addResultCodes = new HashMap(10);
    private final HashMap<ResultCode, AtomicLong> bindResultCodes = new HashMap(10);
    private final HashMap<ResultCode, AtomicLong> compareResultCodes = new HashMap(10);
    private final HashMap<ResultCode, AtomicLong> deleteResultCodes = new HashMap(10);
    private final HashMap<ResultCode, AtomicLong> extendedResultCodes = new HashMap(10);
    private final HashMap<ResultCode, AtomicLong> modifyResultCodes = new HashMap(10);
    private final HashMap<ResultCode, AtomicLong> modifyDNResultCodes = new HashMap(10);
    private final HashMap<ResultCode, AtomicLong> searchResultCodes = new HashMap(10);
    private final HashMap<SearchScope, AtomicLong> searchScopes = new HashMap(4);
    private final HashMap<String, AtomicLong> clientAddresses = new HashMap(100);
    private final HashMap<String, AtomicLong> clientConnectionPolicies = new HashMap(100);
    private final HashMap<String, AtomicLong> disconnectReasons = new HashMap(100);
    private final HashMap<String, AtomicLong> extendedOperations = new HashMap(10);
    private final HashMap<String, AtomicLong> filterTypes = new HashMap(100);
    private final HashSet<String> processedRequests = new HashSet(100);
    private final LinkedHashMap<Long, AtomicLong> addProcessingTimes = new LinkedHashMap(11);
    private final LinkedHashMap<Long, AtomicLong> bindProcessingTimes = new LinkedHashMap(11);
    private final LinkedHashMap<Long, AtomicLong> compareProcessingTimes = new LinkedHashMap(11);
    private final LinkedHashMap<Long, AtomicLong> deleteProcessingTimes = new LinkedHashMap(11);
    private final LinkedHashMap<Long, AtomicLong> extendedProcessingTimes = new LinkedHashMap(11);
    private final LinkedHashMap<Long, AtomicLong> modifyProcessingTimes = new LinkedHashMap(11);
    private final LinkedHashMap<Long, AtomicLong> modifyDNProcessingTimes = new LinkedHashMap(11);
    private final LinkedHashMap<Long, AtomicLong> searchProcessingTimes = new LinkedHashMap(11);

    public static void main(String[] args) {
        ResultCode resultCode = SummarizeAccessLog.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        SummarizeAccessLog summarizer = new SummarizeAccessLog(outStream, errStream);
        return summarizer.runTool(args);
    }

    public SummarizeAccessLog(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
        SummarizeAccessLog.populateProcessingTimeMap(this.addProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.bindProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.compareProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.deleteProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.extendedProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.modifyProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.modifyDNProcessingTimes);
        SummarizeAccessLog.populateProcessingTimeMap(this.searchProcessingTimes);
    }

    @Override
    public String getToolName() {
        return "summarize-access-log";
    }

    @Override
    public String getToolDescription() {
        return "Examine one or more access log files from Ping Identity, UnboundID, or Alcatel-Lucent 8661 server products to display a number of metrics about operations processed within the server.";
    }

    @Override
    public String getToolVersion() {
        return "4.0.3";
    }

    @Override
    public int getMinTrailingArguments() {
        return 1;
    }

    @Override
    public int getMaxTrailingArguments() {
        return -1;
    }

    @Override
    public String getTrailingArgumentsPlaceholder() {
        return "{path}";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.argumentParser = parser;
        String description = "Indicates that the log file is compressed..";
        this.isCompressed = new BooleanArgument(Character.valueOf('c'), "isCompressed", "Indicates that the log file is compressed..");
        this.isCompressed.addLongIdentifier("is-compressed", true);
        parser.addArgument(this.isCompressed);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        List<String> trailingArguments = this.argumentParser.getTrailingArguments();
        if (trailingArguments == null || trailingArguments.isEmpty()) {
            throw new ArgumentException("No access log file paths were provided.");
        }
    }

    @Override
    public ResultCode doToolProcessing() {
        long totalUncached;
        long totalOps;
        long logLines = 0L;
        for (String path : this.argumentParser.getTrailingArguments()) {
            AccessLogReader reader;
            File f = new File(path);
            this.out("Examining access log ", f.getAbsolutePath());
            try {
                reader = this.isCompressed.isPresent() ? new AccessLogReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(f)))) : new AccessLogReader(f);
            }
            catch (IOException ioe) {
                this.err("Unable to open access log file ", f.getAbsolutePath(), ":  ", StaticUtils.getExceptionMessage(ioe));
                return ResultCode.LOCAL_ERROR;
            }
            long startTime = 0L;
            long stopTime = 0L;
            while (true) {
                AccessLogMessage msg;
                try {
                    msg = reader.read();
                }
                catch (IOException ioe) {
                    this.err("Error reading from access log file ", f.getAbsolutePath(), ":  ", StaticUtils.getExceptionMessage(ioe));
                    return ResultCode.LOCAL_ERROR;
                }
                catch (LogException le) {
                    this.err("Encountered an error while attempting to parse a line inaccess log file ", f.getAbsolutePath(), ":  ", StaticUtils.getExceptionMessage(le));
                    continue;
                }
                if (msg == null) break;
                ++logLines;
                stopTime = msg.getTimestamp().getTime();
                if (startTime == 0L) {
                    startTime = stopTime;
                }
                block3 : switch (msg.getMessageType()) {
                    case CONNECT: {
                        this.processConnect((ConnectAccessLogMessage)msg);
                        break;
                    }
                    case DISCONNECT: {
                        this.processDisconnect((DisconnectAccessLogMessage)msg);
                        break;
                    }
                    case REQUEST: {
                        switch (((OperationAccessLogMessage)msg).getOperationType()) {
                            case ABANDON: {
                                this.processAbandonRequest((AbandonRequestAccessLogMessage)msg);
                                break block3;
                            }
                            case EXTENDED: {
                                this.processExtendedRequest((ExtendedRequestAccessLogMessage)msg);
                                break block3;
                            }
                            case SEARCH: {
                                this.processSearchRequest((SearchRequestAccessLogMessage)msg);
                                break block3;
                            }
                            case UNBIND: {
                                this.processUnbindRequest((UnbindRequestAccessLogMessage)msg);
                            }
                        }
                        break;
                    }
                    case RESULT: {
                        switch (((OperationAccessLogMessage)msg).getOperationType()) {
                            case ADD: {
                                this.processAddResult((AddResultAccessLogMessage)msg);
                                break block3;
                            }
                            case BIND: {
                                this.processBindResult((BindResultAccessLogMessage)msg);
                                break block3;
                            }
                            case COMPARE: {
                                this.processCompareResult((CompareResultAccessLogMessage)msg);
                                break block3;
                            }
                            case DELETE: {
                                this.processDeleteResult((DeleteResultAccessLogMessage)msg);
                                break block3;
                            }
                            case EXTENDED: {
                                this.processExtendedResult((ExtendedResultAccessLogMessage)msg);
                                break block3;
                            }
                            case MODIFY: {
                                this.processModifyResult((ModifyResultAccessLogMessage)msg);
                                break block3;
                            }
                            case MODDN: {
                                this.processModifyDNResult((ModifyDNResultAccessLogMessage)msg);
                                break block3;
                            }
                            case SEARCH: {
                                this.processSearchResult((SearchResultAccessLogMessage)msg);
                            }
                        }
                        break;
                    }
                }
            }
            try {
                reader.close();
            }
            catch (Exception msg) {
                // empty catch block
            }
            this.logDurationMillis += stopTime - startTime;
        }
        int numFiles = this.argumentParser.getTrailingArguments().size();
        this.out(new Object[0]);
        this.out("Examined ", logLines, " lines in ", numFiles, numFiles == 1 ? " file" : " files", " covering a total duration of ", StaticUtils.millisToHumanReadableDuration(this.logDurationMillis));
        this.out(new Object[0]);
        double logDurationSeconds = (double)this.logDurationMillis / 1000.0;
        double connectsPerSecond = (double)this.numConnects / logDurationSeconds;
        double disconnectsPerSecond = (double)this.numDisconnects / logDurationSeconds;
        this.out("Total connections established:  ", this.numConnects, " (", this.decimalFormat.format(connectsPerSecond), "/second)");
        this.out("Total disconnects:  ", this.numDisconnects, " (", this.decimalFormat.format(disconnectsPerSecond), "/second)");
        if (!this.clientAddresses.isEmpty()) {
            this.out(new Object[0]);
            List<ObjectPair<String, Long>> connectCounts = SummarizeAccessLog.getMostCommonElements(this.clientAddresses, 20);
            this.out("Most common client addresses:");
            for (ObjectPair<String, Long> p : connectCounts) {
                long count = p.getSecond();
                double percent = 100.0 * (double)count / (double)this.numConnects;
                this.out(p.getFirst(), ":  ", count, " (", this.decimalFormat.format(percent), ")");
            }
        }
        if (!this.clientConnectionPolicies.isEmpty()) {
            long totalCCPs = 0L;
            for (AtomicLong l : this.clientConnectionPolicies.values()) {
                totalCCPs += l.get();
            }
            List<ObjectPair<String, Long>> reasonCounts = SummarizeAccessLog.getMostCommonElements(this.clientConnectionPolicies, 20);
            this.out(new Object[0]);
            this.out("Most common client connection policies:");
            for (ObjectPair<String, Long> p : reasonCounts) {
                long count = p.getSecond();
                double percent = 100.0 * (double)count / (double)totalCCPs;
                this.out(p.getFirst(), ":  ", p.getSecond(), " (", this.decimalFormat.format(percent), "%)");
            }
        }
        if (!this.disconnectReasons.isEmpty()) {
            List<ObjectPair<String, Long>> reasonCounts = SummarizeAccessLog.getMostCommonElements(this.disconnectReasons, 20);
            this.out(new Object[0]);
            this.out("Most common disconnect reasons:");
            for (ObjectPair<String, Long> p : reasonCounts) {
                long count = p.getSecond();
                double percent = 100.0 * (double)count / (double)this.numDisconnects;
                this.out(p.getFirst(), ":  ", p.getSecond(), " (", this.decimalFormat.format(percent), "%)");
            }
        }
        if ((totalOps = this.numAbandons + this.numAdds + this.numBinds + this.numCompares + this.numDeletes + this.numExtended + this.numModifies + this.numModifyDNs + this.numSearches + this.numUnbinds) > 0L) {
            double percent;
            long count;
            List<ObjectPair<ResultCode, Long>> rcCounts;
            double percentAbandon = 100.0 * (double)this.numAbandons / (double)totalOps;
            double percentAdd = 100.0 * (double)this.numAdds / (double)totalOps;
            double percentBind = 100.0 * (double)this.numBinds / (double)totalOps;
            double percentCompare = 100.0 * (double)this.numCompares / (double)totalOps;
            double percentDelete = 100.0 * (double)this.numDeletes / (double)totalOps;
            double percentExtended = 100.0 * (double)this.numExtended / (double)totalOps;
            double percentModify = 100.0 * (double)this.numModifies / (double)totalOps;
            double percentModifyDN = 100.0 * (double)this.numModifyDNs / (double)totalOps;
            double percentSearch = 100.0 * (double)this.numSearches / (double)totalOps;
            double percentUnbind = 100.0 * (double)this.numUnbinds / (double)totalOps;
            double abandonsPerSecond = (double)this.numAbandons / logDurationSeconds;
            double addsPerSecond = (double)this.numAdds / logDurationSeconds;
            double bindsPerSecond = (double)this.numBinds / logDurationSeconds;
            double comparesPerSecond = (double)this.numCompares / logDurationSeconds;
            double deletesPerSecond = (double)this.numDeletes / logDurationSeconds;
            double extendedPerSecond = (double)this.numExtended / logDurationSeconds;
            double modifiesPerSecond = (double)this.numModifies / logDurationSeconds;
            double modifyDNsPerSecond = (double)this.numModifyDNs / logDurationSeconds;
            double searchesPerSecond = (double)this.numSearches / logDurationSeconds;
            double unbindsPerSecond = (double)this.numUnbinds / logDurationSeconds;
            this.out(new Object[0]);
            this.out("Total operations examined:  ", totalOps);
            this.out("Abandon operations examined:  ", this.numAbandons, " (", this.decimalFormat.format(percentAbandon), "%, ", this.decimalFormat.format(abandonsPerSecond), "/second)");
            this.out("Add operations examined:  ", this.numAdds, " (", this.decimalFormat.format(percentAdd), "%, ", this.decimalFormat.format(addsPerSecond), "/second)");
            this.out("Bind operations examined:  ", this.numBinds, " (", this.decimalFormat.format(percentBind), "%, ", this.decimalFormat.format(bindsPerSecond), "/second)");
            this.out("Compare operations examined:  ", this.numCompares, " (", this.decimalFormat.format(percentCompare), "%, ", this.decimalFormat.format(comparesPerSecond), "/second)");
            this.out("Delete operations examined:  ", this.numDeletes, " (", this.decimalFormat.format(percentDelete), "%, ", this.decimalFormat.format(deletesPerSecond), "/second)");
            this.out("Extended operations examined:  ", this.numExtended, " (", this.decimalFormat.format(percentExtended), "%, ", this.decimalFormat.format(extendedPerSecond), "/second)");
            this.out("Modify operations examined:  ", this.numModifies, " (", this.decimalFormat.format(percentModify), "%, ", this.decimalFormat.format(modifiesPerSecond), "/second)");
            this.out("Modify DN operations examined:  ", this.numModifyDNs, " (", this.decimalFormat.format(percentModifyDN), "%, ", this.decimalFormat.format(modifyDNsPerSecond), "/second)");
            this.out("Search operations examined:  ", this.numSearches, " (", this.decimalFormat.format(percentSearch), "%, ", this.decimalFormat.format(searchesPerSecond), "/second)");
            this.out("Unbind operations examined:  ", this.numUnbinds, " (", this.decimalFormat.format(percentUnbind), "%, ", this.decimalFormat.format(unbindsPerSecond), "/second)");
            double totalProcessingDuration = this.addProcessingDuration + this.bindProcessingDuration + this.compareProcessingDuration + this.deleteProcessingDuration + this.extendedProcessingDuration + this.modifyProcessingDuration + this.modifyDNProcessingDuration + this.searchProcessingDuration;
            this.out(new Object[0]);
            this.out("Average operation processing duration:  ", this.decimalFormat.format(totalProcessingDuration / (double)totalOps), "ms");
            if (this.numAdds > 0L) {
                this.out("Average add operation processing duration:  ", this.decimalFormat.format(this.addProcessingDuration / (double)this.numAdds), "ms");
            }
            if (this.numBinds > 0L) {
                this.out("Average bind operation processing duration:  ", this.decimalFormat.format(this.bindProcessingDuration / (double)this.numBinds), "ms");
            }
            if (this.numCompares > 0L) {
                this.out("Average compare operation processing duration:  ", this.decimalFormat.format(this.compareProcessingDuration / (double)this.numCompares), "ms");
            }
            if (this.numDeletes > 0L) {
                this.out("Average delete operation processing duration:  ", this.decimalFormat.format(this.deleteProcessingDuration / (double)this.numDeletes), "ms");
            }
            if (this.numExtended > 0L) {
                this.out("Average extended operation processing duration:  ", this.decimalFormat.format(this.extendedProcessingDuration / (double)this.numExtended), "ms");
            }
            if (this.numModifies > 0L) {
                this.out("Average modify operation processing duration:  ", this.decimalFormat.format(this.modifyProcessingDuration / (double)this.numModifies), "ms");
            }
            if (this.numModifyDNs > 0L) {
                this.out("Average modify DN operation processing duration:  ", this.decimalFormat.format(this.modifyDNProcessingDuration / (double)this.numModifyDNs), "ms");
            }
            if (this.numSearches > 0L) {
                this.out("Average search operation processing duration:  ", this.decimalFormat.format(this.searchProcessingDuration / (double)this.numSearches), "ms");
            }
            this.printProcessingTimeHistogram("add", this.numAdds, this.addProcessingTimes);
            this.printProcessingTimeHistogram("bind", this.numBinds, this.bindProcessingTimes);
            this.printProcessingTimeHistogram("compare", this.numCompares, this.compareProcessingTimes);
            this.printProcessingTimeHistogram("delete", this.numDeletes, this.deleteProcessingTimes);
            this.printProcessingTimeHistogram("extended", this.numExtended, this.extendedProcessingTimes);
            this.printProcessingTimeHistogram("modify", this.numModifies, this.modifyProcessingTimes);
            this.printProcessingTimeHistogram("modify DN", this.numModifyDNs, this.modifyDNProcessingTimes);
            this.printProcessingTimeHistogram("search", this.numSearches, this.searchProcessingTimes);
            if (!this.addResultCodes.isEmpty()) {
                rcCounts = SummarizeAccessLog.getMostCommonElements(this.addResultCodes, 20);
                this.out(new Object[0]);
                this.out("Most common add operation result codes:");
                for (ObjectPair<ResultCode, Long> objectPair : rcCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numAdds;
                    this.out(objectPair.getFirst().getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.bindResultCodes.isEmpty()) {
                rcCounts = SummarizeAccessLog.getMostCommonElements(this.bindResultCodes, 20);
                this.out(new Object[0]);
                this.out("Most common bind operation result codes:");
                for (ObjectPair<ResultCode, Long> objectPair : rcCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numBinds;
                    this.out(objectPair.getFirst().getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.compareResultCodes.isEmpty()) {
                rcCounts = SummarizeAccessLog.getMostCommonElements(this.compareResultCodes, 20);
                this.out(new Object[0]);
                this.out("Most common compare operation result codes:");
                for (ObjectPair<ResultCode, Long> objectPair : rcCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numCompares;
                    this.out(objectPair.getFirst().getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.deleteResultCodes.isEmpty()) {
                rcCounts = SummarizeAccessLog.getMostCommonElements(this.deleteResultCodes, 20);
                this.out(new Object[0]);
                this.out("Most common delete operation result codes:");
                for (ObjectPair<ResultCode, Long> objectPair : rcCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numDeletes;
                    this.out(objectPair.getFirst().getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.extendedResultCodes.isEmpty()) {
                rcCounts = SummarizeAccessLog.getMostCommonElements(this.extendedResultCodes, 20);
                this.out(new Object[0]);
                this.out("Most common extended operation result codes:");
                for (ObjectPair<ResultCode, Long> objectPair : rcCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numExtended;
                    this.out(objectPair.getFirst().getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.modifyResultCodes.isEmpty()) {
                rcCounts = SummarizeAccessLog.getMostCommonElements(this.modifyResultCodes, 20);
                this.out(new Object[0]);
                this.out("Most common modify operation result codes:");
                for (ObjectPair<ResultCode, Long> objectPair : rcCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numModifies;
                    this.out(objectPair.getFirst().getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.modifyDNResultCodes.isEmpty()) {
                rcCounts = SummarizeAccessLog.getMostCommonElements(this.modifyDNResultCodes, 20);
                this.out(new Object[0]);
                this.out("Most common modify DN operation result codes:");
                for (ObjectPair<ResultCode, Long> objectPair : rcCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numModifyDNs;
                    this.out(objectPair.getFirst().getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.searchResultCodes.isEmpty()) {
                rcCounts = SummarizeAccessLog.getMostCommonElements(this.searchResultCodes, 20);
                this.out(new Object[0]);
                this.out("Most common search operation result codes:");
                for (ObjectPair<ResultCode, Long> objectPair : rcCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numSearches;
                    this.out(objectPair.getFirst().getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.extendedOperations.isEmpty()) {
                List<ObjectPair<String, Long>> extOpCounts = SummarizeAccessLog.getMostCommonElements(this.extendedOperations, 20);
                this.out(new Object[0]);
                this.out("Most common extended operation types:");
                for (ObjectPair<Object, Long> objectPair : extOpCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numExtended;
                    this.out(objectPair.getFirst(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            this.out(new Object[0]);
            this.out("Number of unindexed search attempts:  ", this.numUnindexedAttempts);
            this.out("Number of successfully-completed unindexed searches:  ", this.numUnindexedSuccessful);
            this.out("Number of failed unindexed searches:  ", this.numUnindexedFailed);
            if (!this.searchScopes.isEmpty()) {
                List<ObjectPair<SearchScope, Long>> scopeCounts = SummarizeAccessLog.getMostCommonElements(this.searchScopes, 20);
                this.out(new Object[0]);
                this.out("Most common search scopes:");
                for (ObjectPair<Object, Long> objectPair : scopeCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numSearches;
                    this.out(((SearchScope)objectPair.getFirst()).getName(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.searchEntryCounts.isEmpty()) {
                List<ObjectPair<Long, Long>> entryCounts = SummarizeAccessLog.getMostCommonElements(this.searchEntryCounts, 20);
                this.out(new Object[0]);
                this.out("Most common search entry counts:");
                for (ObjectPair<Object, Long> objectPair : entryCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numSearches;
                    this.out(objectPair.getFirst(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
            if (!this.filterTypes.isEmpty()) {
                List<ObjectPair<String, Long>> filterCounts = SummarizeAccessLog.getMostCommonElements(this.filterTypes, 20);
                this.out(new Object[0]);
                this.out("Most common generic filters for searches with a non-base scope:");
                for (ObjectPair<Object, Long> objectPair : filterCounts) {
                    count = objectPair.getSecond();
                    percent = 100.0 * (double)count / (double)this.numNonBaseSearches;
                    this.out(objectPair.getFirst(), ":  ", objectPair.getSecond(), " (", this.decimalFormat.format(percent), "%)");
                }
            }
        }
        if ((totalUncached = this.numUncachedAdds + this.numUncachedBinds + this.numUncachedCompares + this.numUncachedDeletes + this.numUncachedExtended + this.numUncachedModifies + this.numUncachedModifyDNs + this.numUncachedSearches) > 0L) {
            this.out(new Object[0]);
            this.out("Operations accessing uncached data:");
            this.printUncached("Add", this.numUncachedAdds, this.numAdds);
            this.printUncached("Bind", this.numUncachedBinds, this.numBinds);
            this.printUncached("Compare", this.numUncachedCompares, this.numCompares);
            this.printUncached("Delete", this.numUncachedDeletes, this.numDeletes);
            this.printUncached("Extended", this.numUncachedExtended, this.numExtended);
            this.printUncached("Modify", this.numUncachedModifies, this.numModifies);
            this.printUncached("Modify DN", this.numUncachedModifyDNs, this.numModifyDNs);
            this.printUncached("Search", this.numUncachedSearches, this.numSearches);
        }
        return ResultCode.SUCCESS;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"/ds/logs/access"};
        String description = "Analyze the contents of the /ds/logs/access access log file.";
        examples.put(args, "Analyze the contents of the /ds/logs/access access log file.");
        return examples;
    }

    private static void populateProcessingTimeMap(HashMap<Long, AtomicLong> m) {
        m.put(1L, new AtomicLong(0L));
        m.put(2L, new AtomicLong(0L));
        m.put(3L, new AtomicLong(0L));
        m.put(5L, new AtomicLong(0L));
        m.put(10L, new AtomicLong(0L));
        m.put(20L, new AtomicLong(0L));
        m.put(30L, new AtomicLong(0L));
        m.put(50L, new AtomicLong(0L));
        m.put(100L, new AtomicLong(0L));
        m.put(1000L, new AtomicLong(0L));
        m.put(Long.MAX_VALUE, new AtomicLong(0L));
    }

    private void processConnect(ConnectAccessLogMessage m) {
        String ccp;
        ++this.numConnects;
        String clientAddr = m.getSourceAddress();
        if (clientAddr != null) {
            AtomicLong count = this.clientAddresses.get(clientAddr);
            if (count == null) {
                count = new AtomicLong(0L);
                this.clientAddresses.put(clientAddr, count);
            }
            count.incrementAndGet();
        }
        if ((ccp = m.getClientConnectionPolicy()) != null) {
            AtomicLong l = this.clientConnectionPolicies.get(ccp);
            if (l == null) {
                l = new AtomicLong(0L);
                this.clientConnectionPolicies.put(ccp, l);
            }
            l.incrementAndGet();
        }
    }

    private void processDisconnect(DisconnectAccessLogMessage m) {
        ++this.numDisconnects;
        String reason = m.getDisconnectReason();
        if (reason != null) {
            AtomicLong l = this.disconnectReasons.get(reason);
            if (l == null) {
                l = new AtomicLong(0L);
                this.disconnectReasons.put(reason, l);
            }
            l.incrementAndGet();
        }
    }

    private void processAbandonRequest(AbandonRequestAccessLogMessage m) {
        ++this.numAbandons;
    }

    private void processExtendedRequest(ExtendedRequestAccessLogMessage m) {
        this.processedRequests.add(m.getConnectionID() + "-" + m.getOperationID());
        this.processExtendedRequestInternal(m);
    }

    private void processExtendedRequestInternal(ExtendedRequestAccessLogMessage m) {
        String oid = m.getRequestOID();
        if (oid != null) {
            AtomicLong l = this.extendedOperations.get(oid);
            if (l == null) {
                l = new AtomicLong(0L);
                this.extendedOperations.put(oid, l);
            }
            l.incrementAndGet();
        }
    }

    private void processSearchRequest(SearchRequestAccessLogMessage m) {
        this.processedRequests.add(m.getConnectionID() + "-" + m.getOperationID());
        this.processSearchRequestInternal(m);
    }

    private void processSearchRequestInternal(SearchRequestAccessLogMessage m) {
        SearchScope scope = m.getScope();
        if (scope != null) {
            Filter filter;
            AtomicLong scopeCount;
            if (scope != SearchScope.BASE) {
                ++this.numNonBaseSearches;
            }
            if ((scopeCount = this.searchScopes.get(scope)) == null) {
                scopeCount = new AtomicLong(0L);
                this.searchScopes.put(scope, scopeCount);
            }
            scopeCount.incrementAndGet();
            if (!scope.equals(SearchScope.BASE) && (filter = m.getParsedFilter()) != null) {
                String genericString = new GenericFilter(filter).toString();
                AtomicLong filterCount = this.filterTypes.get(genericString);
                if (filterCount == null) {
                    filterCount = new AtomicLong(0L);
                    this.filterTypes.put(genericString, filterCount);
                }
                filterCount.incrementAndGet();
            }
        }
    }

    private void processUnbindRequest(UnbindRequestAccessLogMessage m) {
        ++this.numUnbinds;
    }

    private void processAddResult(AddResultAccessLogMessage m) {
        ++this.numAdds;
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.addResultCodes);
        this.addProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.addProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedAdds;
        }
    }

    private void processBindResult(BindResultAccessLogMessage m) {
        Boolean uncachedDataAccessed;
        ++this.numBinds;
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.bindResultCodes);
        this.bindProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.bindProcessingTimes);
        String ccp = m.getClientConnectionPolicy();
        if (ccp != null) {
            AtomicLong l = this.clientConnectionPolicies.get(ccp);
            if (l == null) {
                l = new AtomicLong(0L);
                this.clientConnectionPolicies.put(ccp, l);
            }
            l.incrementAndGet();
        }
        if ((uncachedDataAccessed = m.getUncachedDataAccessed()) != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedBinds;
        }
    }

    private void processCompareResult(CompareResultAccessLogMessage m) {
        ++this.numCompares;
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.compareResultCodes);
        this.compareProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.compareProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedCompares;
        }
    }

    private void processDeleteResult(DeleteResultAccessLogMessage m) {
        ++this.numDeletes;
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.deleteResultCodes);
        this.deleteProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.deleteProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedDeletes;
        }
    }

    private void processExtendedResult(ExtendedResultAccessLogMessage m) {
        Boolean uncachedDataAccessed;
        ++this.numExtended;
        String id = m.getConnectionID() + "-" + m.getOperationID();
        if (!this.processedRequests.remove(id)) {
            this.processExtendedRequestInternal(m);
        }
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.extendedResultCodes);
        this.extendedProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.extendedProcessingTimes);
        String ccp = m.getClientConnectionPolicy();
        if (ccp != null) {
            AtomicLong l = this.clientConnectionPolicies.get(ccp);
            if (l == null) {
                l = new AtomicLong(0L);
                this.clientConnectionPolicies.put(ccp, l);
            }
            l.incrementAndGet();
        }
        if ((uncachedDataAccessed = m.getUncachedDataAccessed()) != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedExtended;
        }
    }

    private void processModifyResult(ModifyResultAccessLogMessage m) {
        ++this.numModifies;
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.modifyResultCodes);
        this.modifyProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.modifyProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedModifies;
        }
    }

    private void processModifyDNResult(ModifyDNResultAccessLogMessage m) {
        ++this.numModifyDNs;
        SummarizeAccessLog.updateResultCodeCount(m.getResultCode(), this.modifyDNResultCodes);
        this.modifyDNProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.modifyDNProcessingTimes);
        Boolean uncachedDataAccessed = m.getUncachedDataAccessed();
        if (uncachedDataAccessed != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedModifyDNs;
        }
    }

    private void processSearchResult(SearchResultAccessLogMessage m) {
        Boolean uncachedDataAccessed;
        Boolean isUnindexed;
        ++this.numSearches;
        String id = m.getConnectionID() + "-" + m.getOperationID();
        if (!this.processedRequests.remove(id)) {
            this.processSearchRequestInternal(m);
        }
        ResultCode resultCode = m.getResultCode();
        SummarizeAccessLog.updateResultCodeCount(resultCode, this.searchResultCodes);
        this.searchProcessingDuration += SummarizeAccessLog.doubleValue(m.getProcessingTimeMillis(), this.searchProcessingTimes);
        Long entryCount = m.getEntriesReturned();
        if (entryCount != null) {
            AtomicLong l = this.searchEntryCounts.get(entryCount);
            if (l == null) {
                l = new AtomicLong(0L);
                this.searchEntryCounts.put(entryCount, l);
            }
            l.incrementAndGet();
        }
        if ((isUnindexed = m.isUnindexed()) != null && isUnindexed.booleanValue()) {
            ++this.numUnindexedAttempts;
            if (resultCode == ResultCode.SUCCESS) {
                ++this.numUnindexedSuccessful;
            } else {
                ++this.numUnindexedFailed;
            }
        }
        if ((uncachedDataAccessed = m.getUncachedDataAccessed()) != null && uncachedDataAccessed.booleanValue()) {
            ++this.numUncachedSearches;
        }
    }

    private static void updateResultCodeCount(ResultCode rc, HashMap<ResultCode, AtomicLong> m) {
        if (rc == null) {
            return;
        }
        AtomicLong l = m.get(rc);
        if (l == null) {
            l = new AtomicLong(0L);
            m.put(rc, l);
        }
        l.incrementAndGet();
    }

    private static double doubleValue(Double d, HashMap<Long, AtomicLong> m) {
        if (d == null) {
            return 0.0;
        }
        for (Map.Entry<Long, AtomicLong> e : m.entrySet()) {
            if (!(d <= (double)e.getKey().longValue())) continue;
            e.getValue().incrementAndGet();
            break;
        }
        return d;
    }

    private static <K> List<ObjectPair<K, Long>> getMostCommonElements(Map<K, AtomicLong> m, int n) {
        TreeMap reverseMap = new TreeMap(new ReverseComparator());
        for (Map.Entry<K, AtomicLong> e : m.entrySet()) {
            Long count = e.getValue().get();
            ArrayList<K> list = (ArrayList<K>)reverseMap.get(count);
            if (list == null) {
                list = new ArrayList<K>(n);
                reverseMap.put(count, list);
            }
            list.add(e.getKey());
        }
        ArrayList<ObjectPair<K, Long>> returnList = new ArrayList<ObjectPair<K, Long>>(n);
        for (Map.Entry e : reverseMap.entrySet()) {
            Long l = (Long)e.getKey();
            for (Object k : (List)e.getValue()) {
                returnList.add(new ObjectPair(k, l));
            }
            if (returnList.size() < n) continue;
            break;
        }
        return returnList;
    }

    private void printProcessingTimeHistogram(String t, long n, LinkedHashMap<Long, AtomicLong> m) {
        if (n <= 0L) {
            return;
        }
        this.out(new Object[0]);
        this.out("Count of ", t, " operations by processing time:");
        long lowerBound = 0L;
        long accumulatedCount = 0L;
        Iterator<Map.Entry<Long, AtomicLong>> i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Long, AtomicLong> e = i.next();
            long upperBound = e.getKey();
            long count = e.getValue().get();
            double categoryPercent = 100.0 * (double)count / (double)n;
            double accumulatedPercent = 100.0 * (double)(accumulatedCount += count) / (double)n;
            if (i.hasNext()) {
                this.out("Between ", lowerBound, "ms and ", upperBound, "ms:  ", count, " (", this.decimalFormat.format(categoryPercent), "%, ", this.decimalFormat.format(accumulatedPercent), "% accumulated)");
                lowerBound = upperBound;
                continue;
            }
            this.out("Greater than ", lowerBound, "ms:  ", count, " (", this.decimalFormat.format(categoryPercent), "%, ", this.decimalFormat.format(accumulatedPercent), "% accumulated)");
        }
    }

    private void printUncached(String operationType, long numUncached, long numTotal) {
        if (numUncached == 0L) {
            return;
        }
        this.out(operationType, ":  ", numUncached, " (", this.decimalFormat.format(100.0 * (double)numUncached / (double)numTotal), "%)");
    }
}

