/*
 * Copyright 2009-2018 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright (C) 2015-2018 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;



import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This enum contains the set of error log categories defined in the Directory
 * Server.
 * <BR>
 * <BLOCKQUOTE>
 *   <B>NOTE:</B>  This class, and other classes within the
 *   {@code com.unboundid.ldap.sdk.unboundidds} package structure, are only
 *   supported for use against Ping Identity, UnboundID, and Alcatel-Lucent 8661
 *   server products.  These classes provide support for proprietary
 *   functionality or for external specifications that are not considered stable
 *   or mature enough to be guaranteed to work in an interoperable way with
 *   other types of LDAP servers.
 * </BLOCKQUOTE>
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ErrorLogCategory
{
  /**
   * The error log category used for messages related to access control.
   */
  ACCESS_CONTROL,



  /**
   * The error log category used for messages related to the server
   * administration framework.
   */
  ADMIN,



  /**
   * The error log category used for messages related to tools used for
   * administering the server.
   */
  ADMIN_TOOL,



  /**
   * The error log category used for messages generated by most types of
   * Directory Server backends.
   */
  BACKEND,



  /**
   * The error log category used for messages related to the server
   * configuration.
   */
  CONFIG,



  /**
   * The error log category used for messages related to the core processing of
   * the server.
   */
  CORE,



  /**
   * The error log category used for messages related to the use of the dsconfig
   * tool.
   */
  DSCONFIG,



  /**
   * The error log category used for messages generated by server extensions.
   */
  EXTENSIONS,



  /**
   * The error log category used for messages generated by the backend using the
   * Berkeley DB Java Edition for storing data.
   */
  JEB,



  /**
   * The error log category used for messages generated by the logging
   * framework.
   */
  LOG,



  /**
   * The error log category used for messages generated by server plugins.
   */
  PLUGIN,



  /**
   * The error log category used for messages about communication performed with
   * clients.
   */
  PROTOCOL,



  /**
   * The error log category used for messages about the operation of the
   * Directory Proxy Server.
   */
  PROXY,



  /**
   * The error log category used for messages generated by the QuickSetup tool.
   */
  QUICKSETUP,



  /**
   * The error log category used for messages related to replication between
   * server instances.
   */
  REPLICATION,



  /**
   * The error log category used for messages related to information about the
   * environment in which the server is running.
   */
  RUNTIME_INFORMATION,



  /**
   * The error log category used for messages related to the server schema.
   */
  SCHEMA,



  /**
   * The error log category used for messages related to processing performed by
   * server tasks.
   */
  TASK,



  /**
   * The error log category used for messages generated by third-party
   * components.
   */
  THIRD_PARTY,



  /**
   * The error log category used for messages generated by server tools.
   */
  TOOLS,



  /**
   * The error log category used for messages generated by utility classes
   * within the server.
   */
  UTIL,



  /**
   * The error log category used for messages about the server version.
   */
  VERSION;
}
