/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchHelper;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SearchRequest
extends UpdatableLDAPRequest
implements ReadOnlySearchRequest,
ResponseAcceptor,
ProtocolOp {
    public static final String ALL_USER_ATTRIBUTES = "*";
    public static final String ALL_OPERATIONAL_ATTRIBUTES = "+";
    public static final String NO_ATTRIBUTES = "1.1";
    public static final String[] REQUEST_ATTRS_DEFAULT = StaticUtils.NO_STRINGS;
    private static final long serialVersionUID = 1500219434086474893L;
    private String[] attributes;
    private boolean typesOnly;
    private DereferencePolicy derefPolicy;
    private int messageID = -1;
    private int sizeLimit;
    private int timeLimit;
    private Filter filter;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue(50);
    private final SearchResultListener searchResultListener;
    private SearchScope scope;
    private String baseDN;

    public SearchRequest(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPException {
        this(null, null, baseDN, scope, DereferencePolicy.NEVER, 0, 0, false, Filter.create(filter), attributes);
    }

    public SearchRequest(String baseDN, SearchScope scope, Filter filter, String ... attributes) {
        this(null, null, baseDN, scope, DereferencePolicy.NEVER, 0, 0, false, filter, attributes);
    }

    public SearchRequest(SearchResultListener searchResultListener, String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPException {
        this(searchResultListener, null, baseDN, scope, DereferencePolicy.NEVER, 0, 0, false, Filter.create(filter), attributes);
    }

    public SearchRequest(SearchResultListener searchResultListener, String baseDN, SearchScope scope, Filter filter, String ... attributes) {
        this(searchResultListener, null, baseDN, scope, DereferencePolicy.NEVER, 0, 0, false, filter, attributes);
    }

    public SearchRequest(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPException {
        this(null, null, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, Filter.create(filter), attributes);
    }

    public SearchRequest(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) {
        this(null, null, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    public SearchRequest(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPException {
        this(searchResultListener, null, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, Filter.create(filter), attributes);
    }

    public SearchRequest(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) {
        this(searchResultListener, null, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    public SearchRequest(SearchResultListener searchResultListener, Control[] controls, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPException {
        this(searchResultListener, controls, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, Filter.create(filter), attributes);
    }

    public SearchRequest(SearchResultListener searchResultListener, Control[] controls, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) {
        super(controls);
        Validator.ensureNotNull(baseDN, filter);
        this.baseDN = baseDN;
        this.scope = scope;
        this.derefPolicy = derefPolicy;
        this.typesOnly = typesOnly;
        this.filter = filter;
        this.searchResultListener = searchResultListener;
        this.sizeLimit = sizeLimit < 0 ? 0 : sizeLimit;
        this.timeLimit = timeLimit < 0 ? 0 : timeLimit;
        this.attributes = attributes == null ? REQUEST_ATTRS_DEFAULT : attributes;
    }

    @Override
    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        Validator.ensureNotNull(baseDN);
        this.baseDN = baseDN;
    }

    public void setBaseDN(DN baseDN) {
        Validator.ensureNotNull(baseDN);
        this.baseDN = baseDN.toString();
    }

    @Override
    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    @Override
    public DereferencePolicy getDereferencePolicy() {
        return this.derefPolicy;
    }

    public void setDerefPolicy(DereferencePolicy derefPolicy) {
        this.derefPolicy = derefPolicy;
    }

    @Override
    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit < 0 ? 0 : sizeLimit;
    }

    @Override
    public int getTimeLimitSeconds() {
        return this.timeLimit;
    }

    public void setTimeLimitSeconds(int timeLimit) {
        this.timeLimit = timeLimit < 0 ? 0 : timeLimit;
    }

    @Override
    public boolean typesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) throws LDAPException {
        Validator.ensureNotNull(filter);
        this.filter = Filter.create(filter);
    }

    public void setFilter(Filter filter) {
        Validator.ensureNotNull(filter);
        this.filter = filter;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    public List<String> getAttributeList() {
        return Collections.unmodifiableList(Arrays.asList(this.attributes));
    }

    public void setAttributes(String ... attributes) {
        this.attributes = attributes == null ? REQUEST_ATTRS_DEFAULT : attributes;
    }

    public void setAttributes(List<String> attributes) {
        if (attributes == null) {
            this.attributes = REQUEST_ATTRS_DEFAULT;
        } else {
            this.attributes = new String[attributes.size()];
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i] = attributes.get(i);
            }
        }
    }

    public SearchResultListener getSearchResultListener() {
        return this.searchResultListener;
    }

    @Override
    public byte getProtocolOpType() {
        return 99;
    }

    @Override
    public void writeTo(ASN1Buffer writer) {
        ASN1BufferSequence requestSequence = writer.beginSequence((byte)99);
        writer.addOctetString(this.baseDN);
        writer.addEnumerated(this.scope.intValue());
        writer.addEnumerated(this.derefPolicy.intValue());
        writer.addInteger(this.sizeLimit);
        writer.addInteger(this.timeLimit);
        writer.addBoolean(this.typesOnly);
        this.filter.writeTo(writer);
        ASN1BufferSequence attrSequence = writer.beginSequence();
        for (String s : this.attributes) {
            writer.addOctetString(s);
        }
        attrSequence.end();
        requestSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] attrElements = new ASN1Element[this.attributes.length];
        for (int i = 0; i < attrElements.length; ++i) {
            attrElements[i] = new ASN1OctetString(this.attributes[i]);
        }
        ASN1Element[] protocolOpElements = new ASN1Element[]{new ASN1OctetString(this.baseDN), new ASN1Enumerated(this.scope.intValue()), new ASN1Enumerated(this.derefPolicy.intValue()), new ASN1Integer(this.sizeLimit), new ASN1Integer(this.timeLimit), new ASN1Boolean(this.typesOnly), this.filter.encode(), new ASN1Sequence(attrElements)};
        return new ASN1Sequence(99, protocolOpElements);
    }

    @Override
    protected SearchResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            boolean autoReconnect = connection.getConnectionOptions().autoReconnect();
            return this.processSync(connection, depth, autoReconnect);
        }
        long requestTime = System.nanoTime();
        this.processAsync(connection, null);
        try {
            ArrayList<SearchResultReference> referenceList;
            ArrayList<SearchResultEntry> entryList;
            if (this.searchResultListener == null) {
                entryList = new ArrayList<SearchResultEntry>(5);
                referenceList = new ArrayList<SearchResultReference>(5);
            } else {
                entryList = null;
                referenceList = null;
            }
            int numEntries = 0;
            int numReferences = 0;
            ResultCode intermediateResultCode = ResultCode.SUCCESS;
            long responseTimeout = this.getResponseTimeoutMillis(connection);
            while (true) {
                SearchResult searchResult;
                SearchResult searchResult2;
                LDAPResponse response;
                try {
                    response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
                }
                catch (InterruptedException ie) {
                    Debug.debugException(ie);
                    Thread.currentThread().interrupt();
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SEARCH_INTERRUPTED.get(connection.getHostPort()), ie);
                }
                if (response == null) {
                    if (connection.getConnectionOptions().abandonOnTimeout()) {
                        connection.abandon(this.messageID, new Control[0]);
                    }
                    SearchResult searchResult3 = new SearchResult(this.messageID, ResultCode.TIMEOUT, LDAPMessages.ERR_SEARCH_CLIENT_TIMEOUT.get(responseTimeout, this.messageID, this.baseDN, this.scope.getName(), this.filter.toString(), connection.getHostPort()), null, null, entryList, referenceList, numEntries, numReferences, null);
                    throw new LDAPSearchException(searchResult3);
                }
                if (response instanceof ConnectionClosedResponse) {
                    ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
                    String message = ccr.getMessage();
                    if (message == null) {
                        searchResult2 = new SearchResult(this.messageID, ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE.get(connection.getHostPort(), this.toString()), null, null, entryList, referenceList, numEntries, numReferences, null);
                        throw new LDAPSearchException(searchResult2);
                    }
                    searchResult2 = new SearchResult(this.messageID, ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message), null, null, entryList, referenceList, numEntries, numReferences, null);
                    throw new LDAPSearchException(searchResult2);
                }
                if (response instanceof SearchResultEntry) {
                    SearchResultEntry searchEntry = (SearchResultEntry)response;
                    ++numEntries;
                    if (this.searchResultListener == null) {
                        entryList.add(searchEntry);
                        continue;
                    }
                    this.searchResultListener.searchEntryReturned(searchEntry);
                    continue;
                }
                if (response instanceof SearchResultReference) {
                    SearchResultReference searchReference = (SearchResultReference)response;
                    if (this.followReferrals(connection)) {
                        LDAPResult result = this.followSearchReference(this.messageID, searchReference, connection, depth);
                        if (!result.getResultCode().equals(ResultCode.SUCCESS)) {
                            ++numReferences;
                            if (this.searchResultListener == null) {
                                referenceList.add(searchReference);
                            } else {
                                this.searchResultListener.searchReferenceReturned(searchReference);
                            }
                            if (!intermediateResultCode.equals(ResultCode.SUCCESS)) continue;
                            intermediateResultCode = result.getResultCode();
                            continue;
                        }
                        if (!(result instanceof SearchResult)) continue;
                        searchResult2 = (SearchResult)result;
                        numEntries += searchResult2.getEntryCount();
                        if (this.searchResultListener != null) continue;
                        entryList.addAll(searchResult2.getSearchEntries());
                        continue;
                    }
                    ++numReferences;
                    if (this.searchResultListener == null) {
                        referenceList.add(searchReference);
                        continue;
                    }
                    this.searchResultListener.searchReferenceReturned(searchReference);
                    continue;
                }
                connection.getConnectionStatistics().incrementNumSearchResponses(numEntries, numReferences, System.nanoTime() - requestTime);
                SearchResult result = (SearchResult)response;
                result.setCounts(numEntries, entryList, numReferences, referenceList);
                if (result.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(connection)) {
                    if (depth >= connection.getConnectionOptions().getReferralHopLimit()) {
                        searchResult = new SearchResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), result.getMatchedDN(), result.getReferralURLs(), entryList, referenceList, numEntries, numReferences, result.getResponseControls());
                        return searchResult;
                    }
                    result = this.followReferral(result, connection, depth);
                }
                if (result.getResultCode().equals(ResultCode.SUCCESS) && !intermediateResultCode.equals(ResultCode.SUCCESS)) {
                    searchResult = new SearchResult(this.messageID, intermediateResultCode, result.getDiagnosticMessage(), result.getMatchedDN(), result.getReferralURLs(), entryList, referenceList, numEntries, numReferences, result.getResponseControls());
                    return searchResult;
                }
                searchResult = result;
                return searchResult;
            }
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection connection, AsyncSearchResultListener resultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        long timeout = this.getResponseTimeoutMillis(connection);
        if (resultListener == null) {
            asyncRequestID = null;
            connection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncSearchHelper helper = new AsyncSearchHelper(connection, this.messageID, resultListener, this.getIntermediateResponseListener());
            connection.registerResponseAcceptor(this.messageID, helper);
            asyncRequestID = helper.getAsyncRequestID();
            if (timeout > 0L) {
                Timer timer = connection.getTimer();
                AsyncTimeoutTimerTask timerTask = new AsyncTimeoutTimerTask(helper);
                timer.schedule((TimerTask)timerTask, timeout);
                asyncRequestID.setTimerTask(timerTask);
            }
        }
        try {
            Debug.debugLDAPRequest(Level.INFO, this, this.messageID, connection);
            connection.getConnectionStatistics().incrementNumSearchRequests();
            connection.sendMessage(message, timeout);
            return asyncRequestID;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.deregisterResponseAcceptor(this.messageID);
            throw le;
        }
    }

    private SearchResult processSync(LDAPConnection connection, int depth, boolean allowRetry) throws LDAPException {
        SearchResult retryResult;
        LDAPResponse response;
        ArrayList<SearchResultReference> referenceList;
        ArrayList<SearchResultEntry> entryList;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        long responseTimeout = this.getResponseTimeoutMillis(connection);
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(Level.INFO, this, this.messageID, connection);
        connection.getConnectionStatistics().incrementNumSearchRequests();
        try {
            connection.sendMessage(message, responseTimeout);
        }
        catch (LDAPException le) {
            SearchResult retryResult2;
            Debug.debugException(le);
            if (allowRetry && (retryResult2 = this.reconnectAndRetry(connection, depth, le.getResultCode(), 0, 0)) != null) {
                return retryResult2;
            }
            throw le;
        }
        if (this.searchResultListener == null) {
            entryList = new ArrayList<SearchResultEntry>(5);
            referenceList = new ArrayList<SearchResultReference>(5);
        } else {
            entryList = null;
            referenceList = null;
        }
        int numEntries = 0;
        int numReferences = 0;
        ResultCode intermediateResultCode = ResultCode.SUCCESS;
        while (true) {
            SearchResult searchResult;
            try {
                response = connection.readResponse(this.messageID);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (le.getResultCode() == ResultCode.TIMEOUT && connection.getConnectionOptions().abandonOnTimeout()) {
                    connection.abandon(this.messageID, new Control[0]);
                }
                if (allowRetry && (retryResult = this.reconnectAndRetry(connection, depth, le.getResultCode(), numEntries, numReferences)) != null) {
                    return retryResult;
                }
                throw le;
            }
            if (response == null) {
                if (connection.getConnectionOptions().abandonOnTimeout()) {
                    connection.abandon(this.messageID, new Control[0]);
                }
                throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_SEARCH_CLIENT_TIMEOUT.get(responseTimeout, this.messageID, this.baseDN, this.scope.getName(), this.filter.toString(), connection.getHostPort()));
            }
            if (response instanceof ConnectionClosedResponse) {
                SearchResult retryResult3;
                if (allowRetry && (retryResult3 = this.reconnectAndRetry(connection, depth, ResultCode.SERVER_DOWN, numEntries, numReferences)) != null) {
                    return retryResult3;
                }
                ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
                String msg = ccr.getMessage();
                if (msg == null) {
                    searchResult = new SearchResult(this.messageID, ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE.get(connection.getHostPort(), this.toString()), null, null, entryList, referenceList, numEntries, numReferences, null);
                    throw new LDAPSearchException(searchResult);
                }
                searchResult = new SearchResult(this.messageID, ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), msg), null, null, entryList, referenceList, numEntries, numReferences, null);
                throw new LDAPSearchException(searchResult);
            }
            if (response instanceof IntermediateResponse) {
                IntermediateResponseListener listener = this.getIntermediateResponseListener();
                if (listener == null) continue;
                listener.intermediateResponseReturned((IntermediateResponse)response);
                continue;
            }
            if (response instanceof SearchResultEntry) {
                SearchResultEntry searchEntry = (SearchResultEntry)response;
                ++numEntries;
                if (this.searchResultListener == null) {
                    entryList.add(searchEntry);
                    continue;
                }
                this.searchResultListener.searchEntryReturned(searchEntry);
                continue;
            }
            if (!(response instanceof SearchResultReference)) break;
            SearchResultReference searchReference = (SearchResultReference)response;
            if (this.followReferrals(connection)) {
                LDAPResult result = this.followSearchReference(this.messageID, searchReference, connection, depth);
                if (!result.getResultCode().equals(ResultCode.SUCCESS)) {
                    ++numReferences;
                    if (this.searchResultListener == null) {
                        referenceList.add(searchReference);
                    } else {
                        this.searchResultListener.searchReferenceReturned(searchReference);
                    }
                    if (!intermediateResultCode.equals(ResultCode.SUCCESS)) continue;
                    intermediateResultCode = result.getResultCode();
                    continue;
                }
                if (!(result instanceof SearchResult)) continue;
                searchResult = (SearchResult)result;
                numEntries += searchResult.getEntryCount();
                if (this.searchResultListener != null) continue;
                entryList.addAll(searchResult.getSearchEntries());
                continue;
            }
            ++numReferences;
            if (this.searchResultListener == null) {
                referenceList.add(searchReference);
                continue;
            }
            this.searchResultListener.searchReferenceReturned(searchReference);
        }
        SearchResult result = (SearchResult)response;
        if (allowRetry && (retryResult = this.reconnectAndRetry(connection, depth, result.getResultCode(), numEntries, numReferences)) != null) {
            return retryResult;
        }
        return this.handleResponse(connection, response, requestTime, depth, numEntries, numReferences, entryList, referenceList, intermediateResultCode);
    }

    private SearchResult reconnectAndRetry(LDAPConnection connection, int depth, ResultCode resultCode, int numEntries, int numReferences) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    connection.reconnect();
                    if (numEntries != 0 || numReferences != 0) break;
                    return this.processSync(connection, depth, false);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    private SearchResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime, int depth, int numEntries, int numReferences, List<SearchResultEntry> entryList, List<SearchResultReference> referenceList, ResultCode intermediateResultCode) throws LDAPException {
        connection.getConnectionStatistics().incrementNumSearchResponses(numEntries, numReferences, System.nanoTime() - requestTime);
        SearchResult result = (SearchResult)response;
        result.setCounts(numEntries, entryList, numReferences, referenceList);
        if (result.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(connection)) {
            if (depth >= connection.getConnectionOptions().getReferralHopLimit()) {
                return new SearchResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), result.getMatchedDN(), result.getReferralURLs(), entryList, referenceList, numEntries, numReferences, result.getResponseControls());
            }
            result = this.followReferral(result, connection, depth);
        }
        if (result.getResultCode().equals(ResultCode.SUCCESS) && !intermediateResultCode.equals(ResultCode.SUCCESS)) {
            return new SearchResult(this.messageID, intermediateResultCode, result.getDiagnosticMessage(), result.getMatchedDN(), result.getReferralURLs(), entryList, referenceList, numEntries, numReferences, result.getResponseControls());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followSearchReference(int messageID, SearchResultReference searchReference, LDAPConnection connection, int depth) throws LDAPException {
        for (String urlString : searchReference.getReferralURLs()) {
            LDAPURL referralURL = new LDAPURL(urlString);
            String host = referralURL.getHost();
            if (host == null) continue;
            String requestBaseDN = referralURL.baseDNProvided() ? referralURL.getBaseDN().toString() : this.baseDN;
            SearchScope requestScope = referralURL.scopeProvided() ? referralURL.getScope() : this.scope;
            Filter requestFilter = referralURL.filterProvided() ? referralURL.getFilter() : this.filter;
            SearchRequest searchRequest = new SearchRequest(this.searchResultListener, this.getControls(), requestBaseDN, requestScope, this.derefPolicy, this.sizeLimit, this.timeLimit, this.typesOnly, requestFilter, this.attributes);
            LDAPConnection referralConn = connection.getReferralConnector().getReferralConnection(referralURL, connection);
            try {
                SearchResult searchResult = searchRequest.process(referralConn, depth + 1);
                referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                referralConn.close();
                return searchResult;
            }
            catch (Throwable throwable) {
                try {
                    referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConn.close();
                    throw throwable;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (!le.getResultCode().equals(ResultCode.REFERRAL_LIMIT_EXCEEDED)) continue;
                    throw le;
                }
            }
        }
        return new SearchResult(messageID, ResultCode.REFERRAL, null, null, searchReference.getReferralURLs(), 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult followReferral(SearchResult referralResult, LDAPConnection connection, int depth) throws LDAPException {
        for (String urlString : referralResult.getReferralURLs()) {
            LDAPURL referralURL = new LDAPURL(urlString);
            String host = referralURL.getHost();
            if (host == null) continue;
            String requestBaseDN = referralURL.baseDNProvided() ? referralURL.getBaseDN().toString() : this.baseDN;
            SearchScope requestScope = referralURL.scopeProvided() ? referralURL.getScope() : this.scope;
            Filter requestFilter = referralURL.filterProvided() ? referralURL.getFilter() : this.filter;
            SearchRequest searchRequest = new SearchRequest(this.searchResultListener, this.getControls(), requestBaseDN, requestScope, this.derefPolicy, this.sizeLimit, this.timeLimit, this.typesOnly, requestFilter, this.attributes);
            LDAPConnection referralConn = connection.getReferralConnector().getReferralConnection(referralURL, connection);
            try {
                SearchResult searchResult = searchRequest.process(referralConn, depth + 1);
                referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                referralConn.close();
                return searchResult;
            }
            catch (Throwable throwable) {
                try {
                    referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConn.close();
                    throw throwable;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (!le.getResultCode().equals(ResultCode.REFERRAL_LIMIT_EXCEEDED)) continue;
                    throw le;
                }
            }
        }
        return referralResult;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.SEARCH;
    }

    @Override
    public SearchRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public SearchRequest duplicate(Control[] controls) {
        SearchRequest r = new SearchRequest(this.searchResultListener, controls, this.baseDN, this.scope, this.derefPolicy, this.sizeLimit, this.timeLimit, this.typesOnly, this.filter, this.attributes);
        if (this.followReferralsInternal() != null) {
            r.setFollowReferrals(this.followReferralsInternal());
        }
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchRequest(baseDN='");
        buffer.append(this.baseDN);
        buffer.append("', scope=");
        buffer.append(this.scope);
        buffer.append(", deref=");
        buffer.append(this.derefPolicy);
        buffer.append(", sizeLimit=");
        buffer.append(this.sizeLimit);
        buffer.append(", timeLimit=");
        buffer.append(this.timeLimit);
        buffer.append(", filter='");
        buffer.append(this.filter);
        buffer.append("', attrs={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.attributes[i]);
        }
        buffer.append('}');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(List<String> lineList, String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(10);
        constructorArgs.add(ToCodeArgHelper.createString(this.baseDN, "Base DN"));
        constructorArgs.add(ToCodeArgHelper.createScope(this.scope, "Scope"));
        constructorArgs.add(ToCodeArgHelper.createDerefPolicy(this.derefPolicy, "Alias Dereference Policy"));
        constructorArgs.add(ToCodeArgHelper.createInteger(this.sizeLimit, "Size Limit"));
        constructorArgs.add(ToCodeArgHelper.createInteger(this.timeLimit, "Time Limit"));
        constructorArgs.add(ToCodeArgHelper.createBoolean(this.typesOnly, "Types Only"));
        constructorArgs.add(ToCodeArgHelper.createFilter(this.filter, "Filter"));
        String comment = "Requested Attributes";
        for (String s : this.attributes) {
            constructorArgs.add(ToCodeArgHelper.createString(s, comment));
            comment = null;
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "SearchRequest", requestID + "Request", "new SearchRequest", constructorArgs);
        for (Control c : this.getControls()) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "Request.addControl", ToCodeArgHelper.createControl(c, null));
        }
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "SearchResult " + requestID + "Result;");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  " + requestID + "Result = connection.search(" + requestID + "Request);");
            lineList.add(indent + "  // The search was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPSearchException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The search failed.  Maybe the following " + "will help explain why.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add("");
            lineList.add(indent + "  // Even though there was an error, we may " + "have gotten some results.");
            lineList.add(indent + "  " + requestID + "Result = e.getSearchResult();");
            lineList.add(indent + '}');
            lineList.add("");
            lineList.add(indent + "// If there were results, then process them.");
            lineList.add(indent + "for (SearchResultEntry e : " + requestID + "Result.getSearchEntries())");
            lineList.add(indent + '{');
            lineList.add(indent + "  // Do something with the entry.");
            lineList.add(indent + '}');
        }
    }
}

