/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPSearchException
extends LDAPException {
    private static final long serialVersionUID = 350230437196125113L;
    private final SearchResult searchResult;

    public LDAPSearchException(ResultCode resultCode, String errorMessage) {
        super(resultCode, errorMessage);
        this.searchResult = new SearchResult(-1, resultCode, errorMessage, null, StaticUtils.NO_STRINGS, 0, 0, StaticUtils.NO_CONTROLS);
    }

    public LDAPSearchException(ResultCode resultCode, String errorMessage, Throwable cause) {
        super(resultCode, errorMessage, cause);
        this.searchResult = new SearchResult(-1, resultCode, errorMessage, null, StaticUtils.NO_STRINGS, 0, 0, StaticUtils.NO_CONTROLS);
    }

    public LDAPSearchException(LDAPException ldapException) {
        super(ldapException.getResultCode(), ldapException.getMessage(), ldapException.getMatchedDN(), ldapException.getReferralURLs(), ldapException.getResponseControls(), ldapException);
        if (ldapException instanceof LDAPSearchException) {
            LDAPSearchException lse = (LDAPSearchException)ldapException;
            this.searchResult = lse.searchResult;
        } else {
            this.searchResult = new SearchResult(-1, ldapException.getResultCode(), ldapException.getMessage(), ldapException.getMatchedDN(), ldapException.getReferralURLs(), 0, 0, ldapException.getResponseControls());
        }
    }

    public LDAPSearchException(SearchResult searchResult) {
        super(searchResult);
        this.searchResult = searchResult;
    }

    public SearchResult getSearchResult() {
        return this.searchResult;
    }

    public int getEntryCount() {
        return this.searchResult.getEntryCount();
    }

    public int getReferenceCount() {
        return this.searchResult.getReferenceCount();
    }

    public List<SearchResultEntry> getSearchEntries() {
        return this.searchResult.getSearchEntries();
    }

    public List<SearchResultReference> getSearchReferences() {
        return this.searchResult.getSearchReferences();
    }

    @Override
    public SearchResult toLDAPResult() {
        return this.searchResult;
    }

    @Override
    public void toString(StringBuilder buffer) {
        super.toString(buffer);
    }

    @Override
    public void toString(StringBuilder buffer, boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        buffer.append("LDAPException(resultCode=");
        buffer.append(this.getResultCode());
        buffer.append(", numEntries=");
        buffer.append(this.searchResult.getEntryCount());
        buffer.append(", numReferences=");
        buffer.append(this.searchResult.getReferenceCount());
        String errorMessage = this.getMessage();
        String diagnosticMessage = this.getDiagnosticMessage();
        if (errorMessage != null && !errorMessage.equals(diagnosticMessage)) {
            buffer.append(", errorMessage='");
            buffer.append(errorMessage);
            buffer.append('\'');
        }
        if (diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        if (includeStackTrace) {
            buffer.append(", trace='");
            StaticUtils.getStackTrace(this.getStackTrace(), buffer);
            buffer.append('\'');
        }
        if ((includeCause || includeStackTrace) && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause, true, includeStackTrace));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=4.0.6, revision=27850";
        if (buffer.indexOf(", ldapSDKVersion=4.0.6, revision=27850") < 0) {
            buffer.append(", ldapSDKVersion=4.0.6, revision=27850");
        }
        buffer.append("')");
    }
}

