/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum UniquenessValidationLevel {
    NONE(0),
    ALL_SUBTREE_VIEWS(1),
    ALL_BACKEND_SETS(2),
    ALL_AVAILABLE_BACKEND_SERVERS(3);

    private final int intValue;

    private UniquenessValidationLevel(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public static UniquenessValidationLevel valueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ALL_SUBTREE_VIEWS;
            }
            case 2: {
                return ALL_BACKEND_SETS;
            }
            case 3: {
                return ALL_AVAILABLE_BACKEND_SERVERS;
            }
        }
        return null;
    }

    public static UniquenessValidationLevel forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "none": {
                return NONE;
            }
            case "allsubtreeviews": 
            case "all-subtree-views": 
            case "all_subtree_views": {
                return ALL_SUBTREE_VIEWS;
            }
            case "allbackendsets": 
            case "all-backend-sets": 
            case "all_backend_sets": {
                return ALL_BACKEND_SETS;
            }
            case "allavailablebackendservers": 
            case "all-available-backend-servers": 
            case "all_available_backend_servers": {
                return ALL_AVAILABLE_BACKEND_SERVERS;
            }
        }
        return null;
    }
}

