/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.LDAPConnectionDetailsJSONSpecification;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.PKCS11KeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.util.Arrays;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SecurityOptions {
    private static final String FIELD_CLIENT_CERT_ALIAS = "client-certificate-alias";
    private static final String FIELD_KEY_STORE_FILE = "key-store-file";
    private static final String FIELD_KEY_STORE_PIN = "key-store-pin";
    private static final String FIELD_KEY_STORE_PIN_FILE = "key-store-pin-file";
    private static final String FIELD_KEY_STORE_TYPE = "key-store-type";
    private static final String FIELD_SECURITY_TYPE = "security-type";
    private static final String FIELD_TRUST_ALL_CERTS = "trust-all-certificates";
    private static final String FIELD_TRUST_EXPIRED_CERTS = "trust-expired-certificates";
    private static final String FIELD_TRUST_STORE_FILE = "trust-store-file";
    private static final String FIELD_TRUST_STORE_PIN = "trust-store-pin";
    private static final String FIELD_TRUST_STORE_PIN_FILE = "trust-store-pin-file";
    private static final String FIELD_TRUST_STORE_TYPE = "trust-store-type";
    private static final String FIELD_VERIFY_ADDRESS = "verify-address-in-certificate";
    private final boolean verifyAddressInCertificate;
    private final SocketFactory socketFactory;
    private final StartTLSPostConnectProcessor postConnectProcessor;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SecurityOptions(JSONObject connectionDetailsObject) throws LDAPException {
        boolean useSSL = false;
        boolean useStartTLS = false;
        boolean trustAll = false;
        boolean trustExpired = false;
        boolean verifyAddress = false;
        String certAlias = null;
        String keyStoreFile = null;
        String keyStorePIN = null;
        String keyStoreType = null;
        String trustStoreFile = null;
        String trustStorePIN = null;
        String trustStoreType = null;
        JSONObject o = LDAPConnectionDetailsJSONSpecification.getObject(connectionDetailsObject, "communication-security");
        if (o != null) {
            void var16_24;
            LDAPConnectionDetailsJSONSpecification.validateAllowedFields(o, "communication-security", FIELD_CLIENT_CERT_ALIAS, FIELD_KEY_STORE_FILE, FIELD_KEY_STORE_PIN, FIELD_KEY_STORE_PIN_FILE, FIELD_KEY_STORE_TYPE, FIELD_SECURITY_TYPE, FIELD_TRUST_ALL_CERTS, FIELD_TRUST_EXPIRED_CERTS, FIELD_TRUST_STORE_FILE, FIELD_TRUST_STORE_PIN, FIELD_TRUST_STORE_PIN_FILE, FIELD_TRUST_STORE_TYPE, FIELD_VERIFY_ADDRESS);
            String string = StaticUtils.toLowerCase(LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_SECURITY_TYPE, null));
            if (string == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_MISSING_SECURITY_TYPE.get(FIELD_SECURITY_TYPE));
            }
            if (string.equals("none")) {
                if (o.getFields().size() > 1) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_INVALID_FIELD_WITH_NONE.get(FIELD_SECURITY_TYPE));
                }
            } else if (string.equals("ssl") || string.equals("tls")) {
                useSSL = true;
            } else {
                if (!string.equals("starttls") && !string.equals("start-tls")) throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_INVALID_TYPE.get(FIELD_SECURITY_TYPE));
                useStartTLS = true;
            }
            trustExpired = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_TRUST_EXPIRED_CERTS, false);
            trustAll = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_TRUST_ALL_CERTS, false);
            if (trustAll) {
                LDAPConnectionDetailsJSONSpecification.rejectConflictingFields(o, FIELD_TRUST_ALL_CERTS, FIELD_TRUST_STORE_FILE, FIELD_TRUST_STORE_PIN, FIELD_TRUST_STORE_PIN_FILE, FIELD_TRUST_STORE_TYPE);
            } else {
                trustStoreFile = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_TRUST_STORE_FILE, null);
                if (trustStoreFile == null) {
                    LDAPConnectionDetailsJSONSpecification.rejectUnresolvedDependency(o, FIELD_TRUST_STORE_FILE, FIELD_TRUST_STORE_PIN, FIELD_TRUST_STORE_PIN_FILE, FIELD_TRUST_STORE_TYPE);
                } else {
                    trustStoreType = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_TRUST_STORE_TYPE, "JKS").toUpperCase();
                    if (!trustStoreType.equals("JKS") && !trustStoreType.equals("PKCS12")) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_INVALID_TS_TYPE.get(FIELD_TRUST_STORE_TYPE, trustStoreType));
                    }
                    trustStorePIN = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_TRUST_STORE_PIN, null);
                    if (trustStorePIN == null) {
                        String string2 = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_TRUST_STORE_PIN_FILE, null);
                        if (string2 != null) {
                            trustStorePIN = LDAPConnectionDetailsJSONSpecification.getStringFromFile(string2, FIELD_TRUST_STORE_PIN_FILE);
                        }
                    } else {
                        LDAPConnectionDetailsJSONSpecification.rejectConflictingFields(o, FIELD_TRUST_STORE_PIN, FIELD_TRUST_STORE_PIN_FILE);
                    }
                }
            }
            verifyAddress = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_VERIFY_ADDRESS, verifyAddress);
            boolean bl = false;
            keyStoreFile = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_KEY_STORE_FILE, keyStoreFile);
            if (keyStoreFile != null) {
                boolean bl2 = true;
                keyStoreType = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_KEY_STORE_TYPE, "JKS").toUpperCase();
                if (!keyStoreType.equals("JKS") && !keyStoreType.equals("PKCS12")) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_INVALID_KS_TYPE_WITH_FILE.get(FIELD_KEY_STORE_TYPE, keyStoreType));
                }
            } else {
                keyStoreType = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_KEY_STORE_TYPE, null);
                if (keyStoreType != null) {
                    boolean bl3 = true;
                    if (!(keyStoreType = keyStoreType.toUpperCase()).equals("PKCS11")) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_INVALID_KS_TYPE_WITHOUT_FILE.get(FIELD_KEY_STORE_TYPE, keyStoreType, FIELD_KEY_STORE_FILE));
                    }
                }
            }
            if (var16_24 != false) {
                certAlias = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_CLIENT_CERT_ALIAS, null);
                keyStorePIN = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_KEY_STORE_PIN, null);
                if (keyStorePIN == null) {
                    String keyStorePINFile = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_KEY_STORE_PIN_FILE, null);
                    if (keyStorePINFile != null) {
                        keyStorePIN = LDAPConnectionDetailsJSONSpecification.getStringFromFile(keyStorePINFile, FIELD_KEY_STORE_PIN_FILE);
                    }
                } else {
                    LDAPConnectionDetailsJSONSpecification.rejectConflictingFields(o, FIELD_KEY_STORE_PIN, FIELD_KEY_STORE_PIN_FILE);
                }
            } else {
                for (String fieldName : Arrays.asList(FIELD_KEY_STORE_PIN, FIELD_KEY_STORE_PIN_FILE, FIELD_CLIENT_CERT_ALIAS)) {
                    if (o.getField(fieldName) == null) continue;
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_INVALID_FIELD_WITHOUT_KS.get(fieldName));
                }
            }
        }
        this.verifyAddressInCertificate = verifyAddress;
        if (useSSL || useStartTLS) {
            void var15_19;
            void var16_32;
            try {
                if (trustAll) {
                    TrustAllTrustManager trustAllTrustManager = new TrustAllTrustManager(!trustExpired);
                } else if (trustStoreFile != null) {
                    void var16_27;
                    if (trustStorePIN == null) {
                        Object var16_25 = null;
                    } else {
                        char[] cArray = trustStorePIN.toCharArray();
                    }
                    TrustStoreTrustManager trustStoreTrustManager = new TrustStoreTrustManager(trustStoreFile, (char[])var16_27, trustStoreType, !trustExpired);
                } else {
                    Object var15_18 = null;
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDAPException(ResultCode.LOCAL_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_CANNOT_CREATE_TRUST_MANAGER.get(StaticUtils.getExceptionMessage(exception)), exception);
            }
            try {
                char[] keyStorePINArray = keyStorePIN == null ? null : keyStorePIN.toCharArray();
                if (keyStoreFile != null) {
                    KeyStoreKeyManager keyStoreKeyManager = new KeyStoreKeyManager(keyStoreFile, keyStorePINArray, keyStoreType, certAlias);
                } else if (keyStoreType != null && keyStoreType.equals("PKCS11")) {
                    PKCS11KeyManager pKCS11KeyManager = new PKCS11KeyManager(keyStorePINArray, certAlias);
                } else {
                    Object var16_31 = null;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_CANNOT_CREATE_KEY_MANAGER.get(StaticUtils.getExceptionMessage(e)), e);
            }
            SSLUtil sslUtil = new SSLUtil((KeyManager)var16_32, (TrustManager)var15_19);
            if (useSSL) {
                try {
                    this.socketFactory = sslUtil.createSSLSocketFactory();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_CANNOT_CREATE_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
                }
                this.postConnectProcessor = null;
                return;
            }
            this.socketFactory = SocketFactory.getDefault();
            try {
                this.postConnectProcessor = new StartTLSPostConnectProcessor(sslUtil.createSSLSocketFactory());
                return;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, JSONMessages.ERR_SECURITY_OPTIONS_CANNOT_CREATE_POST_CONNECT_PROCESSOR.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        this.socketFactory = SocketFactory.getDefault();
        this.postConnectProcessor = null;
    }

    boolean verifyAddressInCertificate() {
        return this.verifyAddressInCertificate;
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    StartTLSPostConnectProcessor getPostConnectProcessor() {
        return this.postConnectProcessor;
    }
}

