/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

final class ConnectThread
extends Thread {
    private final AtomicBoolean connected;
    private final AtomicReference<Socket> socket;
    private final AtomicReference<Thread> thread;
    private final AtomicReference<Throwable> exception;
    private final CountDownLatch startLatch;
    private final int connectTimeoutMillis;
    private final int port;
    private final SocketFactory socketFactory;
    private final InetAddress address;

    ConnectThread(SocketFactory socketFactory, InetAddress address, int port, int connectTimeoutMillis) {
        super("Background connect thread for " + address + ':' + port);
        this.setDaemon(true);
        this.socketFactory = socketFactory;
        this.address = address;
        this.port = port;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.connected = new AtomicBoolean(false);
        this.socket = new AtomicReference();
        this.thread = new AtomicReference();
        this.exception = new AtomicReference();
        this.startLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread.set(Thread.currentThread());
        this.startLatch.countDown();
        try {
            boolean connectNeeded;
            Socket s;
            try {
                s = this.socketFactory.createSocket();
                connectNeeded = true;
            }
            catch (Exception e) {
                Debug.debugException(e);
                s = this.socketFactory.createSocket(this.address, this.port);
                connectNeeded = false;
            }
            this.socket.set(s);
            if (connectNeeded) {
                s.connect(new InetSocketAddress(this.address, this.port), this.connectTimeoutMillis);
            }
            this.connected.set(true);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            this.exception.set(t);
        }
        finally {
            this.thread.set(null);
        }
    }

    Socket getConnectedSocket() throws LDAPException {
        Thread t;
        if (this.startLatch.getCount() > 0L) {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNECT_THREAD_INTERRUPTED.get(this.address.getHostAddress(), this.port, StaticUtils.getExceptionMessage(ie)), ie);
            }
        }
        if ((t = this.thread.get()) != null) {
            try {
                t.join(this.connectTimeoutMillis);
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNECT_THREAD_INTERRUPTED.get(this.address.getHostAddress(), this.port, StaticUtils.getExceptionMessage(ie)), ie);
            }
        }
        if (this.connected.get()) {
            return this.socket.get();
        }
        try {
            if (t != null) {
                t.interrupt();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            Socket s = this.socket.get();
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        Throwable cause = this.exception.get();
        if (cause == null) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_TIMEOUT.get(this.address, this.port, this.connectTimeoutMillis));
        }
        StaticUtils.rethrowIfError(cause);
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_EXCEPTION.get(this.address, this.port, StaticUtils.getExceptionMessage(cause)), cause);
    }
}

