/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPPersistException
extends LDAPException {
    private static final long serialVersionUID = 8625904586803506713L;
    private final Object partiallyDecodedObject;

    public LDAPPersistException(LDAPException e) {
        super(e);
        this.partiallyDecodedObject = null;
    }

    public LDAPPersistException(String message) {
        super(ResultCode.LOCAL_ERROR, message);
        this.partiallyDecodedObject = null;
    }

    public LDAPPersistException(String message, Throwable cause) {
        super(ResultCode.LOCAL_ERROR, message, cause);
        this.partiallyDecodedObject = null;
    }

    public LDAPPersistException(String message, Object partiallyDecodedObject, Throwable cause) {
        super(ResultCode.LOCAL_ERROR, message, cause);
        this.partiallyDecodedObject = partiallyDecodedObject;
    }

    public Object getPartiallyDecodedObject() {
        return this.partiallyDecodedObject;
    }

    @Override
    public void toString(StringBuilder buffer) {
        super.toString(buffer);
    }

    @Override
    public void toString(StringBuilder buffer, boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        buffer.append("LDAPException(resultCode=");
        buffer.append(this.getResultCode());
        String errorMessage = this.getMessage();
        String diagnosticMessage = this.getDiagnosticMessage();
        if (errorMessage != null && !errorMessage.equals(diagnosticMessage)) {
            buffer.append(", errorMessage='");
            buffer.append(errorMessage);
            buffer.append('\'');
        }
        if (this.partiallyDecodedObject != null) {
            buffer.append(", partiallyDecodedObject=");
            buffer.append(this.partiallyDecodedObject);
        }
        if (diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        if (includeStackTrace) {
            buffer.append(", trace='");
            StaticUtils.getStackTrace(this.getStackTrace(), buffer);
            buffer.append('\'');
        }
        if ((includeCause || includeStackTrace) && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause, true, includeStackTrace));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=4.0.9, revision=29290";
        if (buffer.indexOf(", ldapSDKVersion=4.0.9, revision=29290") < 0) {
            buffer.append(", ldapSDKVersion=4.0.9, revision=29290");
        }
        buffer.append("')");
    }
}

