/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AttributeUsage {
    USER_APPLICATIONS("userApplications", false),
    DIRECTORY_OPERATION("directoryOperation", true),
    DISTRIBUTED_OPERATION("distributedOperation", true),
    DSA_OPERATION("dSAOperation", true);

    private final boolean isOperational;
    private final String name;

    private AttributeUsage(String name, boolean isOperational) {
        this.name = name;
        this.isOperational = isOperational;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOperational() {
        return this.isOperational;
    }

    public static AttributeUsage forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "userapplications": 
            case "user-applications": 
            case "user_applications": {
                return USER_APPLICATIONS;
            }
            case "directoryoperation": 
            case "directory-operation": 
            case "directory_operation": {
                return DIRECTORY_OPERATION;
            }
            case "distributedoperation": 
            case "distributed-operation": 
            case "distributed_operation": {
                return DISTRIBUTED_OPERATION;
            }
            case "dsaoperation": 
            case "dsa-operation": 
            case "dsa_operation": {
                return DSA_OPERATION;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

