/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.SubentriesRequestControl;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedRequest;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeAccessibilitySearchListener;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeListener;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeResult;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RealAttributesOnlyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ReturnConflictEntriesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeletedEntryAccessRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressReferentialIntegrityUpdatesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetSubtreeAccessibilityExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetSubtreeAccessibilityExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.SetSubtreeAccessibilityExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.SubtreeAccessibilityRestriction;
import com.unboundid.ldap.sdk.unboundidds.extensions.SubtreeAccessibilityState;
import com.unboundid.util.Debug;
import com.unboundid.util.MultiServerLDAPCommandLineTool;
import com.unboundid.util.ReverseComparator;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class MoveSubtree
extends MultiServerLDAPCommandLineTool
implements UnsolicitedNotificationHandler,
MoveSubtreeListener {
    private static final String ATTR_STARTUP_UUID = "startupUUID";
    private BooleanArgument verbose = null;
    private DNArgument baseDN = null;
    private FileArgument baseDNFile = null;
    private IntegerArgument sizeLimit = null;
    private volatile String interruptMessage = null;
    private StringArgument purpose = null;

    public static void main(String ... args) {
        ResultCode rc = MoveSubtree.main(args, System.out, System.err);
        if (rc != ResultCode.SUCCESS) {
            System.exit(Math.max(rc.intValue(), 255));
        }
    }

    public static ResultCode main(String[] args, OutputStream out, OutputStream err) {
        MoveSubtree moveSubtree = new MoveSubtree(out, err);
        return moveSubtree.runTool(args);
    }

    public MoveSubtree(OutputStream out, OutputStream err) {
        super(out, err, new String[]{"source", "target"}, null);
    }

    @Override
    public String getToolName() {
        return "move-subtree";
    }

    @Override
    public String getToolDescription() {
        return UnboundIDDSMessages.INFO_MOVE_SUBTREE_TOOL_DESCRIPTION.get();
    }

    @Override
    public String getToolVersion() {
        return "4.0.9";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.baseDN = new DNArgument(Character.valueOf('b'), "baseDN", false, 0, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_BASE_DN_PLACEHOLDER.get(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_BASE_DN_DESCRIPTION.get());
        this.baseDN.addLongIdentifier("entryDN", true);
        parser.addArgument(this.baseDN);
        this.baseDNFile = new FileArgument(Character.valueOf('f'), "baseDNFile", false, 1, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_BASE_DN_FILE_PLACEHOLDER.get(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_BASE_DN_FILE_DESCRIPTION.get(), true, true, true, false);
        this.baseDNFile.addLongIdentifier("entryDNFile", true);
        parser.addArgument(this.baseDNFile);
        this.sizeLimit = new IntegerArgument(Character.valueOf('z'), "sizeLimit", false, 1, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_SIZE_LIMIT_PLACEHOLDER.get(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_SIZE_LIMIT_DESCRIPTION.get(), 0, Integer.MAX_VALUE, 0);
        parser.addArgument(this.sizeLimit);
        this.purpose = new StringArgument(null, "purpose", false, 1, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_PURPOSE_PLACEHOLDER.get(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_PURPOSE_DESCRIPTION.get());
        parser.addArgument(this.purpose);
        this.verbose = new BooleanArgument(Character.valueOf('v'), "verbose", 1, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_VERBOSE_DESCRIPTION.get());
        parser.addArgument(this.verbose);
        parser.addRequiredArgumentSet(this.baseDN, this.baseDNFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.baseDN, this.baseDNFile, new Argument[0]);
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUnsolicitedNotificationHandler(this);
        return options;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        List<String> baseDNs;
        if (this.baseDN.isPresent()) {
            List<DN> dnList = this.baseDN.getValues();
            baseDNs = new ArrayList<String>(dnList.size());
            for (DN dn : dnList) {
                baseDNs.add(dn.toString());
            }
        } else {
            try {
                baseDNs = this.baseDNFile.getNonBlankFileLines();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_READING_BASE_DN_FILE.get(this.baseDNFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
            if (baseDNs.isEmpty()) {
                this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_BASE_DN_FILE_EMPTY.get(this.baseDNFile.getValue().getAbsolutePath()));
                return ResultCode.PARAM_ERROR;
            }
        }
        LDAPConnection sourceConnection = null;
        LDAPConnection targetConnection = null;
        try {
            RootDSE sourceRootDSE;
            boolean suppressReferentialIntegrityUpdates;
            block34: {
                try {
                    sourceConnection = this.getConnection(0);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_CONNECT_TO_SOURCE.get(StaticUtils.getExceptionMessage(le)));
                    ResultCode resultCode = le.getResultCode();
                    if (sourceConnection != null) {
                        sourceConnection.close();
                    }
                    if (targetConnection != null) {
                        targetConnection.close();
                    }
                    return resultCode;
                }
                try {
                    targetConnection = this.getConnection(1);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_CONNECT_TO_TARGET.get(StaticUtils.getExceptionMessage(le)));
                    ResultCode resultCode = le.getResultCode();
                    if (sourceConnection != null) {
                        sourceConnection.close();
                    }
                    if (targetConnection != null) {
                        targetConnection.close();
                    }
                    return resultCode;
                }
                sourceConnection.setConnectionName(UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get());
                targetConnection.setConnectionName(UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get());
                if (sourceConnection.getConnectedAddress().equals(targetConnection.getConnectedAddress()) && sourceConnection.getConnectedPort() == targetConnection.getConnectedPort()) {
                    this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SAME_SOURCE_AND_TARGET_SERVERS.get());
                    ResultCode le = ResultCode.PARAM_ERROR;
                    return le;
                }
                suppressReferentialIntegrityUpdates = false;
                sourceRootDSE = sourceConnection.getRootDSE();
                RootDSE targetRootDSE = targetConnection.getRootDSE();
                if (sourceRootDSE == null || targetRootDSE == null) break block34;
                String sourceStartupUUID = sourceRootDSE.getAttributeValue(ATTR_STARTUP_UUID);
                String targetStartupUUID = targetRootDSE.getAttributeValue(ATTR_STARTUP_UUID);
                if (sourceStartupUUID == null || !sourceStartupUUID.equals(targetStartupUUID)) break block34;
                this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SAME_SOURCE_AND_TARGET_SERVERS.get());
                ResultCode resultCode = ResultCode.PARAM_ERROR;
                return resultCode;
            }
            try {
                if (sourceRootDSE != null) {
                    suppressReferentialIntegrityUpdates = sourceRootDSE.supportsControl("1.3.6.1.4.1.30221.2.5.30");
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            boolean first = true;
            ResultCode resultCode = ResultCode.SUCCESS;
            for (String dn : baseDNs) {
                if (first) {
                    first = false;
                } else {
                    this.out(new Object[0]);
                }
                OperationPurposeRequestControl operationPurpose = this.purpose.isPresent() ? new OperationPurposeRequestControl(this.getToolName(), this.getToolVersion(), 20, this.purpose.getValue()) : null;
                MoveSubtreeResult result = MoveSubtree.moveSubtreeWithRestrictedAccessibility(this, sourceConnection, targetConnection, dn, this.sizeLimit.getValue(), operationPurpose, suppressReferentialIntegrityUpdates, this.verbose.isPresent() ? this : null);
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    this.wrapOut(0, 79, UnboundIDDSMessages.INFO_MOVE_SUBTREE_RESULT_SUCCESSFUL.get(result.getEntriesAddedToTarget(), dn));
                    continue;
                }
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = result.getResultCode();
                }
                this.wrapErr(0, 79, UnboundIDDSMessages.ERR_MOVE_SUBTREE_RESULT_UNSUCCESSFUL.get());
                if (result.getErrorMessage() != null) {
                    this.wrapErr(0, 79, UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_MESSAGE.get(result.getErrorMessage()));
                }
                if (result.getAdminActionRequired() == null) continue;
                this.wrapErr(0, 79, UnboundIDDSMessages.ERR_MOVE_SUBTREE_ADMIN_ACTION.get(result.getAdminActionRequired()));
            }
            ResultCode resultCode2 = resultCode;
            return resultCode2;
        }
        finally {
            if (sourceConnection != null) {
                sourceConnection.close();
            }
            if (targetConnection != null) {
                targetConnection.close();
            }
        }
    }

    public static MoveSubtreeResult moveEntryWithInteractiveTransaction(LDAPConnection sourceConnection, LDAPConnection targetConnection, String entryDN, OperationPurposeRequestControl opPurposeControl, MoveSubtreeListener listener) {
        return MoveSubtree.moveEntryWithInteractiveTransaction(sourceConnection, targetConnection, entryDN, opPurposeControl, false, listener);
    }

    /*
     * Exception decompiling
     */
    public static MoveSubtreeResult moveEntryWithInteractiveTransaction(LDAPConnection sourceConnection, LDAPConnection targetConnection, String entryDN, OperationPurposeRequestControl opPurposeControl, boolean suppressRefInt, MoveSubtreeListener listener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 66[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MoveSubtreeResult moveSubtreeWithRestrictedAccessibility(LDAPConnection sourceConnection, LDAPConnection targetConnection, String baseDN, int sizeLimit, OperationPurposeRequestControl opPurposeControl, MoveSubtreeListener listener) {
        return MoveSubtree.moveSubtreeWithRestrictedAccessibility(sourceConnection, targetConnection, baseDN, sizeLimit, opPurposeControl, false, listener);
    }

    public static MoveSubtreeResult moveSubtreeWithRestrictedAccessibility(LDAPConnection sourceConnection, LDAPConnection targetConnection, String baseDN, int sizeLimit, OperationPurposeRequestControl opPurposeControl, boolean suppressRefInt, MoveSubtreeListener listener) {
        return MoveSubtree.moveSubtreeWithRestrictedAccessibility(null, sourceConnection, targetConnection, baseDN, sizeLimit, opPurposeControl, suppressRefInt, listener);
    }

    private static MoveSubtreeResult moveSubtreeWithRestrictedAccessibility(MoveSubtree tool, LDAPConnection sourceConnection, LDAPConnection targetConnection, String baseDN, int sizeLimit, OperationPurposeRequestControl opPurposeControl, boolean suppressRefInt, MoveSubtreeListener listener) {
        SubtreeAccessibilityState currentTargetState;
        SubtreeAccessibilityState currentSourceState;
        boolean targetServerAltered;
        boolean sourceServerAltered;
        AtomicReference<ResultCode> resultCode;
        AtomicInteger entriesDeletedFromSource;
        AtomicInteger entriesAddedToTarget;
        AtomicInteger entriesReadFromSource;
        StringBuilder adminMsg;
        StringBuilder errorMsg;
        block40: {
            SearchResult searchResult;
            String targetUserDN;
            String sourceUserDN;
            MoveSubtreeResult initialAccessibilityResult = MoveSubtree.checkInitialAccessibility(sourceConnection, targetConnection, baseDN, opPurposeControl);
            if (initialAccessibilityResult != null) {
                return initialAccessibilityResult;
            }
            errorMsg = new StringBuilder();
            adminMsg = new StringBuilder();
            ReverseComparator reverseComparator = new ReverseComparator();
            TreeSet<DN> sourceEntryDNs = new TreeSet<DN>(reverseComparator);
            entriesReadFromSource = new AtomicInteger(0);
            entriesAddedToTarget = new AtomicInteger(0);
            entriesDeletedFromSource = new AtomicInteger(0);
            resultCode = new AtomicReference<ResultCode>();
            sourceServerAltered = false;
            targetServerAltered = false;
            currentSourceState = SubtreeAccessibilityState.ACCESSIBLE;
            currentTargetState = SubtreeAccessibilityState.ACCESSIBLE;
            try {
                sourceUserDN = MoveSubtree.getAuthenticatedUserDN(sourceConnection, true, opPurposeControl);
                targetUserDN = MoveSubtree.getAuthenticatedUserDN(targetConnection, false, opPurposeControl);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                resultCode.compareAndSet(null, le.getResultCode());
                MoveSubtree.append(le.getMessage(), errorMsg);
                break block40;
            }
            try {
                MoveSubtree.setAccessibility(targetConnection, false, baseDN, SubtreeAccessibilityState.HIDDEN, targetUserDN, opPurposeControl);
                currentTargetState = SubtreeAccessibilityState.HIDDEN;
                MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_TARGET_HIDDEN.get(baseDN, targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                resultCode.compareAndSet(null, le.getResultCode());
                MoveSubtree.append(le.getMessage(), errorMsg);
                break block40;
            }
            try {
                MoveSubtree.setAccessibility(sourceConnection, true, baseDN, SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED, sourceUserDN, opPurposeControl);
                currentSourceState = SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED;
                MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_SOURCE_READ_ONLY.get(baseDN, targetConnection.getConnectedAddress(), targetConnection.getConnectedPort(), sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort()));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                resultCode.compareAndSet(null, le.getResultCode());
                MoveSubtree.append(le.getMessage(), errorMsg);
                break block40;
            }
            Control[] searchControls = opPurposeControl == null ? new Control[]{new ManageDsaITRequestControl(true), new SubentriesRequestControl(true), new ReturnConflictEntriesRequestControl(true), new SoftDeletedEntryAccessRequestControl(true, true, false), new RealAttributesOnlyRequestControl(true)} : new Control[]{new ManageDsaITRequestControl(true), new SubentriesRequestControl(true), new ReturnConflictEntriesRequestControl(true), new SoftDeletedEntryAccessRequestControl(true, true, false), new RealAttributesOnlyRequestControl(true), opPurposeControl};
            MoveSubtreeAccessibilitySearchListener searchListener = new MoveSubtreeAccessibilitySearchListener(tool, baseDN, sourceConnection, targetConnection, resultCode, errorMsg, entriesReadFromSource, entriesAddedToTarget, sourceEntryDNs, opPurposeControl, listener);
            SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchListener, searchControls, baseDN, SearchScope.SUB, DereferencePolicy.NEVER, sizeLimit, 0, false, Filter.createPresenceFilter("objectClass"), "*", "+");
            try {
                searchResult = sourceConnection.search(searchRequest);
            }
            catch (LDAPSearchException lse) {
                Debug.debugException(lse);
                searchResult = lse.getSearchResult();
            }
            if (entriesAddedToTarget.get() > 0) {
                targetServerAltered = true;
            }
            if (searchResult.getResultCode() != ResultCode.SUCCESS) {
                resultCode.compareAndSet(null, searchResult.getResultCode());
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SEARCH_FAILED.get(baseDN, searchResult.getDiagnosticMessage()), errorMsg);
                AtomicInteger deleteCount = new AtomicInteger(0);
                if (targetServerAltered) {
                    MoveSubtree.deleteEntries(targetConnection, false, sourceEntryDNs, opPurposeControl, false, null, deleteCount, resultCode, errorMsg);
                    entriesAddedToTarget.addAndGet(0 - deleteCount.get());
                    if (entriesAddedToTarget.get() == 0) {
                        targetServerAltered = false;
                    } else {
                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_TARGET_NOT_DELETED_ADMIN_ACTION.get(baseDN), adminMsg);
                    }
                }
            } else if (resultCode.get() != null) {
                AtomicInteger deleteCount = new AtomicInteger(0);
                if (targetServerAltered) {
                    MoveSubtree.deleteEntries(targetConnection, false, sourceEntryDNs, opPurposeControl, false, null, deleteCount, resultCode, errorMsg);
                    entriesAddedToTarget.addAndGet(0 - deleteCount.get());
                    if (entriesAddedToTarget.get() == 0) {
                        targetServerAltered = false;
                    } else {
                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_TARGET_NOT_DELETED_ADMIN_ACTION.get(baseDN), adminMsg);
                    }
                }
            } else {
                try {
                    MoveSubtree.setAccessibility(targetConnection, true, baseDN, SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED, targetUserDN, opPurposeControl);
                    currentTargetState = SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED;
                    MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_TARGET_READ_ONLY.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    resultCode.compareAndSet(null, le.getResultCode());
                    MoveSubtree.append(le.getMessage(), errorMsg);
                    break block40;
                }
                try {
                    MoveSubtree.setAccessibility(sourceConnection, true, baseDN, SubtreeAccessibilityState.HIDDEN, sourceUserDN, opPurposeControl);
                    currentSourceState = SubtreeAccessibilityState.HIDDEN;
                    MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_SOURCE_HIDDEN.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    resultCode.compareAndSet(null, le.getResultCode());
                    MoveSubtree.append(le.getMessage(), errorMsg);
                    break block40;
                }
                try {
                    MoveSubtree.setAccessibility(targetConnection, true, baseDN, SubtreeAccessibilityState.ACCESSIBLE, targetUserDN, opPurposeControl);
                    currentTargetState = SubtreeAccessibilityState.ACCESSIBLE;
                    MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_TARGET_ACCESSIBLE.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    resultCode.compareAndSet(null, le.getResultCode());
                    MoveSubtree.append(le.getMessage(), errorMsg);
                    break block40;
                }
                boolean deleteSuccessful = MoveSubtree.deleteEntries(sourceConnection, true, sourceEntryDNs, opPurposeControl, suppressRefInt, listener, entriesDeletedFromSource, resultCode, errorMsg);
                boolean bl = sourceServerAltered = entriesDeletedFromSource.get() != 0;
                if (!deleteSuccessful) {
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SOURCE_NOT_DELETED_ADMIN_ACTION.get(baseDN), adminMsg);
                } else {
                    try {
                        MoveSubtree.setAccessibility(sourceConnection, true, baseDN, SubtreeAccessibilityState.ACCESSIBLE, sourceUserDN, opPurposeControl);
                        currentSourceState = SubtreeAccessibilityState.ACCESSIBLE;
                        MoveSubtree.setInterruptMessage(tool, null);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        resultCode.compareAndSet(null, le.getResultCode());
                        MoveSubtree.append(le.getMessage(), errorMsg);
                    }
                }
            }
        }
        if (currentSourceState != SubtreeAccessibilityState.ACCESSIBLE) {
            if (!sourceServerAltered) {
                try {
                    MoveSubtree.setAccessibility(sourceConnection, true, baseDN, SubtreeAccessibilityState.ACCESSIBLE, null, opPurposeControl);
                    currentSourceState = SubtreeAccessibilityState.ACCESSIBLE;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            if (currentSourceState != SubtreeAccessibilityState.ACCESSIBLE) {
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SOURCE_LEFT_INACCESSIBLE.get(new Object[]{currentSourceState, baseDN}), adminMsg);
            }
        }
        if (currentTargetState != SubtreeAccessibilityState.ACCESSIBLE) {
            if (!targetServerAltered) {
                try {
                    MoveSubtree.setAccessibility(targetConnection, false, baseDN, SubtreeAccessibilityState.ACCESSIBLE, null, opPurposeControl);
                    currentTargetState = SubtreeAccessibilityState.ACCESSIBLE;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            if (currentTargetState != SubtreeAccessibilityState.ACCESSIBLE) {
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_TARGET_LEFT_INACCESSIBLE.get(new Object[]{currentTargetState, baseDN}), adminMsg);
            }
        }
        resultCode.compareAndSet(null, ResultCode.SUCCESS);
        String errorMessage = errorMsg.length() > 0 ? errorMsg.toString() : null;
        String adminActionRequired = adminMsg.length() > 0 ? adminMsg.toString() : null;
        return new MoveSubtreeResult((ResultCode)resultCode.get(), errorMessage, adminActionRequired, sourceServerAltered, targetServerAltered, entriesReadFromSource.get(), entriesAddedToTarget.get(), entriesDeletedFromSource.get());
    }

    private static String getAuthenticatedUserDN(LDAPConnection connection, boolean isSource, OperationPurposeRequestControl opPurposeControl) throws LDAPException {
        WhoAmIExtendedResult whoAmIResult;
        BindRequest bindRequest = InternalSDKHelper.getLastBindRequest(connection);
        if (bindRequest != null && bindRequest instanceof SimpleBindRequest) {
            SimpleBindRequest r = (SimpleBindRequest)bindRequest;
            return r.getBindDN();
        }
        Control[] controls = opPurposeControl == null ? StaticUtils.NO_CONTROLS : new Control[]{opPurposeControl};
        String connectionName = isSource ? UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get() : UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get();
        try {
            whoAmIResult = (WhoAmIExtendedResult)connection.processExtendedOperation(new WhoAmIExtendedRequest(controls));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_INVOKING_WHO_AM_I.get(connectionName, StaticUtils.getExceptionMessage(le)), le);
        }
        if (whoAmIResult.getResultCode() != ResultCode.SUCCESS) {
            throw new LDAPException(whoAmIResult.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_INVOKING_WHO_AM_I.get(connectionName, whoAmIResult.getDiagnosticMessage()));
        }
        String authzID = whoAmIResult.getAuthorizationID();
        if (authzID != null && authzID.startsWith("dn:")) {
            return authzID.substring(3);
        }
        throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_IDENTIFY_CONNECTED_USER.get(connectionName));
    }

    private static MoveSubtreeResult checkInitialAccessibility(LDAPConnection sourceConnection, LDAPConnection targetConnection, String baseDN, OperationPurposeRequestControl opPurposeControl) {
        GetSubtreeAccessibilityExtendedResult targetResult;
        GetSubtreeAccessibilityExtendedResult sourceResult;
        DN parsedBaseDN;
        try {
            parsedBaseDN = new DN(baseDN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new MoveSubtreeResult(ResultCode.INVALID_DN_SYNTAX, UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_PARSE_BASE_DN.get(baseDN, StaticUtils.getExceptionMessage(e)), null, false, false, 0, 0, 0);
        }
        Control[] controls = opPurposeControl == null ? StaticUtils.NO_CONTROLS : new Control[]{opPurposeControl};
        try {
            sourceResult = (GetSubtreeAccessibilityExtendedResult)sourceConnection.processExtendedOperation(new GetSubtreeAccessibilityExtendedRequest(controls));
            if (sourceResult.getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(sourceResult);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new MoveSubtreeResult(le.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_GET_ACCESSIBILITY_STATE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), le.getMessage()), null, false, false, 0, 0, 0);
        }
        boolean sourceMatch = false;
        String sourceMessage = null;
        SubtreeAccessibilityRestriction sourceRestriction = null;
        List<SubtreeAccessibilityRestriction> sourceRestrictions = sourceResult.getAccessibilityRestrictions();
        if (sourceRestrictions != null) {
            for (SubtreeAccessibilityRestriction r : sourceRestrictions) {
                DN restrictionDN;
                if (r.getAccessibilityState() == SubtreeAccessibilityState.ACCESSIBLE) continue;
                try {
                    restrictionDN = new DN(r.getSubtreeBaseDN());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    return new MoveSubtreeResult(ResultCode.INVALID_DN_SYNTAX, UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_PARSE_RESTRICTION_BASE_DN.get(r.getSubtreeBaseDN(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), r.toString(), StaticUtils.getExceptionMessage(e)), null, false, false, 0, 0, 0);
                }
                if (restrictionDN.equals(parsedBaseDN)) {
                    sourceMatch = true;
                    sourceRestriction = r;
                    sourceMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_NOT_ACCESSIBLE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), r.getAccessibilityState().getStateName());
                    break;
                }
                if (restrictionDN.isAncestorOf(parsedBaseDN, false)) {
                    sourceRestriction = r;
                    sourceMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_WITHIN_UNACCESSIBLE_TREE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), r.getSubtreeBaseDN(), r.getAccessibilityState().getStateName());
                    break;
                }
                if (!restrictionDN.isDescendantOf(parsedBaseDN, false)) continue;
                sourceRestriction = r;
                sourceMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_CONTAINS_UNACCESSIBLE_TREE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), r.getSubtreeBaseDN(), r.getAccessibilityState().getStateName());
                break;
            }
        }
        try {
            targetResult = (GetSubtreeAccessibilityExtendedResult)targetConnection.processExtendedOperation(new GetSubtreeAccessibilityExtendedRequest(controls));
            if (targetResult.getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(targetResult);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new MoveSubtreeResult(le.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_GET_ACCESSIBILITY_STATE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), le.getMessage()), null, false, false, 0, 0, 0);
        }
        boolean targetMatch = false;
        String targetMessage = null;
        SubtreeAccessibilityRestriction targetRestriction = null;
        List<SubtreeAccessibilityRestriction> targetRestrictions = targetResult.getAccessibilityRestrictions();
        if (targetRestrictions != null) {
            for (SubtreeAccessibilityRestriction r : targetRestrictions) {
                DN restrictionDN;
                if (r.getAccessibilityState() == SubtreeAccessibilityState.ACCESSIBLE) continue;
                try {
                    restrictionDN = new DN(r.getSubtreeBaseDN());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    return new MoveSubtreeResult(ResultCode.INVALID_DN_SYNTAX, UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_PARSE_RESTRICTION_BASE_DN.get(r.getSubtreeBaseDN(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), r.toString(), StaticUtils.getExceptionMessage(e)), null, false, false, 0, 0, 0);
                }
                if (restrictionDN.equals(parsedBaseDN)) {
                    targetMatch = true;
                    targetRestriction = r;
                    targetMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_NOT_ACCESSIBLE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), r.getAccessibilityState().getStateName());
                    break;
                }
                if (restrictionDN.isAncestorOf(parsedBaseDN, false)) {
                    targetRestriction = r;
                    targetMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_WITHIN_UNACCESSIBLE_TREE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), r.getSubtreeBaseDN(), r.getAccessibilityState().getStateName());
                    break;
                }
                if (!restrictionDN.isDescendantOf(parsedBaseDN, false)) continue;
                targetRestriction = r;
                targetMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_CONTAINS_UNACCESSIBLE_TREE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), r.getSubtreeBaseDN(), r.getAccessibilityState().getStateName());
                break;
            }
        }
        if (sourceRestriction == null && targetRestriction == null) {
            return null;
        }
        if (sourceMatch || targetMatch) {
            if (sourceRestriction != null && sourceRestriction.getAccessibilityState().isReadOnly() && targetRestriction != null && targetRestriction.getAccessibilityState().isHidden()) {
                return new MoveSubtreeResult(ResultCode.UNWILLING_TO_PERFORM, UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED_IN_ADDS.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()), UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED_IN_ADDS_ADMIN_MSG.get(), false, false, 0, 0, 0);
            }
            if (sourceRestriction != null && sourceRestriction.getAccessibilityState().isHidden() && targetRestriction == null) {
                return new MoveSubtreeResult(ResultCode.UNWILLING_TO_PERFORM, UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED_IN_DELETES.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()), UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED_IN_DELETES_ADMIN_MSG.get(), false, false, 0, 0, 0);
            }
        }
        StringBuilder details = new StringBuilder();
        if (sourceMessage != null) {
            details.append(sourceMessage);
        }
        if (targetMessage != null) {
            MoveSubtree.append(targetMessage, details);
        }
        return new MoveSubtreeResult(ResultCode.UNWILLING_TO_PERFORM, UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort(), details.toString()), null, false, false, 0, 0, 0);
    }

    private static void setAccessibility(LDAPConnection connection, boolean isSource, String baseDN, SubtreeAccessibilityState state, String bypassDN, OperationPurposeRequestControl opPurposeControl) throws LDAPException {
        LDAPResult result;
        SetSubtreeAccessibilityExtendedRequest request;
        String connectionName = isSource ? UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get() : UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get();
        Control[] controls = opPurposeControl == null ? StaticUtils.NO_CONTROLS : new Control[]{opPurposeControl};
        switch (state) {
            case ACCESSIBLE: {
                request = SetSubtreeAccessibilityExtendedRequest.createSetAccessibleRequest(baseDN, controls);
                break;
            }
            case READ_ONLY_BIND_ALLOWED: {
                request = SetSubtreeAccessibilityExtendedRequest.createSetReadOnlyRequest(baseDN, true, bypassDN, controls);
                break;
            }
            case READ_ONLY_BIND_DENIED: {
                request = SetSubtreeAccessibilityExtendedRequest.createSetReadOnlyRequest(baseDN, false, bypassDN, controls);
                break;
            }
            case HIDDEN: {
                request = SetSubtreeAccessibilityExtendedRequest.createSetHiddenRequest(baseDN, bypassDN, controls);
                break;
            }
            default: {
                throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_MOVE_SUBTREE_UNSUPPORTED_ACCESSIBILITY_STATE.get(state.getStateName(), baseDN, connectionName));
            }
        }
        try {
            result = connection.processExtendedOperation(request);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            result = le.toLDAPResult();
        }
        if (result.getResultCode() != ResultCode.SUCCESS) {
            throw new LDAPException(result.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_SETTING_ACCESSIBILITY.get(state.getStateName(), baseDN, connectionName, result.getDiagnosticMessage()));
        }
    }

    static void setInterruptMessage(MoveSubtree tool, String message) {
        if (tool != null) {
            tool.interruptMessage = message;
        }
    }

    private static boolean deleteEntries(LDAPConnection connection, boolean isSource, TreeSet<DN> entryDNs, OperationPurposeRequestControl opPurposeControl, boolean suppressRefInt, MoveSubtreeListener listener, AtomicInteger deleteCount, AtomicReference<ResultCode> resultCode, StringBuilder errorMsg) {
        ArrayList<Control> deleteControlList = new ArrayList<Control>(3);
        deleteControlList.add(new ManageDsaITRequestControl(true));
        if (opPurposeControl != null) {
            deleteControlList.add(opPurposeControl);
        }
        if (suppressRefInt) {
            deleteControlList.add(new SuppressReferentialIntegrityUpdatesRequestControl(false));
        }
        Control[] deleteControls = new Control[deleteControlList.size()];
        deleteControlList.toArray(deleteControls);
        boolean successful = true;
        for (DN dn : entryDNs) {
            LDAPResult deleteResult;
            if (isSource && listener != null) {
                try {
                    listener.doPreDeleteProcessing(dn);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_PRE_DELETE_FAILURE.get(dn.toString(), StaticUtils.getExceptionMessage(e)), errorMsg);
                    successful = false;
                    continue;
                }
            }
            try {
                deleteResult = connection.delete(new DeleteRequest(dn, deleteControls));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                deleteResult = le.toLDAPResult();
            }
            if (deleteResult.getResultCode() != ResultCode.SUCCESS) {
                resultCode.compareAndSet(null, deleteResult.getResultCode());
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_DELETE_FAILURE.get(dn.toString(), deleteResult.getDiagnosticMessage()), errorMsg);
                successful = false;
                continue;
            }
            deleteCount.incrementAndGet();
            if (!isSource || listener == null) continue;
            try {
                listener.doPostDeleteProcessing(dn);
            }
            catch (Exception e) {
                Debug.debugException(e);
                resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_POST_DELETE_FAILURE.get(dn.toString(), StaticUtils.getExceptionMessage(e)), errorMsg);
                successful = false;
            }
        }
        return successful;
    }

    static void append(String message, StringBuilder buffer) {
        if (message != null) {
            if (buffer.length() > 0) {
                buffer.append("  ");
            }
            buffer.append(message);
        }
    }

    @Override
    public void handleUnsolicitedNotification(LDAPConnection connection, ExtendedResult notification) {
        this.wrapOut(0, 79, UnboundIDDSMessages.INFO_MOVE_SUBTREE_UNSOLICITED_NOTIFICATION.get(notification.getOID(), connection.getConnectionName(), notification.getResultCode(), notification.getDiagnosticMessage()));
    }

    @Override
    public ReadOnlyEntry doPreAddProcessing(ReadOnlyEntry entry) {
        return entry;
    }

    @Override
    public void doPostAddProcessing(ReadOnlyEntry entry) {
        this.wrapOut(0, 79, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ADD_SUCCESSFUL.get(entry.getDN()));
    }

    @Override
    public void doPreDeleteProcessing(DN entryDN) {
    }

    @Override
    public void doPostDeleteProcessing(DN entryDN) {
        this.wrapOut(0, 79, UnboundIDDSMessages.INFO_MOVE_SUBTREE_DELETE_SUCCESSFUL.get(entryDN.toString()));
    }

    @Override
    protected boolean registerShutdownHook() {
        return true;
    }

    @Override
    protected void doShutdownHookProcessing(ResultCode resultCode) {
        if (resultCode != null) {
            return;
        }
        this.wrapErr(0, 79, this.interruptMessage);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        String[] args = new String[]{"--sourceHostname", "ds1.example.com", "--sourcePort", "389", "--sourceBindDN", "uid=admin,dc=example,dc=com", "--sourceBindPassword", "password", "--targetHostname", "ds2.example.com", "--targetPort", "389", "--targetBindDN", "uid=admin,dc=example,dc=com", "--targetBindPassword", "password", "--baseDN", "cn=small subtree,dc=example,dc=com", "--sizeLimit", "100", "--purpose", "Migrate a small subtree from ds1 to ds2"};
        exampleMap.put(args, UnboundIDDSMessages.INFO_MOVE_SUBTREE_EXAMPLE_DESCRIPTION.get());
        return exampleMap;
    }
}

