/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.WrapperKeyManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class KeyStoreKeyManager
extends WrapperKeyManager
implements Serializable {
    private static final long serialVersionUID = -5202641256733094253L;
    private final String keyStoreFile;
    private final String keyStoreFormat;

    public KeyStoreKeyManager(File keyStoreFile, char[] keyStorePIN) throws KeyStoreException {
        this(keyStoreFile.getAbsolutePath(), keyStorePIN, null, null);
    }

    public KeyStoreKeyManager(String keyStoreFile, char[] keyStorePIN) throws KeyStoreException {
        this(keyStoreFile, keyStorePIN, null, null);
    }

    public KeyStoreKeyManager(File keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias) throws KeyStoreException {
        this(keyStoreFile.getAbsolutePath(), keyStorePIN, keyStoreFormat, certificateAlias);
    }

    public KeyStoreKeyManager(String keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias) throws KeyStoreException {
        this(keyStoreFile, keyStorePIN, keyStoreFormat, certificateAlias, false);
    }

    public KeyStoreKeyManager(File keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias, boolean validateKeyStore) throws KeyStoreException {
        this(keyStoreFile.getAbsolutePath(), keyStorePIN, keyStoreFormat, certificateAlias, validateKeyStore);
    }

    public KeyStoreKeyManager(String keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias, boolean validateKeyStore) throws KeyStoreException {
        super(KeyStoreKeyManager.getKeyManagers(keyStoreFile, keyStorePIN, keyStoreFormat, certificateAlias, validateKeyStore), certificateAlias);
        this.keyStoreFile = keyStoreFile;
        this.keyStoreFormat = keyStoreFormat == null ? KeyStore.getDefaultType() : keyStoreFormat;
    }

    private static KeyManager[] getKeyManagers(String keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias, boolean validateKeyStore) throws KeyStoreException {
        File f;
        Validator.ensureNotNull(keyStoreFile);
        String type = keyStoreFormat;
        if (type == null) {
            type = KeyStore.getDefaultType();
        }
        if (!(f = new File(keyStoreFile)).exists()) {
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_NO_SUCH_FILE.get(keyStoreFile));
        }
        KeyStore ks = KeyStore.getInstance(type);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
            ks.load(inputStream, keyStorePIN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CANNOT_LOAD.get(keyStoreFile, type, String.valueOf(e)), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        if (validateKeyStore) {
            KeyStoreKeyManager.validateKeyStore(ks, f, keyStorePIN, certificateAlias);
        }
        try {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(ks, keyStorePIN);
            return factory.getKeyManagers();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CANNOT_GET_KEY_MANAGERS.get(keyStoreFile, keyStoreFormat, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static void validateKeyStore(KeyStore keyStore, File keyStoreFile, char[] keyStorePIN, String certificateAlias) throws KeyStoreException {
        KeyStore.PasswordProtection protectionParameter = keyStorePIN == null ? null : new KeyStore.PasswordProtection(keyStorePIN);
        try {
            if (certificateAlias == null) {
                StringBuilder invalidMessages = new StringBuilder();
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!keyStore.isKeyEntry(alias)) continue;
                    try {
                        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, protectionParameter);
                        KeyStoreKeyManager.ensureAllCertificatesInChainAreValid(alias, entry);
                        return;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        if (invalidMessages.length() > 0) {
                            invalidMessages.append("  ");
                        }
                        invalidMessages.append(e.getMessage());
                    }
                }
                if (invalidMessages.length() > 0) {
                    throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_NO_VALID_PRIVATE_KEY_ENTRIES.get(keyStoreFile.getAbsolutePath(), invalidMessages.toString()));
                }
                throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_NO_PRIVATE_KEY_ENTRIES.get(keyStoreFile.getAbsolutePath()));
            }
            if (!keyStore.containsAlias(certificateAlias)) {
                throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_NO_ENTRY_WITH_ALIAS.get(keyStoreFile.getAbsolutePath(), certificateAlias));
            }
            if (!keyStore.isKeyEntry(certificateAlias)) {
                throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_ENTRY_NOT_PRIVATE_KEY.get(certificateAlias, keyStoreFile.getAbsolutePath()));
            }
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(certificateAlias, protectionParameter);
            KeyStoreKeyManager.ensureAllCertificatesInChainAreValid(certificateAlias, entry);
        }
        catch (KeyStoreException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CANNOT_VALIDATE.get(keyStoreFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static void ensureAllCertificatesInChainAreValid(String alias, KeyStore.PrivateKeyEntry entry) throws KeyStoreException {
        Date currentTime = new Date();
        for (Certificate cert : entry.getCertificateChain()) {
            if (!(cert instanceof X509Certificate)) continue;
            X509Certificate c = (X509Certificate)cert;
            if (currentTime.before(c.getNotBefore())) {
                throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CERT_NOT_YET_VALID.get(alias, c.getSubjectX500Principal().getName("RFC2253"), String.valueOf(c.getNotBefore())));
            }
            if (!currentTime.after(c.getNotAfter())) continue;
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CERT_EXPIRED.get(alias, c.getSubjectX500Principal().getName("RFC2253"), String.valueOf(c.getNotAfter())));
        }
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }
}

