/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataOutputStream;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CollectSupportDataOutputIntermediateResponse
extends IntermediateResponse {
    public static final String COLLECT_SUPPORT_DATA_OUTPUT_INTERMEDIATE_RESPONSE_OID = "1.3.6.1.4.1.30221.2.6.65";
    private static final byte TYPE_OUTPUT_STREAM = -128;
    private static final byte TYPE_OUTPUT_MESSAGE = -127;
    private static final long serialVersionUID = -2844901273280769861L;
    private final CollectSupportDataOutputStream outputStream;
    private final String outputMessage;

    public CollectSupportDataOutputIntermediateResponse(CollectSupportDataOutputStream outputStream, String outputMessage, Control ... controls) {
        super(COLLECT_SUPPORT_DATA_OUTPUT_INTERMEDIATE_RESPONSE_OID, CollectSupportDataOutputIntermediateResponse.encodeValue(outputStream, outputMessage), controls);
        this.outputStream = outputStream;
        this.outputMessage = outputMessage;
    }

    private static ASN1OctetString encodeValue(CollectSupportDataOutputStream outputStream, String outputMessage) {
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1Enumerated(-128, outputStream.getIntValue()), new ASN1OctetString(-127, outputMessage));
        return new ASN1OctetString(valueSequence.encode());
    }

    public CollectSupportDataOutputIntermediateResponse(IntermediateResponse intermediateResponse) throws LDAPException {
        super(intermediateResponse);
        ASN1OctetString value = intermediateResponse.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_OUTPUT_IR_DECODE_NO_VALUE.get());
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            ASN1Element[] elements = valueSequence.elements();
            int outputStreamIntValue = ASN1Enumerated.decodeAsEnumerated(elements[0]).intValue();
            this.outputStream = CollectSupportDataOutputStream.forIntValue(outputStreamIntValue);
            if (this.outputStream == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_OUTPUT_IR_DECODE_UNRECOGNIZED_OUTPUT_STREAM.get(outputStreamIntValue));
            }
            this.outputMessage = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_OUTPUT_IR_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public CollectSupportDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getOutputMessage() {
        return this.outputMessage;
    }

    @Override
    public String getIntermediateResponseName() {
        return ExtOpMessages.INFO_COLLECT_SUPPORT_DATA_OUTPUT_IR_NAME.get();
    }

    @Override
    public String valueToString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("outputStream='");
        buffer.append(this.outputStream.getName());
        buffer.append("' outputMessage='");
        buffer.append(this.outputMessage);
        buffer.append('\'');
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("CollectSupportDataOutputIntermediateResponse(oid='");
        buffer.append(this.getOID());
        buffer.append("', outputStream='");
        buffer.append(this.outputStream.getName());
        buffer.append("', outputMessage='");
        buffer.append(this.outputMessage);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

