/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class HostSystemRecentCPUAndMemoryMonitorEntry
extends MonitorEntry {
    static final String HOST_SYSTEM_RECENT_CPU_AND_MEMORY_MONITOR_OC = "ds-host-system-cpu-memory-monitor-entry";
    private static final String ATTR_RECENT_CPU_IDLE = "recent-cpu-idle";
    private static final String ATTR_RECENT_CPU_IOWAIT = "recent-cpu-iowait";
    private static final String ATTR_RECENT_CPU_SYSTEM = "recent-cpu-system";
    private static final String ATTR_RECENT_TOTAL_CPU_BUSY = "recent-cpu-used";
    private static final String ATTR_RECENT_CPU_USER = "recent-cpu-user";
    private static final String ATTR_RECENT_MEMORY_FREE_GB = "recent-memory-free-gb";
    private static final String ATTR_RECENT_MEMORY_FREE_PCT = "recent-memory-pct-free";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_TOTAL_MEMORY_GB = "total-memory-gb";
    private static final long serialVersionUID = -4408434740529394905L;
    private final Date timestamp = this.getDate("timestamp");
    private final Double recentCPUIdle = this.getDouble("recent-cpu-idle");
    private final Double recentCPUIOWait = this.getDouble("recent-cpu-iowait");
    private final Double recentCPUSystem = this.getDouble("recent-cpu-system");
    private final Double recentCPUTotalBusy;
    private final Double recentCPUUser = this.getDouble("recent-cpu-user");
    private final Double recentMemoryFreeGB;
    private final Double recentMemoryPercentFree;
    private final Double totalMemoryGB;

    public HostSystemRecentCPUAndMemoryMonitorEntry(Entry entry) {
        super(entry);
        this.recentCPUTotalBusy = this.getDouble(ATTR_RECENT_TOTAL_CPU_BUSY);
        this.recentMemoryFreeGB = this.getDouble(ATTR_RECENT_MEMORY_FREE_GB);
        this.recentMemoryPercentFree = this.getDouble(ATTR_RECENT_MEMORY_FREE_PCT);
        this.totalMemoryGB = this.getDouble(ATTR_TOTAL_MEMORY_GB);
    }

    public Date getUpdateTime() {
        return this.timestamp;
    }

    public Double getRecentCPUTotalBusyPercent() {
        return this.recentCPUTotalBusy;
    }

    public Double getRecentCPUUserPercent() {
        return this.recentCPUUser;
    }

    public Double getRecentCPUSystemPercent() {
        return this.recentCPUSystem;
    }

    public Double getRecentCPUIOWaitPercent() {
        return this.recentCPUIOWait;
    }

    public Double getRecentCPUIdlePercent() {
        return this.recentCPUIdle;
    }

    public Double getTotalSystemMemoryGB() {
        return this.totalMemoryGB;
    }

    public Double getRecentSystemMemoryFreeGB() {
        return this.recentMemoryFreeGB;
    }

    public Double getRecentSystemMemoryPercentFree() {
        return this.recentMemoryPercentFree;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_CPU_MEM_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_CPU_MEM_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(9));
        if (this.timestamp != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_TIMESTAMP, MonitorMessages.INFO_CPU_MEM_DISPNAME_TIMESTAMP.get(), MonitorMessages.INFO_CPU_MEM_DESC_TIMESTAMP.get(), this.timestamp);
        }
        if (this.recentCPUTotalBusy != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_TOTAL_CPU_BUSY, MonitorMessages.INFO_CPU_MEM_DISPNAME_RECENT_CPU_TOTAL_BUSY.get(), MonitorMessages.INFO_CPU_MEM_DESC_RECENT_CPU_TOTAL_BUSY.get(), this.recentCPUTotalBusy);
        }
        if (this.recentCPUUser != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_CPU_USER, MonitorMessages.INFO_CPU_MEM_DISPNAME_RECENT_CPU_USER.get(), MonitorMessages.INFO_CPU_MEM_DESC_RECENT_CPU_USER.get(), this.recentCPUUser);
        }
        if (this.recentCPUSystem != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_CPU_SYSTEM, MonitorMessages.INFO_CPU_MEM_DISPNAME_RECENT_CPU_SYSTEM.get(), MonitorMessages.INFO_CPU_MEM_DESC_RECENT_CPU_SYSTEM.get(), this.recentCPUSystem);
        }
        if (this.recentCPUIOWait != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_CPU_IOWAIT, MonitorMessages.INFO_CPU_MEM_DISPNAME_RECENT_CPU_IOWAIT.get(), MonitorMessages.INFO_CPU_MEM_DESC_RECENT_CPU_IOWAIT.get(), this.recentCPUIOWait);
        }
        if (this.recentCPUIdle != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_CPU_IDLE, MonitorMessages.INFO_CPU_MEM_DISPNAME_RECENT_CPU_IDLE.get(), MonitorMessages.INFO_CPU_MEM_DESC_RECENT_CPU_IDLE.get(), this.recentCPUIdle);
        }
        if (this.totalMemoryGB != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_MEMORY_GB, MonitorMessages.INFO_CPU_MEM_DISPNAME_TOTAL_MEM.get(), MonitorMessages.INFO_CPU_MEM_DESC_TOTAL_MEM.get(), this.totalMemoryGB);
        }
        if (this.recentMemoryFreeGB != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_MEMORY_FREE_GB, MonitorMessages.INFO_CPU_MEM_DISPNAME_FREE_MEM_GB.get(), MonitorMessages.INFO_CPU_MEM_DESC_FREE_MEM_GB.get(), this.recentMemoryFreeGB);
        }
        if (this.recentMemoryPercentFree != null) {
            HostSystemRecentCPUAndMemoryMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_MEMORY_FREE_PCT, MonitorMessages.INFO_CPU_MEM_DISPNAME_FREE_MEM_PCT.get(), MonitorMessages.INFO_CPU_MEM_DESC_FREE_MEM_PCT.get(), this.recentMemoryPercentFree);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

