/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class ServerSet {
    protected ServerSet() {
    }

    public boolean includesAuthentication() {
        return false;
    }

    public boolean includesPostConnectProcessing() {
        return false;
    }

    @NotNull
    public abstract LDAPConnection getConnection() throws LDAPException;

    @NotNull
    public LDAPConnection getConnection(@Nullable LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        LDAPConnection c = this.getConnection();
        if (healthCheck != null) {
            try {
                healthCheck.ensureNewConnectionValid(c);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                c.close();
                throw le;
            }
        }
        return c;
    }

    protected static void doBindPostConnectAndHealthCheckProcessing(@NotNull LDAPConnection connection, @Nullable BindRequest bindRequest, @Nullable PostConnectProcessor postConnectProcessor, @Nullable LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        try {
            if (postConnectProcessor != null) {
                postConnectProcessor.processPreAuthenticatedConnection(connection);
            }
            if (bindRequest != null) {
                BindResult bindResult;
                LDAPException bindException = null;
                try {
                    bindResult = connection.bind(bindRequest.duplicate());
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    bindException = le;
                    bindResult = new BindResult(le);
                }
                if (healthCheck != null) {
                    healthCheck.ensureConnectionValidAfterAuthentication(connection, bindResult);
                }
                if (bindException != null) {
                    throw bindException;
                }
            }
            if (postConnectProcessor != null) {
                postConnectProcessor.processPostAuthenticatedConnection(connection);
            }
            if (healthCheck != null) {
                healthCheck.ensureNewConnectionValid(connection);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.closeWithoutUnbind();
            throw le;
        }
    }

    protected final void associateConnectionWithThisServerSet(@NotNull LDAPConnection connection) {
        if (connection != null) {
            connection.setServerSet(this);
        }
    }

    protected void handleConnectionClosed(@NotNull LDAPConnection connection, @NotNull String host, int port, @NotNull DisconnectType disconnectType, @Nullable String message, @Nullable Throwable cause) {
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ServerSet(className=");
        buffer.append(this.getClass().getName());
        buffer.append(')');
    }
}

