/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearch;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.NotNull;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class ColumnFormatterLDAPSearchOutputHandler
extends LDAPSearchOutputHandler {
    @NotNull
    private final ArrayList<String> formattedLines;
    private final boolean includeAllValues;
    @NotNull
    private final ColumnFormatter formatter;
    private final int maxCommentWidth;
    @NotNull
    private final LDAPSearch ldapSearch;
    @NotNull
    private final Object[] columnValues;
    @NotNull
    private final String[] attributes;
    @NotNull
    private final StringBuilder formattedLineBuffer;

    ColumnFormatterLDAPSearchOutputHandler(@NotNull LDAPSearch ldapSearch, @NotNull OutputFormat outputFormat, @NotNull List<String> requestedAttributes, int maxCommentWidth, boolean includeAllValues) {
        this.ldapSearch = ldapSearch;
        this.maxCommentWidth = maxCommentWidth;
        this.includeAllValues = includeAllValues;
        this.attributes = new String[requestedAttributes.size()];
        requestedAttributes.toArray(this.attributes);
        this.columnValues = new Object[this.attributes.length + 1];
        FormattableColumn[] columns = new FormattableColumn[this.attributes.length + 1];
        columns[0] = new FormattableColumn(10, HorizontalAlignment.LEFT, "DN");
        for (int i = 0; i < this.attributes.length; ++i) {
            columns[i + 1] = new FormattableColumn(10, HorizontalAlignment.LEFT, this.attributes[i]);
        }
        this.formatter = new ColumnFormatter(false, null, outputFormat, " ", columns);
        this.formattedLines = new ArrayList(20);
        this.formattedLineBuffer = new StringBuilder(100);
    }

    @Override
    public void formatHeader() {
        for (String headerLine : this.formatter.getHeaderLines(false)) {
            this.ldapSearch.writeOut("# " + headerLine);
        }
    }

    @Override
    public void formatSearchResultEntry(@NotNull SearchResultEntry entry) {
        this.columnValues[0] = entry.getDN();
        int i = 1;
        for (String attributeName : this.attributes) {
            Attribute a = entry.getAttribute(attributeName);
            if (a == null || a.size() == 0) {
                this.columnValues[i] = "";
            } else if (this.includeAllValues && a.size() > 1) {
                StringBuilder buffer = new StringBuilder();
                for (String v : a.getValues()) {
                    if (buffer.length() > 0) {
                        buffer.append('|');
                    }
                    buffer.append(v);
                }
                this.columnValues[i] = buffer.toString();
            } else {
                this.columnValues[i] = a.getValue();
            }
            ++i;
        }
        this.ldapSearch.writeOut(this.formatter.formatRow(this.columnValues));
    }

    @Override
    public void formatSearchResultReference(@NotNull SearchResultReference ref) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatSearchResultReference(this.formattedLines, ref, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }

    @Override
    public void formatResult(@NotNull LDAPResult result) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatResult(this.formattedLines, result, true, false, 0, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }

    @Override
    public void formatUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatUnsolicitedNotification(this.formattedLines, notification, true, 0, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }
}

