/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearch;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchOutputHandler;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class DNsOnlyLDAPSearchOutputHandler
extends LDAPSearchOutputHandler {
    @NotNull
    private final LDAPSearch ldapSearch;

    DNsOnlyLDAPSearchOutputHandler(@NotNull LDAPSearch ldapSearch) {
        this.ldapSearch = ldapSearch;
    }

    @Override
    public void formatHeader() {
    }

    @Override
    public void formatSearchResultEntry(@NotNull SearchResultEntry entry) {
        this.ldapSearch.getOutStream().println(entry.getDN());
    }

    @Override
    public void formatSearchResultReference(@NotNull SearchResultReference ref) {
    }

    @Override
    public void formatResult(@NotNull LDAPResult result) {
        this.ldapSearch.getOutStream().flush();
    }

    @Override
    public void formatUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        this.ldapSearch.getOutStream().flush();
    }
}

