/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BitString;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1ObjectIdentifier;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.DecodedPublicKey;
import com.unboundid.util.ssl.cert.EllipticCurvePublicKey;
import com.unboundid.util.ssl.cert.NamedCurve;
import com.unboundid.util.ssl.cert.PKCS10CertificateSigningRequestVersion;
import com.unboundid.util.ssl.cert.PublicKeyAlgorithmIdentifier;
import com.unboundid.util.ssl.cert.RSAPublicKey;
import com.unboundid.util.ssl.cert.SignatureAlgorithmIdentifier;
import com.unboundid.util.ssl.cert.SubjectKeyIdentifierExtension;
import com.unboundid.util.ssl.cert.X509Certificate;
import com.unboundid.util.ssl.cert.X509CertificateExtension;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PKCS10CertificateSigningRequest
implements Serializable {
    private static final byte TYPE_ATTRIBUTES = -96;
    @NotNull
    private static final OID ATTRIBUTE_OID_EXTENSIONS = new OID("1.2.840.113549.1.9.14");
    private static final long serialVersionUID = -1665446530589389194L;
    @NotNull
    private final ASN1BitString signatureValue;
    @NotNull
    private final ASN1BitString encodedPublicKey;
    @Nullable
    private final ASN1Element publicKeyAlgorithmParameters;
    @Nullable
    private final ASN1Element signatureAlgorithmParameters;
    @NotNull
    private final byte[] pkcs10CertificateSigningRequestBytes;
    @Nullable
    private final DecodedPublicKey decodedPublicKey;
    @NotNull
    private final DN subjectDN;
    @NotNull
    private final List<ObjectPair<OID, ASN1Set>> requestAttributes;
    @NotNull
    private final List<X509CertificateExtension> extensions;
    @NotNull
    private final OID publicKeyAlgorithmOID;
    @NotNull
    private final OID signatureAlgorithmOID;
    @NotNull
    private final PKCS10CertificateSigningRequestVersion version;
    @Nullable
    private final String publicKeyAlgorithmName;
    @Nullable
    private final String signatureAlgorithmName;

    PKCS10CertificateSigningRequest(@NotNull PKCS10CertificateSigningRequestVersion version, @NotNull OID signatureAlgorithmOID, @Nullable ASN1Element signatureAlgorithmParameters, @NotNull ASN1BitString signatureValue, @NotNull DN subjectDN, @NotNull OID publicKeyAlgorithmOID, @Nullable ASN1Element publicKeyAlgorithmParameters, @NotNull ASN1BitString encodedPublicKey, @Nullable DecodedPublicKey decodedPublicKey, @Nullable List<ObjectPair<OID, ASN1Set>> nonExtensionAttributes, X509CertificateExtension ... extensions) throws CertException {
        this.version = version;
        this.signatureAlgorithmOID = signatureAlgorithmOID;
        this.signatureAlgorithmParameters = signatureAlgorithmParameters;
        this.signatureValue = signatureValue;
        this.subjectDN = subjectDN;
        this.publicKeyAlgorithmOID = publicKeyAlgorithmOID;
        this.publicKeyAlgorithmParameters = publicKeyAlgorithmParameters;
        this.encodedPublicKey = encodedPublicKey;
        this.decodedPublicKey = decodedPublicKey;
        this.extensions = StaticUtils.toList(extensions);
        SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.forOID(signatureAlgorithmOID);
        this.signatureAlgorithmName = signatureAlgorithmIdentifier == null ? null : signatureAlgorithmIdentifier.getUserFriendlyName();
        PublicKeyAlgorithmIdentifier publicKeyAlgorithmIdentifier = PublicKeyAlgorithmIdentifier.forOID(publicKeyAlgorithmOID);
        this.publicKeyAlgorithmName = publicKeyAlgorithmIdentifier == null ? null : publicKeyAlgorithmIdentifier.getName();
        ArrayList<ObjectPair<OID, ASN1Set>> attrs = new ArrayList<ObjectPair<OID, ASN1Set>>(10);
        if (nonExtensionAttributes != null) {
            attrs.addAll(nonExtensionAttributes);
        }
        if (extensions.length > 0) {
            ArrayList<ASN1Sequence> extensionElements = new ArrayList<ASN1Sequence>(extensions.length);
            for (X509CertificateExtension e : extensions) {
                extensionElements.add(e.encode());
            }
            attrs.add(new ObjectPair<OID, ASN1Set>(ATTRIBUTE_OID_EXTENSIONS, new ASN1Set(new ASN1Sequence(extensionElements))));
        }
        this.requestAttributes = Collections.unmodifiableList(attrs);
        this.pkcs10CertificateSigningRequestBytes = this.encode().encode();
    }

    public PKCS10CertificateSigningRequest(@NotNull byte[] encodedRequest) throws CertException {
        ASN1Element[] requestInfoElements;
        ASN1Element[] requestElements;
        this.pkcs10CertificateSigningRequestBytes = encodedRequest;
        try {
            requestElements = ASN1Sequence.decodeAsSequence(encodedRequest).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_DECODE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (requestElements.length != 3) {
            throw new CertException(CertMessages.ERR_CSR_DECODE_UNEXPECTED_SEQUENCE_ELEMENT_COUNT.get(requestElements.length));
        }
        try {
            requestInfoElements = ASN1Sequence.decodeAsSequence(requestElements[0]).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_DECODE_FIRST_ELEMENT_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            int versionIntValue = requestInfoElements[0].decodeAsInteger().intValue();
            this.version = PKCS10CertificateSigningRequestVersion.valueOf(versionIntValue);
            if (this.version == null) {
                throw new CertException(CertMessages.ERR_CSR_DECODE_UNSUPPORTED_VERSION.get(new Object[]{this.version}));
            }
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_DECODE_CANNOT_PARSE_VERSION.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            this.subjectDN = X509Certificate.decodeName(requestInfoElements[1]);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_DECODE_CANNOT_PARSE_SUBJECT_DN.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ASN1Element[] subjectPublicKeyInfoElements = requestInfoElements[2].decodeAsSequence().elements();
            ASN1Element[] publicKeyAlgorithmElements = subjectPublicKeyInfoElements[0].decodeAsSequence().elements();
            this.publicKeyAlgorithmOID = publicKeyAlgorithmElements[0].decodeAsObjectIdentifier().getOID();
            this.publicKeyAlgorithmParameters = publicKeyAlgorithmElements.length > 1 ? publicKeyAlgorithmElements[1] : null;
            this.encodedPublicKey = subjectPublicKeyInfoElements[1].decodeAsBitString();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_DECODE_CANNOT_PARSE_PUBLIC_KEY_INFO.get(StaticUtils.getExceptionMessage(e)), e);
        }
        PublicKeyAlgorithmIdentifier publicKeyAlgorithmIdentifier = PublicKeyAlgorithmIdentifier.forOID(this.publicKeyAlgorithmOID);
        if (publicKeyAlgorithmIdentifier == null) {
            this.publicKeyAlgorithmName = null;
            this.decodedPublicKey = null;
        } else {
            this.publicKeyAlgorithmName = publicKeyAlgorithmIdentifier.getName();
            DecodedPublicKey pk = null;
            switch (publicKeyAlgorithmIdentifier) {
                case RSA: {
                    try {
                        pk = new RSAPublicKey(this.encodedPublicKey);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    break;
                }
                case EC: {
                    try {
                        pk = new EllipticCurvePublicKey(this.encodedPublicKey);
                        break;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
            }
            this.decodedPublicKey = pk;
        }
        ArrayList<ObjectPair<OID, ASN1Set>> attrList = new ArrayList<ObjectPair<OID, ASN1Set>>(10);
        ArrayList<X509CertificateExtension> extList = new ArrayList<X509CertificateExtension>(10);
        if (requestInfoElements.length > 3) {
            for (int i = 3; i < requestInfoElements.length; ++i) {
                ASN1Element element = requestInfoElements[i];
                if (element.getType() != -96) continue;
                try {
                    for (ASN1Element attrSetElement : element.decodeAsSet().elements()) {
                        ASN1Element[] attrElements = attrSetElement.decodeAsSequence().elements();
                        OID attrOID = attrElements[0].decodeAsObjectIdentifier().getOID();
                        ASN1Set attrValues = attrElements[1].decodeAsSet();
                        attrList.add(new ObjectPair<OID, ASN1Set>(attrOID, attrValues));
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new CertException(CertMessages.ERR_CSR_DECODE_CANNOT_PARSE_ATTRS.get(StaticUtils.getExceptionMessage(e)), e);
                }
                for (ObjectPair objectPair : attrList) {
                    if (!((OID)objectPair.getFirst()).equals(ATTRIBUTE_OID_EXTENSIONS)) continue;
                    try {
                        for (ASN1Element extElement : ((ASN1Set)objectPair.getSecond()).elements()[0].decodeAsSequence().elements()) {
                            extList.add(X509CertificateExtension.decode(extElement));
                        }
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new CertException(CertMessages.ERR_CSR_DECODE_CANNOT_PARSE_EXT_ATTR.get(objectPair.getFirst(), StaticUtils.getExceptionMessage(e)), e);
                    }
                }
            }
        }
        this.requestAttributes = Collections.unmodifiableList(attrList);
        this.extensions = Collections.unmodifiableList(extList);
        try {
            ASN1Element[] signatureAlgorithmElements = requestElements[1].decodeAsSequence().elements();
            this.signatureAlgorithmOID = signatureAlgorithmElements[0].decodeAsObjectIdentifier().getOID();
            this.signatureAlgorithmParameters = signatureAlgorithmElements.length > 1 ? signatureAlgorithmElements[1] : null;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_DECODE_CANNOT_PARSE_SIG_ALG.get(StaticUtils.getExceptionMessage(e)), e);
        }
        SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.forOID(this.signatureAlgorithmOID);
        this.signatureAlgorithmName = signatureAlgorithmIdentifier == null ? null : signatureAlgorithmIdentifier.getUserFriendlyName();
        try {
            this.signatureValue = requestElements[2].decodeAsBitString();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_DECODE_CANNOT_PARSE_SIG_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private ASN1Element encode() throws CertException {
        try {
            ArrayList<ASN1Element> requestInfoElements = new ArrayList<ASN1Element>(4);
            requestInfoElements.add(new ASN1Integer(this.version.getIntValue()));
            requestInfoElements.add(X509Certificate.encodeName(this.subjectDN));
            if (this.publicKeyAlgorithmParameters == null) {
                requestInfoElements.add(new ASN1Sequence(new ASN1Sequence(new ASN1ObjectIdentifier(this.publicKeyAlgorithmOID)), this.encodedPublicKey));
            } else {
                requestInfoElements.add(new ASN1Sequence(new ASN1Sequence(new ASN1ObjectIdentifier(this.publicKeyAlgorithmOID), this.publicKeyAlgorithmParameters), this.encodedPublicKey));
            }
            ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(this.requestAttributes.size());
            for (ObjectPair<OID, ASN1Set> attr : this.requestAttributes) {
                attrElements.add(new ASN1Sequence(new ASN1ObjectIdentifier(attr.getFirst()), attr.getSecond()));
            }
            requestInfoElements.add(new ASN1Set(-96, attrElements));
            ArrayList<ASN1Element> certificationRequestElements = new ArrayList<ASN1Element>(3);
            certificationRequestElements.add(new ASN1Sequence(requestInfoElements));
            if (this.signatureAlgorithmParameters == null) {
                certificationRequestElements.add(new ASN1Sequence(new ASN1ObjectIdentifier(this.signatureAlgorithmOID)));
            } else {
                certificationRequestElements.add(new ASN1Sequence(new ASN1ObjectIdentifier(this.signatureAlgorithmOID), this.signatureAlgorithmParameters));
            }
            certificationRequestElements.add(this.signatureValue);
            return new ASN1Sequence(certificationRequestElements);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_ENCODE_ERROR.get(this.toString(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static PKCS10CertificateSigningRequest generateCertificateSigningRequest(@NotNull SignatureAlgorithmIdentifier signatureAlgorithm, @NotNull KeyPair keyPair, @NotNull DN subjectDN, X509CertificateExtension ... extensions) throws CertException {
        byte[] subjectKeyIdentifier;
        ASN1BitString encodedPublicKey;
        ASN1Element publicKeyAlgorithmParameters;
        OID publicKeyAlgorithmOID;
        DecodedPublicKey decodedPublicKey = null;
        try {
            ASN1Element[] pkElements = ASN1Sequence.decodeAsSequence(keyPair.getPublic().getEncoded()).elements();
            ASN1Element[] pkAlgIDElements = ASN1Sequence.decodeAsSequence(pkElements[0]).elements();
            publicKeyAlgorithmOID = pkAlgIDElements[0].decodeAsObjectIdentifier().getOID();
            publicKeyAlgorithmParameters = pkAlgIDElements.length == 1 ? null : pkAlgIDElements[1];
            encodedPublicKey = pkElements[1].decodeAsBitString();
            try {
                if (publicKeyAlgorithmOID.equals(PublicKeyAlgorithmIdentifier.RSA.getOID())) {
                    decodedPublicKey = new RSAPublicKey(encodedPublicKey);
                } else if (publicKeyAlgorithmOID.equals(PublicKeyAlgorithmIdentifier.EC.getOID())) {
                    decodedPublicKey = new EllipticCurvePublicKey(encodedPublicKey);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            MessageDigest sha256 = MessageDigest.getInstance("SHA-1");
            subjectKeyIdentifier = sha256.digest(encodedPublicKey.getBytes());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_GEN_CANNOT_PARSE_KEY_PAIR.get(StaticUtils.getExceptionMessage(e)), e);
        }
        ArrayList<X509CertificateExtension> extensionList = new ArrayList<X509CertificateExtension>(10);
        extensionList.add(new SubjectKeyIdentifierExtension(false, new ASN1OctetString(subjectKeyIdentifier)));
        if (extensions != null) {
            for (X509CertificateExtension e : extensions) {
                if (e.getOID().equals(SubjectKeyIdentifierExtension.SUBJECT_KEY_IDENTIFIER_OID)) continue;
                extensionList.add(e);
            }
        }
        X509CertificateExtension[] allExtensions = new X509CertificateExtension[extensionList.size()];
        extensionList.toArray(allExtensions);
        ASN1BitString encodedSignature = PKCS10CertificateSigningRequest.generateSignature(signatureAlgorithm, keyPair.getPrivate(), subjectDN, publicKeyAlgorithmOID, publicKeyAlgorithmParameters, encodedPublicKey, allExtensions);
        return new PKCS10CertificateSigningRequest(PKCS10CertificateSigningRequestVersion.V1, signatureAlgorithm.getOID(), null, encodedSignature, subjectDN, publicKeyAlgorithmOID, publicKeyAlgorithmParameters, encodedPublicKey, decodedPublicKey, null, allExtensions);
    }

    @NotNull
    private static ASN1BitString generateSignature(@NotNull SignatureAlgorithmIdentifier signatureAlgorithm, @NotNull PrivateKey privateKey, @NotNull DN subjectDN, @NotNull OID publicKeyAlgorithmOID, @Nullable ASN1Element publicKeyAlgorithmParameters, @NotNull ASN1BitString encodedPublicKey, X509CertificateExtension ... extensions) throws CertException {
        Signature signature;
        try {
            signature = Signature.getInstance(signatureAlgorithm.getJavaName());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_GEN_SIGNATURE_CANNOT_GET_SIGNATURE_GENERATOR.get(signatureAlgorithm.getJavaName(), StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_GEN_SIGNATURE_CANNOT_INIT_SIGNATURE_GENERATOR.get(signatureAlgorithm.getJavaName(), StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ArrayList<ASN1Element> requestInfoElements = new ArrayList<ASN1Element>(4);
            requestInfoElements.add(new ASN1Integer(PKCS10CertificateSigningRequestVersion.V1.getIntValue()));
            requestInfoElements.add(X509Certificate.encodeName(subjectDN));
            if (publicKeyAlgorithmParameters == null) {
                requestInfoElements.add(new ASN1Sequence(new ASN1Sequence(new ASN1ObjectIdentifier(publicKeyAlgorithmOID)), encodedPublicKey));
            } else {
                requestInfoElements.add(new ASN1Sequence(new ASN1Sequence(new ASN1ObjectIdentifier(publicKeyAlgorithmOID), publicKeyAlgorithmParameters), encodedPublicKey));
            }
            ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(1);
            if (extensions != null && extensions.length > 0) {
                ArrayList<ASN1Sequence> extensionElements = new ArrayList<ASN1Sequence>(extensions.length);
                for (X509CertificateExtension e : extensions) {
                    extensionElements.add(e.encode());
                }
                attrElements.add(new ASN1Sequence(new ASN1ObjectIdentifier(ATTRIBUTE_OID_EXTENSIONS), new ASN1Set(new ASN1Sequence(extensionElements))));
            }
            requestInfoElements.add(new ASN1Set(-96, attrElements));
            byte[] certificationRequestInfoBytes = new ASN1Sequence(requestInfoElements).encode();
            signature.update(certificationRequestInfoBytes);
            byte[] signatureBytes = signature.sign();
            return new ASN1BitString(ASN1BitString.getBitsForBytes(signatureBytes));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_GEN_SIGNATURE_CANNOT_COMPUTE.get(signatureAlgorithm.getJavaName(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public byte[] getPKCS10CertificateSigningRequestBytes() {
        return this.pkcs10CertificateSigningRequestBytes;
    }

    @NotNull
    public PKCS10CertificateSigningRequestVersion getVersion() {
        return this.version;
    }

    @NotNull
    public OID getSignatureAlgorithmOID() {
        return this.signatureAlgorithmOID;
    }

    @Nullable
    public String getSignatureAlgorithmName() {
        return this.signatureAlgorithmName;
    }

    @NotNull
    public String getSignatureAlgorithmNameOrOID() {
        if (this.signatureAlgorithmName != null) {
            return this.signatureAlgorithmName;
        }
        return this.signatureAlgorithmOID.toString();
    }

    @Nullable
    public ASN1Element getSignatureAlgorithmParameters() {
        return this.signatureAlgorithmParameters;
    }

    @NotNull
    public DN getSubjectDN() {
        return this.subjectDN;
    }

    @NotNull
    public OID getPublicKeyAlgorithmOID() {
        return this.publicKeyAlgorithmOID;
    }

    @Nullable
    public String getPublicKeyAlgorithmName() {
        return this.publicKeyAlgorithmName;
    }

    @NotNull
    public String getPublicKeyAlgorithmNameOrOID() {
        if (this.publicKeyAlgorithmName != null) {
            return this.publicKeyAlgorithmName;
        }
        return this.publicKeyAlgorithmOID.toString();
    }

    @Nullable
    public ASN1Element getPublicKeyAlgorithmParameters() {
        return this.publicKeyAlgorithmParameters;
    }

    @NotNull
    public ASN1BitString getEncodedPublicKey() {
        return this.encodedPublicKey;
    }

    @Nullable
    public DecodedPublicKey getDecodedPublicKey() {
        return this.decodedPublicKey;
    }

    @NotNull
    public List<ObjectPair<OID, ASN1Set>> getRequestAttributes() {
        return this.requestAttributes;
    }

    @NotNull
    public List<X509CertificateExtension> getExtensions() {
        return this.extensions;
    }

    @NotNull
    public ASN1BitString getSignatureValue() {
        return this.signatureValue;
    }

    public void verifySignature() throws CertException {
        boolean signatureIsValid;
        Signature signature;
        SignatureAlgorithmIdentifier signatureAlgorithm;
        PublicKey publicKey;
        try {
            byte[] encodedPublicKeyBytes = this.publicKeyAlgorithmParameters == null ? new ASN1Sequence(new ASN1Sequence(new ASN1ObjectIdentifier(this.publicKeyAlgorithmOID)), this.encodedPublicKey).encode() : new ASN1Sequence(new ASN1Sequence(new ASN1ObjectIdentifier(this.publicKeyAlgorithmOID), this.publicKeyAlgorithmParameters), this.encodedPublicKey).encode();
            KeyFactory keyFactory = KeyFactory.getInstance(this.getPublicKeyAlgorithmNameOrOID());
            publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedPublicKeyBytes));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_VERIFY_SIGNATURE_CANNOT_GET_PUBLIC_KEY.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            signatureAlgorithm = SignatureAlgorithmIdentifier.forOID(this.signatureAlgorithmOID);
            signature = Signature.getInstance(signatureAlgorithm.getJavaName());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_VERIFY_SIGNATURE_CANNOT_GET_SIGNATURE_VERIFIER.get(this.getSignatureAlgorithmNameOrOID(), StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            signature.initVerify(publicKey);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_VERIFY_SIGNATURE_CANNOT_INIT_SIGNATURE_VERIFIER.get(signatureAlgorithm.getJavaName(), StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ASN1Element[] requestInfoElements = ASN1Sequence.decodeAsSequence(this.pkcs10CertificateSigningRequestBytes).elements();
            byte[] requestInfoBytes = requestInfoElements[0].encode();
            signature.update(requestInfoBytes);
            signatureIsValid = signature.verify(this.signatureValue.getBytes());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CSR_VERIFY_SIGNATURE_ERROR.get(this.subjectDN, StaticUtils.getExceptionMessage(e)), e);
        }
        if (!signatureIsValid) {
            throw new CertException(CertMessages.ERR_CSR_VERIFY_SIGNATURE_NOT_VALID.get(this.subjectDN));
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PKCS10CertificateSigningRequest(version='");
        buffer.append(this.version.getName());
        buffer.append("', subjectDN='");
        buffer.append(this.subjectDN);
        buffer.append("', publicKeyAlgorithmOID='");
        buffer.append(this.publicKeyAlgorithmOID.toString());
        buffer.append('\'');
        if (this.publicKeyAlgorithmName != null) {
            buffer.append(", publicKeyAlgorithmName='");
            buffer.append(this.publicKeyAlgorithmName);
            buffer.append('\'');
        }
        buffer.append(", subjectPublicKey=");
        if (this.decodedPublicKey == null) {
            buffer.append('\'');
            try {
                StaticUtils.toHex(this.encodedPublicKey.getBytes(), ":", buffer);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.encodedPublicKey.toString(buffer);
            }
            buffer.append('\'');
        } else {
            this.decodedPublicKey.toString(buffer);
            if (this.decodedPublicKey instanceof EllipticCurvePublicKey) {
                try {
                    OID namedCurveOID = this.publicKeyAlgorithmParameters.decodeAsObjectIdentifier().getOID();
                    buffer.append(", ellipticCurvePublicKeyParameters=namedCurve='");
                    buffer.append(NamedCurve.getNameOrOID(namedCurveOID));
                    buffer.append('\'');
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        buffer.append(", signatureAlgorithmOID='");
        buffer.append(this.signatureAlgorithmOID.toString());
        buffer.append('\'');
        if (this.signatureAlgorithmName != null) {
            buffer.append(", signatureAlgorithmName='");
            buffer.append(this.signatureAlgorithmName);
            buffer.append('\'');
        }
        if (!this.extensions.isEmpty()) {
            buffer.append(", extensions={");
            Iterator<X509CertificateExtension> iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(", signatureValue='");
        try {
            StaticUtils.toHex(this.signatureValue.getBytes(), ":", buffer);
        }
        catch (Exception e) {
            Debug.debugException(e);
            buffer.append(this.signatureValue.toString());
        }
        buffer.append("')");
    }

    @NotNull
    public List<String> toPEM() {
        ArrayList<String> lines = new ArrayList<String>(10);
        lines.add("-----BEGIN CERTIFICATE REQUEST-----");
        String csrBase64 = Base64.encode(this.pkcs10CertificateSigningRequestBytes);
        lines.addAll(StaticUtils.wrapLine(csrBase64, 64));
        lines.add("-----END CERTIFICATE REQUEST-----");
        return Collections.unmodifiableList(lines);
    }

    @NotNull
    public String toPEMString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("-----BEGIN CERTIFICATE REQUEST-----");
        buffer.append(StaticUtils.EOL);
        String csrBase64 = Base64.encode(this.pkcs10CertificateSigningRequestBytes);
        for (String line : StaticUtils.wrapLine(csrBase64, 64)) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL);
        }
        buffer.append("-----END CERTIFICATE REQUEST-----");
        buffer.append(StaticUtils.EOL);
        return buffer.toString();
    }
}

