/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.RDNNameValuePair;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RDN
implements Comparable<RDN>,
Comparator<RDN>,
Serializable {
    private static final long serialVersionUID = 2923419812807188487L;
    @NotNull
    private final ASN1OctetString[] attributeValues;
    @Nullable
    private final Schema schema;
    @Nullable
    private volatile SortedSet<RDNNameValuePair> nameValuePairs;
    @Nullable
    private volatile String normalizedString;
    @Nullable
    private volatile String rdnString;
    @NotNull
    private final String[] attributeNames;

    public RDN(@NotNull String attributeName, @NotNull String attributeValue) {
        this(attributeName, attributeValue, null);
    }

    public RDN(@NotNull String attributeName, @NotNull String attributeValue, @Nullable Schema schema) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.schema = schema;
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{new ASN1OctetString(attributeValue)};
        this.nameValuePairs = null;
        this.normalizedString = null;
        this.rdnString = null;
    }

    public RDN(@NotNull String attributeName, @NotNull byte[] attributeValue) {
        this(attributeName, attributeValue, null);
    }

    public RDN(@NotNull String attributeName, @NotNull byte[] attributeValue, @Nullable Schema schema) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.schema = schema;
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{new ASN1OctetString(attributeValue)};
        this.nameValuePairs = null;
        this.normalizedString = null;
        this.rdnString = null;
    }

    public RDN(@NotNull String[] attributeNames, @NotNull String[] attributeValues) {
        this(attributeNames, attributeValues, null);
    }

    public RDN(@NotNull String[] attributeNames, @NotNull String[] attributeValues, @Nullable Schema schema) {
        Validator.ensureNotNull(attributeNames, attributeValues);
        Validator.ensureTrue(attributeNames.length == attributeValues.length, "RDN.attributeNames and attributeValues must be the same size.");
        Validator.ensureTrue(attributeNames.length > 0, "RDN.attributeNames must not be empty.");
        this.attributeNames = attributeNames;
        this.schema = schema;
        this.attributeValues = new ASN1OctetString[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            this.attributeValues[i] = new ASN1OctetString(attributeValues[i]);
        }
        this.nameValuePairs = null;
        this.normalizedString = null;
        this.rdnString = null;
    }

    public RDN(@NotNull String[] attributeNames, @NotNull byte[][] attributeValues) {
        this(attributeNames, attributeValues, null);
    }

    public RDN(@NotNull String[] attributeNames, @NotNull byte[][] attributeValues, @Nullable Schema schema) {
        Validator.ensureNotNull(attributeNames, attributeValues);
        Validator.ensureTrue(attributeNames.length == attributeValues.length, "RDN.attributeNames and attributeValues must be the same size.");
        Validator.ensureTrue(attributeNames.length > 0, "RDN.attributeNames must not be empty.");
        this.attributeNames = attributeNames;
        this.schema = schema;
        this.attributeValues = new ASN1OctetString[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            this.attributeValues[i] = new ASN1OctetString(attributeValues[i]);
        }
        this.nameValuePairs = null;
        this.normalizedString = null;
        this.rdnString = null;
    }

    RDN(@NotNull String attributeName, @NotNull ASN1OctetString attributeValue, @Nullable Schema schema, @NotNull String rdnString) {
        this.rdnString = rdnString;
        this.schema = schema;
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{attributeValue};
        this.nameValuePairs = null;
        this.normalizedString = null;
    }

    RDN(@NotNull String[] attributeNames, @NotNull ASN1OctetString[] attributeValues, @Nullable Schema schema, @NotNull String rdnString) {
        this.rdnString = rdnString;
        this.schema = schema;
        this.attributeNames = attributeNames;
        this.attributeValues = attributeValues;
        this.nameValuePairs = null;
        this.normalizedString = null;
    }

    public RDN(@NotNull String rdnString) throws LDAPException {
        this(rdnString, (Schema)null, false);
    }

    public RDN(@NotNull String rdnString, @Nullable Schema schema) throws LDAPException {
        this(rdnString, schema, false);
    }

    public RDN(@NotNull String rdnString, @Nullable Schema schema, boolean strictNameChecking) throws LDAPException {
        ASN1OctetString value;
        char c;
        int pos;
        Validator.ensureNotNull(rdnString);
        this.rdnString = rdnString;
        this.schema = schema;
        this.nameValuePairs = null;
        this.normalizedString = null;
        int length = rdnString.length();
        for (pos = 0; pos < length && rdnString.charAt(pos) == ' '; ++pos) {
        }
        int attrStartPos = pos;
        while (pos < length && (c = rdnString.charAt(pos)) != ' ' && c != '=') {
            ++pos;
        }
        String attrName = rdnString.substring(attrStartPos, pos);
        if (attrName.isEmpty()) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_NAME.get(rdnString));
        }
        if (strictNameChecking && !Attribute.nameIsValid(attrName) && !StaticUtils.isNumericOID(attrName)) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_ATTR_NAME.get(rdnString, attrName));
        }
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length || rdnString.charAt(pos) != '=') {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_EQUAL_SIGN.get(rdnString, attrName));
        }
        ++pos;
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            value = new ASN1OctetString();
        } else if (rdnString.charAt(pos) == '#') {
            byte[] valueArray = RDN.readHexString(rdnString, ++pos);
            try {
                value = ASN1OctetString.decodeAsOctetString(valueArray);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_HEX_STRING_NOT_BER_ENCODED.get(rdnString, attrName), e);
            }
            pos += valueArray.length * 2;
        } else {
            StringBuilder buffer = new StringBuilder();
            pos = RDN.readValueString(rdnString, pos, buffer);
            value = new ASN1OctetString(buffer.toString());
        }
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            this.attributeNames = new String[]{attrName};
            this.attributeValues = new ASN1OctetString[]{value};
            return;
        }
        ArrayList<String> nameList = new ArrayList<String>(5);
        ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(5);
        nameList.add(attrName);
        valueList.add(value);
        if (rdnString.charAt(pos) != '+') {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS.get(rdnString));
        }
        if (++pos >= length) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP.get(rdnString));
        }
        int numValues = 1;
        while (pos < length) {
            char c2;
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            attrStartPos = pos;
            while (pos < length && (c2 = rdnString.charAt(pos)) != ' ' && c2 != '=') {
                ++pos;
            }
            attrName = rdnString.substring(attrStartPos, pos);
            if (attrName.isEmpty()) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_NAME.get(rdnString));
            }
            if (strictNameChecking && !Attribute.nameIsValid(attrName) && !StaticUtils.isNumericOID(attrName)) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_ATTR_NAME.get(rdnString, attrName));
            }
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length || rdnString.charAt(pos) != '=') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_EQUAL_SIGN.get(rdnString, attrName));
            }
            ++pos;
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                value = new ASN1OctetString();
            } else if (rdnString.charAt(pos) == '#') {
                byte[] valueArray = RDN.readHexString(rdnString, ++pos);
                try {
                    value = ASN1OctetString.decodeAsOctetString(valueArray);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_HEX_STRING_NOT_BER_ENCODED.get(rdnString, attrName), e);
                }
                pos += valueArray.length * 2;
            } else {
                StringBuilder buffer = new StringBuilder();
                pos = RDN.readValueString(rdnString, pos, buffer);
                value = new ASN1OctetString(buffer.toString());
            }
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            nameList.add(attrName);
            valueList.add(value);
            ++numValues;
            if (pos >= length) break;
            if (rdnString.charAt(pos) != '+') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS.get(rdnString));
            }
            if (++pos < length) continue;
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP.get(rdnString));
        }
        this.attributeNames = new String[numValues];
        this.attributeValues = new ASN1OctetString[numValues];
        for (int i = 0; i < numValues; ++i) {
            this.attributeNames[i] = (String)nameList.get(i);
            this.attributeValues[i] = (ASN1OctetString)valueList.get(i);
        }
    }

    @NotNull
    static byte[] readHexString(@NotNull String rdnString, int startPos) throws LDAPException {
        int length = rdnString.length();
        int pos = startPos;
        ByteBuffer buffer = ByteBuffer.allocate(length - pos);
        block37: while (pos < length) {
            byte hexByte;
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    hexByte = 0;
                    break;
                }
                case '1': {
                    hexByte = 16;
                    break;
                }
                case '2': {
                    hexByte = 32;
                    break;
                }
                case '3': {
                    hexByte = 48;
                    break;
                }
                case '4': {
                    hexByte = 64;
                    break;
                }
                case '5': {
                    hexByte = 80;
                    break;
                }
                case '6': {
                    hexByte = 96;
                    break;
                }
                case '7': {
                    hexByte = 112;
                    break;
                }
                case '8': {
                    hexByte = -128;
                    break;
                }
                case '9': {
                    hexByte = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    hexByte = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    hexByte = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    hexByte = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    hexByte = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    hexByte = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    hexByte = -16;
                    break;
                }
                case ' ': 
                case '+': 
                case ',': 
                case ';': {
                    break block37;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(rdnString, Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_MISSING_HEX_CHAR.get(rdnString));
            }
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    buffer.put(hexByte);
                    continue block37;
                }
                case '1': {
                    buffer.put((byte)(hexByte | 1));
                    continue block37;
                }
                case '2': {
                    buffer.put((byte)(hexByte | 2));
                    continue block37;
                }
                case '3': {
                    buffer.put((byte)(hexByte | 3));
                    continue block37;
                }
                case '4': {
                    buffer.put((byte)(hexByte | 4));
                    continue block37;
                }
                case '5': {
                    buffer.put((byte)(hexByte | 5));
                    continue block37;
                }
                case '6': {
                    buffer.put((byte)(hexByte | 6));
                    continue block37;
                }
                case '7': {
                    buffer.put((byte)(hexByte | 7));
                    continue block37;
                }
                case '8': {
                    buffer.put((byte)(hexByte | 8));
                    continue block37;
                }
                case '9': {
                    buffer.put((byte)(hexByte | 9));
                    continue block37;
                }
                case 'A': 
                case 'a': {
                    buffer.put((byte)(hexByte | 0xA));
                    continue block37;
                }
                case 'B': 
                case 'b': {
                    buffer.put((byte)(hexByte | 0xB));
                    continue block37;
                }
                case 'C': 
                case 'c': {
                    buffer.put((byte)(hexByte | 0xC));
                    continue block37;
                }
                case 'D': 
                case 'd': {
                    buffer.put((byte)(hexByte | 0xD));
                    continue block37;
                }
                case 'E': 
                case 'e': {
                    buffer.put((byte)(hexByte | 0xE));
                    continue block37;
                }
                case 'F': 
                case 'f': {
                    buffer.put((byte)(hexByte | 0xF));
                    continue block37;
                }
            }
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(rdnString, Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
        }
        buffer.flip();
        byte[] valueArray = new byte[buffer.limit()];
        buffer.get(valueArray);
        return valueArray;
    }

    static int readValueString(@NotNull String rdnString, int startPos, @NotNull StringBuilder buffer) throws LDAPException {
        int pos;
        int length = rdnString.length();
        boolean inQuotes = false;
        block5: for (pos = startPos; pos < length; ++pos) {
            char c = rdnString.charAt(pos);
            switch (c) {
                case '\\': {
                    if (pos + 1 >= length) {
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_ENDS_WITH_BACKSLASH.get(rdnString));
                    }
                    if (StaticUtils.isHex(c = rdnString.charAt(++pos))) {
                        pos = RDN.readEscapedHexString(rdnString, pos, buffer) - 1;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case '\"': {
                    if (inQuotes) {
                        ++pos;
                        while (pos < length && (c = rdnString.charAt(pos)) != '+' && c != ',' && c != ';') {
                            if (c != ' ') {
                                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_CHAR_OUTSIDE_QUOTES.get(rdnString, Character.valueOf(c), pos - 1));
                            }
                            ++pos;
                        }
                        inQuotes = false;
                        break block5;
                    }
                    if (pos == startPos) {
                        inQuotes = true;
                        continue block5;
                    }
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_UNEXPECTED_DOUBLE_QUOTE.get(rdnString, pos));
                }
                case '+': 
                case ',': 
                case ';': {
                    if (!inQuotes) break block5;
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        if (inQuotes) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_UNCLOSED_DOUBLE_QUOTE.get(rdnString));
        }
        int bufferPos = buffer.length() - 1;
        int rdnStrPos = pos - 2;
        while (bufferPos > 0 && buffer.charAt(bufferPos) == ' ' && rdnString.charAt(rdnStrPos) != '\\') {
            buffer.deleteCharAt(bufferPos--);
            --rdnStrPos;
        }
        return pos;
    }

    private static int readEscapedHexString(@NotNull String rdnString, int startPos, @NotNull StringBuilder buffer) throws LDAPException {
        int pos;
        int length = rdnString.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(length - pos);
        for (pos = startPos; pos < length; ++pos) {
            byte b;
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    b = 0;
                    break;
                }
                case '1': {
                    b = 16;
                    break;
                }
                case '2': {
                    b = 32;
                    break;
                }
                case '3': {
                    b = 48;
                    break;
                }
                case '4': {
                    b = 64;
                    break;
                }
                case '5': {
                    b = 80;
                    break;
                }
                case '6': {
                    b = 96;
                    break;
                }
                case '7': {
                    b = 112;
                    break;
                }
                case '8': {
                    b = -128;
                    break;
                }
                case '9': {
                    b = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    b = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    b = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    b = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    b = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    b = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    b = -16;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(rdnString, Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_MISSING_HEX_CHAR.get(rdnString));
            }
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    byteBuffer.put(b);
                    break;
                }
                case '1': {
                    byteBuffer.put((byte)(b | 1));
                    break;
                }
                case '2': {
                    byteBuffer.put((byte)(b | 2));
                    break;
                }
                case '3': {
                    byteBuffer.put((byte)(b | 3));
                    break;
                }
                case '4': {
                    byteBuffer.put((byte)(b | 4));
                    break;
                }
                case '5': {
                    byteBuffer.put((byte)(b | 5));
                    break;
                }
                case '6': {
                    byteBuffer.put((byte)(b | 6));
                    break;
                }
                case '7': {
                    byteBuffer.put((byte)(b | 7));
                    break;
                }
                case '8': {
                    byteBuffer.put((byte)(b | 8));
                    break;
                }
                case '9': {
                    byteBuffer.put((byte)(b | 9));
                    break;
                }
                case 'A': 
                case 'a': {
                    byteBuffer.put((byte)(b | 0xA));
                    break;
                }
                case 'B': 
                case 'b': {
                    byteBuffer.put((byte)(b | 0xB));
                    break;
                }
                case 'C': 
                case 'c': {
                    byteBuffer.put((byte)(b | 0xC));
                    break;
                }
                case 'D': 
                case 'd': {
                    byteBuffer.put((byte)(b | 0xD));
                    break;
                }
                case 'E': 
                case 'e': {
                    byteBuffer.put((byte)(b | 0xE));
                    break;
                }
                case 'F': 
                case 'f': {
                    byteBuffer.put((byte)(b | 0xF));
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(rdnString, Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos + 1 >= length || rdnString.charAt(pos) != '\\' || !StaticUtils.isHex(rdnString.charAt(pos + 1))) break;
        }
        byteBuffer.flip();
        byte[] byteArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byteArray);
        buffer.append(StaticUtils.toUTF8String(byteArray));
        return pos;
    }

    public static boolean isValidRDN(@NotNull String s) {
        return RDN.isValidRDN(s, false);
    }

    public static boolean isValidRDN(@NotNull String s, boolean strictNameChecking) {
        try {
            new RDN(s, null, strictNameChecking);
            return true;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return false;
        }
    }

    public boolean isMultiValued() {
        return this.attributeNames.length != 1;
    }

    public int getValueCount() {
        return this.attributeNames.length;
    }

    @NotNull
    public Attribute[] getAttributes() {
        Attribute[] attrs = new Attribute[this.attributeNames.length];
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = new Attribute(this.attributeNames[i], this.schema, new ASN1OctetString[]{this.attributeValues[i]});
        }
        return attrs;
    }

    @NotNull
    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    @NotNull
    public String[] getAttributeValues() {
        String[] stringValues = new String[this.attributeValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            stringValues[i] = this.attributeValues[i].stringValue();
        }
        return stringValues;
    }

    @NotNull
    public byte[][] getByteArrayAttributeValues() {
        byte[][] byteValues = new byte[this.attributeValues.length][];
        for (int i = 0; i < byteValues.length; ++i) {
            byteValues[i] = this.attributeValues[i].getValue();
        }
        return byteValues;
    }

    @NotNull
    public SortedSet<RDNNameValuePair> getNameValuePairs() {
        if (this.nameValuePairs == null) {
            TreeSet<RDNNameValuePair> s = new TreeSet<RDNNameValuePair>();
            for (int i = 0; i < this.attributeNames.length; ++i) {
                s.add(new RDNNameValuePair(this.attributeNames[i], this.attributeValues[i], this.schema));
            }
            this.nameValuePairs = Collections.unmodifiableSortedSet(s);
        }
        return this.nameValuePairs;
    }

    @Nullable
    Schema getSchema() {
        return this.schema;
    }

    public boolean hasAttribute(@NotNull String attributeName) {
        for (RDNNameValuePair nameValuePair : this.getNameValuePairs()) {
            if (!nameValuePair.hasAttributeName(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(@NotNull String attributeName, @NotNull String attributeValue) {
        for (RDNNameValuePair nameValuePair : this.getNameValuePairs()) {
            if (!nameValuePair.hasAttributeName(attributeName) || !nameValuePair.hasAttributeValue(attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(@NotNull String attributeName, @NotNull byte[] attributeValue) {
        for (RDNNameValuePair nameValuePair : this.getNameValuePairs()) {
            if (!nameValuePair.hasAttributeName(attributeName) || !nameValuePair.hasAttributeValue(attributeValue)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String toString() {
        if (this.rdnString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer, false);
            this.rdnString = buffer.toString();
        }
        return this.rdnString;
    }

    @NotNull
    public String toMinimallyEncodedString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        this.toString(buffer, false);
    }

    public void toString(@NotNull StringBuilder buffer, boolean minimizeEncoding) {
        if (this.rdnString != null && !minimizeEncoding) {
            buffer.append(this.rdnString);
            return;
        }
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (i > 0) {
                buffer.append('+');
            }
            buffer.append(this.attributeNames[i]);
            buffer.append('=');
            RDN.appendValue(buffer, this.attributeValues[i], minimizeEncoding);
        }
    }

    static void appendValue(@NotNull StringBuilder buffer, @NotNull ASN1OctetString value, boolean minimizeEncoding) {
        String valueString = value.stringValue();
        int length = valueString.length();
        block6: for (int j = 0; j < length; ++j) {
            char c = valueString.charAt(j);
            switch (c) {
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block6;
                }
                case '#': {
                    if (j == 0) {
                        buffer.append("\\#");
                        continue block6;
                    }
                    buffer.append('#');
                    continue block6;
                }
                case ' ': {
                    if (j == 0 || j + 1 == length) {
                        buffer.append("\\ ");
                        continue block6;
                    }
                    buffer.append(' ');
                    continue block6;
                }
                case '\u0000': {
                    buffer.append("\\00");
                    continue block6;
                }
                default: {
                    if (!(minimizeEncoding || c >= ' ' && c <= '~')) {
                        StaticUtils.hexEncode(c, buffer);
                        continue block6;
                    }
                    buffer.append(c);
                }
            }
        }
    }

    @NotNull
    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
            this.normalizedString = buffer.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(@NotNull StringBuilder buffer) {
        if (this.attributeNames.length == 1) {
            String name = this.normalizeAttrName(this.attributeNames[0]);
            buffer.append(name);
            buffer.append('=');
            RDN.appendNormalizedValue(buffer, name, this.attributeValues[0], this.schema);
        } else {
            Iterator iterator = this.getNameValuePairs().iterator();
            while (iterator.hasNext()) {
                buffer.append(((RDNNameValuePair)iterator.next()).toNormalizedString());
                if (!iterator.hasNext()) continue;
                buffer.append('+');
            }
        }
    }

    @NotNull
    private String normalizeAttrName(@NotNull String name) {
        AttributeTypeDefinition at;
        String n = name;
        if (this.schema != null && (at = this.schema.getAttributeType(name)) != null) {
            n = at.getNameOrOID();
        }
        return StaticUtils.toLowerCase(n);
    }

    @NotNull
    public static String normalize(@NotNull String s) throws LDAPException {
        return RDN.normalize(s, null);
    }

    @NotNull
    public static String normalize(@NotNull String s, @Nullable Schema schema) throws LDAPException {
        return new RDN(s, schema).toNormalizedString();
    }

    static void appendNormalizedValue(@NotNull StringBuilder buffer, @NotNull String attributeName, @NotNull ASN1OctetString value, @Nullable Schema schema) {
        ASN1OctetString rawNormValue;
        MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(attributeName, schema);
        try {
            rawNormValue = matchingRule.normalize(value);
        }
        catch (Exception e) {
            Debug.debugException(e);
            rawNormValue = new ASN1OctetString(StaticUtils.toLowerCase(value.stringValue()));
        }
        String valueString = rawNormValue.stringValue();
        int length = valueString.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = valueString.charAt(i);
            switch (c) {
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block7;
                }
                case '#': {
                    if (i == 0) {
                        buffer.append("\\#");
                        continue block7;
                    }
                    buffer.append('#');
                    continue block7;
                }
                case ' ': {
                    if (i == 0 || i + 1 == length) {
                        buffer.append("\\ ");
                        continue block7;
                    }
                    buffer.append(' ');
                    continue block7;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        buffer.append(c);
                        continue block7;
                    }
                    if (Character.isHighSurrogate(c)) {
                        if (i + 1 < length && Character.isLowSurrogate(valueString.charAt(i + 1))) {
                            char c2 = valueString.charAt(++i);
                            int codePoint = Character.toCodePoint(c, c2);
                            StaticUtils.hexEncode(codePoint, buffer);
                            continue block7;
                        }
                        StaticUtils.hexEncode(c, buffer);
                        continue block7;
                    }
                    StaticUtils.hexEncode(c, buffer);
                }
            }
        }
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDN)) {
            return false;
        }
        RDN rdn = (RDN)o;
        return this.toNormalizedString().equals(rdn.toNormalizedString());
    }

    public boolean equals(@Nullable String s) throws LDAPException {
        if (s == null) {
            return false;
        }
        return this.equals(new RDN(s, this.schema));
    }

    public static boolean equals(@NotNull String s1, @NotNull String s2) throws LDAPException {
        return new RDN(s1).equals(new RDN(s2));
    }

    @Override
    public int compareTo(@NotNull RDN rdn) {
        return this.compare(this, rdn);
    }

    @Override
    public int compare(@NotNull RDN rdn1, @NotNull RDN rdn2) {
        Validator.ensureNotNull(rdn1, rdn2);
        Iterator iterator1 = rdn1.getNameValuePairs().iterator();
        Iterator iterator2 = rdn2.getNameValuePairs().iterator();
        while (iterator1.hasNext()) {
            if (iterator2.hasNext()) {
                RDNNameValuePair p2;
                RDNNameValuePair p1 = (RDNNameValuePair)iterator1.next();
                int compareValue = p1.compareTo(p2 = (RDNNameValuePair)iterator2.next());
                if (compareValue == 0) continue;
                return compareValue;
            }
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int compare(@NotNull String s1, @NotNull String s2) throws LDAPException {
        return RDN.compare(s1, s2, null);
    }

    public static int compare(@NotNull String s1, @NotNull String s2, @Nullable Schema schema) throws LDAPException {
        return new RDN(s1, schema).compareTo(new RDN(s2, schema));
    }
}

