/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.IntegerArgument;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class IndentLDAPFilter
extends CommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private static final String ARG_INDENT_SPACES = "indent-spaces";
    @NotNull
    private static final String ARG_DO_NOT_SIMPLIFY = "do-not-simplify";
    @Nullable
    private ArgumentParser parser = null;

    public static void main(String ... args) {
        ResultCode resultCode = IndentLDAPFilter.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        IndentLDAPFilter indentLDAPFilter = new IndentLDAPFilter(out, err);
        return indentLDAPFilter.runTool(args);
    }

    public IndentLDAPFilter(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "indent-ldap-filter";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "Parses a provided LDAP filter string and displays it a multi-line form that makes it easier to understand its hierarchy and embedded components.  If possible, it may also be able to simplify the provided filter in certain ways (for example, by removing unnecessary levels of hierarchy, like an AND embedded in an AND).";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "5.1.4";
    }

    @Override
    public int getMinTrailingArguments() {
        return 1;
    }

    @Override
    public int getMaxTrailingArguments() {
        return 1;
    }

    @Override
    @NotNull
    public String getTrailingArgumentsPlaceholder() {
        return "{filter}";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        IntegerArgument indentColumnsArg = new IntegerArgument(null, ARG_INDENT_SPACES, false, 1, "{numSpaces}", "Specifies the number of spaces that should be used to indent each additional level of filter hierarchy.  A value of zero indicates that the hierarchy should be displayed without any additional indenting.  If this argument is not provided, a default indent of two spaces will be used.", 0, Integer.MAX_VALUE, 2);
        indentColumnsArg.addLongIdentifier("indentSpaces", true);
        indentColumnsArg.addLongIdentifier("indent-columns", true);
        indentColumnsArg.addLongIdentifier("indentColumns", true);
        indentColumnsArg.addLongIdentifier("indent", true);
        parser.addArgument(indentColumnsArg);
        BooleanArgument doNotSimplifyArg = new BooleanArgument(null, ARG_DO_NOT_SIMPLIFY, 1, "Indicates that the tool should not make any attempt to simplify the provided filter.  If this argument is not provided, then the tool will try to simplify the provided filter (for example, by removing unnecessary levels of hierarchy, like an AND embedded in an AND).");
        doNotSimplifyArg.addLongIdentifier("doNotSimplify", true);
        doNotSimplifyArg.addLongIdentifier("do-not-simplify-filter", true);
        doNotSimplifyArg.addLongIdentifier("doNotSimplifyFilter", true);
        doNotSimplifyArg.addLongIdentifier("dont-simplify", true);
        doNotSimplifyArg.addLongIdentifier("dontSimplify", true);
        doNotSimplifyArg.addLongIdentifier("dont-simplify-filter", true);
        doNotSimplifyArg.addLongIdentifier("dontSimplifyFilter", true);
        parser.addArgument(doNotSimplifyArg);
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        Filter filter;
        try {
            filter = Filter.create(this.parser.getTrailingArguments().get(0));
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, "ERROR:  Unable to parse the provided filter string:  " + StaticUtils.getExceptionMessage(e));
            return e.getResultCode();
        }
        int indentSpaces = this.parser.getIntegerArgument(ARG_INDENT_SPACES).getValue();
        char[] indentChars = new char[indentSpaces];
        Arrays.fill(indentChars, ' ');
        String indentString = new String(indentChars);
        ArrayList<String> indentedFilterLines = new ArrayList<String>(10);
        IndentLDAPFilter.indentLDAPFilter(filter, "", indentString, indentedFilterLines);
        for (String line : indentedFilterLines) {
            this.out(line);
        }
        if (!this.parser.getBooleanArgument(ARG_DO_NOT_SIMPLIFY).isPresent()) {
            this.out(new Object[0]);
            Filter simplifiedFilter = Filter.simplifyFilter(filter, false);
            if (simplifiedFilter.equals(filter)) {
                this.wrapOut(0, WRAP_COLUMN, "The provided filter cannot be simplified.");
            } else {
                this.wrapOut(0, WRAP_COLUMN, "The provided filter can be simplified to:");
                this.out(new Object[0]);
                this.out("     ", simplifiedFilter.toString());
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, "An indented representation of the simplified filter:");
                this.out(new Object[0]);
                indentedFilterLines.clear();
                IndentLDAPFilter.indentLDAPFilter(simplifiedFilter, "", indentString, indentedFilterLines);
                for (String line : indentedFilterLines) {
                    this.out(line);
                }
            }
        }
        return ResultCode.SUCCESS;
    }

    public static void indentLDAPFilter(@NotNull Filter filter, @NotNull String currentIndentString, @NotNull String indentSpaces, @NotNull List<String> indentedFilterLines) {
        switch (filter.getFilterType()) {
            case -96: {
                Filter[] andComponents = filter.getComponents();
                if (andComponents.length == 0) {
                    indentedFilterLines.add(currentIndentString + "(&)");
                    break;
                }
                indentedFilterLines.add(currentIndentString + "(&");
                String andComponentIndent = currentIndentString + " &" + indentSpaces;
                for (Filter andComponent : andComponents) {
                    IndentLDAPFilter.indentLDAPFilter(andComponent, andComponentIndent, indentSpaces, indentedFilterLines);
                }
                indentedFilterLines.add(currentIndentString + " &)");
                break;
            }
            case -95: {
                Filter[] orComponents = filter.getComponents();
                if (orComponents.length == 0) {
                    indentedFilterLines.add(currentIndentString + "(|)");
                    break;
                }
                indentedFilterLines.add(currentIndentString + "(|");
                String orComponentIndent = currentIndentString + " |" + indentSpaces;
                for (Filter orComponent : orComponents) {
                    IndentLDAPFilter.indentLDAPFilter(orComponent, orComponentIndent, indentSpaces, indentedFilterLines);
                }
                indentedFilterLines.add(currentIndentString + " |)");
                break;
            }
            case -94: {
                indentedFilterLines.add(currentIndentString + "(!");
                IndentLDAPFilter.indentLDAPFilter(filter.getNOTComponent(), currentIndentString + " !" + indentSpaces, indentSpaces, indentedFilterLines);
                indentedFilterLines.add(currentIndentString + " !)");
                break;
            }
            default: {
                indentedFilterLines.add(currentIndentString + filter.toString());
            }
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        examples.put(new String[]{"(|(givenName=jdoe)(|(sn=jdoe)(|(cn=jdoe)(|(uid=jdoe)(mail=jdoe)))))"}, "Displays an indented representation of the provided filter, as well as a simplified version of that filter.");
        return examples;
    }
}

