/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationRequestAccessLogMessage;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class SearchRequestAccessLogMessage
extends OperationRequestAccessLogMessage {
    private static final long serialVersionUID = -6751258649156129642L;
    @Nullable
    private final Boolean typesOnly;
    @Nullable
    private final DereferencePolicy derefPolicy;
    @Nullable
    private final Integer sizeLimit;
    @Nullable
    private final Integer timeLimit;
    @Nullable
    private final List<String> requestedAttributes;
    @Nullable
    private final SearchScope scope;
    @Nullable
    private final String baseDN = this.getNamedValue("base");
    @Nullable
    private final String filter = this.getNamedValue("filter");

    public SearchRequestAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public SearchRequestAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        this.sizeLimit = this.getNamedValueAsInteger("sizeLimit");
        this.timeLimit = this.getNamedValueAsInteger("timeLimit");
        this.typesOnly = this.getNamedValueAsBoolean("typesOnly");
        SearchScope ss = null;
        try {
            ss = SearchScope.definedValueOf(this.getNamedValueAsInteger("scope"));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.scope = ss;
        DereferencePolicy deref = null;
        String derefStr = this.getNamedValue("deref");
        if (derefStr != null) {
            for (DereferencePolicy p : DereferencePolicy.values()) {
                if (!p.getName().equalsIgnoreCase(derefStr)) continue;
                deref = p;
                break;
            }
        }
        this.derefPolicy = deref;
        String attrStr = this.getNamedValue("attrs");
        if (attrStr == null) {
            this.requestedAttributes = null;
        } else if (attrStr.equals("ALL")) {
            this.requestedAttributes = Collections.emptyList();
        } else {
            LinkedList<String> attrs = new LinkedList<String>();
            StringTokenizer st = new StringTokenizer(attrStr, ",", false);
            while (st.hasMoreTokens()) {
                attrs.add(st.nextToken());
            }
            this.requestedAttributes = Collections.unmodifiableList(attrs);
        }
    }

    @Nullable
    public final String getBaseDN() {
        return this.baseDN;
    }

    @Nullable
    public final SearchScope getScope() {
        return this.scope;
    }

    @Nullable
    public final String getFilter() {
        return this.filter;
    }

    @Nullable
    public final Filter getParsedFilter() {
        try {
            if (this.filter == null) {
                return null;
            }
            return Filter.create(this.filter);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    public final DereferencePolicy getDereferencePolicy() {
        return this.derefPolicy;
    }

    @Nullable
    public final Integer getSizeLimit() {
        return this.sizeLimit;
    }

    @Nullable
    public final Integer getTimeLimit() {
        return this.timeLimit;
    }

    @Nullable
    public final Boolean typesOnly() {
        return this.typesOnly;
    }

    @Nullable
    public final List<String> getRequestedAttributes() {
        return this.requestedAttributes;
    }

    @Override
    @NotNull
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.SEARCH;
    }
}

