/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONValue;
import java.math.BigDecimal;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONNumber
extends JSONValue {
    private static final long serialVersionUID = -9194944952299318254L;
    @NotNull
    private final BigDecimal value;
    @NotNull
    private final BigDecimal normalizedValue;
    @NotNull
    private final String stringRepresentation;

    public JSONNumber(long value) {
        this.normalizedValue = this.value = new BigDecimal(value);
        this.stringRepresentation = String.valueOf(value);
    }

    public JSONNumber(double value) {
        this.normalizedValue = this.value = new BigDecimal(value);
        this.stringRepresentation = String.valueOf(value);
    }

    public JSONNumber(@NotNull BigDecimal value) {
        BigDecimal minimalValue;
        this.value = value;
        this.stringRepresentation = value.toPlainString();
        try {
            minimalValue = new BigDecimal(value.toBigIntegerExact());
        }
        catch (Exception e) {
            minimalValue = value.stripTrailingZeros();
        }
        this.normalizedValue = minimalValue;
    }

    public JSONNumber(@NotNull String stringRepresentation) throws JSONException {
        BigDecimal minimalValue;
        this.stringRepresentation = stringRepresentation;
        char[] chars = stringRepresentation.toCharArray();
        if (chars.length == 0) {
            throw new JSONException(JSONMessages.ERR_NUMBER_EMPTY_STRING.get());
        }
        if (!JSONNumber.isDigit(chars[chars.length - 1])) {
            throw new JSONException(JSONMessages.ERR_NUMBER_LAST_CHAR_NOT_DIGIT.get(stringRepresentation));
        }
        int pos = 0;
        if (chars[0] == '-') {
            ++pos;
        }
        if (!JSONNumber.isDigit(chars[pos])) {
            throw new JSONException(JSONMessages.ERR_NUMBER_ILLEGAL_CHAR.get(stringRepresentation, pos));
        }
        if (chars[pos++] == '0' && chars.length > pos && JSONNumber.isDigit(chars[pos])) {
            throw new JSONException(JSONMessages.ERR_NUMBER_ILLEGAL_LEADING_ZERO.get(stringRepresentation));
        }
        boolean decimalFound = false;
        boolean eFound = false;
        while (pos < chars.length) {
            char c = chars[pos];
            if (c == '.') {
                if (decimalFound) {
                    throw new JSONException(JSONMessages.ERR_NUMBER_MULTIPLE_DECIMAL_POINTS.get(stringRepresentation));
                }
                decimalFound = true;
                if (eFound) {
                    throw new JSONException(JSONMessages.ERR_NUMBER_DECIMAL_IN_EXPONENT.get(stringRepresentation));
                }
                if (!JSONNumber.isDigit(chars[pos + 1])) {
                    throw new JSONException(JSONMessages.ERR_NUMBER_DECIMAL_NOT_FOLLOWED_BY_DIGIT.get(stringRepresentation));
                }
            } else if (c == 'e' || c == 'E') {
                if (eFound) {
                    throw new JSONException(JSONMessages.ERR_NUMBER_MULTIPLE_EXPONENTS.get(stringRepresentation));
                }
                eFound = true;
                if (chars[pos + 1] == '-' || chars[pos + 1] == '+') {
                    if (!JSONNumber.isDigit(chars[pos + 2])) {
                        throw new JSONException(JSONMessages.ERR_NUMBER_EXPONENT_NOT_FOLLOWED_BY_DIGIT.get(stringRepresentation));
                    }
                    ++pos;
                } else if (!JSONNumber.isDigit(chars[pos + 1])) {
                    throw new JSONException(JSONMessages.ERR_NUMBER_EXPONENT_NOT_FOLLOWED_BY_DIGIT.get(stringRepresentation));
                }
            } else if (!JSONNumber.isDigit(chars[pos])) {
                throw new JSONException(JSONMessages.ERR_NUMBER_ILLEGAL_CHAR.get(stringRepresentation, pos));
            }
            ++pos;
        }
        try {
            this.value = new BigDecimal(stringRepresentation);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new JSONException(JSONMessages.ERR_NUMBER_CANNOT_PARSE.get(stringRepresentation, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            minimalValue = new BigDecimal(this.value.toBigIntegerExact());
        }
        catch (Exception e) {
            minimalValue = this.value.stripTrailingZeros();
        }
        this.normalizedValue = minimalValue;
    }

    private static boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public BigDecimal getValue() {
        return this.value;
    }

    @Nullable
    public Integer getValueAsInteger() {
        try {
            return this.value.intValueExact();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    public Long getValueAsLong() {
        try {
            return this.value.longValueExact();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    public double getValueAsDouble() {
        return this.value.doubleValue();
    }

    @Override
    public int hashCode() {
        return this.normalizedValue.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JSONNumber) {
            JSONNumber n = (JSONNumber)o;
            return this.value.compareTo(n.value) == 0;
        }
        return false;
    }

    @Override
    public boolean equals(@NotNull JSONValue v, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        return v instanceof JSONNumber && this.value.compareTo(((JSONNumber)v).value) == 0;
    }

    @Override
    @NotNull
    public String toString() {
        return this.stringRepresentation;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append(this.stringRepresentation);
    }

    @Override
    @NotNull
    public String toSingleLineString() {
        return this.stringRepresentation;
    }

    @Override
    public void toSingleLineString(@NotNull StringBuilder buffer) {
        buffer.append(this.stringRepresentation);
    }

    @Override
    @NotNull
    public String toNormalizedString() {
        return this.normalizedValue.toPlainString();
    }

    @Override
    public void toNormalizedString(@NotNull StringBuilder buffer) {
        buffer.append(this.normalizedValue.toPlainString());
    }

    @Override
    @NotNull
    public String toNormalizedString(boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        return this.normalizedValue.toPlainString();
    }

    @Override
    public void toNormalizedString(@NotNull StringBuilder buffer, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        buffer.append(this.normalizedValue.toPlainString());
    }

    @Override
    public void appendToJSONBuffer(@NotNull JSONBuffer buffer) {
        buffer.appendNumber(this.stringRepresentation);
    }

    @Override
    public void appendToJSONBuffer(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(fieldName, this.stringRepresentation);
    }
}

