/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.ColumnBasedLDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.DNsOnlyLDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.JSONLDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.LDIFLDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.ldap.sdk.unboundidds.tools.ValuesOnlyLDAPResultWriter;
import com.unboundid.ldif.LDIFMessages;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.PassphraseEncryptedOutputStream;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDIFSearch
extends CommandLineTool {
    @Nullable
    private static final File PING_SERVER_ROOT = InternalSDKHelper.getPingIdentityServerRoot();
    private static final boolean PING_SERVER_AVAILABLE = PING_SERVER_ROOT != null;
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @Nullable
    private volatile ArgumentParser parser = null;
    @NotNull
    private final AtomicReference<String> completionMessage;
    private volatile boolean ldifEncryptionPassphraseFileRead = false;
    @NotNull
    private final List<char[]> inputEncryptionPassphrases;
    @NotNull
    private final List<LDAPURL> searchURLs;
    @NotNull
    private volatile LDAPResultWriter resultWriter = new LDIFLDAPResultWriter(this.getOut(), WRAP_COLUMN);
    @Nullable
    private BooleanArgument checkSchema = null;
    @Nullable
    private BooleanArgument compressOutput = null;
    @Nullable
    private BooleanArgument doNotWrap = null;
    @Nullable
    private BooleanArgument encryptOutput = null;
    @Nullable
    private BooleanArgument isCompressed = null;
    @Nullable
    private BooleanArgument overwriteExistingOutputFile = null;
    @Nullable
    private BooleanArgument separateOutputFilePerSearch = null;
    @Nullable
    private BooleanArgument stripTrailingSpaces = null;
    @Nullable
    private DNArgument baseDN = null;
    @Nullable
    private FileArgument filterFile = null;
    @Nullable
    private FileArgument ldapURLFile = null;
    @Nullable
    private FileArgument ldifEncryptionPassphraseFile = null;
    @Nullable
    private FileArgument ldifFile = null;
    @Nullable
    private FileArgument outputFile = null;
    @Nullable
    private FileArgument outputEncryptionPassphraseFile = null;
    @Nullable
    private FileArgument schemaPath = null;
    @Nullable
    private IntegerArgument sizeLimit = null;
    @Nullable
    private IntegerArgument timeLimitSeconds = null;
    @Nullable
    private IntegerArgument wrapColumn = null;
    @Nullable
    private ScopeArgument scope = null;
    @Nullable
    private StringArgument outputFormat = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDIFSearch.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        LDIFSearch tool = new LDIFSearch(out, err);
        return tool.runTool(args);
    }

    public LDIFSearch(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
        this.completionMessage = new AtomicReference();
        this.inputEncryptionPassphrases = new ArrayList<char[]>(5);
        this.searchURLs = new ArrayList<LDAPURL>();
    }

    @Override
    @NotNull
    public String getToolName() {
        return "ldifsearch";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return LDIFMessages.INFO_LDIFSEARCH_TOOL_DESCRIPTION.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.4";
    }

    @Override
    public int getMinTrailingArguments() {
        return 0;
    }

    @Override
    public int getMaxTrailingArguments() {
        return -1;
    }

    @Override
    @NotNull
    public String getTrailingArgumentsPlaceholder() {
        return LDIFMessages.INFO_LDIFSEARCH_TRAILING_ARGS_PLACEHOLDER.get();
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    @Nullable
    protected String getToolCompletionMessage() {
        return this.completionMessage.get();
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        this.ldifFile = new FileArgument(Character.valueOf('l'), "ldifFile", true, 0, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_LDIF_FILE.get(), true, true, true, false);
        this.ldifFile.addLongIdentifier("ldif-file", true);
        this.ldifFile.addLongIdentifier("inputFile", true);
        this.ldifFile.addLongIdentifier("input-file", true);
        this.ldifFile.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_INPUT.get());
        parser.addArgument(this.ldifFile);
        String ldifPWDesc = PING_SERVER_AVAILABLE ? LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_LDIF_PW_FILE_PING_SERVER.get() : LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_LDIF_PW_FILE_STANDALONE.get();
        this.ldifEncryptionPassphraseFile = new FileArgument(null, "ldifEncryptionPassphraseFile", false, 1, null, ldifPWDesc, true, true, true, false);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("ldif-encryption-passphrase-file", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("ldifPassphraseFile", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("ldif-passphrase-file", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("ldifEncryptionPasswordFile", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("ldif-encryption-password-file", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("ldifPasswordFile", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("ldif-password-file", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("inputEncryptionPassphraseFile", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("input-encryption-passphrase-file", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("inputPassphraseFile", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("input-passphrase-file", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("inputEncryptionPasswordFile", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("input-encryption-password-file", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("inputPasswordFile", true);
        this.ldifEncryptionPassphraseFile.addLongIdentifier("input-password-file", true);
        this.ldifEncryptionPassphraseFile.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_INPUT.get());
        parser.addArgument(this.ldifEncryptionPassphraseFile);
        this.stripTrailingSpaces = new BooleanArgument(null, "stripTrailingSpaces", 1, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_STRIP_TRAILING_SPACES.get());
        this.stripTrailingSpaces.addLongIdentifier("strip-trailing-spaces", true);
        this.stripTrailingSpaces.addLongIdentifier("ignoreTrailingSpaces", true);
        this.stripTrailingSpaces.addLongIdentifier("ignore-trailing-spaces", true);
        this.stripTrailingSpaces.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_INPUT.get());
        parser.addArgument(this.stripTrailingSpaces);
        String schemaPathDesc = PING_SERVER_AVAILABLE ? LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_SCHEMA_PATH_PING_SERVER.get() : LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_SCHEMA_PATH_STANDALONE.get();
        this.schemaPath = new FileArgument(null, "schemaPath", false, 0, null, schemaPathDesc, true, true, false, false);
        this.schemaPath.addLongIdentifier("schema-path", true);
        this.schemaPath.addLongIdentifier("schemaFile", true);
        this.schemaPath.addLongIdentifier("schema-file", true);
        this.schemaPath.addLongIdentifier("schemaDirectory", true);
        this.schemaPath.addLongIdentifier("schema-directory", true);
        this.schemaPath.addLongIdentifier("schema", true);
        this.schemaPath.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_INPUT.get());
        parser.addArgument(this.schemaPath);
        this.checkSchema = new BooleanArgument(null, "checkSchema", 1, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_CHECK_SCHEMA.get());
        this.checkSchema.addLongIdentifier("check-schema", true);
        this.checkSchema.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_INPUT.get());
        parser.addArgument(this.checkSchema);
        this.isCompressed = new BooleanArgument(null, "isCompressed", 1, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_IS_COMPRESSED.get());
        this.isCompressed.addLongIdentifier("is-compressed", true);
        this.isCompressed.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_INPUT.get());
        this.isCompressed.setHidden(true);
        parser.addArgument(this.isCompressed);
        this.outputFile = new FileArgument(Character.valueOf('o'), "outputFile", false, 1, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_OUTPUT_FILE.get(), false, true, true, false);
        this.outputFile.addLongIdentifier("output-file", true);
        this.outputFile.addLongIdentifier("outputLDIF", true);
        this.outputFile.addLongIdentifier("output-ldif", true);
        this.outputFile.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.outputFile);
        this.separateOutputFilePerSearch = new BooleanArgument(null, "separateOutputFilePerSearch", 1, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_SEPARATE_OUTPUT_FILES.get());
        this.separateOutputFilePerSearch.addLongIdentifier("separate-output-file-per-search", true);
        this.separateOutputFilePerSearch.addLongIdentifier("separateOutputFiles", true);
        this.separateOutputFilePerSearch.addLongIdentifier("separate-output-files", true);
        this.separateOutputFilePerSearch.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.separateOutputFilePerSearch);
        this.compressOutput = new BooleanArgument(null, "compressOutput", 1, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_COMPRESS_OUTPUT.get());
        this.compressOutput.addLongIdentifier("compress-output", true);
        this.compressOutput.addLongIdentifier("compressLDIF", true);
        this.compressOutput.addLongIdentifier("compress-ldif", true);
        this.compressOutput.addLongIdentifier("compress", true);
        this.compressOutput.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.compressOutput);
        this.encryptOutput = new BooleanArgument(null, "encryptOutput", 1, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_ENCRYPT_OUTPUT.get());
        this.encryptOutput.addLongIdentifier("encrypt-output", true);
        this.encryptOutput.addLongIdentifier("encryptLDIF", true);
        this.encryptOutput.addLongIdentifier("encrypt-ldif", true);
        this.encryptOutput.addLongIdentifier("encrypt", true);
        this.encryptOutput.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.encryptOutput);
        this.outputEncryptionPassphraseFile = new FileArgument(null, "outputEncryptionPassphraseFile", false, 1, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_OUTPUT_PW_FILE.get(), true, true, true, false);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-encryption-passphrase-file", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("outputPassphraseFile", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-passphrase-file", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("outputEncryptionPasswordFile", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-encryption-password-file", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("outputPasswordFile", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-password-file", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("outputEncryptionPasswordFile", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-encryption-password-file", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("outputPasswordFile", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-password-file", true);
        this.outputEncryptionPassphraseFile.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.outputEncryptionPassphraseFile);
        this.overwriteExistingOutputFile = new BooleanArgument(Character.valueOf('O'), "overwriteExistingOutputFile", 1, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_OVERWRITE_EXISTING.get());
        this.overwriteExistingOutputFile.addLongIdentifier("overwrite-existing-output-file", true);
        this.overwriteExistingOutputFile.addLongIdentifier("overwriteExistingOutputFiles", true);
        this.overwriteExistingOutputFile.addLongIdentifier("overwrite-existing-output-files", true);
        this.overwriteExistingOutputFile.addLongIdentifier("overwriteExistingOutput", true);
        this.overwriteExistingOutputFile.addLongIdentifier("overwrite-existing-output", true);
        this.overwriteExistingOutputFile.addLongIdentifier("overwriteExisting", true);
        this.overwriteExistingOutputFile.addLongIdentifier("overwrite-existing", true);
        this.overwriteExistingOutputFile.addLongIdentifier("overwrite", true);
        this.overwriteExistingOutputFile.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.overwriteExistingOutputFile);
        Set<String> outputFormatAllowedValues = StaticUtils.setOf("ldif", "json", "csv", "multi-valued-csv", "tab-delimited", "multi-valued-tab-delimited", "dns-only", "values-only");
        this.outputFormat = new StringArgument(null, "outputFormat", false, 1, "{ldif|json|csv|multi-valued-csv|tab-delimited|multi-valued-tab-delimited|dns-only|values-only}", LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_OUTPUT_FORMAT.get(), outputFormatAllowedValues, "ldif");
        this.outputFormat.addLongIdentifier("output-format", true);
        this.outputFormat.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.outputFormat);
        this.wrapColumn = new IntegerArgument(null, "wrapColumn", false, 1, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_WRAP_COLUMN.get(), 5, Integer.MAX_VALUE);
        this.wrapColumn.addLongIdentifier("wrap-column", true);
        this.wrapColumn.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.wrapColumn);
        this.doNotWrap = new BooleanArgument(Character.valueOf('T'), "doNotWrap", 1, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_DO_NOT_WRAP.get());
        this.doNotWrap.addLongIdentifier("do-not-wrap", true);
        this.doNotWrap.addLongIdentifier("dontWrap", true);
        this.doNotWrap.addLongIdentifier("dont-wrap", true);
        this.doNotWrap.addLongIdentifier("noWrap", true);
        this.doNotWrap.addLongIdentifier("no-wrap", true);
        this.doNotWrap.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.doNotWrap);
        this.baseDN = new DNArgument(Character.valueOf('b'), "baseDN", false, 1, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_BASE_DN.get());
        this.baseDN.addLongIdentifier("base-dn", true);
        this.baseDN.addLongIdentifier("searchBaseDN", true);
        this.baseDN.addLongIdentifier("search-base-dn", true);
        this.baseDN.addLongIdentifier("searchBase", true);
        this.baseDN.addLongIdentifier("search-base", true);
        this.baseDN.addLongIdentifier("base", true);
        this.baseDN.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_CRITERIA.get());
        parser.addArgument(this.baseDN);
        this.scope = new ScopeArgument(Character.valueOf('s'), "scope", false, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_SCOPE.get());
        this.scope.addLongIdentifier("searchScope", true);
        this.scope.addLongIdentifier("search-scope", true);
        this.scope.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_CRITERIA.get());
        parser.addArgument(this.scope);
        this.filterFile = new FileArgument(Character.valueOf('f'), "filterFile", false, 0, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_FILTER_FILE.get(), true, true, true, false);
        this.filterFile.addLongIdentifier("filter-file", true);
        this.filterFile.addLongIdentifier("filtersFile", true);
        this.filterFile.addLongIdentifier("filters-file", true);
        this.filterFile.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_CRITERIA.get());
        parser.addArgument(this.filterFile);
        this.ldapURLFile = new FileArgument(null, "ldapURLFile", false, 0, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_LDAP_URL_FILE.get(), true, true, true, false);
        this.ldapURLFile.addLongIdentifier("ldap-url-file", true);
        this.ldapURLFile.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_CRITERIA.get());
        parser.addArgument(this.ldapURLFile);
        this.sizeLimit = new IntegerArgument(Character.valueOf('z'), "sizeLimit", false, 1, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_SIZE_LIMIT.get(), 0, Integer.MAX_VALUE, 0);
        this.sizeLimit.addLongIdentifier("size-limit", true);
        this.sizeLimit.addLongIdentifier("searchSizeLimit", true);
        this.sizeLimit.addLongIdentifier("search-size-limit", true);
        this.sizeLimit.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_CRITERIA.get());
        this.sizeLimit.setHidden(true);
        parser.addArgument(this.sizeLimit);
        this.timeLimitSeconds = new IntegerArgument(Character.valueOf('t'), "timeLimitSeconds", false, 1, null, LDIFMessages.INFO_LDIFSEARCH_ARG_DESC_TIME_LIMIT_SECONDS.get(), 0, Integer.MAX_VALUE, 0);
        this.timeLimitSeconds.addLongIdentifier("time-limit-seconds", true);
        this.timeLimitSeconds.addLongIdentifier("timeLimit", true);
        this.timeLimitSeconds.setArgumentGroupName(LDIFMessages.INFO_LDIFSEARCH_ARG_GROUP_CRITERIA.get());
        this.timeLimitSeconds.setHidden(true);
        parser.addArgument(this.timeLimitSeconds);
        parser.addDependentArgumentSet(this.separateOutputFilePerSearch, this.outputFile, new Argument[0]);
        parser.addDependentArgumentSet(this.compressOutput, this.outputFile, new Argument[0]);
        parser.addDependentArgumentSet(this.encryptOutput, this.outputFile, new Argument[0]);
        parser.addDependentArgumentSet(this.overwriteExistingOutputFile, this.outputFile, new Argument[0]);
        parser.addDependentArgumentSet(this.outputEncryptionPassphraseFile, this.encryptOutput, new Argument[0]);
        parser.addExclusiveArgumentSet(this.wrapColumn, this.doNotWrap, new Argument[0]);
        parser.addExclusiveArgumentSet(this.baseDN, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.scope, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.filterFile, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.outputFormat, this.separateOutputFilePerSearch, new Argument[0]);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        File outFile = this.outputFile.getValue();
        if (outFile != null && outFile.exists() && (this.compressOutput.isPresent() || this.encryptOutput.isPresent()) && !this.overwriteExistingOutputFile.isPresent()) {
            throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_APPEND_WITH_COMPRESSION_OR_ENCRYPTION.get(this.compressOutput.getIdentifierString(), this.encryptOutput.getIdentifierString(), this.overwriteExistingOutputFile.getIdentifierString()));
        }
        List<String> trailingArgs = this.parser.getTrailingArguments();
        ArrayList<String> requestedAttributes = new ArrayList<String>();
        if (this.filterFile.isPresent()) {
            if (!trailingArgs.isEmpty()) {
                try {
                    Filter.create(trailingArgs.get(0));
                    throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_FILTER_FILE_WITH_TRAILING_FILTER.get());
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
            }
            requestedAttributes.addAll(trailingArgs);
            this.readFilterFile();
        } else if (this.ldapURLFile.isPresent()) {
            if (!trailingArgs.isEmpty()) {
                throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_LDAP_URL_FILE_WITH_TRAILING_ARGS.get());
            }
            this.readLDAPURLFile();
            if (this.searchURLs.size() > 1 && !this.separateOutputFilePerSearch.isPresent()) {
                Iterator<LDAPURL> iterator = this.searchURLs.iterator();
                HashSet<String> requestedAttrs = new HashSet<String>(Arrays.asList(iterator.next().getAttributes()));
                while (iterator.hasNext()) {
                    HashSet<String> attrSet = new HashSet<String>(Arrays.asList(iterator.next().getAttributes()));
                    if (requestedAttrs.equals(attrSet)) continue;
                    throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_DIFFERENT_URL_ATTRS_IN_SAME_FILE.get(this.ldapURLFile.getIdentifierString(), this.separateOutputFilePerSearch.getIdentifierString()));
                }
            }
        } else {
            SearchScope searchScope;
            Filter filter;
            if (trailingArgs.isEmpty()) {
                throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_NO_FILTER.get());
            }
            try {
                ArrayList<String> trailingArgList = new ArrayList<String>(trailingArgs);
                Iterator trailingArgIterator = trailingArgList.iterator();
                filter = Filter.create((String)trailingArgIterator.next());
                while (trailingArgIterator.hasNext()) {
                    requestedAttributes.add((String)trailingArgIterator.next());
                }
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_FIRST_TRAILING_ARG_NOT_FILTER.get(), e);
            }
            DN dn = this.baseDN.getValue();
            if (dn == null) {
                dn = DN.NULL_DN;
            }
            if ((searchScope = this.scope.getValue()) == null) {
                searchScope = SearchScope.SUB;
            }
            try {
                this.searchURLs.add(new LDAPURL("ldap", null, null, dn, requestedAttributes.toArray(StaticUtils.NO_STRINGS), searchScope, filter));
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new ArgumentException(StaticUtils.getExceptionMessage(e), e);
            }
        }
        String outputFormatStr = StaticUtils.toLowerCase(this.outputFormat.getValue());
        if (outputFormatStr.equals("json")) {
            this.resultWriter = new JSONLDAPResultWriter(this.getOut());
        } else if (outputFormatStr.equals("csv") || outputFormatStr.equals("multi-valued-csv") || outputFormatStr.equals("tab-delimited") || outputFormatStr.equals("multi-valued-tab-delimited")) {
            boolean includeAllValues;
            OutputFormat format;
            if (this.ldapURLFile.isPresent()) {
                throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_OUTPUT_FORMAT_NOT_SUPPORTED_WITH_URLS.get(this.outputFormat.getValue(), this.ldapURLFile.getIdentifierString()));
            }
            if (requestedAttributes.isEmpty()) {
                throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_OUTPUT_FORMAT_REQUIRES_REQUESTED_ATTRS.get(this.outputFormat.getValue()));
            }
            switch (outputFormatStr) {
                case "multi-valued-csv": {
                    format = OutputFormat.CSV;
                    includeAllValues = true;
                    break;
                }
                case "tab-delimited": {
                    format = OutputFormat.TAB_DELIMITED_TEXT;
                    includeAllValues = false;
                    break;
                }
                case "multi-valued-tab-delimited": {
                    format = OutputFormat.TAB_DELIMITED_TEXT;
                    includeAllValues = true;
                    break;
                }
                default: {
                    format = OutputFormat.CSV;
                    includeAllValues = false;
                }
            }
            this.resultWriter = new ColumnBasedLDAPResultWriter(this.getOut(), format, requestedAttributes, WRAP_COLUMN, includeAllValues);
        } else if (outputFormatStr.equals("dns-only")) {
            this.resultWriter = new DNsOnlyLDAPResultWriter(this.getOut());
        } else if (outputFormatStr.equals("values-only")) {
            this.resultWriter = new ValuesOnlyLDAPResultWriter(this.getOut());
        } else {
            int wc = this.doNotWrap.isPresent() ? Integer.MAX_VALUE : (this.wrapColumn.isPresent() ? this.wrapColumn.getValue() : WRAP_COLUMN);
            this.resultWriter = new LDIFLDAPResultWriter(this.getOut(), wc);
        }
    }

    private void readFilterFile() throws ArgumentException {
        SearchScope searchScope;
        DN dn = this.baseDN.getValue();
        if (dn == null) {
            dn = DN.NULL_DN;
        }
        if ((searchScope = this.scope.getValue()) == null) {
            searchScope = SearchScope.SUB;
        }
        String[] requestedAttributes = this.parser.getTrailingArguments().toArray(StaticUtils.NO_STRINGS);
        for (File f : this.filterFile.getValues()) {
            InputStream inputStream;
            try {
                inputStream = this.openInputStream(f);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new ArgumentException(e.getMessage(), e);
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        try {
                            Filter filter = Filter.create(line.trim());
                            this.searchURLs.add(new LDAPURL("ldap", null, null, dn, requestedAttributes, searchScope, filter));
                        }
                        catch (LDAPException e) {
                            Debug.debugException(e);
                            throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_FILTER_FILE_INVALID_FILTER.get(line, f.getAbsolutePath(), e.getMessage()), e);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
                throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_ERROR_READING_FILTER_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        if (this.searchURLs.isEmpty()) {
            throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_NO_FILTERS_FROM_FILE.get(this.filterFile.getValues().get(0).getAbsolutePath()));
        }
    }

    private void readLDAPURLFile() throws ArgumentException {
        for (File f : this.ldapURLFile.getValues()) {
            InputStream inputStream;
            try {
                inputStream = this.openInputStream(f);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new ArgumentException(e.getMessage(), e);
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        try {
                            this.searchURLs.add(new LDAPURL(line.trim()));
                        }
                        catch (LDAPException e) {
                            Debug.debugException(e);
                            throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_LDAP_URL_FILE_INVALID_URL.get(line, f.getAbsolutePath(), e.getMessage()), e);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
                throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_ERROR_READING_LDAP_URL_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        if (this.searchURLs.isEmpty()) {
            throw new ArgumentException(LDIFMessages.ERR_LDIFSEARCH_NO_URLS_FROM_FILE.get(this.ldapURLFile.getValues().get(0).getAbsolutePath()));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static Schema getSchema(@NotNull List<File> paths) throws Exception {
        LinkedHashSet<File> schemaFiles = new LinkedHashSet<File>();
        for (File f : paths) {
            if (!f.exists()) continue;
            if (f.isFile()) {
                schemaFiles.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            TreeMap<String, File> sortedFiles = new TreeMap<String, File>();
            for (File fileInDir : f.listFiles()) {
                if (!fileInDir.isFile()) continue;
                sortedFiles.put(fileInDir.getName(), fileInDir);
            }
            schemaFiles.addAll(sortedFiles.values());
        }
        return Schema.getSchema(new ArrayList<File>(schemaFiles));
    }

    @NotNull
    private InputStream openInputStream(@NotNull File f) throws LDAPException {
        if (this.ldifEncryptionPassphraseFile.isPresent() && !this.ldifEncryptionPassphraseFileRead) {
            this.readPassphraseFile(this.ldifEncryptionPassphraseFile.getValue());
            this.ldifEncryptionPassphraseFileRead = true;
        }
        boolean closeStream = true;
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
            ObjectPair<InputStream, char[]> p = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, this.inputEncryptionPassphrases, !this.ldifEncryptionPassphraseFile.isPresent(), (CharSequence)LDIFMessages.INFO_LDIFSEARCH_ENTER_ENCRYPTION_PW.get(f.getName()), (CharSequence)LDIFMessages.ERR_LDIFSEARCH_WRONG_ENCRYPTION_PW.get(), this.getOut(), this.getErr());
            inputStream = p.getFirst();
            this.addPassphrase(p.getSecond());
            inputStream = ToolUtils.getPossiblyGZIPCompressedInputStream(inputStream);
            closeStream = false;
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFSEARCH_ERROR_OPENING_INPUT_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        finally {
            if (inputStream != null && closeStream) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    private void readPassphraseFile(@NotNull File f) throws LDAPException {
        try {
            this.addPassphrase(this.getPasswordFileReader().readPassword(f));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFSEARCH_CANNOT_READ_PW_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private void addPassphrase(@Nullable char[] passphrase) {
        if (passphrase == null) {
            return;
        }
        for (char[] existingPassphrase : this.inputEncryptionPassphrases) {
            if (!Arrays.equals(existingPassphrase, passphrase)) continue;
            return;
        }
        this.inputEncryptionPassphrases.add(passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private OutputStream createOutputStream(@NotNull File f) throws LDAPException {
        OutputStream outputStream = null;
        boolean closeOutputStream = true;
        try {
            try {
                outputStream = new FileOutputStream(f, !this.overwriteExistingOutputFile.isPresent());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFSEARCH_CANNOT_OPEN_OUTPUT_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            if (this.encryptOutput.isPresent()) {
                try {
                    char[] passphrase = this.outputEncryptionPassphraseFile.isPresent() ? this.getPasswordFileReader().readPassword(this.outputEncryptionPassphraseFile.getValue()) : ToolUtils.promptForEncryptionPassphrase(false, true, LDIFMessages.INFO_LDIFSEARCH_PROMPT_OUTPUT_FILE_ENC_PW.get(), LDIFMessages.INFO_LDIFSEARCH_CONFIRM_OUTPUT_FILE_ENC_PW.get(), this.getOut(), this.getErr()).toCharArray();
                    outputStream = new PassphraseEncryptedOutputStream(passphrase, outputStream, null, true, true);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFSEARCH_CANNOT_ENCRYPT_OUTPUT_FILE.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.compressOutput.isPresent()) {
                try {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFSEARCH_CANNOT_COMPRESS_OUTPUT_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
            }
            closeOutputStream = false;
            OutputStream outputStream2 = outputStream;
            return outputStream2;
        }
        finally {
            if (closeOutputStream && outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private LDIFWriter createLDIFWriter(@NotNull File f, @Nullable LDAPURL ldapURL) throws LDAPException {
        boolean closeOutputStream = true;
        OutputStream outputStream = this.createOutputStream(f);
        try {
            LDIFWriter ldifWriter = new LDIFWriter(outputStream);
            if (this.doNotWrap.isPresent()) {
                ldifWriter.setWrapColumn(0);
            } else if (this.wrapColumn.isPresent()) {
                ldifWriter.setWrapColumn(this.wrapColumn.getValue());
            } else {
                ldifWriter.setWrapColumn(WRAP_COLUMN);
            }
            if (ldapURL != null) {
                try {
                    ldifWriter.writeComment(LDIFMessages.INFO_LDIFSEARCH_ENTRIES_MATCHING_URL.get(ldapURL.toString()), false, true);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            closeOutputStream = false;
            LDIFWriter lDIFWriter = ldifWriter;
            return lDIFWriter;
        }
        finally {
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    private boolean urlMatchesEntry(@NotNull LDAPURL url, @NotNull Entry entry) {
        try {
            return entry.matchesBaseAndScope(url.getBaseDN(), url.getScope()) && url.getFilter().matchesEntry(entry);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    private void commentToOut(@NotNull String message) {
        this.getOut().flush();
        for (String line : StaticUtils.wrapLine(message, WRAP_COLUMN - 2)) {
            this.out("# " + line);
        }
        this.getOut().flush();
    }

    private void commentToErr(@NotNull String message) {
        this.getErr().flush();
        for (String line : StaticUtils.wrapLine(message, WRAP_COLUMN - 2)) {
            this.err("# " + line);
        }
        this.getErr().flush();
    }

    private void logCompletionMessage(boolean isError, @NotNull String message) {
        this.completionMessage.compareAndSet(null, message);
        if (!this.outputFile.isPresent()) {
            this.resultWriter.writeComment(message);
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--ldifFile", "data.ldif", "(uid=jdoe)"}, LDIFMessages.INFO_LDIFSEARCH_EXAMPLE_1.get());
        examples.put(new String[]{"--ldifFile", "data.ldif", "--outputFile", "people.ldif", "--baseDN", "dc=example,dc=com", "--scope", "sub", "(objectClass=person)", "givenName", "sn", "cn"}, LDIFMessages.INFO_LDIFSEARCH_EXAMPLE_2.get());
        return examples;
    }
}

