/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.listener.CannedResponseRequestHandler;
import com.unboundid.ldap.listener.LDAPListener;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.examples.AuthRate;
import com.unboundid.ldap.sdk.examples.ModRate;
import com.unboundid.ldap.sdk.examples.SearchAndModRate;
import com.unboundid.ldap.sdk.examples.SearchRate;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.cert.ManageCertificates;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ServerSocketFactory;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class TestLDAPSDKPerformance
extends CommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private static final String TOOL_NAME_AUTHRATE = "authrate";
    @NotNull
    private static final String TOOL_NAME_MODRATE = "modrate";
    @NotNull
    private static final String TOOL_NAME_SEARCH_AND_MOD_RATE = "search-and-mod-rate";
    @NotNull
    private static final String TOOL_NAME_SEARCHRATE = "searchrate";
    @NotNull
    private final AtomicReference<String> completionMessage = new AtomicReference();
    @Nullable
    private BooleanArgument bindOnlyArg = null;
    @Nullable
    private BooleanArgument useSSLArg = null;
    @Nullable
    private IntegerArgument entriesPerSearchArg = null;
    @Nullable
    private IntegerArgument intervalDurationSecondsArg = null;
    @Nullable
    private IntegerArgument numIntervalsArg = null;
    @Nullable
    private IntegerArgument numThreadsArg = null;
    @Nullable
    private IntegerArgument resultCodeArg = null;
    @Nullable
    private IntegerArgument warmUpIntervalsArg = null;
    @Nullable
    private StringArgument diagnosticMessageArg = null;
    @Nullable
    private StringArgument toolArg = null;

    public static void main(String ... args) {
        ResultCode resultCode = TestLDAPSDKPerformance.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        TestLDAPSDKPerformance tool = new TestLDAPSDKPerformance(out, err);
        return tool.runTool(args);
    }

    public TestLDAPSDKPerformance(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "test-ldap-sdk-performance";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "Provides a mechanism to help test the performance of the LDAP SDK.";
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        return Collections.singletonList("It creates an LDAP listener that uses a canned-response request handler to return a predefined response to all requests.  Itthen invokes another tool (either searchrate, modrate, authrate, or search-and-mod-rate) to issue concurrent requests against that listener as quickly as possible.");
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.6";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    @Nullable
    protected String getToolCompletionMessage() {
        return this.completionMessage.get();
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.toolArg = new StringArgument(null, "tool", true, 1, "{searchrate|modrate|authrate|search-and-mod-rate}", "The tool to invoke against the LDAP listener.  It may be one of searchrate, modrate, authrate, or search-and-mod-rate.  If this is not provided, then the searchrate tool will be invoked.", StaticUtils.setOf(TOOL_NAME_SEARCHRATE, TOOL_NAME_MODRATE, TOOL_NAME_AUTHRATE, TOOL_NAME_SEARCH_AND_MOD_RATE), TOOL_NAME_SEARCHRATE);
        this.toolArg.addLongIdentifier("toolName", true);
        this.toolArg.addLongIdentifier("tool-name", true);
        parser.addArgument(this.toolArg);
        this.numThreadsArg = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, "{num}", "The number of concurrent threads (each using its own connection) to use to process requests.  If this is not provided, then a single thread will be used.", 1, Integer.MAX_VALUE, 1);
        this.numThreadsArg.addLongIdentifier("num-threads", true);
        this.numThreadsArg.addLongIdentifier("threads", true);
        parser.addArgument(this.numThreadsArg);
        this.entriesPerSearchArg = new IntegerArgument(null, "entriesPerSearch", true, 1, "{num}", "The number of entries to return in response to each search request.  If this is provided, the value must be between 0 and 100.  If it is not provided, then a single entry will be returned.", 0, 100, 1);
        this.entriesPerSearchArg.addLongIdentifier("entries-per-search", true);
        this.entriesPerSearchArg.addLongIdentifier("numEntries", true);
        this.entriesPerSearchArg.addLongIdentifier("num-entries", true);
        this.entriesPerSearchArg.addLongIdentifier("entries", true);
        parser.addArgument(this.entriesPerSearchArg);
        this.bindOnlyArg = new BooleanArgument(null, "bindOnly", 1, "Indicates that the authrate tool should only issue bind requests.  If this is not provided, the authrate tool will perform both search and bind operations.  This argument will only be used in conjunction with the authrate tool.");
        this.bindOnlyArg.addLongIdentifier("bind-only", true);
        parser.addArgument(this.bindOnlyArg);
        this.resultCodeArg = new IntegerArgument(null, "resultCode", true, 1, "{intValue}", "The integer value for the result code to return in response to each request.  If this is not provided, then a result code of 0 (success) will be returned.", 0, Integer.MAX_VALUE, 0);
        this.resultCodeArg.addLongIdentifier("result-code", true);
        parser.addArgument(this.resultCodeArg);
        this.diagnosticMessageArg = new StringArgument(null, "diagnosticMessage", false, 1, "{message}", "The diagnostic message to return in response to each request.  If this is not provided, then no diagnostic message will be returned.");
        this.diagnosticMessageArg.addLongIdentifier("diagnostic-message", true);
        this.diagnosticMessageArg.addLongIdentifier("errorMessage", true);
        this.diagnosticMessageArg.addLongIdentifier("error-message", true);
        this.diagnosticMessageArg.addLongIdentifier("message", true);
        parser.addArgument(this.diagnosticMessageArg);
        this.useSSLArg = new BooleanArgument(Character.valueOf('Z'), "useSSL", 1, "Encrypt communication with SSL.  If this argument is not provided, then the communication will not be encrypted.");
        this.useSSLArg.addLongIdentifier("use-ssl", true);
        this.useSSLArg.addLongIdentifier("ssl", true);
        this.useSSLArg.addLongIdentifier("useTLS", true);
        this.useSSLArg.addLongIdentifier("use-tls", true);
        this.useSSLArg.addLongIdentifier("tls", true);
        parser.addArgument(this.useSSLArg);
        this.numIntervalsArg = new IntegerArgument(Character.valueOf('I'), "numIntervals", false, 1, "{num}", "The number of intervals to use when running the performance measurement tool.  If this argument is provided in conjunction with the --warmUpIntervals argument, then the warm-up intervals will not be included in this count, and the total number of intervals run will be the sum of the two values.  If this argument is not provided, then the tool will run until it is interrupted (e.g., by pressing Ctrl+C or by killing the underlying Java process).", 0, Integer.MAX_VALUE);
        this.numIntervalsArg.addLongIdentifier("num-intervals", true);
        this.numIntervalsArg.addLongIdentifier("intervals", true);
        parser.addArgument(this.numIntervalsArg);
        this.intervalDurationSecondsArg = new IntegerArgument(Character.valueOf('i'), "intervalDurationSeconds", true, 1, "{num}", "The length of time in seconds to use for each tool interval (that is, the length of time between each line of output giving statistical information for operations processed in that interval).  If this is not provided, then a default interval duration of five seconds will be used.", 1, Integer.MAX_VALUE, 5);
        this.intervalDurationSecondsArg.addLongIdentifier("interval-duration-seconds", true);
        this.intervalDurationSecondsArg.addLongIdentifier("intervalDuration", true);
        this.intervalDurationSecondsArg.addLongIdentifier("interval-duration", true);
        parser.addArgument(this.intervalDurationSecondsArg);
        this.warmUpIntervalsArg = new IntegerArgument(null, "warmUpIntervals", true, 1, "{num}", "The number of intervals to run before starting to actually collect statistics to include in the final result.  This can give the JVM and JIT a chance to identify and optimize hotspots in the code for the best and most stable performance.  If this is not provided, then no warm-up intervals will be used and the tool will start collecting statistics right away.", 0, Integer.MAX_VALUE, 0);
        this.warmUpIntervalsArg.addLongIdentifier("warm-up-intervals", true);
        this.warmUpIntervalsArg.addLongIdentifier("warmup-intervals", true);
        this.warmUpIntervalsArg.addLongIdentifier("warmUp", true);
        this.warmUpIntervalsArg.addLongIdentifier("warm-up", true);
        parser.addArgument(this.warmUpIntervalsArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        ServerSocketFactory serverSocketFactory;
        if (this.useSSLArg.isPresent()) {
            try {
                File keyStoreFile = File.createTempFile("test-ldap-sdk-performance-keystore-", ".jks");
                keyStoreFile.deleteOnExit();
                keyStoreFile.delete();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ResultCode manageCertificatesResultCode = ManageCertificates.main(null, out, out, "generate-self-signed-certificate", "--keystore", keyStoreFile.getAbsolutePath(), "--keystore-password", keyStoreFile.getAbsolutePath(), "--keystore-type", "JKS", "--alias", "server-cert", "--subject-dn", "CN=Test LDAP SDK Performance");
                if (manageCertificatesResultCode != ResultCode.SUCCESS) {
                    String message = "ERROR:  Unable to use the manage-certificates tool to generate a self-signed server certificate to use for SSL communication.";
                    this.completionMessage.compareAndSet(null, "ERROR:  Unable to use the manage-certificates tool to generate a self-signed server certificate to use for SSL communication.");
                    this.wrapErr(0, WRAP_COLUMN, "ERROR:  Unable to use the manage-certificates tool to generate a self-signed server certificate to use for SSL communication.");
                    this.err(new Object[0]);
                    this.wrapErr(0, WRAP_COLUMN, "The manage-certificates output was:");
                    this.err(new Object[0]);
                    this.err(StaticUtils.toUTF8String(out.toByteArray()));
                    return manageCertificatesResultCode;
                }
                SSLUtil sslUtil = new SSLUtil(new KeyStoreKeyManager(keyStoreFile, keyStoreFile.getAbsolutePath().toCharArray(), "JKS", "server-cert"), new TrustAllTrustManager());
                serverSocketFactory = sslUtil.createSSLServerSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                String message = "ERROR:  Unable to initialize support for SSL communication:  " + StaticUtils.getExceptionMessage(e);
                this.completionMessage.compareAndSet(null, message);
                this.wrapErr(0, WRAP_COLUMN, message);
                return ResultCode.LOCAL_ERROR;
            }
        } else {
            serverSocketFactory = ServerSocketFactory.getDefault();
        }
        int numEntries = this.entriesPerSearchArg.getValue();
        ArrayList<Entry> entries = new ArrayList<Entry>(numEntries);
        for (int i = 1; i <= numEntries; ++i) {
            entries.add(new Entry("uid=user." + i + ",ou=People,dc=example,dc=com", new Attribute("objectClass", "top", "person", "organizationalPerson", "inetOrgPerson"), new Attribute("uid", "user." + i), new Attribute("givenName", "User"), new Attribute("sn", String.valueOf(i)), new Attribute("cn", "User " + i), new Attribute("mail", "user." + i + "@example.com"), new Attribute("userPassword", "password")));
        }
        CannedResponseRequestHandler cannedResponseRequestHandler = new CannedResponseRequestHandler(ResultCode.valueOf(this.resultCodeArg.getValue()), null, this.diagnosticMessageArg.getValue(), Collections.emptyList(), entries, Collections.emptyList());
        LDAPListenerConfig listenerConfig = new LDAPListenerConfig(0, cannedResponseRequestHandler);
        listenerConfig.setServerSocketFactory(serverSocketFactory);
        LDAPListener ldapListener = new LDAPListener(listenerConfig);
        try {
            ldapListener.startListening();
        }
        catch (Exception e) {
            Debug.debugException(e);
            String message = "ERROR:  Unable to start listening for client connections:  " + StaticUtils.getExceptionMessage(e);
            this.completionMessage.compareAndSet(null, message);
            this.wrapErr(0, WRAP_COLUMN, message);
            return ResultCode.LOCAL_ERROR;
        }
        try {
            String toolName;
            int listenPort = ldapListener.getListenPort();
            switch (toolName = StaticUtils.toLowerCase(this.toolArg.getValue())) {
                case "searchrate": {
                    ResultCode resultCode = this.invokeSearchRate(listenPort);
                    return resultCode;
                }
                case "modrate": {
                    ResultCode resultCode = this.invokeModRate(listenPort);
                    return resultCode;
                }
                case "authrate": {
                    ResultCode resultCode = this.invokeAuthRate(listenPort);
                    return resultCode;
                }
                case "search-and-mod-rate": {
                    ResultCode resultCode = this.invokeSearchAndModRate(listenPort);
                    return resultCode;
                }
            }
            String message = "ERROR:  Unrecognized tool name:  " + toolName;
            this.completionMessage.compareAndSet(null, message);
            this.wrapErr(0, WRAP_COLUMN, message);
            ResultCode resultCode = ResultCode.PARAM_ERROR;
            return resultCode;
        }
        finally {
            ldapListener.shutDown(true);
        }
    }

    @NotNull
    private ResultCode invokeSearchRate(int listenPort) {
        ArrayList<String> searchRateArgs = new ArrayList<String>();
        searchRateArgs.add("--hostname");
        searchRateArgs.add("localhost");
        searchRateArgs.add("--port");
        searchRateArgs.add(String.valueOf(listenPort));
        if (this.useSSLArg.isPresent()) {
            searchRateArgs.add("--useSSL");
            searchRateArgs.add("--trustAll");
        }
        searchRateArgs.add("--baseDN");
        searchRateArgs.add("dc=example,dc=com");
        searchRateArgs.add("--scope");
        searchRateArgs.add("sub");
        searchRateArgs.add("--filter");
        searchRateArgs.add("(objectClass=*)");
        searchRateArgs.add("--numThreads");
        searchRateArgs.add(String.valueOf(this.numThreadsArg.getValue()));
        if (this.numIntervalsArg.isPresent()) {
            searchRateArgs.add("--numIntervals");
            searchRateArgs.add(String.valueOf(this.numIntervalsArg.getValue()));
        }
        if (this.intervalDurationSecondsArg.isPresent()) {
            searchRateArgs.add("--intervalDuration");
            searchRateArgs.add(String.valueOf(this.intervalDurationSecondsArg.getValue()));
        }
        if (this.warmUpIntervalsArg.isPresent()) {
            searchRateArgs.add("--warmUpIntervals");
            searchRateArgs.add(String.valueOf(this.warmUpIntervalsArg.getValue()));
        }
        String[] searchRateArgsArray = searchRateArgs.toArray(StaticUtils.NO_STRINGS);
        SearchRate searchRate = new SearchRate(this.getOut(), this.getErr());
        ResultCode searchRateResultCode = searchRate.runTool(searchRateArgsArray);
        if (searchRateResultCode == ResultCode.SUCCESS) {
            String message = "The searchrate tool completed successfully.";
            this.completionMessage.compareAndSet(null, "The searchrate tool completed successfully.");
            this.wrapOut(0, WRAP_COLUMN, "The searchrate tool completed successfully.");
        } else {
            String message = "ERROR:  The searchrate tool exited with error result code " + searchRateResultCode + '.';
            this.completionMessage.compareAndSet(null, message);
            this.wrapErr(0, WRAP_COLUMN, message);
        }
        return searchRateResultCode;
    }

    @NotNull
    private ResultCode invokeModRate(int listenPort) {
        ArrayList<String> modRateArgs = new ArrayList<String>();
        modRateArgs.add("--hostname");
        modRateArgs.add("localhost");
        modRateArgs.add("--port");
        modRateArgs.add(String.valueOf(listenPort));
        if (this.useSSLArg.isPresent()) {
            modRateArgs.add("--useSSL");
            modRateArgs.add("--trustAll");
        }
        modRateArgs.add("--entryDN");
        modRateArgs.add("dc=example,dc=com");
        modRateArgs.add("--attribute");
        modRateArgs.add("description");
        modRateArgs.add("--valuePattern");
        modRateArgs.add("value");
        modRateArgs.add("--numThreads");
        modRateArgs.add(String.valueOf(this.numThreadsArg.getValue()));
        if (this.numIntervalsArg.isPresent()) {
            modRateArgs.add("--numIntervals");
            modRateArgs.add(String.valueOf(this.numIntervalsArg.getValue()));
        }
        if (this.intervalDurationSecondsArg.isPresent()) {
            modRateArgs.add("--intervalDuration");
            modRateArgs.add(String.valueOf(this.intervalDurationSecondsArg.getValue()));
        }
        if (this.warmUpIntervalsArg.isPresent()) {
            modRateArgs.add("--warmUpIntervals");
            modRateArgs.add(String.valueOf(this.warmUpIntervalsArg.getValue()));
        }
        String[] modRateArgsArray = modRateArgs.toArray(StaticUtils.NO_STRINGS);
        ModRate modRate = new ModRate(this.getOut(), this.getErr());
        ResultCode modRateResultCode = modRate.runTool(modRateArgsArray);
        if (modRateResultCode == ResultCode.SUCCESS) {
            String message = "The modrate tool completed successfully.";
            this.completionMessage.compareAndSet(null, "The modrate tool completed successfully.");
            this.wrapOut(0, WRAP_COLUMN, "The modrate tool completed successfully.");
        } else {
            String message = "ERROR:  The modrate tool exited with error result code " + modRateResultCode + '.';
            this.completionMessage.compareAndSet(null, message);
            this.wrapErr(0, WRAP_COLUMN, message);
        }
        return modRateResultCode;
    }

    @NotNull
    private ResultCode invokeAuthRate(int listenPort) {
        ArrayList<String> authRateArgs = new ArrayList<String>();
        authRateArgs.add("--hostname");
        authRateArgs.add("localhost");
        authRateArgs.add("--port");
        authRateArgs.add(String.valueOf(listenPort));
        if (this.useSSLArg.isPresent()) {
            authRateArgs.add("--useSSL");
            authRateArgs.add("--trustAll");
        }
        if (this.bindOnlyArg.isPresent()) {
            authRateArgs.add("--bindOnly");
            authRateArgs.add("--baseDN");
            authRateArgs.add("uid=user.1,ou=People,dc=example,dc=com");
        } else {
            authRateArgs.add("--baseDN");
            authRateArgs.add("dc=example,dc=com");
            authRateArgs.add("--scope");
            authRateArgs.add("sub");
            authRateArgs.add("--filter");
            authRateArgs.add("(uid=user.1)");
        }
        authRateArgs.add("--credentials");
        authRateArgs.add("password");
        authRateArgs.add("--numThreads");
        authRateArgs.add(String.valueOf(this.numThreadsArg.getValue()));
        if (this.numIntervalsArg.isPresent()) {
            authRateArgs.add("--numIntervals");
            authRateArgs.add(String.valueOf(this.numIntervalsArg.getValue()));
        }
        if (this.intervalDurationSecondsArg.isPresent()) {
            authRateArgs.add("--intervalDuration");
            authRateArgs.add(String.valueOf(this.intervalDurationSecondsArg.getValue()));
        }
        if (this.warmUpIntervalsArg.isPresent()) {
            authRateArgs.add("--warmUpIntervals");
            authRateArgs.add(String.valueOf(this.warmUpIntervalsArg.getValue()));
        }
        String[] authRateArgsArray = authRateArgs.toArray(StaticUtils.NO_STRINGS);
        AuthRate authRate = new AuthRate(this.getOut(), this.getErr());
        ResultCode authRateResultCode = authRate.runTool(authRateArgsArray);
        if (authRateResultCode == ResultCode.SUCCESS) {
            String message = "The authrate tool completed successfully.";
            this.completionMessage.compareAndSet(null, "The authrate tool completed successfully.");
            this.wrapOut(0, WRAP_COLUMN, "The authrate tool completed successfully.");
        } else {
            String message = "ERROR:  The authrate tool exited with error result code " + authRateResultCode + '.';
            this.completionMessage.compareAndSet(null, message);
            this.wrapErr(0, WRAP_COLUMN, message);
        }
        return authRateResultCode;
    }

    @NotNull
    private ResultCode invokeSearchAndModRate(int listenPort) {
        ArrayList<String> searchAndModRateArgs = new ArrayList<String>();
        searchAndModRateArgs.add("--hostname");
        searchAndModRateArgs.add("localhost");
        searchAndModRateArgs.add("--port");
        searchAndModRateArgs.add(String.valueOf(listenPort));
        if (this.useSSLArg.isPresent()) {
            searchAndModRateArgs.add("--useSSL");
            searchAndModRateArgs.add("--trustAll");
        }
        searchAndModRateArgs.add("--baseDN");
        searchAndModRateArgs.add("dc=example,dc=com");
        searchAndModRateArgs.add("--scope");
        searchAndModRateArgs.add("sub");
        searchAndModRateArgs.add("--filter");
        searchAndModRateArgs.add("(objectClass=*)");
        searchAndModRateArgs.add("--modifyAttribute");
        searchAndModRateArgs.add("description");
        searchAndModRateArgs.add("--valueLength");
        searchAndModRateArgs.add("10");
        searchAndModRateArgs.add("--numThreads");
        searchAndModRateArgs.add(String.valueOf(this.numThreadsArg.getValue()));
        if (this.numIntervalsArg.isPresent()) {
            searchAndModRateArgs.add("--numIntervals");
            searchAndModRateArgs.add(String.valueOf(this.numIntervalsArg.getValue()));
        }
        if (this.intervalDurationSecondsArg.isPresent()) {
            searchAndModRateArgs.add("--intervalDuration");
            searchAndModRateArgs.add(String.valueOf(this.intervalDurationSecondsArg.getValue()));
        }
        if (this.warmUpIntervalsArg.isPresent()) {
            searchAndModRateArgs.add("--warmUpIntervals");
            searchAndModRateArgs.add(String.valueOf(this.warmUpIntervalsArg.getValue()));
        }
        String[] searchAndModRateArgsArray = searchAndModRateArgs.toArray(StaticUtils.NO_STRINGS);
        SearchAndModRate searchAndModRate = new SearchAndModRate(this.getOut(), this.getErr());
        ResultCode searchAndModRateResultCode = searchAndModRate.runTool(searchAndModRateArgsArray);
        if (searchAndModRateResultCode == ResultCode.SUCCESS) {
            String message = "The search-and-mod-rate tool completed successfully.";
            this.completionMessage.compareAndSet(null, "The search-and-mod-rate tool completed successfully.");
            this.wrapOut(0, WRAP_COLUMN, "The search-and-mod-rate tool completed successfully.");
        } else {
            String message = "ERROR:  The search-and-mod-rate tool exited with error result code " + searchAndModRateResultCode + '.';
            this.completionMessage.compareAndSet(null, message);
            this.wrapErr(0, WRAP_COLUMN, message);
        }
        return searchAndModRateResultCode;
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--numThreads", "10"}, "Test LDAP SDK performance with the searchrate tool using ten concurrent threads.  Communication will use an insecure connection, and each search will return a success result with a single matching entry.  The tool will continue to run until it is interrupted.");
        examples.put(new String[]{"--tool", TOOL_NAME_MODRATE, "--numThreads", "10", "--useSSL", "--resultCode", "32", "--diagnosticMessage", "The base entry does not exist", "--warmUpIntervals", "5", "--numIntervals", "10", "--intervalDurationSeconds", "5"}, "Test LDAP SDK performance with the modrate tool using ten concurrent threads over SSL-encrypted connections.  Each modify will return an error result with a result code of 32 (noSuchObject) and a diagnostic message of 'The target entry does not exist'.  The tool will run five warm-up intervals of five seconds each, and then ten 5-second intervals in which it will capture statistics.  The tool will exit after those last ten intervals have completed.");
        return examples;
    }
}

