/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDiffCompactDN;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDiffDNDumper;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDiffProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDiffProcessorResult;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKThreadFactory;
import com.unboundid.util.MultiServerLDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Result;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPDiff
extends MultiServerLDAPCommandLineTool {
    static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private static final int MAX_ENTRIES_PER_BATCH = 1000;
    @NotNull
    private static final String DEFAULT_BIND_DN = "cn=Directory Manager";
    @NotNull
    private static final ResultCode LEGACY_EXIT_CODE_ARG_PARSING_ERROR = ResultCode.PROTOCOL_ERROR;
    @NotNull
    private static final ResultCode LEGACY_EXIT_CODE_OUT_OF_SYNC = ResultCode.TIME_LIMIT_EXCEEDED;
    @NotNull
    private static final ResultCode LEGACY_EXIT_CODE_SUCCESS = ResultCode.SUCCESS;
    @NotNull
    private static final ResultCode LEGACY_EXIT_CODE_UNEXPECTED_ERROR = ResultCode.OPERATIONS_ERROR;
    @NotNull
    private final AtomicReference<String> toolCompletionMessageRef = new AtomicReference();
    @Nullable
    private ArgumentParser parser = null;
    @Nullable
    private BooleanArgument byteForByteArg;
    @Nullable
    private BooleanArgument missingOnlyArg = null;
    @Nullable
    private BooleanArgument quietArg = null;
    @Nullable
    private DNArgument baseDNArg = null;
    @Nullable
    private DNArgument excludeBranchArg = null;
    @Nullable
    private FileArgument outputLDIFArg = null;
    @Nullable
    private FileArgument sourceDNsFileArg = null;
    @Nullable
    private FileArgument targetDNsFileArg = null;
    @Nullable
    private FilterArgument searchFilterArg = null;
    @Nullable
    private IntegerArgument numPassesArg = null;
    @Nullable
    private IntegerArgument numThreadsArg = null;
    @Nullable
    private IntegerArgument secondsBetweenPassesArg = null;
    @Nullable
    private IntegerArgument wrapColumnArg = null;
    @Nullable
    private ScopeArgument searchScopeArg = null;
    @Nullable
    private BooleanArgument legacyTrustAllArg = null;
    @Nullable
    private BooleanArgument useLegacyExitCodeArg = null;
    @Nullable
    private DNArgument legacySourceBindDNArg = null;
    @Nullable
    private FileArgument legacyKeyStorePathArg = null;
    @Nullable
    private FileArgument legacyKeyStorePasswordFileArg = null;
    @Nullable
    private FileArgument legacyTargetBindPasswordFileArg = null;
    @Nullable
    private FileArgument legacyTrustStorePathArg = null;
    @Nullable
    private FileArgument legacyTrustStorePasswordFileArg = null;
    @Nullable
    private IntegerArgument legacySourcePortArg = null;
    @Nullable
    private StringArgument legacyCertNicknameArg = null;
    @Nullable
    private StringArgument legacyKeyStoreFormatArg = null;
    @Nullable
    private StringArgument legacyKeyStorePasswordArg = null;
    @Nullable
    private StringArgument legacySourceBindPasswordArg = null;
    @Nullable
    private StringArgument legacySourceHostArg = null;
    @Nullable
    private StringArgument legacyTargetHostArg = null;
    @Nullable
    private StringArgument legacyTrustStoreFormatArg = null;
    @Nullable
    private StringArgument legacyTrustStorePasswordArg = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDAPDiff.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(Math.min(resultCode.intValue(), 255));
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        LDAPDiff ldapDiff = new LDAPDiff(out, err);
        ResultCode resultCode = ldapDiff.runTool(args);
        if (ldapDiff.useLegacyExitCodeArg != null && ldapDiff.useLegacyExitCodeArg.isPresent()) {
            switch (resultCode.intValue()) {
                case 0: {
                    resultCode = LEGACY_EXIT_CODE_SUCCESS;
                    break;
                }
                case 5: {
                    resultCode = LEGACY_EXIT_CODE_OUT_OF_SYNC;
                    break;
                }
                case 89: {
                    resultCode = LEGACY_EXIT_CODE_ARG_PARSING_ERROR;
                    break;
                }
                default: {
                    resultCode = LEGACY_EXIT_CODE_UNEXPECTED_ERROR;
                }
            }
        }
        return resultCode;
    }

    public LDAPDiff(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err, new String[]{"source", "target"}, null);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "ldap-diff";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_1.get();
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        File pingIdentityServerRoot = InternalSDKHelper.getPingIdentityServerRoot();
        if (pingIdentityServerRoot == null) {
            return Arrays.asList(ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_2.get(), ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_3.get(), ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_4_NON_PING_DS.get(), ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_5_NON_PING_DS.get());
        }
        return Arrays.asList(ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_2.get(), ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_3.get(), ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_4_PING_DS.get(), ToolMessages.INFO_LDAP_DIFF_TOOL_DESCRIPTION_5_PING_DS.get());
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.6";
    }

    @Override
    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setUsePooledSchema(true);
        return options;
    }

    @Override
    public int getMinTrailingArguments() {
        return 0;
    }

    @Override
    public int getMaxTrailingArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getTrailingArgumentsPlaceholder() {
        return ToolMessages.INFO_LDAP_DIFF_TRAILING_ARGS_PLACEHOLDER.get();
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        this.baseDNArg = new DNArgument(Character.valueOf('b'), "baseDN", true, 1, ToolMessages.INFO_LDAP_DIFF_ARG_PLACEHOLDER_BASE_DN.get(), ToolMessages.INFO_LDAP_DIFF_ARG_DESC_BASE_DN.get());
        this.baseDNArg.addLongIdentifier("base-dn", true);
        this.baseDNArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.baseDNArg);
        this.sourceDNsFileArg = new FileArgument(null, "sourceDNsFile", false, 1, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_SOURCE_DNS_FILE.get(), true, true, true, false);
        this.sourceDNsFileArg.addLongIdentifier("source-dns-file", true);
        this.sourceDNsFileArg.addLongIdentifier("sourceDNFile", true);
        this.sourceDNsFileArg.addLongIdentifier("source-dn-file", true);
        this.sourceDNsFileArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.sourceDNsFileArg);
        this.targetDNsFileArg = new FileArgument(null, "targetDNsFile", false, 1, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_TARGET_DNS_FILE.get(), true, true, true, false);
        this.targetDNsFileArg.addLongIdentifier("target-dns-file", true);
        this.targetDNsFileArg.addLongIdentifier("targetDNFile", true);
        this.targetDNsFileArg.addLongIdentifier("target-dn-file", true);
        this.targetDNsFileArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.targetDNsFileArg);
        this.excludeBranchArg = new DNArgument(Character.valueOf('B'), "excludeBranch", false, 0, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_EXCLUDE_BRANCH.get());
        this.excludeBranchArg.addLongIdentifier("exclude-branch", true);
        this.excludeBranchArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.excludeBranchArg);
        this.searchFilterArg = new FilterArgument(Character.valueOf('f'), "searchFilter", false, 1, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_FILTER.get(), Filter.createPresenceFilter("objectClass"));
        this.searchFilterArg.addLongIdentifier("search-filter", true);
        this.searchFilterArg.addLongIdentifier("filter", true);
        this.searchFilterArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.searchFilterArg);
        this.searchScopeArg = new ScopeArgument(Character.valueOf('s'), "searchScope", false, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_SCOPE.get(), SearchScope.SUB);
        this.searchScopeArg.addLongIdentifier("search-scope", true);
        this.searchScopeArg.addLongIdentifier("scope", true);
        this.searchScopeArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.searchScopeArg);
        this.outputLDIFArg = new FileArgument(Character.valueOf('o'), "outputLDIF", true, 1, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_OUTPUT_LDIF.get(), false, true, true, false);
        this.outputLDIFArg.addLongIdentifier("output-ldif", true);
        this.outputLDIFArg.addLongIdentifier("outputFile", true);
        this.outputLDIFArg.addLongIdentifier("output-file", true);
        this.outputLDIFArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.outputLDIFArg);
        this.wrapColumnArg = new IntegerArgument(null, "wrapColumn", false, 1, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_WRAP_COLUMN.get(), 0, Integer.MAX_VALUE, 0);
        this.wrapColumnArg.addLongIdentifier("wrap-column", true);
        this.wrapColumnArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.wrapColumnArg);
        this.quietArg = new BooleanArgument(Character.valueOf('Q'), "quiet", 1, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_QUIET.get());
        this.quietArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.quietArg);
        this.numThreadsArg = new IntegerArgument(null, "numThreads", false, 1, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_NUM_THREADS.get(), 1, Integer.MAX_VALUE, 20);
        this.numThreadsArg.addLongIdentifier("num-threads", true);
        this.numThreadsArg.addLongIdentifier("numConnections", true);
        this.numThreadsArg.addLongIdentifier("num-connections", true);
        this.numThreadsArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.numThreadsArg);
        this.numPassesArg = new IntegerArgument(null, "numPasses", false, 1, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_NUM_PASSES.get(), 1, Integer.MAX_VALUE, 3);
        this.numPassesArg.addLongIdentifier("num-passes", true);
        this.numPassesArg.addLongIdentifier("maxPasses", true);
        this.numPassesArg.addLongIdentifier("max-passes", true);
        this.numPassesArg.addLongIdentifier("maximum-Passes", true);
        this.numPassesArg.addLongIdentifier("maximum-passes", true);
        this.numPassesArg.addLongIdentifier("passes", true);
        this.numPassesArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.numPassesArg);
        this.secondsBetweenPassesArg = new IntegerArgument(null, "secondsBetweenPasses", false, 1, null, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_SECONDS_BETWEEN_PASSES.get(), 0, Integer.MAX_VALUE, 2);
        this.secondsBetweenPassesArg.addLongIdentifier("seconds-between-passes", true);
        this.secondsBetweenPassesArg.addLongIdentifier("secondsBetweenPass", true);
        this.secondsBetweenPassesArg.addLongIdentifier("seconds-between-pass", true);
        this.secondsBetweenPassesArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.secondsBetweenPassesArg);
        this.byteForByteArg = new BooleanArgument(null, "byteForByte", 1, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_BYTE_FOR_BYTE.get());
        this.byteForByteArg.addLongIdentifier("byte-for-byte", true);
        this.byteForByteArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.byteForByteArg);
        this.missingOnlyArg = new BooleanArgument(null, "missingOnly", 1, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_MISSING_ONLY.get());
        this.missingOnlyArg.addLongIdentifier("missing-only", true);
        this.missingOnlyArg.addLongIdentifier("onlyMissing", true);
        this.missingOnlyArg.addLongIdentifier("only-missing", true);
        this.missingOnlyArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.missingOnlyArg);
        this.useLegacyExitCodeArg = new BooleanArgument(null, "useLegacyExitCode", 1, ToolMessages.INFO_LDAP_DIFF_ARG_DESC_USE_LEGACY_EXIT_CODE.get());
        this.useLegacyExitCodeArg.addLongIdentifier("use-legacy-exit-code", true);
        this.useLegacyExitCodeArg.addLongIdentifier("useLegacyResultCode", true);
        this.useLegacyExitCodeArg.addLongIdentifier("use-legacy-result-code", true);
        this.useLegacyExitCodeArg.addLongIdentifier("legacyExitCode", true);
        this.useLegacyExitCodeArg.addLongIdentifier("legacy-exit-code", true);
        this.useLegacyExitCodeArg.addLongIdentifier("legacyResultCode", true);
        this.useLegacyExitCodeArg.addLongIdentifier("legacy-result-code", true);
        this.useLegacyExitCodeArg.setArgumentGroupName(ToolMessages.INFO_LDAP_DIFF_ARG_GROUP_PROCESSING_ARGS.get());
        parser.addArgument(this.useLegacyExitCodeArg);
        this.legacySourceHostArg = new StringArgument(Character.valueOf('h'), null, false, 1, null, "");
        this.legacySourceHostArg.setHidden(true);
        parser.addArgument(this.legacySourceHostArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceHostname"), this.legacySourceHostArg, new Argument[0]);
        this.legacySourcePortArg = new IntegerArgument(Character.valueOf('p'), null, false, 1, null, "", 1, 65535);
        this.legacySourcePortArg.setHidden(true);
        parser.addArgument(this.legacySourcePortArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourcePort"), this.legacySourcePortArg, new Argument[0]);
        this.legacySourceBindDNArg = new DNArgument(Character.valueOf('D'), null, false, 1, null, "");
        this.legacySourceBindDNArg.setHidden(true);
        parser.addArgument(this.legacySourceBindDNArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceBindDN"), this.legacySourceBindDNArg, new Argument[0]);
        this.legacySourceBindPasswordArg = new StringArgument(Character.valueOf('w'), null, false, 1, null, "");
        this.legacySourceBindPasswordArg.setHidden(true);
        parser.addArgument(this.legacySourceBindPasswordArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceBindPassword"), this.legacySourceBindPasswordArg, new Argument[0]);
        this.legacyTargetHostArg = new StringArgument(Character.valueOf('O'), null, false, 1, null, "");
        this.legacyTargetHostArg.setHidden(true);
        parser.addArgument(this.legacyTargetHostArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetHostname"), this.legacyTargetHostArg, new Argument[0]);
        this.legacyTargetBindPasswordFileArg = new FileArgument(Character.valueOf('F'), null, false, 1, null, "", true, true, true, false);
        this.legacyTargetBindPasswordFileArg.setHidden(true);
        parser.addArgument(this.legacyTargetBindPasswordFileArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetBindPasswordFile"), this.legacyTargetBindPasswordFileArg, new Argument[0]);
        this.legacyTrustAllArg = new BooleanArgument(Character.valueOf('X'), "trustAll", 1, "");
        this.legacyTrustAllArg.setHidden(true);
        parser.addArgument(this.legacyTrustAllArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceTrustAll"), this.legacyTrustAllArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetTrustAll"), this.legacyTrustAllArg, new Argument[0]);
        this.legacyKeyStorePathArg = new FileArgument(Character.valueOf('K'), "keyStorePath", false, 1, null, "", true, true, true, false);
        this.legacyKeyStorePathArg.setHidden(true);
        parser.addArgument(this.legacyKeyStorePathArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceKeyStorePath"), this.legacyKeyStorePathArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetKeyStorePath"), this.legacyKeyStorePathArg, new Argument[0]);
        this.legacyKeyStorePasswordArg = new StringArgument(Character.valueOf('W'), "keyStorePassword", false, 1, null, "");
        this.legacyKeyStorePasswordArg.setSensitive(true);
        this.legacyKeyStorePasswordArg.setHidden(true);
        parser.addArgument(this.legacyKeyStorePasswordArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceKeyStorePassword"), this.legacyKeyStorePasswordArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetKeyStorePassword"), this.legacyKeyStorePasswordArg, new Argument[0]);
        this.legacyKeyStorePasswordFileArg = new FileArgument(Character.valueOf('u'), "keyStorePasswordFile", false, 1, null, "", true, true, true, false);
        this.legacyKeyStorePasswordFileArg.setHidden(true);
        parser.addArgument(this.legacyKeyStorePasswordFileArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceKeyStorePasswordFile"), this.legacyKeyStorePasswordFileArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetKeyStorePasswordFile"), this.legacyKeyStorePasswordFileArg, new Argument[0]);
        this.legacyKeyStoreFormatArg = new StringArgument(null, "keyStoreFormat", false, 1, null, "");
        this.legacyKeyStoreFormatArg.setHidden(true);
        parser.addArgument(this.legacyKeyStoreFormatArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceKeyStoreFormat"), this.legacyKeyStoreFormatArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetKeyStoreFormat"), this.legacyKeyStoreFormatArg, new Argument[0]);
        this.legacyCertNicknameArg = new StringArgument(Character.valueOf('N'), "certNickname", false, 1, null, "");
        this.legacyCertNicknameArg.setHidden(true);
        parser.addArgument(this.legacyCertNicknameArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceCertNickname"), this.legacyCertNicknameArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetCertNickname"), this.legacyCertNicknameArg, new Argument[0]);
        this.legacyTrustStorePathArg = new FileArgument(Character.valueOf('P'), "trustStorePath", false, 1, null, "", true, true, true, false);
        this.legacyTrustStorePathArg.setHidden(true);
        parser.addArgument(this.legacyTrustStorePathArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceTrustStorePath"), this.legacyTrustStorePathArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetTrustStorePath"), this.legacyTrustStorePathArg, new Argument[0]);
        this.legacyTrustStorePasswordArg = new StringArgument(null, "trustStorePassword", false, 1, null, "");
        this.legacyTrustStorePasswordArg.setSensitive(true);
        this.legacyTrustStorePasswordArg.setHidden(true);
        parser.addArgument(this.legacyTrustStorePasswordArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceTrustStorePassword"), this.legacyTrustStorePasswordArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetTrustStorePassword"), this.legacyTrustStorePasswordArg, new Argument[0]);
        this.legacyTrustStorePasswordFileArg = new FileArgument(Character.valueOf('U'), "trustStorePasswordFile", false, 1, null, "", true, true, true, false);
        this.legacyTrustStorePasswordFileArg.setHidden(true);
        parser.addArgument(this.legacyTrustStorePasswordFileArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceTrustStorePasswordFile"), this.legacyTrustStorePasswordFileArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetTrustStorePasswordFile"), this.legacyTrustStorePasswordFileArg, new Argument[0]);
        this.legacyTrustStoreFormatArg = new StringArgument(null, "trustStoreFormat", false, 1, null, "");
        this.legacyTrustStoreFormatArg.setHidden(true);
        parser.addArgument(this.legacyTrustStoreFormatArg);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("sourceTrustStoreFormat"), this.legacyTrustStoreFormatArg, new Argument[0]);
        parser.addExclusiveArgumentSet(parser.getNamedArgument("targetTrustStoreFormat"), this.legacyTrustStoreFormatArg, new Argument[0]);
    }

    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        FileArgument sourceBindPasswordFileArg;
        DNArgument targetBindDNArg;
        DNArgument sourceBindDNArg;
        DN baseDN = this.baseDNArg.getValue();
        if (baseDN == null || baseDN.isNullDN()) {
            String message = ToolMessages.ERR_LDAP_DIFF_EMPTY_BASE_DN.get();
            this.toolCompletionMessageRef.compareAndSet(null, message);
            throw new ArgumentException(message);
        }
        this.setArgumentValueFromArgument(this.legacySourceHostArg, "sourceHostname");
        this.setArgumentValueFromArgument(this.legacySourcePortArg, "sourcePort");
        this.setArgumentValueFromArgument(this.legacySourceBindDNArg, "sourceBindDN");
        this.setArgumentValueFromArgument(this.legacySourceBindPasswordArg, "sourceBindPassword");
        this.setArgumentValueFromArgument(this.legacyTargetHostArg, "targetHostname");
        this.setArgumentValueFromArgument(this.legacyTargetBindPasswordFileArg, "targetBindPasswordFile");
        this.setArgumentValueFromArgument(this.legacyKeyStorePathArg, "sourceKeyStorePath");
        this.setArgumentValueFromArgument(this.legacyKeyStorePathArg, "targetKeyStorePath");
        this.setArgumentValueFromArgument(this.legacyKeyStorePasswordArg, "sourceKeyStorePassword");
        this.setArgumentValueFromArgument(this.legacyKeyStorePasswordArg, "targetKeyStorePassword");
        this.setArgumentValueFromArgument(this.legacyKeyStorePasswordFileArg, "sourceKeyStorePasswordFile");
        this.setArgumentValueFromArgument(this.legacyKeyStorePasswordFileArg, "targetKeyStorePasswordFile");
        this.setArgumentValueFromArgument(this.legacyKeyStoreFormatArg, "sourceKeyStoreFormat");
        this.setArgumentValueFromArgument(this.legacyKeyStoreFormatArg, "targetKeyStoreFormat");
        this.setArgumentValueFromArgument(this.legacyCertNicknameArg, "sourceCertNickname");
        this.setArgumentValueFromArgument(this.legacyCertNicknameArg, "targetCertNickname");
        this.setArgumentValueFromArgument(this.legacyTrustStorePathArg, "sourceTrustStorePath");
        this.setArgumentValueFromArgument(this.legacyTrustStorePathArg, "targetTrustStorePath");
        this.setArgumentValueFromArgument(this.legacyTrustStorePasswordArg, "sourceTrustStorePassword");
        this.setArgumentValueFromArgument(this.legacyTrustStorePasswordArg, "targetTrustStorePassword");
        this.setArgumentValueFromArgument(this.legacyTrustStorePasswordFileArg, "sourceTrustStorePasswordFile");
        this.setArgumentValueFromArgument(this.legacyTrustStorePasswordFileArg, "targetTrustStorePasswordFile");
        this.setArgumentValueFromArgument(this.legacyTrustStoreFormatArg, "sourceTrustStoreFormat");
        this.setArgumentValueFromArgument(this.legacyTrustStoreFormatArg, "targetTrustStoreFormat");
        if (this.legacyTrustAllArg.isPresent()) {
            this.setArgumentPresent("sourceTrustAll");
            this.setArgumentPresent("targetTrustAll");
        }
        if (!(sourceBindDNArg = this.parser.getDNArgument("sourceBindDN")).isPresent()) {
            try {
                Method addValueMethod = Argument.class.getDeclaredMethod("addValue", String.class);
                addValueMethod.setAccessible(true);
                addValueMethod.invoke((Object)sourceBindDNArg, DEFAULT_BIND_DN);
                Method incrementOccurrencesMethod = Argument.class.getDeclaredMethod("incrementOccurrences", new Class[0]);
                incrementOccurrencesMethod.setAccessible(true);
                incrementOccurrencesMethod.invoke((Object)sourceBindDNArg, new Object[0]);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new ArgumentException(ToolMessages.ERR_LDAP_DIFF_CANNOT_SET_DEFAULT_BIND_DN.get(DEFAULT_BIND_DN, sourceBindDNArg.getIdentifierString(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (!(targetBindDNArg = this.parser.getDNArgument("targetBindDN")).isPresent()) {
            this.setArgumentValueFromArgument(sourceBindDNArg, "targetBindDN");
        }
        StringArgument sourceBindPasswordArg = this.parser.getStringArgument("sourceBindPassword");
        StringArgument targetBindPasswordArg = this.parser.getStringArgument("targetBindPassword");
        FileArgument targetBindPasswordFileArg = this.parser.getFileArgument("targetBindPasswordFile");
        if (sourceBindPasswordArg.isPresent() && !targetBindPasswordArg.isPresent() && !targetBindPasswordFileArg.isPresent()) {
            this.setArgumentValueFromArgument(sourceBindPasswordArg, "targetBindPassword");
        }
        if ((sourceBindPasswordFileArg = this.parser.getFileArgument("sourceBindPasswordFile")).isPresent() && !targetBindPasswordArg.isPresent() && !targetBindPasswordFileArg.isPresent()) {
            this.setArgumentValueFromArgument(sourceBindPasswordFileArg, "targetBindPasswordFile");
        }
    }

    private void setArgumentValueFromArgument(@NotNull Argument legacyArgument, @NotNull String nonLegacyArgumentName) throws ArgumentException {
        if (legacyArgument.isPresent()) {
            try {
                Argument nonLegacyArgument = this.parser.getNamedArgument(nonLegacyArgumentName);
                Method addValueMethod = Argument.class.getDeclaredMethod("addValue", String.class);
                addValueMethod.setAccessible(true);
                Method incrementOccurrencesMethod = Argument.class.getDeclaredMethod("incrementOccurrences", new Class[0]);
                incrementOccurrencesMethod.setAccessible(true);
                for (String valueString : legacyArgument.getValueStringRepresentations(false)) {
                    addValueMethod.invoke((Object)nonLegacyArgument, valueString);
                    incrementOccurrencesMethod.invoke((Object)nonLegacyArgument, new Object[0]);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                String message = ToolMessages.ERR_LDAP_DIFF_CANNOT_SET_ARG_FROM_LEGACY.get(legacyArgument.getIdentifierString(), nonLegacyArgumentName, StaticUtils.getExceptionMessage(e));
                this.toolCompletionMessageRef.compareAndSet(null, message);
                throw new ArgumentException(message, e);
            }
        }
    }

    private void setArgumentPresent(@NotNull String argumentName) throws ArgumentException {
        try {
            BooleanArgument argument = this.parser.getBooleanArgument(argumentName);
            Method incrementOccurrencesMethod = Argument.class.getDeclaredMethod("incrementOccurrences", new Class[0]);
            incrementOccurrencesMethod.setAccessible(true);
            incrementOccurrencesMethod.invoke((Object)argument, new Object[0]);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException(ToolMessages.ERR_LDAP_DIFF_CANNOT_SET_ARG_PRESENT.get(argumentName, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return false;
    }

    @Override
    @Nullable
    protected String getToolCompletionMessage() {
        return this.toolCompletionMessageRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        LDAPConnectionPool sourcePool = null;
        LDAPConnectionPool targetPool = null;
        try {
            TreeSet<LDAPDiffCompactDN> dnsToExamine;
            DN baseDN;
            try {
                sourcePool = this.createConnectionPool(0, "SourceServer");
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.writeCompletionMessage(true, ToolMessages.ERR_LDAP_DIFF_CANNOT_CONNECT_TO_SOURCE.get(StaticUtils.getExceptionMessage(e)));
                ResultCode resultCode = e.getResultCode();
                if (sourcePool != null) {
                    sourcePool.close();
                }
                if (targetPool != null) {
                    targetPool.close();
                }
                return resultCode;
            }
            try {
                targetPool = this.createConnectionPool(1, "TargetServer");
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.writeCompletionMessage(true, ToolMessages.ERR_LDAP_DIFF_CANNOT_CONNECT_TO_TARGET.get(StaticUtils.getExceptionMessage(e)));
                ResultCode resultCode = e.getResultCode();
                if (sourcePool != null) {
                    sourcePool.close();
                }
                if (targetPool != null) {
                    targetPool.close();
                }
                return resultCode;
            }
            Schema schema = null;
            try {
                schema = targetPool.getSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                baseDN = new DN(this.baseDNArg.getStringValue(), schema);
            }
            catch (Exception e) {
                Debug.debugException(e);
                baseDN = this.baseDNArg.getValue();
            }
            try {
                dnsToExamine = this.getDNsToExamine(sourcePool, targetPool, baseDN, schema);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.writeCompletionMessage(true, e.getMessage());
                ResultCode resultCode = e.getResultCode();
                if (sourcePool != null) {
                    sourcePool.close();
                }
                if (targetPool != null) {
                    targetPool.close();
                }
                return resultCode;
            }
            AtomicReference<ResultCode> resultCodeRef = new AtomicReference<ResultCode>();
            long[] entryCounts = this.identifyDifferences(sourcePool, targetPool, baseDN, schema, resultCodeRef, dnsToExamine);
            long inSyncCount = entryCounts[0];
            long addCount = entryCounts[1];
            long delCount = entryCounts[2];
            long modCount = entryCounts[3];
            long missingCount = entryCounts[4];
            long errorCount = entryCounts[5];
            long totalDifferenceCount = addCount + delCount + modCount;
            long totalExaminedCount = inSyncCount + totalDifferenceCount;
            if (!this.quietArg.isPresent()) {
                this.out(new Object[0]);
            }
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_SUMMARY_PROCESSING_COMPLETE.get(this.getToolName()));
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_SUMMARY_TOTAL_EXAMINED.get(totalExaminedCount));
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_SUMMARY_ADD_COUNT.get(addCount));
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_SUMMARY_DEL_COUNT.get(delCount));
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_SUMMARY_MOD_COUNT.get(modCount));
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_SUMMARY_IN_SYNC_COUNT.get(inSyncCount));
            if (missingCount > 0L) {
                this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_SUMMARY_MISSING_COUNT.get(missingCount));
            }
            if (errorCount > 0L) {
                this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_SUMMARY_ERROR_COUNT.get(errorCount));
            }
            this.out(new Object[0]);
            if (errorCount > 0L) {
                this.writeCompletionMessage(false, ToolMessages.INFO_LDAP_DIFF_ERRORS_IDENTIFYING_ENTRIES.get());
                resultCodeRef.compareAndSet(null, ResultCode.LOCAL_ERROR);
                ResultCode resultCode = resultCodeRef.get();
                return resultCode;
            }
            if (totalDifferenceCount == 0L) {
                this.writeCompletionMessage(false, ToolMessages.INFO_LDAP_DIFF_SERVERS_IN_SYNC.get());
                resultCodeRef.compareAndSet(null, ResultCode.SUCCESS);
                ResultCode resultCode = resultCodeRef.get();
                return resultCode;
            }
            if (totalDifferenceCount == 1L) {
                this.writeCompletionMessage(true, ToolMessages.WARN_LDAP_DIFF_DIFFERENCE_FOUND.get());
            } else {
                this.writeCompletionMessage(true, ToolMessages.WARN_LDAP_DIFF_DIFFERENCES_FOUND.get(totalDifferenceCount));
            }
            resultCodeRef.compareAndSet(null, ResultCode.COMPARE_FALSE);
            ResultCode resultCode = resultCodeRef.get();
            return resultCode;
        }
        finally {
            if (sourcePool != null) {
                sourcePool.close();
            }
            if (targetPool != null) {
                targetPool.close();
            }
        }
    }

    @NotNull
    private LDAPConnectionPool createConnectionPool(int serverIndex, @NotNull String name) throws LDAPException {
        LDAPConnectionPool pool = this.getConnectionPool(serverIndex, 1, this.numThreadsArg.getValue());
        pool.setRetryFailedOperationsDueToInvalidConnections(true);
        pool.setConnectionPoolName(name);
        return pool;
    }

    private void writeCompletionMessage(boolean isError, @NotNull String message) {
        if (isError) {
            this.wrapErr(0, WRAP_COLUMN, message);
        } else {
            this.wrapOut(0, WRAP_COLUMN, message);
        }
        this.toolCompletionMessageRef.compareAndSet(null, message);
    }

    @NotNull
    private TreeSet<LDAPDiffCompactDN> getDNsToExamine(@NotNull LDAPConnectionPool sourcePool, @NotNull LDAPConnectionPool targetPool, @NotNull DN baseDN, @Nullable Schema schema) throws LDAPException {
        if (!this.quietArg.isPresent()) {
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_IDENTIFYING_ENTRIES.get());
        }
        TreeSet<LDAPDiffCompactDN> dnSet = new TreeSet<LDAPDiffCompactDN>();
        LDAPDiffDNDumper sourceDNDumper = new LDAPDiffDNDumper(this, "LDAPDiff Source Server DN Dumper", this.sourceDNsFileArg.getValue(), sourcePool, baseDN, this.searchScopeArg.getValue(), this.excludeBranchArg.getValues(), this.searchFilterArg.getValue(), schema, this.missingOnlyArg.isPresent(), this.quietArg.isPresent(), dnSet);
        sourceDNDumper.start();
        LDAPDiffDNDumper targetDNDumper = new LDAPDiffDNDumper(this, "LDAPDiff Target Server DN Dumper", this.targetDNsFileArg.getValue(), targetPool, baseDN, this.searchScopeArg.getValue(), this.excludeBranchArg.getValues(), this.searchFilterArg.getValue(), schema, this.missingOnlyArg.isPresent(), this.quietArg.isPresent(), dnSet);
        targetDNDumper.start();
        try {
            sourceDNDumper.join();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_ERROR_GETTING_SOURCE_DNS.get(StaticUtils.getExceptionMessage(e)));
        }
        LDAPException sourceException = sourceDNDumper.getProcessingException();
        if (sourceException != null) {
            throw new LDAPException(sourceException.getResultCode(), ToolMessages.ERR_LDAP_DIFF_ERROR_GETTING_SOURCE_DNS.get(sourceException.getMessage()), sourceException);
        }
        try {
            targetDNDumper.join();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_ERROR_GETTING_TARGET_DNS.get(StaticUtils.getExceptionMessage(e)));
        }
        LDAPException targetException = targetDNDumper.getProcessingException();
        if (targetException != null) {
            throw new LDAPException(targetException.getResultCode(), ToolMessages.ERR_LDAP_DIFF_ERROR_GETTING_TARGET_DNS.get(targetException.getMessage()), targetException);
        }
        if (!this.quietArg.isPresent()) {
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_IDENTIFIED_ENTRIES.get(dnSet.size()));
        }
        return dnSet;
    }

    @NotNull
    private long[] identifyDifferences(@NotNull LDAPConnectionPool sourcePool, @NotNull LDAPConnectionPool targetPool, @NotNull DN baseDN, @Nullable Schema schema, @NotNull AtomicReference<ResultCode> resultCodeRef, @NotNull TreeSet<LDAPDiffCompactDN> dnsToExamine) throws LDAPException {
        Throwable throwable;
        Throwable throwable2;
        TreeSet missingEntryDNs;
        long errorCount;
        long missingCount;
        long modifyCount;
        long deleteCount;
        long addCount;
        long inSyncCount;
        File modFile;
        File addFile;
        File mergedOutputFile;
        block110: {
            mergedOutputFile = this.outputLDIFArg.getValue();
            addFile = new File(mergedOutputFile.getAbsolutePath() + ".add");
            addFile.deleteOnExit();
            modFile = new File(mergedOutputFile.getAbsolutePath() + ".mod");
            modFile.deleteOnExit();
            inSyncCount = 0L;
            addCount = 0L;
            deleteCount = 0L;
            modifyCount = 0L;
            missingCount = 0L;
            errorCount = 0L;
            ParallelProcessor<LDAPDiffCompactDN, LDAPDiffProcessorResult> parallelProcessor = null;
            String sourceHostPort = this.getServerHostPort("sourceHostname", "sourcePort");
            String targetHostPort = this.getServerHostPort("targetHostname", "targetPort");
            missingEntryDNs = new TreeSet();
            try {
                throwable2 = null;
                try (LDIFWriter mergedWriter = this.createLDIFWriter(mergedOutputFile, ToolMessages.INFO_LDAP_DIFF_MERGED_FILE_COMMENT.get(sourceHostPort, targetHostPort));){
                    throwable = null;
                    try (LDIFWriter addWriter = this.createLDIFWriter(addFile, new String[0]);
                         LDIFWriter modWriter = this.createLDIFWriter(modFile, new String[0]);){
                        String[] attributes = this.parser.getTrailingArguments().toArray(StaticUtils.NO_STRINGS);
                        LDAPDiffProcessor processor = new LDAPDiffProcessor(sourcePool, targetPool, baseDN, schema, this.byteForByteArg.isPresent(), attributes, this.missingOnlyArg.isPresent());
                        parallelProcessor = new ParallelProcessor<LDAPDiffCompactDN, LDAPDiffProcessorResult>(processor, new LDAPSDKThreadFactory("LDAPDiff Compare Processor", true), this.numThreadsArg.getValue(), 5);
                        TreeSet<LDAPDiffCompactDN> currentPassDNs = dnsToExamine;
                        TreeSet<Object> nextPassDNs = new TreeSet();
                        TreeSet deletedEntryDNs = new TreeSet();
                        ArrayList<LDAPDiffCompactDN> currentBatchOfDNs = new ArrayList<LDAPDiffCompactDN>(1000);
                        for (int i = 1; i <= this.numPassesArg.getValue(); ++i) {
                            boolean isLastPass;
                            boolean bl = isLastPass = i == this.numPassesArg.getValue();
                            if (!this.quietArg.isPresent()) {
                                this.out(new Object[0]);
                                this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_STARTING_COMPARE_PASS.get(i, this.numPassesArg.getValue(), currentPassDNs.size()));
                            }
                            nextPassDNs.clear();
                            int differencesIdentifiedCount = 0;
                            int processedCurrentPassCount = 0;
                            int totalCurrentPassCount = currentPassDNs.size();
                            Iterator<LDAPDiffCompactDN> dnIterator = currentPassDNs.iterator();
                            while (dnIterator.hasNext()) {
                                ArrayList<Result<LDAPDiffCompactDN, LDAPDiffProcessorResult>> results;
                                currentBatchOfDNs.clear();
                                while (dnIterator.hasNext()) {
                                    currentBatchOfDNs.add(dnIterator.next());
                                    dnIterator.remove();
                                    if (currentBatchOfDNs.size() < 1000) continue;
                                }
                                try {
                                    results = parallelProcessor.processAll(currentBatchOfDNs);
                                }
                                catch (Exception e) {
                                    Debug.debugException(e);
                                    throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_ERROR_PROCESSING_BATCH.get(StaticUtils.getExceptionMessage(e)), e);
                                }
                                block69: for (Result result : results) {
                                    ++processedCurrentPassCount;
                                    Throwable exception = result.getFailureCause();
                                    if (exception != null) {
                                        LDAPException reportException;
                                        LDAPDiffCompactDN compactDN = (LDAPDiffCompactDN)result.getInput();
                                        if (!isLastPass) {
                                            nextPassDNs.add(compactDN);
                                            ++differencesIdentifiedCount;
                                            continue;
                                        }
                                        if (exception instanceof LDAPException) {
                                            LDAPException caughtException = (LDAPException)exception;
                                            reportException = new LDAPException(caughtException.getResultCode(), ToolMessages.ERR_LDAP_DIFF_ERROR_COMPARING_ENTRY.get(compactDN.toDN(baseDN, schema).toString(), caughtException.getMessage()), caughtException.getMatchedDN(), caughtException.getReferralURLs(), caughtException.getResponseControls(), caughtException.getCause());
                                        } else {
                                            reportException = new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_ERROR_COMPARING_ENTRY.get(compactDN.toDN(baseDN, schema).toString(), StaticUtils.getExceptionMessage(exception)), exception);
                                        }
                                        ++errorCount;
                                        resultCodeRef.compareAndSet(null, reportException.getResultCode());
                                        List<String> formattedResultLines = ResultUtils.formatResult(reportException, false, 0, WRAP_COLUMN - 2);
                                        Iterator<String> resultLineIterator = formattedResultLines.iterator();
                                        while (resultLineIterator.hasNext()) {
                                            mergedWriter.writeComment(resultLineIterator.next(), false, !resultLineIterator.hasNext());
                                        }
                                        continue;
                                    }
                                    LDAPDiffProcessorResult resultOutput = (LDAPDiffProcessorResult)result.getOutput();
                                    ChangeType changeType = resultOutput.getChangeType();
                                    if (changeType == null) {
                                        if (resultOutput.isEntryMissing()) {
                                            ++missingCount;
                                            missingEntryDNs.add(result.getInput());
                                        } else {
                                            ++inSyncCount;
                                        }
                                        ++inSyncCount;
                                        continue;
                                    }
                                    if (!isLastPass) {
                                        nextPassDNs.add(result.getInput());
                                        ++differencesIdentifiedCount;
                                        continue;
                                    }
                                    ++differencesIdentifiedCount;
                                    switch (changeType) {
                                        case DELETE: {
                                            deletedEntryDNs.add(result.getInput());
                                            ++deleteCount;
                                            continue block69;
                                        }
                                        case ADD: {
                                            addWriter.writeChangeRecord(new LDIFAddChangeRecord(resultOutput.getEntry()), ToolMessages.WARN_LDAP_DIFF_COMMENT_ADDED_ENTRY.get(targetHostPort, sourceHostPort));
                                            ++addCount;
                                            continue block69;
                                        }
                                    }
                                    modWriter.writeChangeRecord(new LDIFModifyChangeRecord(resultOutput.getDN(), resultOutput.getModifications()), ToolMessages.WARN_LDAP_DIFF_COMMENT_MODIFIED_ENTRY.get(sourceHostPort, targetHostPort));
                                    ++modifyCount;
                                }
                                if (this.quietArg.isPresent()) continue;
                                int percentComplete = Math.round(100.0f * (float)processedCurrentPassCount / (float)totalCurrentPassCount);
                                this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_COMPARE_PROGRESS.get(processedCurrentPassCount, totalCurrentPassCount, percentComplete, differencesIdentifiedCount));
                            }
                            if (isLastPass) break;
                            if (nextPassDNs.isEmpty()) {
                                if (this.quietArg.isPresent()) break;
                                this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_NO_NEED_FOR_ADDITIONAL_PASS.get());
                                break;
                            }
                            try {
                                int sleepTimeSeconds = this.secondsBetweenPassesArg.getValue();
                                if (!this.quietArg.isPresent()) {
                                    this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_WAITING_BEFORE_NEXT_PASS.get(sleepTimeSeconds));
                                }
                                Thread.sleep(TimeUnit.SECONDS.toMillis(sleepTimeSeconds));
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                            TreeSet<LDAPDiffCompactDN> emptyDNSet = currentPassDNs;
                            currentPassDNs = nextPassDNs;
                            nextPassDNs = emptyDNSet;
                        }
                        if (addCount == 0L && deleteCount == 0L && modifyCount == 0L) {
                            mergedWriter.writeComment(ToolMessages.INFO_LDAP_DIFF_SERVERS_IN_SYNC.get(), true, false);
                        }
                        if (deletedEntryDNs.isEmpty()) break block110;
                        mergedWriter.writeComment(ToolMessages.INFO_LDAP_DIFF_COMMENT_DELETED_ENTRIES.get(), true, true);
                        if (!this.quietArg.isPresent()) {
                            this.out(new Object[0]);
                            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_STARTING_DELETE_PASS.get(deleteCount));
                        }
                        int entryCount = 0;
                        for (LDAPDiffCompactDN compactDN : deletedEntryDNs.descendingSet()) {
                            SearchResultEntry entry = null;
                            LDAPException ldapException = null;
                            String dnString = compactDN.toDN(baseDN, schema).toString();
                            try {
                                entry = sourcePool.getEntry(dnString, attributes);
                            }
                            catch (LDAPException e) {
                                Debug.debugException(e);
                                ldapException = new LDAPException(e.getResultCode(), ToolMessages.ERR_LDAP_DIFF_CANNOT_GET_ENTRY_TO_DELETE.get(dnString, StaticUtils.getExceptionMessage(e)), e);
                            }
                            if (entry != null) {
                                mergedWriter.writeComment(ToolMessages.INFO_LDAP_DIFF_COMMENT_DELETED_ENTRY.get(sourceHostPort, targetHostPort), false, false);
                                mergedWriter.writeComment("", false, false);
                                for (String line : entry.toLDIF(75)) {
                                    mergedWriter.writeComment(line, false, false);
                                }
                                mergedWriter.writeChangeRecord(new LDIFDeleteChangeRecord(entry.getDN()));
                            } else if (ldapException != null) {
                                mergedWriter.writeComment(ldapException.getExceptionMessage(), false, false);
                                mergedWriter.writeChangeRecord(new LDIFDeleteChangeRecord(entry.getDN()));
                            }
                            if (this.quietArg.isPresent() || ++entryCount % 1000 != 0) continue;
                            int percentComplete = Math.round(100.0f * (float)entryCount / (float)deleteCount);
                            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_DELETE_PROGRESS.get(entryCount, deleteCount, percentComplete));
                        }
                        if (!this.quietArg.isPresent()) {
                            int percentComplete = Math.round(100.0f * (float)entryCount / (float)deleteCount);
                            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_DELETE_PROGRESS.get(entryCount, deleteCount, percentComplete));
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_ERROR_WRITING_OUTPUT.get(this.getToolName(), StaticUtils.getExceptionMessage(e)), e);
            }
            finally {
                if (parallelProcessor != null) {
                    try {
                        parallelProcessor.shutdown();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
            }
        }
        if (modifyCount > 0L) {
            this.appendFileToFile(modFile, mergedOutputFile, ToolMessages.INFO_LDAP_DIFF_COMMENT_ADDED_ENTRIES.get());
            modFile.delete();
        }
        if (addCount > 0L) {
            this.appendFileToFile(addFile, mergedOutputFile, ToolMessages.INFO_LDAP_DIFF_COMMENT_MODIFIED_ENTRIES.get());
            addFile.delete();
        }
        if (!missingEntryDNs.isEmpty()) {
            try {
                throwable2 = null;
                try (FileOutputStream outputStream = new FileOutputStream(mergedOutputFile, true);){
                    throwable = null;
                    try (LDIFWriter ldifWriter = new LDIFWriter(outputStream);){
                        ldifWriter.writeComment(ToolMessages.INFO_LDAP_DIFF_COMMENT_MISSING_ENTRIES.get(), true, true);
                        for (LDAPDiffCompactDN missingEntryDN : missingEntryDNs) {
                            ldifWriter.writeComment(ToolMessages.INFO_LDAP_DIFF_COMMENT_MISSING_ENTRY.get(missingEntryDN.toDN(baseDN, schema).toString()), false, true);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    throwable2 = throwable4;
                    throw throwable4;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_ERROR_WRITING_OUTPUT.get(this.getToolName(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        return new long[]{inSyncCount, addCount, deleteCount, modifyCount, missingCount, errorCount};
    }

    @NotNull
    private String getServerHostPort(@NotNull String hostnameArgName, @NotNull String portArgName) {
        StringArgument hostnameArg = this.parser.getStringArgument(hostnameArgName);
        IntegerArgument portArg = this.parser.getIntegerArgument(portArgName);
        return hostnameArg.getValue() + ':' + portArg.getValue();
    }

    @NotNull
    private LDIFWriter createLDIFWriter(@NotNull File ldifFile, String ... comments) throws LDAPException {
        try {
            LDIFWriter writer = new LDIFWriter(ldifFile);
            writer.setWrapColumn(this.wrapColumnArg.getValue());
            for (String comment : comments) {
                writer.writeComment(comment, false, true);
            }
            return writer;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_CANNOT_CREATE_LDIF_WRITER.get(ldifFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void appendFileToFile(@NotNull File fileToAppend, @NotNull File fileToBeAppendedTo, @NotNull String comment) throws LDAPException {
        try {
            inputStream = new FileInputStream(fileToAppend);
            var5_6 = null;
            try {
                outputStream = new FileOutputStream(fileToBeAppendedTo, true);
                var7_9 = null;
                outputStream.write(StaticUtils.getBytes(StaticUtils.EOL));
                for (String line : StaticUtils.wrapLine(comment, LDAPDiff.WRAP_COLUMN - 2)) {
                    outputStream.write(StaticUtils.getBytes("# " + line + StaticUtils.EOL));
                }
                outputStream.write(StaticUtils.getBytes(StaticUtils.EOL));
                buffer = new byte[0x100000];
lbl14:
                // 2 sources

                while (true) {
                    bytesRead = inputStream.read(buffer);
                    if (bytesRead >= 0) ** GOTO lbl43
                    if (outputStream == null) return;
                    if (var7_9 != null) {
                    }
                    ** GOTO lbl41
                    break;
                }
                {
                    catch (Throwable var8_11) {
                        var7_9 = var8_11;
                        throw var8_11;
                    }
                    catch (Throwable var11_16) {
                        if (outputStream == null) throw var11_16;
                        if (var7_9 == null) {
                            outputStream.close();
                            throw var11_16;
                        }
                        try {
                            outputStream.close();
                            throw var11_16;
                        }
                        catch (Throwable x2) {
                            var7_9.addSuppressed(x2);
                            throw var11_16;
                        }
                    }
                    try {
                        outputStream.close();
                        return;
                    }
                    catch (Throwable x2) {
                        var7_9.addSuppressed(x2);
                        return;
                    }
lbl41:
                    // 1 sources

                    outputStream.close();
                    return;
lbl43:
                    // 1 sources

                    ** try [egrp 6[TRYBLOCK] [8 : 217->279)] { 
lbl-1000:
                    // 1 sources

                    {
                        outputStream.write(buffer, 0, bytesRead);
                        ** continue;
                    }
                }
            }
lbl46:
            // 2 sources

            catch (Throwable var6_8) {
                var5_6 = var6_8;
                throw var6_8;
            }
            finally {
                if (inputStream != null) {
                    if (var5_6 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            var5_6.addSuppressed(x2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_ERROR_WRITING_OUTPUT.get(new Object[]{this.getToolName(), StaticUtils.getExceptionMessage(e)}), e);
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--sourceHostname", "source.example.com", "--sourcePort", "636", "--sourceUseSSL", "--sourceBindDN", DEFAULT_BIND_DN, "--sourceBindPasswordFile", "/path/to/password.txt", "--targetHostname", "target.example.com", "--targetPort", "636", "--targetUseSSL", "--targetBindDN", DEFAULT_BIND_DN, "--targetBindPasswordFile", "/path/to/password.txt", "--baseDN", "dc=example,dc=com", "--outputLDIF", "diff.ldif"}, ToolMessages.INFO_LDAP_DIFF_EXAMPLE.get());
        return examples;
    }
}

