/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccount;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountSearchOperation;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountSearchProcessorThread;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.IntegerArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

final class ManageAccountSearchProcessor {
    @Nullable
    private final LinkedBlockingQueue<Filter> filterQueue;
    @NotNull
    private final ManageAccount manageAccount;
    @NotNull
    private final ManageAccountProcessor manageAccountProcessor;
    @Nullable
    private volatile ManageAccountSearchOperation activeSearchOperation;
    private final int simplePageSize;
    @NotNull
    private final LDAPConnectionPool pool;
    @NotNull
    private final List<ManageAccountSearchProcessorThread> searchProcessorThreads;
    @NotNull
    private final String baseDN;
    @NotNull
    private final String userIDAttribute;

    ManageAccountSearchProcessor(@NotNull ManageAccount manageAccount, @NotNull ManageAccountProcessor manageAccountProcessor, @NotNull LDAPConnectionPool pool) {
        this.manageAccount = manageAccount;
        this.manageAccountProcessor = manageAccountProcessor;
        this.pool = pool;
        ArgumentParser parser = manageAccount.getArgumentParser();
        this.activeSearchOperation = null;
        this.baseDN = parser.getDNArgument("baseDN").getValue().toString();
        this.userIDAttribute = parser.getStringArgument("userIDAttribute").getValue();
        IntegerArgument simplePageSizeArg = parser.getIntegerArgument("simplePageSize");
        this.simplePageSize = simplePageSizeArg.isPresent() ? simplePageSizeArg.getValue() : -1;
        int numSearchThreads = parser.getIntegerArgument("numSearchThreads").getValue();
        if (numSearchThreads > 1) {
            this.filterQueue = new LinkedBlockingQueue(100);
            this.searchProcessorThreads = new ArrayList<ManageAccountSearchProcessorThread>(numSearchThreads);
            for (int i = 1; i <= numSearchThreads; ++i) {
                ManageAccountSearchProcessorThread t = new ManageAccountSearchProcessorThread(i, this);
                t.start();
                this.searchProcessorThreads.add(t);
            }
        } else {
            this.filterQueue = null;
            this.searchProcessorThreads = Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processFilter(@NotNull Filter filter) {
        if (this.filterQueue == null) {
            try {
                this.activeSearchOperation = new ManageAccountSearchOperation(this.manageAccount, this.manageAccountProcessor, this.pool, this.baseDN, filter, this.simplePageSize);
                this.activeSearchOperation.doSearch();
            }
            finally {
                this.activeSearchOperation = null;
            }
        } else {
            while (!this.manageAccount.cancelRequested()) {
                try {
                    if (!this.filterQueue.offer(filter, 100L, TimeUnit.MILLISECONDS)) continue;
                    return;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (!(e instanceof InterruptedException)) continue;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    void processFilter(@NotNull String filter) throws LDAPException {
        this.processFilter(Filter.create(filter));
    }

    void processUserID(@NotNull String userID) {
        this.processFilter(Filter.createEqualityFilter(this.userIDAttribute, userID));
    }

    @Nullable
    ManageAccountSearchOperation getSearchOperation() {
        if (this.manageAccount.cancelRequested()) {
            return null;
        }
        Filter filter = this.filterQueue.poll();
        while (filter == null) {
            if (this.manageAccount.cancelRequested()) {
                return null;
            }
            if (this.manageAccount.allFiltersProvided()) {
                filter = this.filterQueue.poll();
                if (filter != null) break;
                return null;
            }
            try {
                filter = this.filterQueue.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
            }
        }
        return new ManageAccountSearchOperation(this.manageAccount, this.manageAccountProcessor, this.pool, this.baseDN, filter, this.simplePageSize);
    }

    void cancelSearches() {
        ManageAccountSearchOperation o = this.activeSearchOperation;
        if (o != null) {
            o.cancelSearch();
        }
        for (ManageAccountSearchProcessorThread t : this.searchProcessorThreads) {
            t.cancelSearch();
        }
    }

    void waitForCompletion() {
        if (this.filterQueue == null) {
            return;
        }
        while (!this.manageAccount.cancelRequested()) {
            if (this.manageAccount.allFiltersProvided() && this.filterQueue.peek() == null) {
                for (ManageAccountSearchProcessorThread t : this.searchProcessorThreads) {
                    try {
                        t.join();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        if (!(e instanceof InterruptedException)) continue;
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
                continue;
            }
            break;
        }
        return;
    }
}

