/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class IdentifyReferencesToMissingEntries
extends LDAPCommandLineTool
implements SearchResultListener {
    private static final long serialVersionUID = 1981894839719501258L;
    @NotNull
    private final AtomicLong entriesExamined = new AtomicLong(0L);
    @Nullable
    private DNArgument baseDNArgument = null;
    @Nullable
    private FileArgument outputLDIFArgument = null;
    @Nullable
    private IntegerArgument pageSizeArgument = null;
    @Nullable
    private LDAPConnectionPool getReferencedEntriesPool = null;
    @Nullable
    private LDIFWriter outputLDIFWriter;
    @NotNull
    private final Map<String, AtomicLong> missingReferenceCounts = new TreeMap<String, AtomicLong>();
    @Nullable
    private String[] attributes;
    @Nullable
    private StringArgument attributeArgument = null;

    public static void main(String ... args) {
        ResultCode resultCode = IdentifyReferencesToMissingEntries.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        IdentifyReferencesToMissingEntries tool = new IdentifyReferencesToMissingEntries(outStream, errStream);
        return tool.runTool(args);
    }

    public IdentifyReferencesToMissingEntries(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "identify-references-to-missing-entries";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "This tool may be used to identify entries containing one or more attributes which reference entries that do not exist.  This may require the ability to perform unindexed searches and/or the ability to use the simple paged results control.";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "7.0.1";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsDebugLogging() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        String description = "The search base DN(s) to use to find entries with references to other entries.  At least one base DN must be specified.";
        this.baseDNArgument = new DNArgument(Character.valueOf('b'), "baseDN", true, 0, "{dn}", description);
        this.baseDNArgument.addLongIdentifier("base-dn", true);
        parser.addArgument(this.baseDNArgument);
        description = "The attribute(s) for which to find missing references.  At least one attribute must be specified, and each attribute must be indexed for equality searches and have values which are DNs.";
        this.attributeArgument = new StringArgument(Character.valueOf('A'), "attribute", true, 0, "{attr}", description);
        parser.addArgument(this.attributeArgument);
        description = "The maximum number of entries to retrieve at a time when attempting to find entries with references to other entries.  This requires that the authenticated user have permission to use the simple paged results control, but it can avoid problems with the server sending entries too quickly for the client to handle.  By default, the simple paged results control will not be used.";
        this.pageSizeArgument = new IntegerArgument(Character.valueOf('z'), "simplePageSize", false, 1, "{num}", description, 1, Integer.MAX_VALUE);
        this.pageSizeArgument.addLongIdentifier("simple-page-size", true);
        parser.addArgument(this.pageSizeArgument);
        description = "The path to a file that should be written with the LDIF representation of any changes that may be needed to remove references to missing entries.  If this is omitted, then information about the missing entries will only be written to standard output in a human-readable form.";
        this.outputLDIFArgument = new FileArgument(Character.valueOf('l'), "outputLDIF", false, 1, "{path}", description, false, true, true, false);
        this.outputLDIFArgument.addLongIdentifier("output-ldif", true);
        parser.addArgument(this.outputLDIFArgument);
    }

    @Override
    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 35[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public Map<String, AtomicLong> getMissingReferenceCounts() {
        return Collections.unmodifiableMap(this.missingReferenceCounts);
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=john.doe,ou=People,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--attribute", "member", "--attribute", "uniqueMember", "--simplePageSize", "100"};
        exampleMap.put(args, "Identify all entries below dc=example,dc=com in which either the member or uniqueMember attribute references an entry that does not exist.");
        return exampleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
        long count;
        try {
            for (String attr : this.attributes) {
                List<Attribute> attrList = searchEntry.getAttributesWithOptions(attr, null);
                for (Attribute a : attrList) {
                    for (String value : a.getValues()) {
                        try {
                            SearchResultEntry e = this.getReferencedEntriesPool.getEntry(value, "1.1");
                            if (e != null) continue;
                            this.err("Entry '", searchEntry.getDN(), "' includes attribute ", a.getName(), " that references entry '", value, "' which does not exist.");
                            this.missingReferenceCounts.get(attr).incrementAndGet();
                            if (this.outputLDIFWriter == null) continue;
                            LDIFModifyChangeRecord changeRecord = new LDIFModifyChangeRecord(searchEntry.getDN(), new Modification(ModificationType.DELETE, a.getName(), value));
                            try {
                                this.outputLDIFWriter.writeChangeRecord(changeRecord);
                            }
                            catch (Exception ex) {
                                Debug.debugException(ex);
                                this.err("An error occurred while attempting to write an LDIF change record to address the above issue:  " + StaticUtils.getExceptionMessage(ex));
                            }
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.err("An error occurred while attempting to determine whether entry '" + value + "' referenced in attribute " + a.getName() + " of entry '" + searchEntry.getDN() + "' exists:  " + StaticUtils.getExceptionMessage(le));
                            this.missingReferenceCounts.get(attr).incrementAndGet();
                        }
                    }
                }
            }
            count = this.entriesExamined.incrementAndGet();
            if (count % 1000L != 0L) return;
        }
        catch (Throwable throwable) {
            long count2 = this.entriesExamined.incrementAndGet();
            if (count2 % 1000L != 0L) throw throwable;
            this.out(count2, " entries examined");
            throw throwable;
        }
        this.out(count, " entries examined");
    }

    @Override
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
    }
}

