/*
 * Copyright 2024 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright 2020-2024 Ping Identity Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2024 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk.controls;



import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;



/**
 * This enum defines a set of message keys for messages in the
 * com.unboundid.ldap.sdk.controls package, which correspond to messages in the
 * unboundid-ldapsdk-controls.properties properties file.
 * <BR><BR>
 * This source file was generated from the properties file.
 * Do not edit it directly.
 */
enum ControlMessages
{
  /**
   * The provided control cannot be decoded as an assertion request control because an error occurred while attempting to decode the assertion filter from the value:  {0}
   */
  ERR_ASSERT_CANNOT_DECODE("The provided control cannot be decoded as an assertion request control because an error occurred while attempting to decode the assertion filter from the value:  {0}"),



  /**
   * Unable to decode JSON object {0} as an assertion request control because filter string ''{1}'' cannot be parsed as a valid LDAP filter.
   */
  ERR_ASSERT_JSON_CONTROL_INVALID_FILTER("Unable to decode JSON object {0} as an assertion request control because filter string ''{1}'' cannot be parsed as a valid LDAP filter."),



  /**
   * Unable to decode JSON object {0} as an assertion request control because the value object is missing the ''{1}'' field needed to specify the assertion filter.
   */
  ERR_ASSERT_JSON_CONTROL_MISSING_FILTER("Unable to decode JSON object {0} as an assertion request control because the value object is missing the ''{1}'' field needed to specify the assertion filter."),



  /**
   * Unable to decode JSON object {0} as an assertion request control because the value object contains unrecognized field ''{1}''.
   */
  ERR_ASSERT_JSON_CONTROL_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as an assertion request control because the value object contains unrecognized field ''{1}''."),



  /**
   * The provided control cannot be decoded as an assertion request control because it does not have a value.
   */
  ERR_ASSERT_NO_VALUE("The provided control cannot be decoded as an assertion request control because it does not have a value."),



  /**
   * The provided control cannot be decoded as an authorization identity request control because it has a value.
   */
  ERR_AUTHZID_REQUEST_HAS_VALUE("The provided control cannot be decoded as an authorization identity request control because it has a value."),



  /**
   * Unable to decode JSON object {0} as an authorization identity response control because the value object contains unrecognized field ''{1}''.
   */
  ERR_AUTHZID_RESPONSE_JSON_CONTROL_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as an authorization identity response control because the value object contains unrecognized field ''{1}''."),



  /**
   * Unable to decode JSON object {0} as an authorization identity response control because the value object is missing the ''{1}'' field needed to specify the authorization identity.
   */
  ERR_AUTHZID_RESPONSE_JSON_MISSING_AUTHZ_ID("Unable to decode JSON object {0} as an authorization identity response control because the value object is missing the ''{1}'' field needed to specify the authorization identity."),



  /**
   * The provided control cannot be decoded as an authorization identity response control because it does not have a value.
   */
  ERR_AUTHZID_RESPONSE_NO_VALUE("The provided control cannot be decoded as an authorization identity response control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a don''t use copy request control because it has a value.
   */
  ERR_DONT_USE_COPY_HAS_VALUE("The provided control cannot be decoded as a don''t use copy request control because it has a value."),



  /**
   * Unable to decode the change number from the entry change notification control sequence:  {0}
   */
  ERR_ECN_CANNOT_DECODE_CHANGE_NUMBER("Unable to decode the change number from the entry change notification control sequence:  {0}"),



  /**
   * Unable to decode the first element of the entry change notification control sequence as a change type enumerated element:  {0}
   */
  ERR_ECN_FIRST_NOT_ENUMERATED("Unable to decode the first element of the entry change notification control sequence as a change type enumerated element:  {0}"),



  /**
   * Invalid change type value for the entry change notification control:  {0}.
   */
  ERR_ECN_INVALID_CHANGE_TYPE("Invalid change type value for the entry change notification control:  {0}."),



  /**
   * Invalid number of elements in the entry change notification control value sequence (expected between 1 and 3, got {0,number,0}).
   */
  ERR_ECN_INVALID_ELEMENT_COUNT("Invalid number of elements in the entry change notification control value sequence (expected between 1 and 3, got {0,number,0})."),



  /**
   * Invalid element type in the entry change notification value sequence:  {0}.
   */
  ERR_ECN_INVALID_ELEMENT_TYPE("Invalid element type in the entry change notification value sequence:  {0}."),



  /**
   * The provided control cannot be decoded as an entry change notification control because it does not have a value.
   */
  ERR_ECN_NO_VALUE("The provided control cannot be decoded as an entry change notification control because it does not have a value."),



  /**
   * Unable to decode the value as an entry change notification control sequence:  {0}
   */
  ERR_ECN_VALUE_NOT_SEQUENCE("Unable to decode the value as an entry change notification control sequence:  {0}"),



  /**
   * The provided control cannot be decoded as a ManageDsaIT request control because it has a value.
   */
  ERR_MANAGE_DSA_IT_HAS_VALUE("The provided control cannot be decoded as a ManageDsaIT request control because it has a value."),



  /**
   * AND search filters cannot be represented as matched values filters.
   */
  ERR_MV_FILTER_AND_NOT_SUPPORTED("AND search filters cannot be represented as matched values filters."),



  /**
   * Unable to decode the provided matched values filter element as a substring filter sequence:  {0}
   */
  ERR_MV_FILTER_CANNOT_DECODE_SUBSTRING("Unable to decode the provided matched values filter element as a substring filter sequence:  {0}"),



  /**
   * Extensible match search filters with the DN attributes flag cannot be represented as matched values filters.
   */
  ERR_MV_FILTER_DNATTRS_NOT_SUPPORTED("Extensible match search filters with the DN attributes flag cannot be represented as matched values filters."),



  /**
   * Unable to decode the provided matched values filter element as an extensible match filter sequence because it contained an element with an invalid BER type of {0}.
   */
  ERR_MV_FILTER_EXT_INVALID_TYPE("Unable to decode the provided matched values filter element as an extensible match filter sequence because it contained an element with an invalid BER type of {0}."),



  /**
   * Unable to decode the provided matched values filter element as an extensible match filter sequence because it contained multiple attribute type elements.
   */
  ERR_MV_FILTER_EXT_MULTIPLE_AT("Unable to decode the provided matched values filter element as an extensible match filter sequence because it contained multiple attribute type elements."),



  /**
   * Unable to decode the provided matched values filter element as an extensible match filter sequence because it contained multiple match value elements.
   */
  ERR_MV_FILTER_EXT_MULTIPLE_VALUE("Unable to decode the provided matched values filter element as an extensible match filter sequence because it contained multiple match value elements."),



  /**
   * Unable to decode the provided matched values filter element as an extensible match filter sequence:  {0}
   */
  ERR_MV_FILTER_EXT_NOT_SEQUENCE("Unable to decode the provided matched values filter element as an extensible match filter sequence:  {0}"),



  /**
   * Unable to decode the provided matched values filter element as an extensible match filter because it did not contain a match value.
   */
  ERR_MV_FILTER_EXT_NO_VALUE("Unable to decode the provided matched values filter element as an extensible match filter because it did not contain a match value."),



  /**
   * The provided search filter had an invalid filter type of {0} that cannot be converted to a matched values filter.
   */
  ERR_MV_FILTER_INVALID_FILTER_TYPE("The provided search filter had an invalid filter type of {0} that cannot be converted to a matched values filter."),



  /**
   * Unable to decode the provided matched values filter element as a substring filter sequence because one of the substring components had an invalid BER type of {0}.
   */
  ERR_MV_FILTER_INVALID_SUB_TYPE("Unable to decode the provided matched values filter element as a substring filter sequence because one of the substring components had an invalid BER type of {0}."),



  /**
   * Unable to decode the provided matched values filter element because it had an invalid BER type of {0}.
   */
  ERR_MV_FILTER_INVALID_TYPE("Unable to decode the provided matched values filter element because it had an invalid BER type of {0}."),



  /**
   * Unable to decode the provided matched values filter element as an extensible match filter sequence because it contained multiple matching rule ID elements.
   */
  ERR_MV_FILTER_MULTIPLE_MRID("Unable to decode the provided matched values filter element as an extensible match filter sequence because it contained multiple matching rule ID elements."),



  /**
   * Unable to decode the provided matched values filter element as a substring filter sequence because it contained multiple subFinal components.
   */
  ERR_MV_FILTER_MULTIPLE_SUBFINAL("Unable to decode the provided matched values filter element as a substring filter sequence because it contained multiple subFinal components."),



  /**
   * Unable to decode the provided matched values filter element as a substring filter sequence because it contained multiple subInitial components.
   */
  ERR_MV_FILTER_MULTIPLE_SUBINITIAL("Unable to decode the provided matched values filter element as a substring filter sequence because it contained multiple subInitial components."),



  /**
   * Unable to decode the provided matched values filter element as an attribute value assertion:  {0}
   */
  ERR_MV_FILTER_NOT_AVA("Unable to decode the provided matched values filter element as an attribute value assertion:  {0}"),



  /**
   * NOT search filters cannot be represented as matched values filters.
   */
  ERR_MV_FILTER_NOT_NOT_SUPPORTED("NOT search filters cannot be represented as matched values filters."),



  /**
   * Unable to decode the provided matched values filter element as an extensible match filter because it did not contain either a match attribute or matching rule ID.
   */
  ERR_MV_FILTER_NO_ATTR_OR_MRID("Unable to decode the provided matched values filter element as an extensible match filter because it did not contain either a match attribute or matching rule ID."),



  /**
   * Unable to decode the provided matched values filter element as a substring filter because it did not contain any substring filter components.
   */
  ERR_MV_FILTER_NO_SUBSTRING_ELEMENTS("Unable to decode the provided matched values filter element as a substring filter because it did not contain any substring filter components."),



  /**
   * OR search filters cannot be represented as matched values filters.
   */
  ERR_MV_FILTER_OR_NOT_SUPPORTED("OR search filters cannot be represented as matched values filters."),



  /**
   * The provided control cannot be decoded as a matched values request control because an error occurred while attempting to decode the value:  {0}
   */
  ERR_MV_REQUEST_CANNOT_DECODE("The provided control cannot be decoded as a matched values request control because an error occurred while attempting to decode the value:  {0}"),



  /**
   * Unable to decode JSON object {0} as a matched values request control because the ''{1}'' array is empty.
   */
  ERR_MV_REQUEST_JSON_EMPTY_FILTERS("Unable to decode JSON object {0} as a matched values request control because the ''{1}'' array is empty."),



  /**
   * Unable to decode JSON object {0} as a matched values request control because the ''{1}'' array has a value that is not a string.
   */
  ERR_MV_REQUEST_JSON_FILTER_NOT_STRING("Unable to decode JSON object {0} as a matched values request control because the ''{1}'' array has a value that is not a string."),



  /**
   * Unable to decode JSON object {0} as a matched values request control because ''{1}'' value ''{2}'' cannot be parsed as a valid matched values filter:  {3}
   */
  ERR_MV_REQUEST_JSON_INVALID_FILTER("Unable to decode JSON object {0} as a matched values request control because ''{1}'' value ''{2}'' cannot be parsed as a valid matched values filter:  {3}"),



  /**
   * Unable to decode JSON object {0} as a matched values request control because it is missing array field ''{1}'' needed to specify the matched values filters.
   */
  ERR_MV_REQUEST_JSON_NO_FILTERS("Unable to decode JSON object {0} as a matched values request control because it is missing array field ''{1}'' needed to specify the matched values filters."),



  /**
   * Unable to decode JSON object {0} as a matched values request control because the value includes unrecognized filed ''{1}''.
   */
  ERR_MV_REQUEST_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a matched values request control because the value includes unrecognized filed ''{1}''."),



  /**
   * The provided control cannot be decoded as a matched values request control because it does not have a value.
   */
  ERR_MV_REQUEST_NO_VALUE("The provided control cannot be decoded as a matched values request control because it does not have a value."),



  /**
   * Unable to decode the first element of the simple paged results value sequence as an integer:  {0}
   */
  ERR_PAGED_RESULTS_FIRST_NOT_INTEGER("Unable to decode the first element of the simple paged results value sequence as an integer:  {0}"),



  /**
   * Unexpected number of elements in the simple paged results value sequence (expected 2, got {0,number,0}).
   */
  ERR_PAGED_RESULTS_INVALID_ELEMENT_COUNT("Unexpected number of elements in the simple paged results value sequence (expected 2, got {0,number,0})."),



  /**
   * Unable to decode JSON object {0} as a simple paged results control because the ''{1}'' value is not a valid base64-encoded string.
   */
  ERR_PAGED_RESULTS_JSON_COOKIE_NOT_BASE64("Unable to decode JSON object {0} as a simple paged results control because the ''{1}'' value is not a valid base64-encoded string."),



  /**
   * Unable to decode JSON object {0} as a simple paged results control because the value is missing the required ''{1}'' integer field.
   */
  ERR_PAGED_RESULTS_JSON_MISSING_PAGE_SIZE("Unable to decode JSON object {0} as a simple paged results control because the value is missing the required ''{1}'' integer field."),



  /**
   * Unable to decode JSON object {0} as a simple paged results control because the value includes unrecognized field ''{1}''.
   */
  ERR_PAGED_RESULTS_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a simple paged results control because the value includes unrecognized field ''{1}''."),



  /**
   * No control value was provided, so it could not be decoded as a simple paged results response control.
   */
  ERR_PAGED_RESULTS_NO_VALUE("No control value was provided, so it could not be decoded as a simple paged results response control."),



  /**
   * Unable to decode the value of the provided control as an paged results control sequence:  {0}
   */
  ERR_PAGED_RESULTS_VALUE_NOT_SEQUENCE("Unable to decode the value of the provided control as an paged results control sequence:  {0}"),



  /**
   * The provided control cannot be decoded as a permissive modify request control because it has a value.
   */
  ERR_PERMISSIVE_MODIFY_HAS_VALUE("The provided control cannot be decoded as a permissive modify request control because it has a value."),



  /**
   * The provided control cannot be decoded as a post-read request control because an error occurred while attempting to decode the value:  {0}
   */
  ERR_POST_READ_REQUEST_CANNOT_DECODE("The provided control cannot be decoded as a post-read request control because an error occurred while attempting to decode the value:  {0}"),



  /**
   * Unable to decode JSON object {0} as a post-read request control because it includes a ''{1}'' value that is not a string.
   */
  ERR_POST_READ_REQUEST_JSON_ATTR_NOT_STRING("Unable to decode JSON object {0} as a post-read request control because it includes a ''{1}'' value that is not a string."),



  /**
   * Unable to decode JSON object {0} as a post-read request control because the value includes unrecognized field ''{1}''.
   */
  ERR_POST_READ_REQUEST_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a post-read request control because the value includes unrecognized field ''{1}''."),



  /**
   * The provided control cannot be decoded as a post-read request control because it does not have a value.
   */
  ERR_POST_READ_REQUEST_NO_VALUE("The provided control cannot be decoded as a post-read request control because it does not have a value."),



  /**
   * The attributes element could not be decoded as an ASN.1 sequence:  {0}
   */
  ERR_POST_READ_RESPONSE_ATTRIBUTES_NOT_SEQUENCE("The attributes element could not be decoded as an ASN.1 sequence:  {0}"),



  /**
   * An attribute element could not be decoded as an ASN.1 sequence:  {0}
   */
  ERR_POST_READ_RESPONSE_ATTR_NOT_SEQUENCE("An attribute element could not be decoded as an ASN.1 sequence:  {0}"),



  /**
   * The post-read entry sequence had an invalid number of elements (expected 2, got {0,number,0}).
   */
  ERR_POST_READ_RESPONSE_INVALID_ELEMENT_COUNT("The post-read entry sequence had an invalid number of elements (expected 2, got {0,number,0})."),



  /**
   * Unable to decode JSON object {0} as a post-read response control because the value of the ''{1}'' field (which is presumed to represent an attribute) is not an array.
   */
  ERR_POST_READ_RESPONSE_JSON_ATTR_VALUE_NOT_ARRAY("Unable to decode JSON object {0} as a post-read response control because the value of the ''{1}'' field (which is presumed to represent an attribute) is not an array."),



  /**
   * Unable to decode JSON object {0} as a post-read response control because the ''{1}'' array has a value that is not a string.
   */
  ERR_POST_READ_RESPONSE_JSON_ATTR_VALUE_NOT_STRING("Unable to decode JSON object {0} as a post-read response control because the ''{1}'' array has a value that is not a string."),



  /**
   * Unable to decode JSON object {0} as a post-read response control because the value of the ''{1}'' field is not a string.
   */
  ERR_POST_READ_RESPONSE_JSON_DN_NOT_STRING("Unable to decode JSON object {0} as a post-read response control because the value of the ''{1}'' field is not a string."),



  /**
   * Unable to decode JSON object {0} as a post-read response control because it is missing the ''{1}'' field needed to specify the entry DN.
   */
  ERR_POST_READ_RESPONSE_JSON_MISSING_DN("Unable to decode JSON object {0} as a post-read response control because it is missing the ''{1}'' field needed to specify the entry DN."),



  /**
   * The provided control cannot be decoded as a post-read response control because it does not have a value.
   */
  ERR_POST_READ_RESPONSE_NO_VALUE("The provided control cannot be decoded as a post-read response control because it does not have a value."),



  /**
   * The control value could not be decoded as a post-read response sequence:  {0}
   */
  ERR_POST_READ_RESPONSE_VALUE_NOT_SEQUENCE("The control value could not be decoded as a post-read response sequence:  {0}"),



  /**
   * The provided control cannot be decoded as a pre-read request control because an error occurred while attempting to decode the value:  {0}
   */
  ERR_PRE_READ_REQUEST_CANNOT_DECODE("The provided control cannot be decoded as a pre-read request control because an error occurred while attempting to decode the value:  {0}"),



  /**
   * Unable to decode JSON object {0} as a pre-read request control because it includes a ''{1}'' value that is not a string.
   */
  ERR_PRE_READ_REQUEST_JSON_ATTR_NOT_STRING("Unable to decode JSON object {0} as a pre-read request control because it includes a ''{1}'' value that is not a string."),



  /**
   * Unable to decode JSON object {0} as a pre-read request control because the value includes unrecognized field ''{1}''.
   */
  ERR_PRE_READ_REQUEST_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a pre-read request control because the value includes unrecognized field ''{1}''."),



  /**
   * The provided control cannot be decoded as a pre-read request control because it does not have a value.
   */
  ERR_PRE_READ_REQUEST_NO_VALUE("The provided control cannot be decoded as a pre-read request control because it does not have a value."),



  /**
   * The attributes element could not be decoded as an ASN.1 sequence:  {0}
   */
  ERR_PRE_READ_RESPONSE_ATTRIBUTES_NOT_SEQUENCE("The attributes element could not be decoded as an ASN.1 sequence:  {0}"),



  /**
   * An attribute element could not be decoded as an ASN.1 sequence:  {0}
   */
  ERR_PRE_READ_RESPONSE_ATTR_NOT_SEQUENCE("An attribute element could not be decoded as an ASN.1 sequence:  {0}"),



  /**
   * The pre-read entry sequence had an invalid number of elements (expected 2, got {0,number,0}).
   */
  ERR_PRE_READ_RESPONSE_INVALID_ELEMENT_COUNT("The pre-read entry sequence had an invalid number of elements (expected 2, got {0,number,0})."),



  /**
   * Unable to decode JSON object {0} as a pre-read response control because the value of the ''{1}'' field (which is presumed to represent an attribute) is not an array.
   */
  ERR_PRE_READ_RESPONSE_JSON_ATTR_VALUE_NOT_ARRAY("Unable to decode JSON object {0} as a pre-read response control because the value of the ''{1}'' field (which is presumed to represent an attribute) is not an array."),



  /**
   * Unable to decode JSON object {0} as a pre-read response control because the ''{1}'' array has a value that is not a string.
   */
  ERR_PRE_READ_RESPONSE_JSON_ATTR_VALUE_NOT_STRING("Unable to decode JSON object {0} as a pre-read response control because the ''{1}'' array has a value that is not a string."),



  /**
   * Unable to decode JSON object {0} as a pre-read response control because the value of the ''{1}'' field is not a string.
   */
  ERR_PRE_READ_RESPONSE_JSON_DN_NOT_STRING("Unable to decode JSON object {0} as a pre-read response control because the value of the ''{1}'' field is not a string."),



  /**
   * Unable to decode JSON object {0} as a pre-read response control because it is missing the ''{1}'' field needed to specify the entry DN.
   */
  ERR_PRE_READ_RESPONSE_JSON_MISSING_DN("Unable to decode JSON object {0} as a pre-read response control because it is missing the ''{1}'' field needed to specify the entry DN."),



  /**
   * The provided control cannot be decoded as a pre-read response control because it does not have a value.
   */
  ERR_PRE_READ_RESPONSE_NO_VALUE("The provided control cannot be decoded as a pre-read response control because it does not have a value."),



  /**
   * The control value could not be decoded as pre-read response sequence:  {0}
   */
  ERR_PRE_READ_RESPONSE_VALUE_NOT_SEQUENCE("The control value could not be decoded as pre-read response sequence:  {0}"),



  /**
   * The provided control cannot be decoded as a proxied authorization v1 request control because an error occurred while attempting to decode the control value:  {0}
   */
  ERR_PROXYV1_DECODE_ERROR("The provided control cannot be decoded as a proxied authorization v1 request control because an error occurred while attempting to decode the control value:  {0}"),



  /**
   * Unable to decode JSON object {0} as a proxied authorization v1 request control because the value is missing field ''{1}'' needed to specify the authorization DN.
   */
  ERR_PROXYV1_JSON_MISSING_AUTHZ_DN("Unable to decode JSON object {0} as a proxied authorization v1 request control because the value is missing field ''{1}'' needed to specify the authorization DN."),



  /**
   * Unable to decode JSON object {0} as a proxied authorization v1 request control because the value includes unexpected field ''{1}''.
   */
  ERR_PROXYV1_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a proxied authorization v1 request control because the value includes unexpected field ''{1}''."),



  /**
   * Unable to decode JSON object {0} as a proxied authorization v2 request control because the value is missing field ''{1}'' needed to specify the authorization ID.
   */
  ERR_PROXYV2_JSON_MISSING_AUTHZ_ID("Unable to decode JSON object {0} as a proxied authorization v2 request control because the value is missing field ''{1}'' needed to specify the authorization ID."),



  /**
   * Unable to decode JSON object {0} as a proxied authorization v2 request control because the value includes unexpected field ''{1}''.
   */
  ERR_PROXYV2_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a proxied authorization v2 request control because the value includes unexpected field ''{1}''."),



  /**
   * The provided control cannot be decoded as a proxied authorization v1 request control because it does not have a value.
   */
  ERR_PROXY_V1_NO_VALUE("The provided control cannot be decoded as a proxied authorization v1 request control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a proxied authorization v2 request control because it does not have a value.
   */
  ERR_PROXY_V2_NO_VALUE("The provided control cannot be decoded as a proxied authorization v2 request control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a persistent search request control because an error occurred while attempting to decode the control value:  {0}
   */
  ERR_PSEARCH_CANNOT_DECODE("The provided control cannot be decoded as a persistent search request control because an error occurred while attempting to decode the control value:  {0}"),



  /**
   * The provided control cannot be decoded as a persistent search request control because it does not have a value.
   */
  ERR_PSEARCH_NO_VALUE("The provided control cannot be decoded as a persistent search request control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a password expired response control because it does not have a value.
   */
  ERR_PW_EXPIRED_NO_VALUE("The provided control cannot be decoded as a password expired response control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a password expired response control because the control value could not be parsed as an integer.
   */
  ERR_PW_EXPIRED_VALUE_NOT_INTEGER("The provided control cannot be decoded as a password expired response control because the control value could not be parsed as an integer."),



  /**
   * Unable to decode JSON object {0} as a password expiring response control because the value is missing required field ''{1}''.
   */
  ERR_PW_EXPIRING_JSON_MISSING_SECONDS_UNTIL_EXPIRATION("Unable to decode JSON object {0} as a password expiring response control because the value is missing required field ''{1}''."),



  /**
   * Unable to decode JSON object {0} as a password expiring response control because the value includes unrecognized field ''{1}''.
   */
  ERR_PW_EXPIRING_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a password expiring response control because the value includes unrecognized field ''{1}''."),



  /**
   * The provided control cannot be decoded as a password expiring response control because it does not have a value.
   */
  ERR_PW_EXPIRING_NO_VALUE("The provided control cannot be decoded as a password expiring response control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a password expiring response control because the control value could not be parsed as an integer.
   */
  ERR_PW_EXPIRING_VALUE_NOT_INTEGER("The provided control cannot be decoded as a password expiring response control because the control value could not be parsed as an integer."),



  /**
   * The provided ASN.1 element cannot be decoded as a sort key because the element sequence contained an element with an invalid BER type of {0}.
   */
  ERR_SORT_KEY_ELEMENT_INVALID_TYPE("The provided ASN.1 element cannot be decoded as a sort key because the element sequence contained an element with an invalid BER type of {0}."),



  /**
   * The provided ASN.1 element cannot be decoded as a sort key because the element sequence has an invalid number of elements (expected between 1 and 3, got {0,number,0}).
   */
  ERR_SORT_KEY_INVALID_ELEMENT_COUNT("The provided ASN.1 element cannot be decoded as a sort key because the element sequence has an invalid number of elements (expected between 1 and 3, got {0,number,0})."),



  /**
   * The provided ASN.1 element cannot be decoded as a sort key because it could not be parsed as an ASN.1 sequence:  {0}
   */
  ERR_SORT_KEY_NOT_SEQUENCE("The provided ASN.1 element cannot be decoded as a sort key because it could not be parsed as an ASN.1 sequence:  {0}"),



  /**
   * The provided ASN.1 element cannot be decoded as a sort key because the reverseOrder element could not be parsed as a Boolean:  {0}
   */
  ERR_SORT_KEY_REVERSE_NOT_BOOLEAN("The provided ASN.1 element cannot be decoded as a sort key because the reverseOrder element could not be parsed as a Boolean:  {0}"),



  /**
   * The provided control cannot be decoded as a server-side sort request control because an error occurred while attempting to decode the control value:  {0}
   */
  ERR_SORT_REQUEST_CANNOT_DECODE("The provided control cannot be decoded as a server-side sort request control because an error occurred while attempting to decode the control value:  {0}"),



  /**
   * Unable to decode JSON object {0} as a server-side sort request control because the ''{1}'' array is empty.
   */
  ERR_SORT_REQUEST_JSON_EMPTY_SORT_KEYS("Unable to decode JSON object {0} as a server-side sort request control because the ''{1}'' array is empty."),



  /**
   * Unable to decode JSON object {0} as a server-side sort request control because the value is missing the required ''{1}'' array field.
   */
  ERR_SORT_REQUEST_JSON_MISSING_SORT_KEYS("Unable to decode JSON object {0} as a server-side sort request control because the value is missing the required ''{1}'' array field."),



  /**
   * Unable to decode JSON object {0} as a server-side sort request control because a ''{1}'' object is missing required field ''{2}''.
   */
  ERR_SORT_REQUEST_JSON_SORT_KEY_MISSING_FIELD("Unable to decode JSON object {0} as a server-side sort request control because a ''{1}'' object is missing required field ''{2}''."),



  /**
   * Unable to decode JSON object {0} as a server-side sort request control because the ''{1}'' array has a value that is not an object.
   */
  ERR_SORT_REQUEST_JSON_SORT_KEY_VALUE_NOT_OBJECT("Unable to decode JSON object {0} as a server-side sort request control because the ''{1}'' array has a value that is not an object."),



  /**
   * Unable to decode JSON object {0} as a server-side sort request control because the value includes unrecognized field ''{1}''.
   */
  ERR_SORT_REQUEST_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a server-side sort request control because the value includes unrecognized field ''{1}''."),



  /**
   * Unable to decode JSON object {0} as a server-side sort request control because a ''{1}'' object includes unrecognized field ''{2}''.
   */
  ERR_SORT_REQUEST_JSON_UNRECOGNIZED_SORT_KEY_FIELD("Unable to decode JSON object {0} as a server-side sort request control because a ''{1}'' object includes unrecognized field ''{2}''."),



  /**
   * The provided control cannot be decoded as a server-side sort request control because it does not have a value.
   */
  ERR_SORT_REQUEST_NO_VALUE("The provided control cannot be decoded as a server-side sort request control because it does not have a value."),



  /**
   * Unable to decode the first element of the provided control as a result code enumerated element:  {0}
   */
  ERR_SORT_RESPONSE_FIRST_NOT_ENUM("Unable to decode the first element of the provided control as a result code enumerated element:  {0}"),



  /**
   * The sort response control value sequence had an invalid number of elements (expected 1 or 2, got {0,number,0}).
   */
  ERR_SORT_RESPONSE_INVALID_ELEMENT_COUNT("The sort response control value sequence had an invalid number of elements (expected 1 or 2, got {0,number,0})."),



  /**
   * Unable to decode JSON object {0} as a server-side sort response control because the value is missing required integer field ''{1}''
   */
  ERR_SORT_RESPONSE_JSON_MISSING_RESULT_CODE("Unable to decode JSON object {0} as a server-side sort response control because the value is missing required integer field ''{1}''"),



  /**
   * Unable to decode JSON object {0} as a server-side sort response control because the value includes unrecognized field ''{1}''.
   */
  ERR_SORT_RESPONSE_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a server-side sort response control because the value includes unrecognized field ''{1}''."),



  /**
   * No control value was provided, so it could not be decoded as a server-side sort response control.
   */
  ERR_SORT_RESPONSE_NO_VALUE("No control value was provided, so it could not be decoded as a server-side sort response control."),



  /**
   * Unable to decode the value of the provided control as a sort response sequence:  {0}
   */
  ERR_SORT_RESPONSE_VALUE_NOT_SEQUENCE("Unable to decode the value of the provided control as a sort response sequence:  {0}"),



  /**
   * The provided control cannot be decoded as a subentries request control because an error occurred while attempting to decode the control value:  {0}
   */
  ERR_SUBENTRIES_ERROR_DECODING_VALUE("The provided control cannot be decoded as a subentries request control because an error occurred while attempting to decode the control value:  {0}"),



  /**
   * The provided control cannot be decoded as a subentries request control because it has a value.
   */
  ERR_SUBENTRIES_HAS_VALUE("The provided control cannot be decoded as a subentries request control because it has a value."),



  /**
   * The provided control cannot be decoded as a subentries request control because it does not have a value.
   */
  ERR_SUBENTRIES_MISSING_VALUE("The provided control cannot be decoded as a subentries request control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a subtree delete request control because it has a value.
   */
  ERR_SUBTREE_DELETE_HAS_VALUE("The provided control cannot be decoded as a subtree delete request control because it has a value."),



  /**
   * The provided control cannot be decoded as a content synchronization done control because it does not have a value.
   */
  ERR_SYNC_DONE_NO_VALUE("The provided control cannot be decoded as a content synchronization done control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a content synchronization done control because an error occurred while trying to decode the control value:  {0}
   */
  ERR_SYNC_DONE_VALUE_CANNOT_DECODE("The provided control cannot be decoded as a content synchronization done control because an error occurred while trying to decode the control value:  {0}"),



  /**
   * The provided control cannot be decoded as a content synchronization done control because the value sequence had an element with an invalid type of {0}.
   */
  ERR_SYNC_DONE_VALUE_INVALID_ELEMENT_TYPE("The provided control cannot be decoded as a content synchronization done control because the value sequence had an element with an invalid type of {0}."),



  /**
   * The provided control cannot be decoded as a content synchronization done control because the value sequence included multiple state cookies.
   */
  ERR_SYNC_DONE_VALUE_MULTIPLE_COOKIES("The provided control cannot be decoded as a content synchronization done control because the value sequence included multiple state cookies."),



  /**
   * The provided control cannot be decoded as a content synchronization done control because the value sequence included multiple refreshDelete elements.
   */
  ERR_SYNC_DONE_VALUE_MULTIPLE_REFRESH_DELETE("The provided control cannot be decoded as a content synchronization done control because the value sequence included multiple refreshDelete elements."),



  /**
   * Unable to decode the provided intermediate response as a sync info response of type {0} because the value sequence included a malformed UUID:  {1}
   */
  ERR_SYNC_INFO_IR_INVALID_UUID("Unable to decode the provided intermediate response as a sync info response of type {0} because the value sequence included a malformed UUID:  {1}"),



  /**
   * Unable to decode the provided intermediate response as a sync info response of type {0} because the value sequence did not contain an entryUUID set.
   */
  ERR_SYNC_INFO_IR_NO_UUID_SET("Unable to decode the provided intermediate response as a sync info response of type {0} because the value sequence did not contain an entryUUID set."),



  /**
   * Unable to decode the provided intermediate response as a sync info response because it does not have a value.
   */
  ERR_SYNC_INFO_IR_NO_VALUE("Unable to decode the provided intermediate response as a sync info response because it does not have a value."),



  /**
   * Unable to decode the provided intermediate response as a sync info response because an error occurred while attempting to parse the value:  {0}
   */
  ERR_SYNC_INFO_IR_VALUE_DECODING_ERROR("Unable to decode the provided intermediate response as a sync info response because an error occurred while attempting to parse the value:  {0}"),



  /**
   * Unable to decode the provided intermediate response as a sync info response of type {0} because the value sequence contained an element with an unexpected type of {1}.
   */
  ERR_SYNC_INFO_IR_VALUE_INVALID_SEQUENCE_TYPE("Unable to decode the provided intermediate response as a sync info response of type {0} because the value sequence contained an element with an unexpected type of {1}."),



  /**
   * Unable to decode the provided intermediate response as a sync info response because the value could not be decoded as an ASN.1 element:  {0}
   */
  ERR_SYNC_INFO_IR_VALUE_NOT_ELEMENT("Unable to decode the provided intermediate response as a sync info response because the value could not be decoded as an ASN.1 element:  {0}"),



  /**
   * Unable to decode the provided intermediate response as a sync info response because the value element had an unrecognized type of {0}.
   */
  ERR_SYNC_INFO_IR_VALUE_UNRECOGNIZED_TYPE("Unable to decode the provided intermediate response as a sync info response because the value element had an unrecognized type of {0}."),



  /**
   * The provided control cannot be decoded as a content synchronization request control because it does not have a value.
   */
  ERR_SYNC_REQUEST_NO_VALUE("The provided control cannot be decoded as a content synchronization request control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a content synchronization request control because an error occurred while trying to decode the control value:  {0}
   */
  ERR_SYNC_REQUEST_VALUE_CANNOT_DECODE("The provided control cannot be decoded as a content synchronization request control because an error occurred while trying to decode the control value:  {0}"),



  /**
   * The provided control cannot be decoded as a content synchronization request control because the value sequence had an element with an invalid type of {0}.
   */
  ERR_SYNC_REQUEST_VALUE_INVALID_ELEMENT_TYPE("The provided control cannot be decoded as a content synchronization request control because the value sequence had an element with an invalid type of {0}."),



  /**
   * The provided control cannot be decoded as a content synchronization request control because the value sequence included an invalid request mode of {0}.
   */
  ERR_SYNC_REQUEST_VALUE_INVALID_MODE("The provided control cannot be decoded as a content synchronization request control because the value sequence included an invalid request mode of {0}."),



  /**
   * The provided control cannot be decoded as a content synchronization request control because the value sequence included multiple state cookies.
   */
  ERR_SYNC_REQUEST_VALUE_MULTIPLE_COOKIES("The provided control cannot be decoded as a content synchronization request control because the value sequence included multiple state cookies."),



  /**
   * The provided control cannot be decoded as a content synchronization request control because the value sequence included multiple reload hint elements.
   */
  ERR_SYNC_REQUEST_VALUE_MULTIPLE_HINTS("The provided control cannot be decoded as a content synchronization request control because the value sequence included multiple reload hint elements."),



  /**
   * The provided control cannot be decoded as a content synchronization request control because the value sequence included multiple request modes.
   */
  ERR_SYNC_REQUEST_VALUE_MULTIPLE_MODES("The provided control cannot be decoded as a content synchronization request control because the value sequence included multiple request modes."),



  /**
   * The provided control cannot be decoded as a content synchronization request control because the value sequence does not include a request mode.
   */
  ERR_SYNC_REQUEST_VALUE_NO_MODE("The provided control cannot be decoded as a content synchronization request control because the value sequence does not include a request mode."),



  /**
   * The provided control cannot be decoded as a content synchronization state control because it does not have a value.
   */
  ERR_SYNC_STATE_NO_VALUE("The provided control cannot be decoded as a content synchronization state control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a content synchronization state control because an error occurred while trying to decode the control value:  {0}
   */
  ERR_SYNC_STATE_VALUE_CANNOT_DECODE("The provided control cannot be decoded as a content synchronization state control because an error occurred while trying to decode the control value:  {0}"),



  /**
   * The provided control cannot be decoded as a content synchronization state control because the value sequence had an element with an invalid type of {0}.
   */
  ERR_SYNC_STATE_VALUE_INVALID_ELEMENT_TYPE("The provided control cannot be decoded as a content synchronization state control because the value sequence had an element with an invalid type of {0}."),



  /**
   * The provided control cannot be decoded as a content synchronization state control because the value sequence included an invalid state value of {0}.
   */
  ERR_SYNC_STATE_VALUE_INVALID_STATE("The provided control cannot be decoded as a content synchronization state control because the value sequence included an invalid state value of {0}."),



  /**
   * The provided control cannot be decoded as a content synchronization state control because the value sequence had a malformed entryUUID:  {0}
   */
  ERR_SYNC_STATE_VALUE_MALFORMED_UUID("The provided control cannot be decoded as a content synchronization state control because the value sequence had a malformed entryUUID:  {0}"),



  /**
   * The provided control cannot be decoded as a transaction specification request control because it does not have a value.
   */
  ERR_TXN_REQUEST_CONTROL_NO_VALUE("The provided control cannot be decoded as a transaction specification request control because it does not have a value."),



  /**
   * The provided control cannot be decoded as a virtual list view request control because an error occurred while attempting to decode the control value:  {0}
   */
  ERR_VLV_REQUEST_CANNOT_DECODE("The provided control cannot be decoded as a virtual list view request control because an error occurred while attempting to decode the control value:  {0}"),



  /**
   * The provided control cannot be decoded as a virtual list view request control because the target element had an invalid BER type of {0}.
   */
  ERR_VLV_REQUEST_INVALID_ELEMENT_TYPE("The provided control cannot be decoded as a virtual list view request control because the target element had an invalid BER type of {0}."),



  /**
   * Unable to decode JSON object {0} as a virtual list view request control because the value contains both the ''{1}'' and ''{2}'' fields.  Exactly one of those fields must be present.
   */
  ERR_VLV_REQUEST_JSON_BOTH_OFFSET_AND_VALUE("Unable to decode JSON object {0} as a virtual list view request control because the value contains both the ''{1}'' and ''{2}'' fields.  Exactly one of those fields must be present."),



  /**
   * Unable to decode JSON object {0} as a virtual list view request control because the ''{1}'' field may not be used in conjunction with the ''{2}'' field.
   */
  ERR_VLV_REQUEST_JSON_CONTENT_COUNT_WITH_ASSERTION_VALUE("Unable to decode JSON object {0} as a virtual list view request control because the ''{1}'' field may not be used in conjunction with the ''{2}'' field."),



  /**
   * Unable to decode JSON object {0} as a virtual list view request control because the value of the ''{1}'' field cannot be base64-decoded.
   */
  ERR_VLV_REQUEST_JSON_CONTEXT_ID_NOT_BASE64("Unable to decode JSON object {0} as a virtual list view request control because the value of the ''{1}'' field cannot be base64-decoded."),



  /**
   * Unable to decode JSON object {0} as a virtual list view request control because the value is missing the required ''{1}'' field.
   */
  ERR_VLV_REQUEST_JSON_MISSING_FIELD("Unable to decode JSON object {0} as a virtual list view request control because the value is missing the required ''{1}'' field."),



  /**
   * Unable to decode JSON object {0} as a virtual list view request control because the value does not contain either the ''{1}'' or the ''{2}'' field.  Exactly one of those fields must be present.
   */
  ERR_VLV_REQUEST_JSON_NEITHER_OFFSET_NOR_VALUE("Unable to decode JSON object {0} as a virtual list view request control because the value does not contain either the ''{1}'' or the ''{2}'' field.  Exactly one of those fields must be present."),



  /**
   * Unable to decode JSON object {0} as a virtual list view request control because the value includes unrecognized field ''{1}''.
   */
  ERR_VLV_REQUEST_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a virtual list view request control because the value includes unrecognized field ''{1}''."),



  /**
   * The provided control cannot be decoded as a virtual list view request control because it does not have a value.
   */
  ERR_VLV_REQUEST_NO_VALUE("The provided control cannot be decoded as a virtual list view request control because it does not have a value."),



  /**
   * Unable to decode the first element of the provided control as an integer element:  {0}
   */
  ERR_VLV_RESPONSE_FIRST_NOT_INTEGER("Unable to decode the first element of the provided control as an integer element:  {0}"),



  /**
   * The control value sequence had an invalid number of elements (expected 3 or 4, got {0,number,0}).
   */
  ERR_VLV_RESPONSE_INVALID_ELEMENT_COUNT("The control value sequence had an invalid number of elements (expected 3 or 4, got {0,number,0})."),



  /**
   * Unable to decode JSON object {0} as a virtual list view response control because the ''{1}'' value cannot be base64-decoded.
   */
  ERR_VLV_RESPONSE_JSON_CONTEXT_ID_NOT_BASE64("Unable to decode JSON object {0} as a virtual list view response control because the ''{1}'' value cannot be base64-decoded."),



  /**
   * Unable to decode JSON object {0} as a virtual list view response control because the value is missing required field ''{1}''.
   */
  ERR_VLV_RESPONSE_JSON_MISSING_FIELD("Unable to decode JSON object {0} as a virtual list view response control because the value is missing required field ''{1}''."),



  /**
   * Unable to decode JSON object {0} as a virtual list view response control because the value includes unrecognized field ''{1}''.
   */
  ERR_VLV_RESPONSE_JSON_UNRECOGNIZED_FIELD("Unable to decode JSON object {0} as a virtual list view response control because the value includes unrecognized field ''{1}''."),



  /**
   * No control value was provided, so it could not be decoded as a virtual list view response control.
   */
  ERR_VLV_RESPONSE_NO_VALUE("No control value was provided, so it could not be decoded as a virtual list view response control."),



  /**
   * Unable to decode the second element of the provided control as an integer element:  {0}
   */
  ERR_VLV_RESPONSE_SECOND_NOT_INTEGER("Unable to decode the second element of the provided control as an integer element:  {0}"),



  /**
   * Unable to decode the third element of the provided control as an enumerated element:  {0}
   */
  ERR_VLV_RESPONSE_THIRD_NOT_ENUM("Unable to decode the third element of the provided control as an enumerated element:  {0}"),



  /**
   * Unable to decode the value of the provided control as an ASN.1 sequence:  {0}
   */
  ERR_VLV_RESPONSE_VALUE_NOT_SEQUENCE("Unable to decode the value of the provided control as an ASN.1 sequence:  {0}"),



  /**
   * Assertion Request Control
   */
  INFO_CONTROL_NAME_ASSERTION_REQUEST("Assertion Request Control"),



  /**
   * Authorization Identity Request Control
   */
  INFO_CONTROL_NAME_AUTHZID_REQUEST("Authorization Identity Request Control"),



  /**
   * Authorization Identity Response Control
   */
  INFO_CONTROL_NAME_AUTHZID_RESPONSE("Authorization Identity Response Control"),



  /**
   * Content Synchronization Done Control
   */
  INFO_CONTROL_NAME_CONTENT_SYNC_DONE("Content Synchronization Done Control"),



  /**
   * Content Synchronization Request Control
   */
  INFO_CONTROL_NAME_CONTENT_SYNC_REQUEST("Content Synchronization Request Control"),



  /**
   * Content Synchronization State Control
   */
  INFO_CONTROL_NAME_CONTENT_SYNC_STATE("Content Synchronization State Control"),



  /**
   * Don''t Use Copy Request Control
   */
  INFO_CONTROL_NAME_DONT_USE_COPY("Don''t Use Copy Request Control"),



  /**
   * Entry Change Notification Control
   */
  INFO_CONTROL_NAME_ENTRY_CHANGE_NOTIFICATION("Entry Change Notification Control"),



  /**
   * ManageDsaIT Request Control
   */
  INFO_CONTROL_NAME_MANAGE_DSAIT_REQUEST("ManageDsaIT Request Control"),



  /**
   * Matched Values Request Control
   */
  INFO_CONTROL_NAME_MATCHED_VALUES_REQUEST("Matched Values Request Control"),



  /**
   * Simple Paged Results Control
   */
  INFO_CONTROL_NAME_PAGED_RESULTS("Simple Paged Results Control"),



  /**
   * Permissive Modify Request Control
   */
  INFO_CONTROL_NAME_PERMISSIVE_MODIFY_REQUEST("Permissive Modify Request Control"),



  /**
   * Post-Read Request Control
   */
  INFO_CONTROL_NAME_POST_READ_REQUEST("Post-Read Request Control"),



  /**
   * Post-Read Response Control
   */
  INFO_CONTROL_NAME_POST_READ_RESPONSE("Post-Read Response Control"),



  /**
   * Pre-Read Request Control
   */
  INFO_CONTROL_NAME_PRE_READ_REQUEST("Pre-Read Request Control"),



  /**
   * Pre-Read Response Control
   */
  INFO_CONTROL_NAME_PRE_READ_RESPONSE("Pre-Read Response Control"),



  /**
   * Proxied Authorization v1 Request Control
   */
  INFO_CONTROL_NAME_PROXIED_AUTHZ_V1_REQUEST("Proxied Authorization v1 Request Control"),



  /**
   * Proxied Authorization v2 Request Control
   */
  INFO_CONTROL_NAME_PROXIED_AUTHZ_V2_REQUEST("Proxied Authorization v2 Request Control"),



  /**
   * Persistent Search Request Control
   */
  INFO_CONTROL_NAME_PSEARCH_REQUEST("Persistent Search Request Control"),



  /**
   * Password Expired Control
   */
  INFO_CONTROL_NAME_PW_EXPIRED("Password Expired Control"),



  /**
   * Password Expiring Control
   */
  INFO_CONTROL_NAME_PW_EXPIRING("Password Expiring Control"),



  /**
   * Server-Side Sort Request Control
   */
  INFO_CONTROL_NAME_SORT_REQUEST("Server-Side Sort Request Control"),



  /**
   * Server-Side Sort Response Control
   */
  INFO_CONTROL_NAME_SORT_RESPONSE("Server-Side Sort Response Control"),



  /**
   * LDAP Subentries Request Control
   */
  INFO_CONTROL_NAME_SUBENTRIES_REQUEST("LDAP Subentries Request Control"),



  /**
   * Subtree Delete Request Control
   */
  INFO_CONTROL_NAME_SUBTREE_DELETE_REQUEST("Subtree Delete Request Control"),



  /**
   * Transaction Specification Request Control
   */
  INFO_CONTROL_NAME_TXN_SPECIFICATION_REQUEST("Transaction Specification Request Control"),



  /**
   * Virtual List View Request Control
   */
  INFO_CONTROL_NAME_VLV_REQUEST("Virtual List View Request Control"),



  /**
   * Virtual List View Response Control
   */
  INFO_CONTROL_NAME_VLV_RESPONSE("Virtual List View Response Control"),



  /**
   * Content Synchronization Info Intermediate Response
   */
  INFO_INTERMEDIATE_RESPONSE_NAME_SYNC_INFO("Content Synchronization Info Intermediate Response");



  /**
   * Indicates whether the unit tests are currently running.
   */
  private static final boolean IS_WITHIN_UNIT_TESTS =
       Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") ||
       Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");



  /**
   * A pre-allocated array of zero objects to use for messages
   * that do not require any arguments.
   */
  private static final Object[] NO_ARGS = new Object[0];



  /**
   * The resource bundle that will be used to load the properties file.
   */
  private static final ResourceBundle RESOURCE_BUNDLE;
  static
  {
    ResourceBundle rb = null;
    try
    {
      rb = ResourceBundle.getBundle("unboundid-ldapsdk-controls");
    } catch (final Exception e) {}
    RESOURCE_BUNDLE = rb;
  }



  /**
   * The map that will be used to hold the unformatted message strings, indexed by property name.
   */
  private static final ConcurrentHashMap<ControlMessages,String> MESSAGE_STRINGS = new ConcurrentHashMap<>(100);



  /**
   * The map that will be used to hold the message format objects, indexed by property name.
   */
  private static final ConcurrentHashMap<ControlMessages,MessageFormat> MESSAGES = new ConcurrentHashMap<>(100);



  // The default text for this message
  private final String defaultText;



  /**
   * Creates a new message key.
   */
  private ControlMessages(final String defaultText)
  {
    this.defaultText = defaultText;
  }



  /**
   * Retrieves a localized version of the message.
   * This method should only be used for messages that do not take any
   * arguments.
   *
   * @return  A localized version of the message.
   */
  public String get()
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(NO_ARGS);
    }

    if (IS_WITHIN_UNIT_TESTS)
    {
      if (formattedMessage.contains("{0}") ||
          formattedMessage.contains("{0,number,0}") ||
          formattedMessage.contains("{1}") ||
          formattedMessage.contains("{1,number,0}") ||
          formattedMessage.contains("{2}") ||
          formattedMessage.contains("{2,number,0}") ||
          formattedMessage.contains("{3}") ||
          formattedMessage.contains("{3,number,0}") ||
          formattedMessage.contains("{4}") ||
          formattedMessage.contains("{4,number,0}") ||
          formattedMessage.contains("{5}") ||
          formattedMessage.contains("{5,number,0}") ||
          formattedMessage.contains("{6}") ||
          formattedMessage.contains("{6,number,0}") ||
          formattedMessage.contains("{7}") ||
          formattedMessage.contains("{7,number,0}") ||
          formattedMessage.contains("{8}") ||
          formattedMessage.contains("{8,number,0}") ||
          formattedMessage.contains("{9}") ||
          formattedMessage.contains("{9,number,0}") ||
          formattedMessage.contains("{10}") ||
          formattedMessage.contains("{10,number,0}"))
      {
        throw new IllegalArgumentException(
             "Message " + getClass().getName() + '.' + name() +
                  " contains an un-replaced token:  " + formattedMessage);
      }
    }

    return formattedMessage;
  }



  /**
   * Retrieves a localized version of the message.
   *
   * @param  args  The arguments to use to format the message.
   *
   * @return  A localized version of the message.
   */
  public String get(final Object... args)
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(args);
    }

    if (IS_WITHIN_UNIT_TESTS)
    {
      if (formattedMessage.contains("{0}") ||
          formattedMessage.contains("{0,number,0}") ||
          formattedMessage.contains("{1}") ||
          formattedMessage.contains("{1,number,0}") ||
          formattedMessage.contains("{2}") ||
          formattedMessage.contains("{2,number,0}") ||
          formattedMessage.contains("{3}") ||
          formattedMessage.contains("{3,number,0}") ||
          formattedMessage.contains("{4}") ||
          formattedMessage.contains("{4,number,0}") ||
          formattedMessage.contains("{5}") ||
          formattedMessage.contains("{5,number,0}") ||
          formattedMessage.contains("{6}") ||
          formattedMessage.contains("{6,number,0}") ||
          formattedMessage.contains("{7}") ||
          formattedMessage.contains("{7,number,0}") ||
          formattedMessage.contains("{8}") ||
          formattedMessage.contains("{8,number,0}") ||
          formattedMessage.contains("{9}") ||
          formattedMessage.contains("{9,number,0}") ||
          formattedMessage.contains("{10}") ||
          formattedMessage.contains("{10,number,0}"))
      {
        throw new IllegalArgumentException(
             "Message " + getClass().getName() + '.' + name() +
                  " contains an un-replaced token:  " + formattedMessage);
      }
    }

    return formattedMessage;
  }



  /**
   * Retrieves a string representation of this message key.
   *
   * @return  A string representation of this message key.
   */
  @Override()
  public String toString()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        s = defaultText;
      }
      else
      {
        try
        {
          s = RESOURCE_BUNDLE.getString(name());
        }
        catch (final Exception e)
        {
          s = defaultText;
        }
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }

    return s;
  }
}

