/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFMessages;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.ldif.TrailingSpaceBehavior;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PassphraseEncryptedOutputStream;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDIFModify
extends CommandLineTool {
    @NotNull
    private static final File PING_SERVER_ROOT = InternalSDKHelper.getPingIdentityServerRoot();
    private static final boolean PING_SERVER_AVAILABLE = PING_SERVER_ROOT != null;
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private final AtomicReference<String> completionMessage = new AtomicReference();
    @NotNull
    private final List<char[]> inputEncryptionPassphrases = new ArrayList<char[]>(5);
    @Nullable
    private BooleanArgument compressTarget = null;
    @Nullable
    private BooleanArgument doNotWrap = null;
    @Nullable
    private BooleanArgument encryptTarget = null;
    @Nullable
    private BooleanArgument ignoreDeletesOfNonexistentEntries = null;
    @Nullable
    private BooleanArgument ignoreDuplicateDeletes = null;
    @Nullable
    private BooleanArgument ignoreModifiesOfNonexistentEntries = null;
    @Nullable
    private BooleanArgument lenientModifications = null;
    @Nullable
    private BooleanArgument strictModifications = null;
    @Nullable
    private BooleanArgument noSchemaCheck = null;
    @Nullable
    private BooleanArgument stripTrailingSpaces = null;
    @Nullable
    private BooleanArgument suppressComments = null;
    @Nullable
    private FileArgument changesEncryptionPassphraseFile = null;
    @Nullable
    private FileArgument changesLDIF = null;
    @Nullable
    private FileArgument sourceEncryptionPassphraseFile = null;
    @Nullable
    private FileArgument sourceLDIF = null;
    @Nullable
    private FileArgument targetEncryptionPassphraseFile = null;
    @Nullable
    private FileArgument targetLDIF = null;
    @Nullable
    private IntegerArgument wrapColumn = null;
    @Nullable
    private LDIFReader changesReader = null;
    @Nullable
    private LDIFReader sourceReader = null;
    @Nullable
    private LDIFWriter targetWriter = null;
    @Nullable
    private List<String> errorMessages = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDIFModify.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        LDIFModify tool = new LDIFModify(out, err);
        return tool.runTool(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean main(@NotNull LDIFReader sourceReader, @NotNull LDIFReader changesReader, @NotNull LDIFWriter targetWriter, @NotNull List<String> errorMessages) {
        Validator.ensureNotNull(sourceReader, changesReader, targetWriter, errorMessages);
        LDIFModify tool = new LDIFModify(null, null);
        tool.sourceReader = sourceReader;
        tool.changesReader = changesReader;
        tool.targetWriter = targetWriter;
        tool.errorMessages = errorMessages;
        try {
            ResultCode resultCode = tool.runTool("--suppressComments", "--lenientModifications");
            boolean bl = resultCode == ResultCode.SUCCESS;
            return bl;
        }
        finally {
            try {
                sourceReader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                changesReader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                targetWriter.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    public LDIFModify(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "ldifmodify";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return LDIFMessages.INFO_LDIFMODIFY_TOOL_DESCRIPTION.get();
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        return Arrays.asList(LDIFMessages.INFO_LDIFMODIFY_TOOL_DESCRIPTION_2.get(), LDIFMessages.INFO_LDIFMODIFY_TOOL_DESCRIPTION_3.get(), LDIFMessages.INFO_LDIFMODIFY_TOOL_DESCRIPTION_4.get(), LDIFMessages.INFO_LDIFMODIFY_TOOL_DESCRIPTION_5.get());
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "7.0.4";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsDebugLogging() {
        return true;
    }

    @Override
    @Nullable
    protected String getToolCompletionMessage() {
        return this.completionMessage.get();
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.sourceLDIF = new FileArgument(Character.valueOf('s'), "sourceLDIF", this.sourceReader == null, 1, null, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_SOURCE_LDIF.get(), true, true, true, false);
        this.sourceLDIF.addLongIdentifier("source-ldif", true);
        this.sourceLDIF.addLongIdentifier("sourceFile", true);
        this.sourceLDIF.addLongIdentifier("source-file", true);
        this.sourceLDIF.addLongIdentifier("source", true);
        this.sourceLDIF.addLongIdentifier("inputLDIF", true);
        this.sourceLDIF.addLongIdentifier("input-ldif", true);
        this.sourceLDIF.addLongIdentifier("inputFile", true);
        this.sourceLDIF.addLongIdentifier("input-file", true);
        this.sourceLDIF.addLongIdentifier("input", true);
        this.sourceLDIF.addLongIdentifier("ldifFile", true);
        this.sourceLDIF.addLongIdentifier("ldif-file", true);
        this.sourceLDIF.addLongIdentifier("ldif", true);
        this.sourceLDIF.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.sourceLDIF);
        String sourcePWDesc = PING_SERVER_AVAILABLE ? LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_SOURCE_PW_FILE_PING_SERVER.get() : LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_SOURCE_PW_FILE_STANDALONE.get();
        this.sourceEncryptionPassphraseFile = new FileArgument(null, "sourceEncryptionPassphraseFile", false, 1, null, sourcePWDesc, true, true, true, false);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("source-encryption-passphrase-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("sourcePassphraseFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("source-passphrase-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("sourceEncryptionPasswordFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("source-encryption-password-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("sourcePasswordFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("source-password-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("inputEncryptionPassphraseFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("input-encryption-passphrase-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("inputPassphraseFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("input-passphrase-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("inputEncryptionPasswordFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("input-encryption-password-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("inputPasswordFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("input-password-file", true);
        this.sourceEncryptionPassphraseFile.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.sourceEncryptionPassphraseFile);
        this.changesLDIF = new FileArgument(Character.valueOf('m'), "changesLDIF", this.changesReader == null, 1, null, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_CHANGES_LDIF.get(), true, true, true, false);
        this.changesLDIF.addLongIdentifier("changes-ldif", true);
        this.changesLDIF.addLongIdentifier("changesFile", true);
        this.changesLDIF.addLongIdentifier("changes-file", true);
        this.changesLDIF.addLongIdentifier("changes", true);
        this.changesLDIF.addLongIdentifier("updatesLDIF", true);
        this.changesLDIF.addLongIdentifier("updates-ldif", true);
        this.changesLDIF.addLongIdentifier("updatesFile", true);
        this.changesLDIF.addLongIdentifier("updates-file", true);
        this.changesLDIF.addLongIdentifier("updates", true);
        this.changesLDIF.addLongIdentifier("modificationsLDIF", true);
        this.changesLDIF.addLongIdentifier("modifications-ldif", true);
        this.changesLDIF.addLongIdentifier("modificationsFile", true);
        this.changesLDIF.addLongIdentifier("modifications-file", true);
        this.changesLDIF.addLongIdentifier("modifications", true);
        this.changesLDIF.addLongIdentifier("modsLDIF", true);
        this.changesLDIF.addLongIdentifier("mods-ldif", true);
        this.changesLDIF.addLongIdentifier("modsFile", true);
        this.changesLDIF.addLongIdentifier("mods-file", true);
        this.changesLDIF.addLongIdentifier("mods", true);
        this.changesLDIF.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.changesLDIF);
        String changesPWDesc = PING_SERVER_AVAILABLE ? LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_CHANGES_PW_FILE_PING_SERVER.get() : LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_CHANGES_PW_FILE_STANDALONE.get();
        this.changesEncryptionPassphraseFile = new FileArgument(null, "changesEncryptionPassphraseFile", false, 1, null, changesPWDesc, true, true, true, false);
        this.changesEncryptionPassphraseFile.addLongIdentifier("changes-encryption-passphrase-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("changesPassphraseFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("changes-passphrase-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("changesEncryptionPasswordFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("changes-encryption-password-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("changesPasswordFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("changes-password-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("updatesEncryptionPassphraseFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("updates-encryption-passphrase-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("updatesPassphraseFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("updates-passphrase-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("updatesEncryptionPasswordFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("updates-encryption-password-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("updatesPasswordFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("updates-password-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modificationsEncryptionPassphraseFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modifications-encryption-passphrase-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modificationsPassphraseFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modifications-passphrase-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modificationsEncryptionPasswordFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modifications-encryption-password-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modificationsPasswordFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modifications-password-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modsEncryptionPassphraseFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("mods-encryption-passphrase-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modsPassphraseFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("mods-passphrase-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modsEncryptionPasswordFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("mods-encryption-password-file", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("modsPasswordFile", true);
        this.changesEncryptionPassphraseFile.addLongIdentifier("mods-password-file", true);
        this.changesEncryptionPassphraseFile.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.changesEncryptionPassphraseFile);
        this.stripTrailingSpaces = new BooleanArgument(null, "stripTrailingSpaces", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_STRIP_TRAILING_SPACES.get());
        this.stripTrailingSpaces.addLongIdentifier("strip-trailing-spaces", true);
        this.stripTrailingSpaces.addLongIdentifier("ignoreTrailingSpaces", true);
        this.stripTrailingSpaces.addLongIdentifier("ignore-trailing-spaces", true);
        this.stripTrailingSpaces.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.stripTrailingSpaces);
        this.lenientModifications = new BooleanArgument(null, "lenientModifications", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_LENIENT_MODIFICATIONS.get());
        this.lenientModifications.addLongIdentifier("lenient-modifications", true);
        this.lenientModifications.addLongIdentifier("lenientModification", true);
        this.lenientModifications.addLongIdentifier("lenient-modification", true);
        this.lenientModifications.addLongIdentifier("lenientMods", true);
        this.lenientModifications.addLongIdentifier("lenient-mods", true);
        this.lenientModifications.addLongIdentifier("lenientMod", true);
        this.lenientModifications.addLongIdentifier("lenient-mod", true);
        this.lenientModifications.addLongIdentifier("lenient", true);
        this.lenientModifications.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        this.lenientModifications.setHidden(true);
        parser.addArgument(this.lenientModifications);
        this.strictModifications = new BooleanArgument(null, "strictModifications", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_STRICT_MODIFICATIONS.get());
        this.strictModifications.addLongIdentifier("strict-modifications", true);
        this.strictModifications.addLongIdentifier("strictModification", true);
        this.strictModifications.addLongIdentifier("strict-modification", true);
        this.strictModifications.addLongIdentifier("strictMods", true);
        this.strictModifications.addLongIdentifier("strict-mods", true);
        this.strictModifications.addLongIdentifier("strictMod", true);
        this.strictModifications.addLongIdentifier("strict-mod", true);
        this.strictModifications.addLongIdentifier("strict", true);
        this.strictModifications.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.strictModifications);
        this.ignoreDuplicateDeletes = new BooleanArgument(null, "ignoreDuplicateDeletes", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_IGNORE_DUPLICATE_DELETES.get());
        this.ignoreDuplicateDeletes.addLongIdentifier("ignore-duplicate-deletes", true);
        this.ignoreDuplicateDeletes.addLongIdentifier("ignoreRepeatedDeletes", true);
        this.ignoreDuplicateDeletes.addLongIdentifier("ignore-repeated-deletes", true);
        this.ignoreDuplicateDeletes.addLongIdentifier("ignoreRepeatDeletes", true);
        this.ignoreDuplicateDeletes.addLongIdentifier("ignore-repeat-deletes", true);
        this.ignoreDuplicateDeletes.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.ignoreDuplicateDeletes);
        this.ignoreDeletesOfNonexistentEntries = new BooleanArgument(null, "ignoreDeletesOfNonexistentEntries", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_IGNORE_NONEXISTENT_DELETES.get());
        this.ignoreDeletesOfNonexistentEntries.addLongIdentifier("ignore-deletes-of-nonexistent-entries", true);
        this.ignoreDeletesOfNonexistentEntries.addLongIdentifier("ignoreNonexistentDeletes", true);
        this.ignoreDeletesOfNonexistentEntries.addLongIdentifier("ignore-nonexistent-deletes", true);
        this.ignoreDeletesOfNonexistentEntries.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.ignoreDeletesOfNonexistentEntries);
        this.ignoreModifiesOfNonexistentEntries = new BooleanArgument(null, "ignoreModifiesOfNonexistentEntries", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_IGNORE_NONEXISTENT_MODIFIES.get());
        this.ignoreModifiesOfNonexistentEntries.addLongIdentifier("ignore-modifies-of-nonexistent-entries", true);
        this.ignoreModifiesOfNonexistentEntries.addLongIdentifier("ignoreNonexistentModifies", true);
        this.ignoreModifiesOfNonexistentEntries.addLongIdentifier("ignore-nonexistent-modifies", true);
        this.ignoreModifiesOfNonexistentEntries.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_INPUT.get());
        parser.addArgument(this.ignoreModifiesOfNonexistentEntries);
        this.targetLDIF = new FileArgument(Character.valueOf('t'), "targetLDIF", this.targetWriter == null, 1, null, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_TARGET_LDIF.get(), false, true, true, false);
        this.targetLDIF.addLongIdentifier("target-ldif", true);
        this.targetLDIF.addLongIdentifier("targetFile", true);
        this.targetLDIF.addLongIdentifier("target-file", true);
        this.targetLDIF.addLongIdentifier("target", true);
        this.targetLDIF.addLongIdentifier("outputLDIF", true);
        this.targetLDIF.addLongIdentifier("output-ldif", true);
        this.targetLDIF.addLongIdentifier("outputFile", true);
        this.targetLDIF.addLongIdentifier("output-file", true);
        this.targetLDIF.addLongIdentifier("output", true);
        this.targetLDIF.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.targetLDIF);
        this.compressTarget = new BooleanArgument(null, "compressTarget", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_COMPRESS_TARGET.get());
        this.compressTarget.addLongIdentifier("compress-target", true);
        this.compressTarget.addLongIdentifier("compressOutput", true);
        this.compressTarget.addLongIdentifier("compress-output", true);
        this.compressTarget.addLongIdentifier("compress", true);
        this.compressTarget.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.compressTarget);
        this.encryptTarget = new BooleanArgument(null, "encryptTarget", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_ENCRYPT_TARGET.get());
        this.encryptTarget.addLongIdentifier("encrypt-target", true);
        this.encryptTarget.addLongIdentifier("encryptOutput", true);
        this.encryptTarget.addLongIdentifier("encrypt-output", true);
        this.encryptTarget.addLongIdentifier("encrypt", true);
        this.encryptTarget.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.encryptTarget);
        this.targetEncryptionPassphraseFile = new FileArgument(null, "targetEncryptionPassphraseFile", false, 1, null, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_TARGET_PW_FILE.get(), true, true, true, false);
        this.targetEncryptionPassphraseFile.addLongIdentifier("target-encryption-passphrase-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("targetPassphraseFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("target-passphrase-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("targetEncryptionPasswordFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("target-encryption-password-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("targetPasswordFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("target-password-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("outputEncryptionPassphraseFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("output-encryption-passphrase-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("outputPassphraseFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("output-passphrase-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("outputEncryptionPasswordFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("output-encryption-password-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("outputPasswordFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("output-password-file", true);
        this.targetEncryptionPassphraseFile.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.targetEncryptionPassphraseFile);
        this.wrapColumn = new IntegerArgument(null, "wrapColumn", false, 1, null, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_WRAP_COLUMN.get(), 5, Integer.MAX_VALUE);
        this.wrapColumn.addLongIdentifier("wrap-column", true);
        this.wrapColumn.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.wrapColumn);
        this.doNotWrap = new BooleanArgument(Character.valueOf('T'), "doNotWrap", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_DO_NOT_WRAP.get());
        this.doNotWrap.addLongIdentifier("do-not-wrap", true);
        this.doNotWrap.addLongIdentifier("dontWrap", true);
        this.doNotWrap.addLongIdentifier("dont-wrap", true);
        this.doNotWrap.addLongIdentifier("noWrap", true);
        this.doNotWrap.addLongIdentifier("no-wrap", true);
        this.doNotWrap.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.doNotWrap);
        this.suppressComments = new BooleanArgument(null, "suppressComments", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_SUPPRESS_COMMENTS.get());
        this.suppressComments.addLongIdentifier("suppress-comments", true);
        this.suppressComments.addLongIdentifier("excludeComments", true);
        this.suppressComments.addLongIdentifier("exclude-comments", true);
        this.suppressComments.addLongIdentifier("noComments", true);
        this.suppressComments.addLongIdentifier("no-comments", true);
        this.suppressComments.setArgumentGroupName(LDIFMessages.INFO_LDIFMODIFY_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.suppressComments);
        this.noSchemaCheck = new BooleanArgument(null, "noSchemaCheck", 1, LDIFMessages.INFO_LDIFMODIFY_ARG_DESC_NO_SCHEMA_CHECK.get());
        this.noSchemaCheck.addLongIdentifier("no-schema-check", true);
        this.noSchemaCheck.setHidden(true);
        parser.addArgument(this.noSchemaCheck);
        parser.addExclusiveArgumentSet(this.lenientModifications, this.strictModifications, new Argument[0]);
        parser.addExclusiveArgumentSet(this.wrapColumn, this.doNotWrap, new Argument[0]);
        parser.addDependentArgumentSet(this.targetEncryptionPassphraseFile, this.encryptTarget, new Argument[0]);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        File sourceLDIFFile = this.sourceLDIF.getValue();
        File changesLDIFFile = this.changesLDIF.getValue();
        File targetLDIFFile = this.targetLDIF.getValue();
        if (sourceLDIFFile != null) {
            if (sourceLDIFFile.equals(changesLDIFFile)) {
                throw new ArgumentException(LDIFMessages.ERR_LDIFMODIFY_ARGS_CANNOT_REFER_TO_SAME_FILE.get(this.sourceLDIF.getIdentifierString(), this.changesLDIF.getIdentifierString()));
            }
            if (sourceLDIFFile.equals(targetLDIFFile)) {
                throw new ArgumentException(LDIFMessages.ERR_LDIFMODIFY_ARGS_CANNOT_REFER_TO_SAME_FILE.get(this.sourceLDIF.getIdentifierString(), this.targetLDIF.getIdentifierString()));
            }
        }
        if (changesLDIFFile != null && changesLDIFFile.equals(targetLDIFFile)) {
            throw new ArgumentException(LDIFMessages.ERR_LDIFMODIFY_ARGS_CANNOT_REFER_TO_SAME_FILE.get(this.changesLDIF.getIdentifierString(), this.targetLDIF.getIdentifierString()));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 52[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void readChangeRecords(@NotNull Map<DN, List<LDIFChangeRecord>> addAndSubsequentChangeRecords, @NotNull Map<DN, Boolean> deletedEntryDNs, @NotNull Map<DN, List<LDIFModifyChangeRecord>> modifyChangeRecords, @NotNull Map<DN, ObjectPair<DN, List<LDIFChangeRecord>>> modifyDNAndSubsequentChangeRecords, @NotNull AtomicReference<ResultCode> resultCode) throws LDAPException {
        LDIFException firstRecoverableException = null;
        try (LDIFReader ldifReader = this.getLDIFReader(this.changesReader, this.changesLDIF.getValue(), this.changesEncryptionPassphraseFile.getValue());){
            while (true) {
                DN parsedNewDN;
                LDIFChangeRecord changeRecord;
                DN parsedDN;
                block55: {
                    LDIFRecord ldifRecord;
                    try {
                        ldifRecord = ldifReader.readLDIFRecord();
                    }
                    catch (LDIFException e) {
                        Debug.debugException(e);
                        if (e.mayContinueReading()) {
                            if (firstRecoverableException == null) {
                                firstRecoverableException = e;
                            }
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_CANNOT_READ_RECORD_CAN_CONTINUE.get(this.changesLDIF.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                            resultCode.compareAndSet(null, ResultCode.DECODING_ERROR);
                            continue;
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDIFMessages.ERR_LDIFMODIFY_CANNOT_READ_RECORD_CANNOT_CONTINUE.get(this.changesLDIF.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                    }
                    if (ldifRecord == null) {
                        break;
                    }
                    try {
                        parsedDN = ldifRecord.getParsedDN();
                    }
                    catch (LDAPException e) {
                        Debug.debugException(e);
                        this.err(new Object[0]);
                        this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_CANNOT_PARSE_CHANGE_RECORD_DN.get(String.valueOf(ldifRecord), this.changesLDIF.getValue().getAbsolutePath(), e.getMessage()));
                        resultCode.compareAndSet(null, e.getResultCode());
                        continue;
                    }
                    changeRecord = ldifRecord instanceof Entry ? new LDIFAddChangeRecord((Entry)ldifRecord) : (LDIFChangeRecord)ldifRecord;
                    if (changeRecord.getChangeType() == ChangeType.MODIFY_DN) {
                        try {
                            parsedNewDN = ((LDIFModifyDNChangeRecord)changeRecord).getNewDN();
                            break block55;
                        }
                        catch (LDAPException e) {
                            Debug.debugException(e);
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_CANNOT_PARSE_NEW_DN.get(String.valueOf(changeRecord), this.changesLDIF.getValue().getAbsolutePath(), e.getMessage()));
                            resultCode.compareAndSet(null, e.getResultCode());
                            continue;
                        }
                    }
                    parsedNewDN = parsedDN;
                }
                block8 : switch (changeRecord.getChangeType()) {
                    case ADD: {
                        Object newDN;
                        if (addAndSubsequentChangeRecords.containsKey(parsedDN)) {
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MULTIPLE_ADDS_FOR_DN.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.ENTRY_ALREADY_EXISTS);
                            break;
                        }
                        if (modifyChangeRecords.containsKey(parsedDN)) {
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_ADD_TARGETS_MODIFIED_ENTRY.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.ENTRY_ALREADY_EXISTS);
                            break;
                        }
                        for (Map.Entry<DN, ObjectPair<DN, List<LDIFChangeRecord>>> e : modifyDNAndSubsequentChangeRecords.entrySet()) {
                            newDN = e.getValue().getFirst();
                            if (!parsedDN.isAncestorOf((DN)newDN, true)) continue;
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_ADD_CONFLICTS_WITH_MOD_DN.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString(), e.getKey().toString(), ((DN)newDN).toString()));
                            resultCode.compareAndSet(null, ResultCode.ENTRY_ALREADY_EXISTS);
                            break block8;
                        }
                        ArrayList<LDIFChangeRecord> addList = new ArrayList<LDIFChangeRecord>();
                        addList.add(changeRecord);
                        addAndSubsequentChangeRecords.put(parsedDN, addList);
                        break;
                    }
                    case DELETE: {
                        if (addAndSubsequentChangeRecords.containsKey(parsedDN)) {
                            addAndSubsequentChangeRecords.remove(parsedDN);
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.WARN_LDIFMODIFY_DELETE_OF_PREVIOUS_ADD.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                            break;
                        }
                        if (modifyDNAndSubsequentChangeRecords.containsKey(parsedDN)) {
                            DN newDN = modifyDNAndSubsequentChangeRecords.get(parsedDN).getFirst();
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_DELETE_OF_PREVIOUS_RENAME.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString(), newDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.NO_SUCH_OBJECT);
                            break;
                        }
                        Iterator<Map.Entry<DN, ObjectPair<DN, List<LDIFChangeRecord>>>> deleteModDNIterator = modifyDNAndSubsequentChangeRecords.entrySet().iterator();
                        while (deleteModDNIterator.hasNext()) {
                            Map.Entry<DN, ObjectPair<DN, List<LDIFChangeRecord>>> e = deleteModDNIterator.next();
                            DN dN = e.getValue().getFirst();
                            if (!parsedDN.isAncestorOf(dN, true)) continue;
                            DN originalDN = e.getKey();
                            deleteModDNIterator.remove();
                            deletedEntryDNs.put(originalDN, Boolean.FALSE);
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.WARN_LDIFMODIFY_DELETE_OF_PREVIOUSLY_RENAMED.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString(), originalDN.toString(), dN.toString()));
                            break block8;
                        }
                        if (deletedEntryDNs.containsKey(parsedDN)) {
                            if (this.ignoreDuplicateDeletes.isPresent()) break;
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MULTIPLE_DELETES_FOR_DN.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.NO_SUCH_OBJECT);
                            break;
                        }
                        if (modifyChangeRecords.containsKey(parsedDN)) {
                            modifyChangeRecords.remove(parsedDN);
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.WARN_LDIFMODIFY_DELETE_OF_PREVIOUSLY_MODIFIED.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                        }
                        deletedEntryDNs.put(parsedDN, Boolean.FALSE);
                        break;
                    }
                    case MODIFY: {
                        Object newDN;
                        if (addAndSubsequentChangeRecords.containsKey(parsedDN)) {
                            addAndSubsequentChangeRecords.get(parsedDN).add(changeRecord);
                            break;
                        }
                        if (modifyDNAndSubsequentChangeRecords.containsKey(parsedDN)) {
                            newDN = modifyDNAndSubsequentChangeRecords.get(parsedDN).getFirst();
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MODIFY_OF_RENAMED_ENTRY.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString(), ((DN)newDN).toString()));
                            resultCode.compareAndSet(null, ResultCode.NO_SUCH_OBJECT);
                            break;
                        }
                        for (Map.Entry entry : modifyDNAndSubsequentChangeRecords.entrySet()) {
                            if (!parsedDN.equals(((ObjectPair)entry.getValue()).getFirst())) continue;
                            ((List)((ObjectPair)entry.getValue()).getSecond()).add(changeRecord);
                            break block8;
                        }
                        if (deletedEntryDNs.containsKey(parsedDN)) {
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MODIFY_OF_DELETED_ENTRY.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.NO_SUCH_OBJECT);
                            break;
                        }
                        if (modifyChangeRecords.containsKey(parsedDN)) {
                            modifyChangeRecords.get(parsedDN).add((LDIFModifyChangeRecord)changeRecord);
                            break;
                        }
                        ArrayList<LDIFModifyChangeRecord> modList = new ArrayList<LDIFModifyChangeRecord>();
                        modList.add((LDIFModifyChangeRecord)changeRecord);
                        modifyChangeRecords.put(parsedDN, modList);
                        break;
                    }
                    case MODIFY_DN: {
                        DN newDN;
                        if (addAndSubsequentChangeRecords.containsKey(parsedDN)) {
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MOD_DN_OF_ADDED_ENTRY.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.UNWILLING_TO_PERFORM);
                            break;
                        }
                        for (DN addedDN : addAndSubsequentChangeRecords.keySet()) {
                            if (!addedDN.isDescendantOf(parsedNewDN, true)) continue;
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MOD_DN_NEW_DN_CONFLICTS_WITH_ADD.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString(), parsedNewDN.toString(), addedDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.ENTRY_ALREADY_EXISTS);
                            break block8;
                        }
                        if (modifyDNAndSubsequentChangeRecords.containsKey(parsedDN)) {
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MULTIPLE_MOD_DN_WITH_DN.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.NO_SUCH_OBJECT);
                            break;
                        }
                        for (Map.Entry<DN, ObjectPair<DN, List<LDIFChangeRecord>>> e : modifyDNAndSubsequentChangeRecords.entrySet()) {
                            newDN = e.getValue().getFirst();
                            if (!newDN.isDescendantOf(parsedDN, true)) continue;
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_UNWILLING_TO_MODIFY_DN_MULTIPLE_TIMES.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString(), parsedNewDN.toString(), e.getKey().toString()));
                            resultCode.compareAndSet(null, ResultCode.UNWILLING_TO_PERFORM);
                            break block8;
                        }
                        for (Map.Entry<DN, ObjectPair<DN, List<LDIFChangeRecord>>> e : modifyDNAndSubsequentChangeRecords.entrySet()) {
                            newDN = e.getValue().getFirst();
                            if (!newDN.isDescendantOf(parsedNewDN, true)) continue;
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MOD_DN_CONFLICTS_WITH_MOD_DN.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString(), parsedNewDN.toString(), e.getKey().toString(), newDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.ENTRY_ALREADY_EXISTS);
                            break block8;
                        }
                        if (deletedEntryDNs.containsKey(parsedDN)) {
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MOD_DN_OF_DELETED_ENTRY.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString()));
                            resultCode.compareAndSet(null, ResultCode.NO_SUCH_OBJECT);
                            break;
                        }
                        for (DN dn : modifyChangeRecords.keySet()) {
                            if (!dn.isDescendantOf(parsedNewDN, true)) continue;
                            this.err(new Object[0]);
                            this.wrapErr(LDIFMessages.ERR_LDIFMODIFY_MOD_DN_NEW_DN_CONFLICTS_WITH_MOD.get(this.changesLDIF.getValue().getAbsolutePath(), parsedDN.toString(), parsedNewDN.toString(), dn.toString()));
                            resultCode.compareAndSet(null, ResultCode.ENTRY_ALREADY_EXISTS);
                            break block8;
                        }
                        ArrayList<LDIFChangeRecord> arrayList = new ArrayList<LDIFChangeRecord>();
                        arrayList.add(changeRecord);
                        modifyDNAndSubsequentChangeRecords.put(parsedDN, new ObjectPair(parsedNewDN, arrayList));
                    }
                }
            }
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(e.getResultCode(), LDIFMessages.ERR_LDIFMODIFY_ERROR_OPENING_CHANGES_FILE.get(this.changesLDIF.getValue().getAbsolutePath(), e.getMessage()), e);
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFMODIFY_ERROR_READING_CHANGES_FILE.get(this.changesLDIF.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        if (addAndSubsequentChangeRecords.isEmpty() && deletedEntryDNs.isEmpty() && modifyChangeRecords.isEmpty() && modifyDNAndSubsequentChangeRecords.isEmpty()) {
            if (firstRecoverableException == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, LDIFMessages.ERR_LDIFMODIFY_NO_CHANGES.get(this.changesLDIF.getValue().getAbsolutePath()));
            }
            throw new LDAPException(ResultCode.PARAM_ERROR, LDIFMessages.ERR_LDIFMODIFY_NO_CHANGES_WITH_ERROR.get(this.changesLDIF.getValue().getAbsolutePath()), firstRecoverableException);
        }
    }

    @NotNull
    private LDIFReader getLDIFReader(@Nullable LDIFReader existingReader, @Nullable File ldifFile, @Nullable File passphraseFile) throws LDAPException {
        if (existingReader != null) {
            return existingReader;
        }
        if (passphraseFile != null) {
            this.readPassphraseFile(passphraseFile);
        }
        boolean closeStream = true;
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(ldifFile);
            ObjectPair<InputStream, char[]> p = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, this.inputEncryptionPassphrases, passphraseFile != null, (CharSequence)LDIFMessages.INFO_LDIFMODIFY_ENTER_INPUT_ENCRYPTION_PW.get(ldifFile.getName()), (CharSequence)LDIFMessages.ERR_LDIFMODIFY_WRONG_ENCRYPTION_PW.get(), this.getOut(), this.getErr());
            inputStream = p.getFirst();
            this.addPassphrase(p.getSecond());
            inputStream = ToolUtils.getPossiblyGZIPCompressedInputStream(inputStream);
            LDIFReader ldifReader = new LDIFReader(inputStream);
            if (this.stripTrailingSpaces.isPresent()) {
                ldifReader.setTrailingSpaceBehavior(TrailingSpaceBehavior.STRIP);
            } else {
                ldifReader.setTrailingSpaceBehavior(TrailingSpaceBehavior.REJECT);
            }
            ldifReader.setSchema(Schema.getDefaultStandardSchema());
            closeStream = false;
            LDIFReader lDIFReader = ldifReader;
            return lDIFReader;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFMODIFY_ERROR_OPENING_INPUT_FILE.get(ldifFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        finally {
            if (inputStream != null && closeStream) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    private void readPassphraseFile(@NotNull File f) throws LDAPException {
        try {
            this.addPassphrase(this.getPasswordFileReader().readPassword(f));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFMODIFY_CANNOT_READ_PW_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private void addPassphrase(@Nullable char[] passphrase) {
        if (passphrase == null) {
            return;
        }
        for (char[] existingPassphrase : this.inputEncryptionPassphrases) {
            if (!Arrays.equals(existingPassphrase, passphrase)) continue;
            return;
        }
        this.inputEncryptionPassphrases.add(passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private LDIFWriter getLDIFWriter(@Nullable LDIFWriter existingWriter) throws LDAPException {
        if (existingWriter != null) {
            return existingWriter;
        }
        File outputFile = this.targetLDIF.getValue();
        File passphraseFile = this.targetEncryptionPassphraseFile.getValue();
        OutputStream outputStream = null;
        boolean closeOutputStream = true;
        try {
            try {
                outputStream = new FileOutputStream(this.targetLDIF.getValue());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFMODIFY_CANNOT_OPEN_OUTPUT_FILE.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            if (this.encryptTarget.isPresent()) {
                try {
                    char[] passphrase = passphraseFile != null ? this.getPasswordFileReader().readPassword(passphraseFile) : ToolUtils.promptForEncryptionPassphrase(false, true, LDIFMessages.INFO_LDIFMODIFY_ENTER_OUTPUT_ENCRYPTION_PW.get(), LDIFMessages.INFO_LDIFMODIFY_CONFIRM_OUTPUT_ENCRYPTION_PW.get(), this.getOut(), this.getErr()).toCharArray();
                    outputStream = new PassphraseEncryptedOutputStream(passphrase, outputStream, null, true, true);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFMODIFY_CANNOT_ENCRYPT_OUTPUT_FILE.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.compressTarget.isPresent()) {
                try {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIFMODIFY_CANNOT_COMPRESS_OUTPUT_FILE.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
            }
            LDIFWriter ldifWriter = new LDIFWriter(outputStream);
            if (this.doNotWrap.isPresent()) {
                ldifWriter.setWrapColumn(0);
            } else if (this.wrapColumn.isPresent()) {
                ldifWriter.setWrapColumn(this.wrapColumn.getValue());
            } else {
                ldifWriter.setWrapColumn(WRAP_COLUMN);
            }
            closeOutputStream = false;
            LDIFWriter lDIFWriter = ldifWriter;
            return lDIFWriter;
        }
        finally {
            if (closeOutputStream && outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    @Nullable
    private Entry updateEntry(@NotNull Entry entry, @NotNull Map<DN, List<LDIFChangeRecord>> addAndSubsequentChangeRecords, @NotNull Map<DN, Boolean> deletedEntryDNs, @NotNull Map<DN, List<LDIFModifyChangeRecord>> modifyChangeRecords, @NotNull Map<DN, ObjectPair<DN, List<LDIFChangeRecord>>> modifyDNAndSubsequentChangeRecords, @NotNull StringBuilder comment, @NotNull AtomicReference<ResultCode> resultCode, @NotNull AtomicLong entriesUpdated) {
        List<LDIFChangeRecord> list;
        ObjectPair<DN, List<LDIFChangeRecord>> modDNRecords;
        DN entryDN;
        try {
            entryDN = entry.getParsedDN();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            resultCode.compareAndSet(null, e.getResultCode());
            this.appendComment(comment, LDIFMessages.ERR_LDIFMODIFY_CANNOT_PARSE_ENTRY_DN.get(e.getMessage()), true);
            return entry;
        }
        if (deletedEntryDNs.containsKey(entryDN)) {
            deletedEntryDNs.put(entryDN, Boolean.TRUE);
            this.createChangeRecordComment(comment, LDIFMessages.INFO_LDIFMODIFY_APPLIED_DELETE.get(), entry, false);
            entriesUpdated.incrementAndGet();
            return null;
        }
        for (DN parentDN = entryDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
            if (!deletedEntryDNs.containsKey(parentDN)) continue;
            this.createChangeRecordComment(comment, LDIFMessages.INFO_LDIFMODIFY_APPLIED_DELETE_OF_ANCESTOR.get(parentDN.toString()), entry, false);
            entriesUpdated.incrementAndGet();
            return null;
        }
        Entry updatedEntry = entry;
        AtomicBoolean isUpdated = new AtomicBoolean(false);
        ArrayList errors = new ArrayList();
        List<LDIFModifyChangeRecord> modRecords = modifyChangeRecords.remove(entryDN);
        if (modRecords != null) {
            for (LDIFModifyChangeRecord lDIFModifyChangeRecord : modRecords) {
                updatedEntry = this.applyModification(updatedEntry, lDIFModifyChangeRecord, isUpdated, resultCode, comment);
            }
        }
        if ((modDNRecords = modifyDNAndSubsequentChangeRecords.remove(entryDN)) != null) {
            for (LDIFChangeRecord r : modDNRecords.getSecond()) {
                if (r instanceof LDIFModifyDNChangeRecord) {
                    LDIFModifyDNChangeRecord modDNChangeRecord = (LDIFModifyDNChangeRecord)r;
                    updatedEntry = this.applyModifyDN(updatedEntry, entryDN, modDNRecords.getFirst(), modDNChangeRecord.deleteOldRDN());
                    this.createChangeRecordComment(comment, LDIFMessages.INFO_LDIFMODIFY_APPLIED_MODIFY_DN.get(), r, false);
                    isUpdated.set(true);
                    continue;
                }
                updatedEntry = this.applyModification(updatedEntry, (LDIFModifyChangeRecord)r, isUpdated, resultCode, comment);
            }
        }
        if ((list = addAndSubsequentChangeRecords.remove(entryDN)) != null) {
            for (LDIFChangeRecord r : list) {
                if (r instanceof LDIFAddChangeRecord) {
                    resultCode.compareAndSet(null, ResultCode.ENTRY_ALREADY_EXISTS);
                    this.createChangeRecordComment(comment, LDIFMessages.ERR_LDIFMODIFY_NOT_ADDING_EXISTING_ENTRY.get(), r, true);
                    continue;
                }
                updatedEntry = this.applyModification(updatedEntry, (LDIFModifyChangeRecord)r, isUpdated, resultCode, comment);
            }
        }
        if (isUpdated.get()) {
            entriesUpdated.incrementAndGet();
        } else {
            if (comment.length() > 0) {
                this.appendComment(comment, StaticUtils.EOL, false);
                this.appendComment(comment, StaticUtils.EOL, false);
            }
            this.appendComment(comment, LDIFMessages.INFO_LDIFMODIFY_ENTRY_NOT_UPDATED.get(), false);
        }
        return updatedEntry;
    }

    @NotNull
    private Entry applyModification(@NotNull Entry entry, @NotNull LDIFModifyChangeRecord modifyChangeRecord, @NotNull AtomicBoolean isUpdated, @NotNull AtomicReference<ResultCode> resultCode, @NotNull StringBuilder comment) {
        try {
            Entry updatedEntry = Entry.applyModifications(entry, !this.strictModifications.isPresent(), modifyChangeRecord.getModifications());
            this.createChangeRecordComment(comment, LDIFMessages.INFO_LDIFMODIFY_APPLIED_MODIFY.get(), modifyChangeRecord, false);
            isUpdated.set(true);
            return updatedEntry;
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            resultCode.compareAndSet(null, e.getResultCode());
            this.createChangeRecordComment(comment, LDIFMessages.ERR_LDIFMODIFY_ERROR_APPLYING_MODIFY.get(String.valueOf(e.getResultCode()), e.getMessage()), modifyChangeRecord, true);
            return entry;
        }
    }

    @NotNull
    private Entry applyModifyDN(@NotNull Entry entry, @NotNull DN originalDN, @NotNull DN newDN, boolean deleteOldRDN) {
        RDN newRDN;
        Entry copy = entry.duplicate();
        copy.setDN(newDN);
        RDN oldRDN = originalDN.getRDN();
        if (deleteOldRDN && oldRDN != null) {
            for (Attribute a : oldRDN.getAttributes()) {
                for (byte[] value : a.getValueByteArrays()) {
                    copy.removeAttributeValue(a.getName(), value);
                }
            }
        }
        if ((newRDN = newDN.getRDN()) != null) {
            for (Attribute a : newRDN.getAttributes()) {
                for (byte[] value : a.getValueByteArrays()) {
                    copy.addAttribute(a);
                }
            }
        }
        return copy;
    }

    private void writeLDIFRecord(@NotNull LDIFWriter ldifWriter, @NotNull LDIFRecord ldifRecord, @Nullable CharSequence comment) throws IOException {
        if (this.suppressComments.isPresent() || comment == null || comment.length() == 0) {
            ldifWriter.writeLDIFRecord(ldifRecord);
        } else {
            ldifWriter.writeLDIFRecord(ldifRecord, comment.toString());
        }
    }

    private void appendComment(@NotNull StringBuilder buffer, @NotNull String comment, boolean isError) {
        buffer.append(comment);
        if (isError && this.errorMessages != null) {
            this.errorMessages.add(comment);
        }
    }

    private void writeLDIFComment(@NotNull LDIFWriter ldifWriter, @Nullable CharSequence comment, boolean isError) throws IOException {
        if (!this.suppressComments.isPresent() && comment != null && comment.length() != 0) {
            ldifWriter.writeComment(comment.toString(), false, true);
        }
        if (isError && this.errorMessages != null && comment != null) {
            this.errorMessages.add(comment.toString());
        }
    }

    private void createChangeRecordComment(@NotNull StringBuilder buffer, @NotNull String message, @NotNull LDIFRecord record, boolean isError) {
        int initialLength = buffer.length();
        if (initialLength > 0) {
            buffer.append(StaticUtils.EOL);
            buffer.append(StaticUtils.EOL);
        }
        buffer.append(message);
        buffer.append(StaticUtils.EOL);
        int wrapCol = this.wrapColumn.isPresent() && this.wrapColumn.getValue() > 20 && this.wrapColumn.getValue() <= 85 ? this.wrapColumn.getValue() - 10 : 75;
        for (String line : record.toLDIF(wrapCol)) {
            buffer.append("     ");
            buffer.append(line);
            buffer.append(StaticUtils.EOL);
        }
        if (isError && this.errorMessages != null) {
            if (initialLength == 0) {
                this.errorMessages.add(buffer.toString());
            } else {
                this.errorMessages.add(buffer.toString().substring(initialLength));
            }
        }
    }

    private void wrapErr(@NotNull String message) {
        this.wrapErr(0, WRAP_COLUMN, message);
        if (this.errorMessages != null) {
            this.errorMessages.add(message);
        }
    }

    private void logCompletionMessage(boolean isError, @NotNull String message) {
        this.completionMessage.compareAndSet(null, message);
        if (isError) {
            this.wrapErr(message);
        } else {
            this.wrapOut(0, WRAP_COLUMN, message);
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--sourceLDIF", "original.ldif", "--changesLDIF", "changes.ldif", "--targetLDIF", "updated.ldif"}, LDIFMessages.INFO_LDIFMODIFY_EXAMPLE.get("changes.ldif", "original.ldif", "updated.ldif"));
        return examples;
    }
}

