/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.fineTune;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FineTune
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FineTune.class);
    @JsonProperty(value="training_file")
    @NonNull
    private String trainingFile;
    @JsonProperty(value="validation_file")
    private String validationFile;
    private String model;
    @JsonProperty(value="n_epochs")
    private Integer n_epochs;
    @JsonProperty(value="batch_size")
    private Integer batchSize;
    @JsonProperty(value="learning_rate_multiplier")
    private Double learningRateMultiplier;
    @JsonProperty(value="prompt_loss_weight")
    private Double promptLossWeight;
    @JsonProperty(value="compute_classification_metrics")
    private boolean computeClassificationMetrics;
    @JsonProperty(value="classification_n_classes")
    private Integer classificationNClasses;
    @JsonProperty(value="classification_betas")
    private List classificationBetas;
    private String suffix;

    public void setTrainingFile(String trainingFile) {
        this.trainingFile = trainingFile;
    }

    public void setValidationFile(String validationFile) {
        this.validationFile = validationFile;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setN_epochs(Integer n_epochs) {
        this.n_epochs = n_epochs;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setLearningRateMultiplier(Double learningRateMultiplier) {
        this.learningRateMultiplier = learningRateMultiplier;
    }

    public void setPromptLossWeight(Double promptLossWeight) {
        this.promptLossWeight = promptLossWeight;
    }

    public void setComputeClassificationMetrics(boolean computeClassificationMetrics) {
        this.computeClassificationMetrics = computeClassificationMetrics;
    }

    public void setClassificationNClasses(Integer classificationNClasses) {
        this.classificationNClasses = classificationNClasses;
    }

    public void setClassificationBetas(List classificationBetas) {
        this.classificationBetas = classificationBetas;
    }

    public void setSuffix(String suffix) {
        if (Objects.nonNull(suffix) && !"".equals(suffix) && suffix.length() > 40) {
            log.error("\u540e\u7f00\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e40");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        this.suffix = suffix;
    }

    private static Integer $default$n_epochs() {
        return 4;
    }

    private static Double $default$promptLossWeight() {
        return 0.01;
    }

    private static boolean $default$computeClassificationMetrics() {
        return false;
    }

    public static FineTuneBuilder builder() {
        return new FineTuneBuilder();
    }

    @NonNull
    public String getTrainingFile() {
        return this.trainingFile;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getN_epochs() {
        return this.n_epochs;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Double getLearningRateMultiplier() {
        return this.learningRateMultiplier;
    }

    public Double getPromptLossWeight() {
        return this.promptLossWeight;
    }

    public boolean isComputeClassificationMetrics() {
        return this.computeClassificationMetrics;
    }

    public Integer getClassificationNClasses() {
        return this.classificationNClasses;
    }

    public List getClassificationBetas() {
        return this.classificationBetas;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public FineTune() {
        this.n_epochs = FineTune.$default$n_epochs();
        this.promptLossWeight = FineTune.$default$promptLossWeight();
        this.computeClassificationMetrics = FineTune.$default$computeClassificationMetrics();
    }

    public FineTune(@NonNull String trainingFile, String validationFile, String model, Integer n_epochs, Integer batchSize, Double learningRateMultiplier, Double promptLossWeight, boolean computeClassificationMetrics, Integer classificationNClasses, List classificationBetas, String suffix) {
        if (trainingFile == null) {
            throw new NullPointerException("trainingFile is marked non-null but is null");
        }
        this.trainingFile = trainingFile;
        this.validationFile = validationFile;
        this.model = model;
        this.n_epochs = n_epochs;
        this.batchSize = batchSize;
        this.learningRateMultiplier = learningRateMultiplier;
        this.promptLossWeight = promptLossWeight;
        this.computeClassificationMetrics = computeClassificationMetrics;
        this.classificationNClasses = classificationNClasses;
        this.classificationBetas = classificationBetas;
        this.suffix = suffix;
    }

    public static class FineTuneBuilder {
        private String trainingFile;
        private String validationFile;
        private String model;
        private boolean n_epochs$set;
        private Integer n_epochs$value;
        private Integer batchSize;
        private Double learningRateMultiplier;
        private boolean promptLossWeight$set;
        private Double promptLossWeight$value;
        private boolean computeClassificationMetrics$set;
        private boolean computeClassificationMetrics$value;
        private Integer classificationNClasses;
        private List classificationBetas;
        private String suffix;

        FineTuneBuilder() {
        }

        @JsonProperty(value="training_file")
        public FineTuneBuilder trainingFile(@NonNull String trainingFile) {
            if (trainingFile == null) {
                throw new NullPointerException("trainingFile is marked non-null but is null");
            }
            this.trainingFile = trainingFile;
            return this;
        }

        @JsonProperty(value="validation_file")
        public FineTuneBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        public FineTuneBuilder model(String model) {
            this.model = model;
            return this;
        }

        @JsonProperty(value="n_epochs")
        public FineTuneBuilder n_epochs(Integer n_epochs) {
            this.n_epochs$value = n_epochs;
            this.n_epochs$set = true;
            return this;
        }

        @JsonProperty(value="batch_size")
        public FineTuneBuilder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @JsonProperty(value="learning_rate_multiplier")
        public FineTuneBuilder learningRateMultiplier(Double learningRateMultiplier) {
            this.learningRateMultiplier = learningRateMultiplier;
            return this;
        }

        @JsonProperty(value="prompt_loss_weight")
        public FineTuneBuilder promptLossWeight(Double promptLossWeight) {
            this.promptLossWeight$value = promptLossWeight;
            this.promptLossWeight$set = true;
            return this;
        }

        @JsonProperty(value="compute_classification_metrics")
        public FineTuneBuilder computeClassificationMetrics(boolean computeClassificationMetrics) {
            this.computeClassificationMetrics$value = computeClassificationMetrics;
            this.computeClassificationMetrics$set = true;
            return this;
        }

        @JsonProperty(value="classification_n_classes")
        public FineTuneBuilder classificationNClasses(Integer classificationNClasses) {
            this.classificationNClasses = classificationNClasses;
            return this;
        }

        @JsonProperty(value="classification_betas")
        public FineTuneBuilder classificationBetas(List classificationBetas) {
            this.classificationBetas = classificationBetas;
            return this;
        }

        public FineTuneBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public FineTune build() {
            Integer n_epochs$value = this.n_epochs$value;
            if (!this.n_epochs$set) {
                n_epochs$value = FineTune.$default$n_epochs();
            }
            Double promptLossWeight$value = this.promptLossWeight$value;
            if (!this.promptLossWeight$set) {
                promptLossWeight$value = FineTune.$default$promptLossWeight();
            }
            boolean computeClassificationMetrics$value = this.computeClassificationMetrics$value;
            if (!this.computeClassificationMetrics$set) {
                computeClassificationMetrics$value = FineTune.$default$computeClassificationMetrics();
            }
            return new FineTune(this.trainingFile, this.validationFile, this.model, n_epochs$value, this.batchSize, this.learningRateMultiplier, promptLossWeight$value, computeClassificationMetrics$value, this.classificationNClasses, this.classificationBetas, this.suffix);
        }

        public String toString() {
            return "FineTune.FineTuneBuilder(trainingFile=" + this.trainingFile + ", validationFile=" + this.validationFile + ", model=" + this.model + ", n_epochs$value=" + this.n_epochs$value + ", batchSize=" + this.batchSize + ", learningRateMultiplier=" + this.learningRateMultiplier + ", promptLossWeight$value=" + this.promptLossWeight$value + ", computeClassificationMetrics$value=" + this.computeClassificationMetrics$value + ", classificationNClasses=" + this.classificationNClasses + ", classificationBetas=" + this.classificationBetas + ", suffix=" + this.suffix + ")";
        }
    }

    public static enum Model {
        ADA("ada"),
        BABBAGE("babbage"),
        CURIE("curie"),
        DAVINCI("davinci");

        private String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

