/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.interceptor;

import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import com.unfbx.chatgpt.function.KeyStrategyFunction;
import java.io.IOException;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeaderAuthorizationInterceptor
implements Interceptor {
    private List<String> apiKey;
    private KeyStrategyFunction<List<String>, String> keyStrategy;

    public HeaderAuthorizationInterceptor(List<String> apiKey, KeyStrategyFunction<List<String>, String> keyStrategy) {
        this.apiKey = apiKey;
        this.keyStrategy = keyStrategy;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request request = original.newBuilder().header(Header.AUTHORIZATION.getValue(), "Bearer " + this.keyStrategy.apply(this.apiKey)).header(Header.CONTENT_TYPE.getValue(), ContentType.JSON.getValue()).method(original.method(), original.body()).build();
        return chain.proceed(request);
    }

    public List<String> getApiKey() {
        return this.apiKey;
    }

    public KeyStrategyFunction<List<String>, String> getKeyStrategy() {
        return this.keyStrategy;
    }
}

